/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package dexfuzz.executors;

/**
 * Every Executor must specify an Architecture. It is important that when reduced
 * to lower case, these match the ISA string that ART would produce. For example,
 * the architecture directory used for /data/dalvik-cache/${ISA}
 */
public enum Architecture {
  ARM,
  ARM64,
  X86,
  X86_64,
  MIPS,
  MIPS64
}
