const char* SimpleMovResults[] = {
  "   0:	0008      	movs	r0, r1\n",
  "   2:	4608      	mov	r0, r1\n",
  "   4:	46c8      	mov	r8, r9\n",
  "   6:	2001      	movs	r0, #1\n",
  "   8:	f04f 0809 	mov.w	r8, #9\n",
  nullptr
};
const char* SimpleMov32Results[] = {
  "   0:	ea4f 0001 	mov.w	r0, r1\n",
  "   4:	ea4f 0809 	mov.w	r8, r9\n",
  nullptr
};
const char* SimpleMovAddResults[] = {
  "   0:	4608      	mov	r0, r1\n",
  "   2:	1888      	adds	r0, r1, r2\n",
  "   4:	1c08      	adds	r0, r1, #0\n",
  nullptr
};
const char* DataProcessingRegisterResults[] = {
  "   0:	ea6f 0001 	mvn.w	r0, r1\n",
  "   4:	eb01 0002 	add.w	r0, r1, r2\n",
  "   8:	eba1 0002 	sub.w	r0, r1, r2\n",
  "   c:	ea01 0002 	and.w	r0, r1, r2\n",
  "  10:	ea41 0002 	orr.w	r0, r1, r2\n",
  "  14:	ea61 0002 	orn	r0, r1, r2\n",
  "  18:	ea81 0002 	eor.w	r0, r1, r2\n",
  "  1c:	ea21 0002 	bic.w	r0, r1, r2\n",
  "  20:	eb41 0002 	adc.w	r0, r1, r2\n",
  "  24:	eb61 0002 	sbc.w	r0, r1, r2\n",
  "  28:	ebc1 0002 	rsb	r0, r1, r2\n",
  "  2c:	ea90 0f01 	teq	r0, r1\n",
  "  30:	0008      	movs	r0, r1\n",
  "  32:	4608      	mov	r0, r1\n",
  "  34:	43c8      	mvns	r0, r1\n",
  "  36:	4408      	add	r0, r1\n",
  "  38:	1888      	adds	r0, r1, r2\n",
  "  3a:	1a88      	subs	r0, r1, r2\n",
  "  3c:	4148      	adcs	r0, r1\n",
  "  3e:	4188      	sbcs	r0, r1\n",
  "  40:	4008      	ands	r0, r1\n",
  "  42:	4308      	orrs	r0, r1\n",
  "  44:	4048      	eors	r0, r1\n",
  "  46:	4388      	bics	r0, r1\n",
  "  48:	4208      	tst	r0, r1\n",
  "  4a:	4288      	cmp	r0, r1\n",
  "  4c:	42c8      	cmn	r0, r1\n",
  "  4e:	4641		mov	r1, r8\n",
  "  50:	4681		mov	r9, r0\n",
  "  52:	46c8		mov	r8, r9\n",
  "  54:	4441		add	r1, r8\n",
  "  56:	4481		add	r9, r0\n",
  "  58:	44c8		add	r8, r9\n",
  "  5a:	4548		cmp	r0, r9\n",
  "  5c:	4588		cmp	r8, r1\n",
  "  5e:	45c1		cmp	r9, r8\n",
  "  60:	4248   	   	negs	r0, r1\n",
  "  62:	4240   	   	negs	r0, r0\n",
  "  64:	ea5f 0008  	movs.w	r0, r8\n",
  "  68:	ea7f 0008  	mvns.w	r0, r8\n",
  "  6c:	eb01 0008 	add.w	r0, r1, r8\n",
  "  70:	eb11 0008 	adds.w	r0, r1, r8\n",
  "  74:	ebb1 0008 	subs.w	r0, r1, r8\n",
  "  78:	eb50 0008 	adcs.w	r0, r0, r8\n",
  "  7c:	eb70 0008 	sbcs.w	r0, r0, r8\n",
  "  80:	ea10 0008 	ands.w	r0, r0, r8\n",
  "  84:	ea50 0008 	orrs.w	r0, r0, r8\n",
  "  88:	ea90 0008 	eors.w	r0, r0, r8\n",
  "  8c:	ea30 0008 	bics.w	r0, r0, r8\n",
  "  90:	ea10 0f08 	tst.w	r0, r8\n",
  "  94:	eb10 0f08 	cmn.w	r0, r8\n",
  "  98:	f1d8 0000 	rsbs	r0, r8, #0\n",
  "  9c:	f1d8 0800 	rsbs	r8, r8, #0\n",
  "  a0:	bf08       	it	eq\n",
  "  a2:	ea7f 0001  	mvnseq.w	r0, r1\n",
  "  a6:	bf08       	it	eq\n",
  "  a8:	eb11 0002 	addseq.w	r0, r1, r2\n",
  "  ac:	bf08       	it	eq\n",
  "  ae:	ebb1 0002 	subseq.w	r0, r1, r2\n",
  "  b2:	bf08       	it	eq\n",
  "  b4:	eb50 0001 	adcseq.w	r0, r0, r1\n",
  "  b8:	bf08       	it	eq\n",
  "  ba:	eb70 0001 	sbcseq.w	r0, r0, r1\n",
  "  be:	bf08       	it	eq\n",
  "  c0:	ea10 0001 	andseq.w	r0, r0, r1\n",
  "  c4:	bf08       	it	eq\n",
  "  c6:	ea50 0001 	orrseq.w	r0, r0, r1\n",
  "  ca:	bf08       	it	eq\n",
  "  cc:	ea90 0001 	eorseq.w	r0, r0, r1\n",
  "  d0:	bf08       	it	eq\n",
  "  d2:	ea30 0001 	bicseq.w	r0, r0, r1\n",
  "  d6:	bf08       	it	eq\n",
  "  d8:	43c8      	mvneq	r0, r1\n",
  "  da:	bf08       	it	eq\n",
  "  dc:	1888      	addeq	r0, r1, r2\n",
  "  de:	bf08       	it	eq\n",
  "  e0:	1a88      	subeq	r0, r1, r2\n",
  "  e2:	bf08       	it	eq\n",
  "  e4:	4148      	adceq	r0, r1\n",
  "  e6:	bf08       	it	eq\n",
  "  e8:	4188      	sbceq	r0, r1\n",
  "  ea:	bf08       	it	eq\n",
  "  ec:	4008      	andeq	r0, r1\n",
  "  ee:	bf08       	it	eq\n",
  "  f0:	4308      	orreq	r0, r1\n",
  "  f2:	bf08       	it	eq\n",
  "  f4:	4048      	eoreq	r0, r1\n",
  "  f6:	bf08       	it	eq\n",
  "  f8:	4388      	biceq	r0, r1\n",
  "  fa:	4608      	mov	r0, r1\n",
  "  fc:	43c8      	mvns	r0, r1\n",
  "  fe:	4408      	add	r0, r1\n",
  " 100:	1888      	adds	r0, r1, r2\n",
  " 102:	1a88      	subs	r0, r1, r2\n",
  " 104:	4148      	adcs	r0, r1\n",
  " 106:	4188      	sbcs	r0, r1\n",
  " 108:	4008      	ands	r0, r1\n",
  " 10a:	4308      	orrs	r0, r1\n",
  " 10c:	4048      	eors	r0, r1\n",
  " 10e:	4388      	bics	r0, r1\n",
  " 110:	4641		mov	r1, r8\n",
  " 112:	4681		mov	r9, r0\n",
  " 114:	46c8		mov	r8, r9\n",
  " 116:	4441		add	r1, r8\n",
  " 118:	4481		add	r9, r0\n",
  " 11a:	44c8		add	r8, r9\n",
  " 11c:	4248   	   	negs	r0, r1\n",
  " 11e:	4240   	   	negs	r0, r0\n",
  " 120:	eb01 0c00 	add.w	ip, r1, r0\n",
  nullptr
};
const char* DataProcessingImmediateResults[] = {
  "   0:	2055      	movs	r0, #85	; 0x55\n",
  "   2:	f06f 0055 	mvn.w	r0, #85	; 0x55\n",
  "   6:	f101 0055 	add.w	r0, r1, #85	; 0x55\n",
  "   a:	f1a1 0055 	sub.w	r0, r1, #85	; 0x55\n",
  "   e:	f001 0055 	and.w	r0, r1, #85	; 0x55\n",
  "  12:	f041 0055 	orr.w	r0, r1, #85	; 0x55\n",
  "  16:	f061 0055 	orn	r0, r1, #85	; 0x55\n",
  "  1a:	f081 0055 	eor.w	r0, r1, #85	; 0x55\n",
  "  1e:	f021 0055 	bic.w	r0, r1, #85	; 0x55\n",
  "  22:	f141 0055 	adc.w	r0, r1, #85	; 0x55\n",
  "  26:	f161 0055 	sbc.w	r0, r1, #85	; 0x55\n",
  "  2a:	f1c1 0055 	rsb	r0, r1, #85	; 0x55\n",
  "  2e:	f010 0f55 	tst.w	r0, #85	; 0x55\n",
  "  32:	f090 0f55 	teq	r0, #85	; 0x55\n",
  "  36:	2855      	cmp	r0, #85	; 0x55\n",
  "  38:	f110 0f55 	cmn.w	r0, #85	; 0x55\n",
  "  3c:	1d48      	adds	r0, r1, #5\n",
  "  3e:	1f48      	subs	r0, r1, #5\n",
  "  40:	2055      	movs	r0, #85	; 0x55\n",
  "  42:	f07f 0055 	mvns.w	r0, #85	; 0x55\n",
  "  46:	1d48      	adds	r0, r1, #5\n",
  "  48:	1f48      	subs	r0, r1, #5\n",
  nullptr
};
const char* DataProcessingModifiedImmediateResults[] = {
  "   0:	f04f 1055 	mov.w	r0, #5570645	; 0x550055\n",
  "   4:	f06f 1055 	mvn.w	r0, #5570645	; 0x550055\n",
  "   8:	f101 1055 	add.w	r0, r1, #5570645	; 0x550055\n",
  "   c:	f1a1 1055 	sub.w	r0, r1, #5570645	; 0x550055\n",
  "  10:	f001 1055 	and.w	r0, r1, #5570645	; 0x550055\n",
  "  14:	f041 1055 	orr.w	r0, r1, #5570645	; 0x550055\n",
  "  18:	f061 1055 	orn	r0, r1, #5570645	; 0x550055\n",
  "  1c:	f081 1055 	eor.w	r0, r1, #5570645	; 0x550055\n",
  "  20:	f021 1055 	bic.w	r0, r1, #5570645	; 0x550055\n",
  "  24:	f141 1055 	adc.w	r0, r1, #5570645	; 0x550055\n",
  "  28:	f161 1055 	sbc.w	r0, r1, #5570645	; 0x550055\n",
  "  2c:	f1c1 1055 	rsb	r0, r1, #5570645	; 0x550055\n",
  "  30:	f010 1f55 	tst.w	r0, #5570645	; 0x550055\n",
  "  34:	f090 1f55 	teq	r0, #5570645	; 0x550055\n",
  "  38:	f1b0 1f55 	cmp.w	r0, #5570645	; 0x550055\n",
  "  3c:	f110 1f55 	cmn.w	r0, #5570645	; 0x550055\n",
  nullptr
};
const char* DataProcessingModifiedImmediatesResults[] = {
  "   0:	f04f 1055 	mov.w	r0, #5570645	; 0x550055\n",
  "   4:	f04f 2055 	mov.w	r0, #1426085120	; 0x55005500\n",
  "   8:	f04f 3055 	mov.w	r0, #1431655765	; 0x55555555\n",
  "   c:	f04f 4055 	mov.w	r0, #3573547008	; 0xd5000000\n",
  "  10:	f04f 40d4 	mov.w	r0, #1778384896	; 0x6a000000\n",
  "  14:	f44f 7054 	mov.w	r0, #848	; 0x350\n",
  "  18:	f44f 70d4 	mov.w	r0, #424	; 0x1a8\n",
  nullptr
};
const char* DataProcessingShiftedRegisterResults[] = {
  "   0:	0123      	lsls	r3, r4, #4\n",
  "   2:	0963      	lsrs	r3, r4, #5\n",
  "   4:	11a3      	asrs	r3, r4, #6\n",
  "   6:	ea5f 13f4 	movs.w	r3, r4, ror #7\n",
  "   a:	ea5f 0334 	movs.w	r3, r4, rrx\n",
  "   e:	ea4f 1304 	mov.w	r3, r4, lsl #4\n",
  "  12:	ea4f 1354 	mov.w	r3, r4, lsr #5\n",
  "  16:	ea4f 13a4 	mov.w	r3, r4, asr #6\n",
  "  1a:	ea4f 13f4 	mov.w	r3, r4, ror #7\n",
  "  1e:	ea4f 0334 	mov.w	r3, r4, rrx\n",
  "  22:	ea5f 1804 	movs.w	r8, r4, lsl #4\n",
  "  26:	ea5f 1854 	movs.w	r8, r4, lsr #5\n",
  "  2a:	ea5f 18a4 	movs.w	r8, r4, asr #6\n",
  "  2e:	ea5f 18f4 	movs.w	r8, r4, ror #7\n",
  "  32:	ea5f 0834 	movs.w	r8, r4, rrx\n",
  nullptr
};
const char* ShiftImmediateResults[] = {
  "   0:  0123        lsls  r3, r4, #4\n",
  "   2:  0963        lsrs  r3, r4, #5\n",
  "   4:  11a3        asrs  r3, r4, #6\n",
  "   6:  ea4f 13f4   mov.w  r3, r4, ror #7\n",
  "   a:  ea4f 0334   mov.w  r3, r4, rrx\n",
  "   e:  ea4f 1304   mov.w r3, r4, lsl #4\n",
  "  12:  ea4f 1354   mov.w r3, r4, lsr #5\n",
  "  16:  ea4f 13a4   mov.w r3, r4, asr #6\n",
  "  1a:  ea4f 13f4   mov.w r3, r4, ror #7\n",
  "  1e:  ea4f 0334   mov.w r3, r4, rrx\n",
  "  22:  ea5f 1804   movs.w  r8, r4, lsl #4\n",
  "  26:  ea5f 1854   movs.w  r8, r4, lsr #5\n",
  "  2a:  ea5f 18a4   movs.w  r8, r4, asr #6\n",
  "  2e:  ea5f 18f4   movs.w  r8, r4, ror #7\n",
  "  32:  ea5f 0834   movs.w  r8, r4, rrx\n",
  nullptr
};
const char* BasicLoadResults[] = {
  "   0:	69a3      	ldr	r3, [r4, #24]\n",
  "   2:	7e23      	ldrb	r3, [r4, #24]\n",
  "   4:	8b23      	ldrh	r3, [r4, #24]\n",
  "   6:	f994 3018 	ldrsb.w	r3, [r4, #24]\n",
  "   a:	f9b4 3018 	ldrsh.w	r3, [r4, #24]\n",
  "   e:	9b06      	ldr	r3, [sp, #24]\n",
  "  10:	f8d4 8018 	ldr.w	r8, [r4, #24]\n",
  "  14:	f894 8018 	ldrb.w	r8, [r4, #24]\n",
  "  18:	f8b4 8018 	ldrh.w	r8, [r4, #24]\n",
  "  1c:	f994 8018 	ldrsb.w	r8, [r4, #24]\n",
  "  20:	f9b4 8018 	ldrsh.w	r8, [r4, #24]\n",
  nullptr
};
const char* BasicStoreResults[] = {
  "   0:	61a3      	str	r3, [r4, #24]\n",
  "   2:	7623      	strb	r3, [r4, #24]\n",
  "   4:	8323      	strh	r3, [r4, #24]\n",
  "   6:	9306      	str	r3, [sp, #24]\n",
  "   8:	f8c4 8018 	str.w	r8, [r4, #24]\n",
  "   c:	f884 8018 	strb.w	r8, [r4, #24]\n",
  "  10:	f8a4 8018 	strh.w	r8, [r4, #24]\n",
  nullptr
};
const char* ComplexLoadResults[] = {
  "   0:	69a3      	ldr	r3, [r4, #24]\n",
  "   2:	f854 3f18 	ldr.w	r3, [r4, #24]!\n",
  "   6:	f854 3b18 	ldr.w	r3, [r4], #24\n",
  "   a:	f854 3c18 	ldr.w	r3, [r4, #-24]\n",
  "   e:	f854 3d18 	ldr.w	r3, [r4, #-24]!\n",
  "  12:	f854 3918 	ldr.w	r3, [r4], #-24\n",
  "  16:	7e23      	ldrb	r3, [r4, #24]\n",
  "  18:	f814 3f18 	ldrb.w	r3, [r4, #24]!\n",
  "  1c:	f814 3b18 	ldrb.w	r3, [r4], #24\n",
  "  20:	f814 3c18 	ldrb.w	r3, [r4, #-24]\n",
  "  24:	f814 3d18 	ldrb.w	r3, [r4, #-24]!\n",
  "  28:	f814 3918 	ldrb.w	r3, [r4], #-24\n",
  "  2c:	8b23      	ldrh	r3, [r4, #24]\n",
  "  2e:	f834 3f18 	ldrh.w	r3, [r4, #24]!\n",
  "  32:	f834 3b18 	ldrh.w	r3, [r4], #24\n",
  "  36:	f834 3c18 	ldrh.w	r3, [r4, #-24]\n",
  "  3a:	f834 3d18 	ldrh.w	r3, [r4, #-24]!\n",
  "  3e:	f834 3918 	ldrh.w	r3, [r4], #-24\n",
  "  42:	f994 3018 	ldrsb.w	r3, [r4, #24]\n",
  "  46:	f914 3f18 	ldrsb.w	r3, [r4, #24]!\n",
  "  4a:	f914 3b18 	ldrsb.w	r3, [r4], #24\n",
  "  4e:	f914 3c18 	ldrsb.w	r3, [r4, #-24]\n",
  "  52:	f914 3d18 	ldrsb.w	r3, [r4, #-24]!\n",
  "  56:	f914 3918 	ldrsb.w	r3, [r4], #-24\n",
  "  5a:	f9b4 3018 	ldrsh.w	r3, [r4, #24]\n",
  "  5e:	f934 3f18 	ldrsh.w	r3, [r4, #24]!\n",
  "  62:	f934 3b18 	ldrsh.w	r3, [r4], #24\n",
  "  66:	f934 3c18 	ldrsh.w	r3, [r4, #-24]\n",
  "  6a:	f934 3d18 	ldrsh.w	r3, [r4, #-24]!\n",
  "  6e:	f934 3918 	ldrsh.w	r3, [r4], #-24\n",
  nullptr
};
const char* ComplexStoreResults[] = {
  "   0:	61a3      	str	r3, [r4, #24]\n",
  "   2:	f844 3f18 	str.w	r3, [r4, #24]!\n",
  "   6:	f844 3b18 	str.w	r3, [r4], #24\n",
  "   a:	f844 3c18 	str.w	r3, [r4, #-24]\n",
  "   e:	f844 3d18 	str.w	r3, [r4, #-24]!\n",
  "  12:	f844 3918 	str.w	r3, [r4], #-24\n",
  "  16:	7623      	strb	r3, [r4, #24]\n",
  "  18:	f804 3f18 	strb.w	r3, [r4, #24]!\n",
  "  1c:	f804 3b18 	strb.w	r3, [r4], #24\n",
  "  20:	f804 3c18 	strb.w	r3, [r4, #-24]\n",
  "  24:	f804 3d18 	strb.w	r3, [r4, #-24]!\n",
  "  28:	f804 3918 	strb.w	r3, [r4], #-24\n",
  "  2c:	8323      	strh	r3, [r4, #24]\n",
  "  2e:	f824 3f18 	strh.w	r3, [r4, #24]!\n",
  "  32:	f824 3b18 	strh.w	r3, [r4], #24\n",
  "  36:	f824 3c18 	strh.w	r3, [r4, #-24]\n",
  "  3a:	f824 3d18 	strh.w	r3, [r4, #-24]!\n",
  "  3e:	f824 3918 	strh.w	r3, [r4], #-24\n",
  nullptr
};
const char* NegativeLoadStoreResults[] = {
  "   0:	f854 3c18 	ldr.w	r3, [r4, #-24]\n",
  "   4:	f854 3d18 	ldr.w	r3, [r4, #-24]!\n",
  "   8:	f854 3918 	ldr.w	r3, [r4], #-24\n",
  "   c:	f854 3e18 	ldrt	r3, [r4, #24]\n",
  "  10:	f854 3f18 	ldr.w	r3, [r4, #24]!\n",
  "  14:	f854 3b18 	ldr.w	r3, [r4], #24\n",
  "  18:	f814 3c18 	ldrb.w	r3, [r4, #-24]\n",
  "  1c:	f814 3d18 	ldrb.w	r3, [r4, #-24]!\n",
  "  20:	f814 3918 	ldrb.w	r3, [r4], #-24\n",
  "  24:	f814 3e18 	ldrbt	r3, [r4, #24]\n",
  "  28:	f814 3f18 	ldrb.w	r3, [r4, #24]!\n",
  "  2c:	f814 3b18 	ldrb.w	r3, [r4], #24\n",
  "  30:	f834 3c18 	ldrh.w	r3, [r4, #-24]\n",
  "  34:	f834 3d18 	ldrh.w	r3, [r4, #-24]!\n",
  "  38:	f834 3918 	ldrh.w	r3, [r4], #-24\n",
  "  3c:	f834 3e18 	ldrht	r3, [r4, #24]\n",
  "  40:	f834 3f18 	ldrh.w	r3, [r4, #24]!\n",
  "  44:	f834 3b18 	ldrh.w	r3, [r4], #24\n",
  "  48:	f914 3c18 	ldrsb.w	r3, [r4, #-24]\n",
  "  4c:	f914 3d18 	ldrsb.w	r3, [r4, #-24]!\n",
  "  50:	f914 3918 	ldrsb.w	r3, [r4], #-24\n",
  "  54:	f914 3e18 	ldrsbt	r3, [r4, #24]\n",
  "  58:	f914 3f18 	ldrsb.w	r3, [r4, #24]!\n",
  "  5c:	f914 3b18 	ldrsb.w	r3, [r4], #24\n",
  "  60:	f934 3c18 	ldrsh.w	r3, [r4, #-24]\n",
  "  64:	f934 3d18 	ldrsh.w	r3, [r4, #-24]!\n",
  "  68:	f934 3918 	ldrsh.w	r3, [r4], #-24\n",
  "  6c:	f934 3e18 	ldrsht	r3, [r4, #24]\n",
  "  70:	f934 3f18 	ldrsh.w	r3, [r4, #24]!\n",
  "  74:	f934 3b18 	ldrsh.w	r3, [r4], #24\n",
  "  78:	f844 3c18 	str.w	r3, [r4, #-24]\n",
  "  7c:	f844 3d18 	str.w	r3, [r4, #-24]!\n",
  "  80:	f844 3918 	str.w	r3, [r4], #-24\n",
  "  84:	f844 3e18 	strt	r3, [r4, #24]\n",
  "  88:	f844 3f18 	str.w	r3, [r4, #24]!\n",
  "  8c:	f844 3b18 	str.w	r3, [r4], #24\n",
  "  90:	f804 3c18 	strb.w	r3, [r4, #-24]\n",
  "  94:	f804 3d18 	strb.w	r3, [r4, #-24]!\n",
  "  98:	f804 3918 	strb.w	r3, [r4], #-24\n",
  "  9c:	f804 3e18 	strbt	r3, [r4, #24]\n",
  "  a0:	f804 3f18 	strb.w	r3, [r4, #24]!\n",
  "  a4:	f804 3b18 	strb.w	r3, [r4], #24\n",
  "  a8:	f824 3c18 	strh.w	r3, [r4, #-24]\n",
  "  ac:	f824 3d18 	strh.w	r3, [r4, #-24]!\n",
  "  b0:	f824 3918 	strh.w	r3, [r4], #-24\n",
  "  b4:	f824 3e18 	strht	r3, [r4, #24]\n",
  "  b8:	f824 3f18 	strh.w	r3, [r4, #24]!\n",
  "  bc:	f824 3b18 	strh.w	r3, [r4], #24\n",
  nullptr
};
const char* SimpleLoadStoreDualResults[] = {
  "   0:	e9c0 2306 	strd	r2, r3, [r0, #24]\n",
  "   4:	e9d0 2306 	ldrd	r2, r3, [r0, #24]\n",
  nullptr
};
const char* ComplexLoadStoreDualResults[] = {
  "   0:	e9c0 2306 	strd	r2, r3, [r0, #24]\n",
  "   4:	e9e0 2306 	strd	r2, r3, [r0, #24]!\n",
  "   8:	e8e0 2306 	strd	r2, r3, [r0], #24\n",
  "   c:	e940 2306 	strd	r2, r3, [r0, #-24]\n",
  "  10:	e960 2306 	strd	r2, r3, [r0, #-24]!\n",
  "  14:	e860 2306 	strd	r2, r3, [r0], #-24\n",
  "  18:	e9d0 2306 	ldrd	r2, r3, [r0, #24]\n",
  "  1c:	e9f0 2306 	ldrd	r2, r3, [r0, #24]!\n",
  "  20:	e8f0 2306 	ldrd	r2, r3, [r0], #24\n",
  "  24:	e950 2306 	ldrd	r2, r3, [r0, #-24]\n",
  "  28:	e970 2306 	ldrd	r2, r3, [r0, #-24]!\n",
  "  2c:	e870 2306 	ldrd	r2, r3, [r0], #-24\n",
  nullptr
};
const char* NegativeLoadStoreDualResults[] = {
  "   0:	e940 2306 	strd	r2, r3, [r0, #-24]\n",
  "   4:	e960 2306 	strd	r2, r3, [r0, #-24]!\n",
  "   8:	e860 2306 	strd	r2, r3, [r0], #-24\n",
  "   c:	e9c0 2306 	strd	r2, r3, [r0, #24]\n",
  "  10:	e9e0 2306 	strd	r2, r3, [r0, #24]!\n",
  "  14:	e8e0 2306 	strd	r2, r3, [r0], #24\n",
  "  18:	e950 2306 	ldrd	r2, r3, [r0, #-24]\n",
  "  1c:	e970 2306 	ldrd	r2, r3, [r0, #-24]!\n",
  "  20:	e870 2306 	ldrd	r2, r3, [r0], #-24\n",
  "  24:	e9d0 2306 	ldrd	r2, r3, [r0, #24]\n",
  "  28:	e9f0 2306 	ldrd	r2, r3, [r0, #24]!\n",
  "  2c:	e8f0 2306 	ldrd	r2, r3, [r0], #24\n",
  nullptr
};
const char* SimpleBranchResults[] = {
  "   0:	2002      	movs	r0, #2\n",
  "   2:	2101      	movs	r1, #1\n",
  "   4:	e7fd      	b.n	2 <SimpleBranch+0x2>\n",
  "   6:	e000      	b.n	a <SimpleBranch+0xa>\n",
  "   8:	2102      	movs	r1, #2\n",
  "   a:	2003      	movs	r0, #3\n",
  "   c:	2002      	movs	r0, #2\n",
  "   e:	2101      	movs	r1, #1\n",
  "  10:	d0fd      	beq.n	e <SimpleBranch+0xe>\n",
  "  12:	d000      	beq.n	16 <SimpleBranch+0x16>\n",
  "  14:	2102      	movs	r1, #2\n",
  "  16:	2003      	movs	r0, #3\n",
  "  18:	e002      	b.n	20 <SimpleBranch+0x20>\n",
  "  1a:	2104      	movs	r1, #4\n",
  "  1c:	e000      	b.n	20 <SimpleBranch+0x20>\n",
  "  1e:	2105      	movs	r1, #5\n",
  "  20:	2006      	movs	r0, #6\n",
  nullptr
};
const char* LongBranchResults[] = {
  "   0:	f04f 0002 	mov.w	r0, #2\n",
  "   4:	f04f 0101 	mov.w	r1, #1\n",
  "   8:	f7ff bffc 	b.w	4 <LongBranch+0x4>\n",
  "   c:	f000 b802 	b.w	14 <LongBranch+0x14>\n",
  "  10:	f04f 0102 	mov.w	r1, #2\n",
  "  14:	f04f 0003 	mov.w	r0, #3\n",
  "  18:	f04f 0002 	mov.w	r0, #2\n",
  "  1c:	f04f 0101 	mov.w	r1, #1\n",
  "  20:	f43f affc 	beq.w	1c <LongBranch+0x1c>\n",
  "  24:	f000 8002 	beq.w	2c <LongBranch+0x2c>\n",
  "  28:	f04f 0102 	mov.w	r1, #2\n",
  "  2c:	f04f 0003 	mov.w	r0, #3\n",
  "  30:	f000 b806 	b.w	40 <LongBranch+0x40>\n",
  "  34:	f04f 0104 	mov.w	r1, #4\n",
  "  38:	f000 b802 	b.w	40 <LongBranch+0x40>\n",
  "  3c:	f04f 0105 	mov.w	r1, #5\n",
  "  40:	f04f 0006 	mov.w	r0, #6\n",
  nullptr
};
const char* LoadMultipleResults[] = {
  "   0:	cc09      	ldmia	r4!, {r0, r3}\n",
  "   2:	e934 4800 	ldmdb	r4!, {fp, lr}\n",
  "   6:	e914 4800 	ldmdb	r4, {fp, lr}\n",
  "   a:	f854 5b04 	ldr.w	r5, [r4], #4\n",
  nullptr
};
const char* StoreMultipleResults[] = {
  "   0:	c409      	stmia	r4!, {r0, r3}\n",
  "   2:	e8a4 4800 	stmia.w	r4!, {fp, lr}\n",
  "   6:	e884 4800 	stmia.w	r4, {fp, lr}\n",
  "   a:	f844 5c04 	str.w	r5, [r4, #-4]\n",
  "   e:	f844 5d04 	str.w	r5, [r4, #-4]!\n",
  nullptr
};
const char* MovWMovTResults[] = {
  "   0:	f240 0400 	movw  r4, #0\n",
  "   4:	f240 0434 	movw  r4, #52 ; 0x34\n",
  "   8:	f240 0934 	movw	r9, #52	; 0x34\n",
  "   c:	f241 2334 	movw	r3, #4660	; 0x1234\n",
  "  10:	f64f 79ff 	movw	r9, #65535	; 0xffff\n",
  "  14:	f2c0 0000 	movt	r0, #0\n",
  "  18:	f2c1 2034 	movt	r0, #4660	; 0x1234\n",
  "  1c:	f6cf 71ff 	movt	r1, #65535	; 0xffff\n",
  nullptr
};
const char* SpecialAddSubResults[] = {
  "   0:	aa14      	add	r2, sp, #80	; 0x50\n",
  "   2:	b014      	add	sp, #80		; 0x50\n",
  "   4:	f10d 0850 	add.w	r8, sp, #80	; 0x50\n",
  "   8:	f50d 6270 	add.w	r2, sp, #3840	; 0xf00\n",
  "   c:	f50d 6d70 	add.w	sp, sp, #3840	; 0xf00\n",
  "  10:	f60d 7dfc 	addw	sp, sp, #4092	; 0xffc\n",
  "  14:	b094      	sub	sp, #80		; 0x50\n",
  "  16:	f1ad 0050 	sub.w	r0, sp, #80	; 0x50\n",
  "  1a:	f1ad 0850 	sub.w	r8, sp, #80	; 0x50\n",
  "  1e:	f5ad 6d70 	sub.w	sp, sp, #3840	; 0xf00\n",
  "  22:	f6ad 7dfc 	subw	sp, sp, #4092	; 0xffc\n",
  nullptr
};
const char* LoadFromOffsetResults[] = {
  "   0:	68e2      	ldr	r2, [r4, #12]\n",
  "   2:	f8d4 2fff 	ldr.w	r2, [r4, #4095]	; 0xfff\n",
  "   6:	f504 5280 	add.w	r2, r4, #4096	; 0x1000\n",
  "   a:	6812      	ldr	r2, [r2, #0]\n",
  "   c:	f504 1280 	add.w	r2, r4, #1048576	; 0x100000\n",
  "  10:	f8d2 20a4 	ldr.w	r2, [r2, #164]	; 0xa4\n",
  "  14:	f241 0200 	movw	r2, #4096	; 0x1000\n",
  "  18:	f2c0 0210 	movt	r2, #16\n",
  "  1c:	4422      	add	r2, r4\n",
  "  1e:	6812      	ldr	r2, [r2, #0]\n",
  "  20:	f241 0c00 	movw	ip, #4096	; 0x1000\n",
  "  24:	f2c0 0c10 	movt	ip, #16\n",
  "  28:	4464      	add	r4, ip\n",
  "  2a:	6824      	ldr	r4, [r4, #0]\n",
  "  2c:	89a2      	ldrh	r2, [r4, #12]\n",
  "  2e:	f8b4 2fff 	ldrh.w	r2, [r4, #4095]	; 0xfff\n",
  "  32:	f504 5280 	add.w	r2, r4, #4096	; 0x1000\n",
  "  36:	8812      	ldrh	r2, [r2, #0]\n",
  "  38:	f504 1280 	add.w	r2, r4, #1048576	; 0x100000\n",
  "  3c:	f8b2 20a4 	ldrh.w	r2, [r2, #164]	; 0xa4\n",
  "  40:	f241 0200 	movw	r2, #4096	; 0x1000\n",
  "  44:	f2c0 0210 	movt	r2, #16\n",
  "  48:	4422      	add	r2, r4\n",
  "  4a:	8812      	ldrh	r2, [r2, #0]\n",
  "  4c:	f241 0c00 	movw	ip, #4096	; 0x1000\n",
  "  50:	f2c0 0c10 	movt	ip, #16\n",
  "  54:	4464      	add	r4, ip\n",
  "  56:	8824      	ldrh	r4, [r4, #0]\n",
  "  58:	e9d4 2303 	ldrd	r2, r3, [r4, #12]\n",
  "  5c:	e9d4 23ff 	ldrd	r2, r3, [r4, #1020]	; 0x3fc\n",
  "  60:	f504 6280 	add.w	r2, r4, #1024	; 0x400\n",
  "  64:	e9d2 2300 	ldrd	r2, r3, [r2]\n",
  "  68:	f504 2280 	add.w	r2, r4, #262144	; 0x40000\n",
  "  6c:	e9d2 2329 	ldrd	r2, r3, [r2, #164];	0xa4\n",
  "  70:	f240 4200 	movw	r2, #1024	; 0x400\n",
  "  74:	f2c0 0204 	movt	r2, #4\n",
  "  78:	4422      	add	r2, r4\n",
  "  7a:	e9d2 2300 	ldrd	r2, r3, [r2]\n",
  "  7e:	f240 4c00 	movw	ip, #1024	; 0x400\n",
  "  82:	f2c0 0c04 	movt	ip, #4\n",
  "  86:	4464      	add	r4, ip\n",
  "  88:	e9d4 4500 	ldrd	r4, r5, [r4]\n",
  "  8c:	f8dc 000c 	ldr.w	r0, [ip, #12]\n",
  "  90:	f5a4 1280 	sub.w	r2, r4, #1048576	; 0x100000\n",
  "  94:	f8d2 20a4 	ldr.w	r2, [r2, #164]	; 0xa4\n",
  "  98:	f994 200c 	ldrsb.w	r2, [r4, #12]\n",
  "  9c:	7b22      	ldrb	r2, [r4, #12]\n",
  "  9e:	f9b4 200c 	ldrsh.w	r2, [r4, #12]\n",
  nullptr
};
const char* StoreToOffsetResults[] = {
  "   0:	60e2      	str	r2, [r4, #12]\n",
  "   2:	f8c4 2fff 	str.w	r2, [r4, #4095]	; 0xfff\n",
  "   6:	f504 5c80 	add.w	ip, r4, #4096	; 0x1000\n",
  "   a:	f8cc 2000 	str.w	r2, [ip]\n",
  "   e:	f504 1c80 	add.w	ip, r4, #1048576	; 0x100000\n",
  "  12:	f8cc 20a4 	str.w	r2, [ip, #164]	; 0xa4\n",
  "  16:	f241 0c00 	movw	ip, #4096	; 0x1000\n",
  "  1a:	f2c0 0c10 	movt	ip, #16\n",
  "  1e:	44a4      	add	ip, r4\n",
  "  20:	f8cc 2000 	str.w	r2, [ip]\n",
  "  24:	f241 0c00 	movw	ip, #4096	; 0x1000\n",
  "  28:	f2c0 0c10 	movt	ip, #16\n",
  "  2c:	44a4      	add	ip, r4\n",
  "  2e:	f8cc 4000 	str.w	r4, [ip]\n",
  "  32:	81a2      	strh	r2, [r4, #12]\n",
  "  34:	f8a4 2fff 	strh.w	r2, [r4, #4095]	; 0xfff\n",
  "  38:	f504 5c80 	add.w	ip, r4, #4096	; 0x1000\n",
  "  3c:	f8ac 2000 	strh.w	r2, [ip]\n",
  "  40:	f504 1c80 	add.w	ip, r4, #1048576	; 0x100000\n",
  "  44:	f8ac 20a4 	strh.w	r2, [ip, #164]	; 0xa4\n",
  "  48:	f241 0c00 	movw	ip, #4096	; 0x1000\n",
  "  4c:	f2c0 0c10 	movt	ip, #16\n",
  "  50:	44a4      	add	ip, r4\n",
  "  52:	f8ac 2000 	strh.w	r2, [ip]\n",
  "  56:	f241 0c00 	movw	ip, #4096	; 0x1000\n",
  "  5a:	f2c0 0c10 	movt	ip, #16\n",
  "  5e:	44a4      	add	ip, r4\n",
  "  60:	f8ac 4000 	strh.w	r4, [ip]\n",
  "  64:	e9c4 2303 	strd	r2, r3, [r4, #12]\n",
  "  68:	e9c4 23ff 	strd	r2, r3, [r4, #1020]	; 0x3fc\n",
  "  6c:	f504 6c80 	add.w	ip, r4, #1024	; 0x400\n",
  "  70:	e9cc 2300 	strd	r2, r3, [ip]\n",
  "  74:	f504 2c80 	add.w	ip, r4, #262144	; 0x40000\n",
  "  78:	e9cc 2329 	strd	r2, r3, [ip, #164];	0xa4\n",
  "  7c:	f240 4c00 	movw	ip, #1024	; 0x400\n",
  "  80:	f2c0 0c04 	movt	ip, #4\n",
  "  84:	44a4      	add	ip, r4\n",
  "  86:	e9cc 2300 	strd	r2, r3, [ip]\n",
  "  8a:	f240 4c00 	movw	ip, #1024	; 0x400\n",
  "  8e:	f2c0 0c04 	movt	ip, #4\n",
  "  92:	44a4      	add	ip, r4\n",
  "  94:	e9cc 4500 	strd	r4, r5, [ip]\n",
  "  98:	f8cc 000c 	str.w	r0, [ip, #12]\n",
  "  9c:	f5a4 1c80 	sub.w	ip, r4, #1048576	; 0x100000\n",
  "  a0:	f8cc 20a4 	str.w	r2, [ip, #164]	; 0xa4\n",
  "  a4:	7322      	strb	r2, [r4, #12]\n",
  nullptr
};
const char* IfThenResults[] = {
  "   0:	bf08      	it	eq\n",
  "   2:	2101      	moveq	r1, #1\n",
  "   4:	bf04      	itt	eq\n",
  "   6:	2101      	moveq	r1, #1\n",
  "   8:	2202      	moveq	r2, #2\n",
  "   a:	bf0c      	ite	eq\n",
  "   c:	2101      	moveq	r1, #1\n",
  "   e:	2202      	movne	r2, #2\n",
  "  10:	bf06      	itte	eq\n",
  "  12:	2101      	moveq	r1, #1\n",
  "  14:	2202      	moveq	r2, #2\n",
  "  16:	2303      	movne	r3, #3\n",
  "  18:	bf0e      	itee	eq\n",
  "  1a:	2101      	moveq	r1, #1\n",
  "  1c:	2202      	movne	r2, #2\n",
  "  1e:	2303      	movne	r3, #3\n",
  "  20:	bf03      	ittte	eq\n",
  "  22:	2101      	moveq	r1, #1\n",
  "  24:	2202      	moveq	r2, #2\n",
  "  26:	2303      	moveq	r3, #3\n",
  "  28:	2404      	movne	r4, #4\n",
  nullptr
};
const char* CbzCbnzResults[] = {
  "   0:	b10a      	cbz	r2, 6 <CbzCbnz+0x6>\n",
  "   2:	2103      	movs	r1, #3\n",
  "   4:	2203      	movs	r2, #3\n",
  "   6:	2204      	movs	r2, #4\n",
  "   8:	b912      	cbnz	r2, 10 <CbzCbnz+0x10>\n",
  "   a:	f04f 0803 	mov.w	r8, #3\n",
  "   e:	2203      	movs	r2, #3\n",
  "  10:	2204      	movs	r2, #4\n",
  nullptr
};
const char* MultiplyResults[] = {
  "   0:	4348      	muls	r0, r1\n",
  "   2:	fb01 f002 	mul.w	r0, r1, r2\n",
  "   6:	fb09 f808 	mul.w	r8, r9, r8\n",
  "   a:	fb09 f80a 	mul.w	r8, r9, sl\n",
  "   e:	fb01 3002 	mla	r0, r1, r2, r3\n",
  "  12:	fb09 9808 	mla	r8, r9, r8, r9\n",
  "  16:	fb01 3012 	mls	r0, r1, r2, r3\n",
  "  1a:	fb09 9818 	mls	r8, r9, r8, r9\n",
  "  1e:	fba2 0103 	umull	r0, r1, r2, r3\n",
  "  22:	fbaa 890b 	umull	r8, r9, sl, fp\n",
  nullptr
};
const char* DivideResults[] = {
  "   0:	fb91 f0f2 	sdiv	r0, r1, r2\n",
  "   4:	fb99 f8fa 	sdiv	r8, r9, sl\n",
  "   8:	fbb1 f0f2 	udiv	r0, r1, r2\n",
  "   c:	fbb9 f8fa 	udiv	r8, r9, sl\n",
  nullptr
};
const char* VMovResults[] = {
  "   0:	eef7 0a00 	vmov.f32	s1, #112	; 0x70\n",
  "   4:	eeb7 1b00 	vmov.f64	d1, #112	; 0x70\n",
  "   8:	eef0 0a41 	vmov.f32	s1, s2\n",
  "   c:	eeb0 1b42 	vmov.f64	d1, d2\n",
  nullptr
};
const char* BasicFloatingPointResults[] = {
  "   0:	ee30 0a81 	vadd.f32	s0, s1, s2\n",
  "   4:	ee30 0ac1 	vsub.f32	s0, s1, s2\n",
  "   8:	ee20 0a81 	vmul.f32	s0, s1, s2\n",
  "   c:	ee00 0a81 	vmla.f32	s0, s1, s2\n",
  "  10:	ee00 0ac1 	vmls.f32	s0, s1, s2\n",
  "  14:	ee80 0a81 	vdiv.f32	s0, s1, s2\n",
  "  18:	eeb0 0ae0 	vabs.f32	s0, s1\n",
  "  1c:	eeb1 0a60 	vneg.f32	s0, s1\n",
  "  20:	eeb1 0ae0 	vsqrt.f32	s0, s1\n",
  "  24:	ee31 0b02 	vadd.f64	d0, d1, d2\n",
  "  28:	ee31 0b42 	vsub.f64	d0, d1, d2\n",
  "  2c:	ee21 0b02 	vmul.f64	d0, d1, d2\n",
  "  30:	ee01 0b02 	vmla.f64	d0, d1, d2\n",
  "  34:	ee01 0b42 	vmls.f64	d0, d1, d2\n",
  "  38:	ee81 0b02 	vdiv.f64	d0, d1, d2\n",
  "  3c:	eeb0 0bc1 	vabs.f64	d0, d1\n",
  "  40:	eeb1 0b41 	vneg.f64	d0, d1\n",
  "  44:	eeb1 0bc1 	vsqrt.f64	d0, d1\n",
  nullptr
};
const char* FloatingPointConversionsResults[] = {
  "   0:	eeb7 1bc2 	vcvt.f32.f64	s2, d2\n",
  "   4:	eeb7 2ac1 	vcvt.f64.f32	d2, s2\n",
  "   8:	eefd 0ac1 	vcvt.s32.f32	s1, s2\n",
  "   c:	eef8 0ac1 	vcvt.f32.s32	s1, s2\n",
  "  10:	eefd 0bc2 	vcvt.s32.f64	s1, d2\n",
  "  14:	eeb8 1bc1 	vcvt.f64.s32	d1, s2\n",
  "  18:	eefc 0ac1 	vcvt.u32.f32	s1, s2\n",
  "  1c:	eef8 0a41 	vcvt.f32.u32	s1, s2\n",
  "  20:	eefc 0bc2 	vcvt.u32.f64	s1, d2\n",
  "  24:	eeb8 1b41 	vcvt.f64.u32	d1, s2\n",
  nullptr
};
const char* FloatingPointComparisonsResults[] = {
  "   0:	eeb4 0a60 	vcmp.f32	s0, s1\n",
  "   4:	eeb4 0b41 	vcmp.f64	d0, d1\n",
  "   8:	eeb5 1a40 	vcmp.f32	s2, #0.0\n",
  "   c:	eeb5 2b40 	vcmp.f64	d2, #0.0\n",
  nullptr
};
const char* CallsResults[] = {
  "   0:	47f0      	blx	lr\n",
  "   2:	4770      	bx	lr\n",
  nullptr
};
const char* BreakpointResults[] = {
  "   0:	be00      	bkpt	0x0000\n",
  nullptr
};
const char* StrR1Results[] = {
  "   0:	9111      	str	r1, [sp, #68]	; 0x44\n",
  "   2:	f8cd 142c 	str.w	r1, [sp, #1068]	; 0x42c\n",
  nullptr
};
const char* VPushPopResults[] = {
  "   0:	ed2d 1a04 	vpush	{s2-s5}\n",
  "   4:	ed2d 2b08 	vpush	{d2-d5}\n",
  "   8:	ecbd 1a04 	vpop	{s2-s5}\n",
  "   c:	ecbd 2b08 	vpop	{d2-d5}\n",
  nullptr
};
const char* Max16BitBranchResults[] = {
  "   0:	e3ff      	b.n	802 <Max16BitBranch+0x802>\n",
  "   2:	2300      	movs	r3, #0\n",
  "   4:	2302      	movs	r3, #2\n",
  "   6:	2304      	movs	r3, #4\n",
  "   8:	2306      	movs	r3, #6\n",
  "   a:	2308      	movs	r3, #8\n",
  "   c:	230a      	movs	r3, #10\n",
  "   e:	230c      	movs	r3, #12\n",
  "  10:	230e      	movs	r3, #14\n",
  "  12:	2310      	movs	r3, #16\n",
  "  14:	2312      	movs	r3, #18\n",
  "  16:	2314      	movs	r3, #20\n",
  "  18:	2316      	movs	r3, #22\n",
  "  1a:	2318      	movs	r3, #24\n",
  "  1c:	231a      	movs	r3, #26\n",
  "  1e:	231c      	movs	r3, #28\n",
  "  20:	231e      	movs	r3, #30\n",
  "  22:	2320      	movs	r3, #32\n",
  "  24:	2322      	movs	r3, #34	; 0x22\n",
  "  26:	2324      	movs	r3, #36	; 0x24\n",
  "  28:	2326      	movs	r3, #38	; 0x26\n",
  "  2a:	2328      	movs	r3, #40	; 0x28\n",
  "  2c:	232a      	movs	r3, #42	; 0x2a\n",
  "  2e:	232c      	movs	r3, #44	; 0x2c\n",
  "  30:	232e      	movs	r3, #46	; 0x2e\n",
  "  32:	2330      	movs	r3, #48	; 0x30\n",
  "  34:	2332      	movs	r3, #50	; 0x32\n",
  "  36:	2334      	movs	r3, #52	; 0x34\n",
  "  38:	2336      	movs	r3, #54	; 0x36\n",
  "  3a:	2338      	movs	r3, #56	; 0x38\n",
  "  3c:	233a      	movs	r3, #58	; 0x3a\n",
  "  3e:	233c      	movs	r3, #60	; 0x3c\n",
  "  40:	233e      	movs	r3, #62	; 0x3e\n",
  "  42:	2340      	movs	r3, #64	; 0x40\n",
  "  44:	2342      	movs	r3, #66	; 0x42\n",
  "  46:	2344      	movs	r3, #68	; 0x44\n",
  "  48:	2346      	movs	r3, #70	; 0x46\n",
  "  4a:	2348      	movs	r3, #72	; 0x48\n",
  "  4c:	234a      	movs	r3, #74	; 0x4a\n",
  "  4e:	234c      	movs	r3, #76	; 0x4c\n",
  "  50:	234e      	movs	r3, #78	; 0x4e\n",
  "  52:	2350      	movs	r3, #80	; 0x50\n",
  "  54:	2352      	movs	r3, #82	; 0x52\n",
  "  56:	2354      	movs	r3, #84	; 0x54\n",
  "  58:	2356      	movs	r3, #86	; 0x56\n",
  "  5a:	2358      	movs	r3, #88	; 0x58\n",
  "  5c:	235a      	movs	r3, #90	; 0x5a\n",
  "  5e:	235c      	movs	r3, #92	; 0x5c\n",
  "  60:	235e      	movs	r3, #94	; 0x5e\n",
  "  62:	2360      	movs	r3, #96	; 0x60\n",
  "  64:	2362      	movs	r3, #98	; 0x62\n",
  "  66:	2364      	movs	r3, #100	; 0x64\n",
  "  68:	2366      	movs	r3, #102	; 0x66\n",
  "  6a:	2368      	movs	r3, #104	; 0x68\n",
  "  6c:	236a      	movs	r3, #106	; 0x6a\n",
  "  6e:	236c      	movs	r3, #108	; 0x6c\n",
  "  70:	236e      	movs	r3, #110	; 0x6e\n",
  "  72:	2370      	movs	r3, #112	; 0x70\n",
  "  74:	2372      	movs	r3, #114	; 0x72\n",
  "  76:	2374      	movs	r3, #116	; 0x74\n",
  "  78:	2376      	movs	r3, #118	; 0x76\n",
  "  7a:	2378      	movs	r3, #120	; 0x78\n",
  "  7c:	237a      	movs	r3, #122	; 0x7a\n",
  "  7e:	237c      	movs	r3, #124	; 0x7c\n",
  "  80:	237e      	movs	r3, #126	; 0x7e\n",
  "  82:	2380      	movs	r3, #128	; 0x80\n",
  "  84:	2382      	movs	r3, #130	; 0x82\n",
  "  86:	2384      	movs	r3, #132	; 0x84\n",
  "  88:	2386      	movs	r3, #134	; 0x86\n",
  "  8a:	2388      	movs	r3, #136	; 0x88\n",
  "  8c:	238a      	movs	r3, #138	; 0x8a\n",
  "  8e:	238c      	movs	r3, #140	; 0x8c\n",
  "  90:	238e      	movs	r3, #142	; 0x8e\n",
  "  92:	2390      	movs	r3, #144	; 0x90\n",
  "  94:	2392      	movs	r3, #146	; 0x92\n",
  "  96:	2394      	movs	r3, #148	; 0x94\n",
  "  98:	2396      	movs	r3, #150	; 0x96\n",
  "  9a:	2398      	movs	r3, #152	; 0x98\n",
  "  9c:	239a      	movs	r3, #154	; 0x9a\n",
  "  9e:	239c      	movs	r3, #156	; 0x9c\n",
  "  a0:	239e      	movs	r3, #158	; 0x9e\n",
  "  a2:	23a0      	movs	r3, #160	; 0xa0\n",
  "  a4:	23a2      	movs	r3, #162	; 0xa2\n",
  "  a6:	23a4      	movs	r3, #164	; 0xa4\n",
  "  a8:	23a6      	movs	r3, #166	; 0xa6\n",
  "  aa:	23a8      	movs	r3, #168	; 0xa8\n",
  "  ac:	23aa      	movs	r3, #170	; 0xaa\n",
  "  ae:	23ac      	movs	r3, #172	; 0xac\n",
  "  b0:	23ae      	movs	r3, #174	; 0xae\n",
  "  b2:	23b0      	movs	r3, #176	; 0xb0\n",
  "  b4:	23b2      	movs	r3, #178	; 0xb2\n",
  "  b6:	23b4      	movs	r3, #180	; 0xb4\n",
  "  b8:	23b6      	movs	r3, #182	; 0xb6\n",
  "  ba:	23b8      	movs	r3, #184	; 0xb8\n",
  "  bc:	23ba      	movs	r3, #186	; 0xba\n",
  "  be:	23bc      	movs	r3, #188	; 0xbc\n",
  "  c0:	23be      	movs	r3, #190	; 0xbe\n",
  "  c2:	23c0      	movs	r3, #192	; 0xc0\n",
  "  c4:	23c2      	movs	r3, #194	; 0xc2\n",
  "  c6:	23c4      	movs	r3, #196	; 0xc4\n",
  "  c8:	23c6      	movs	r3, #198	; 0xc6\n",
  "  ca:	23c8      	movs	r3, #200	; 0xc8\n",
  "  cc:	23ca      	movs	r3, #202	; 0xca\n",
  "  ce:	23cc      	movs	r3, #204	; 0xcc\n",
  "  d0:	23ce      	movs	r3, #206	; 0xce\n",
  "  d2:	23d0      	movs	r3, #208	; 0xd0\n",
  "  d4:	23d2      	movs	r3, #210	; 0xd2\n",
  "  d6:	23d4      	movs	r3, #212	; 0xd4\n",
  "  d8:	23d6      	movs	r3, #214	; 0xd6\n",
  "  da:	23d8      	movs	r3, #216	; 0xd8\n",
  "  dc:	23da      	movs	r3, #218	; 0xda\n",
  "  de:	23dc      	movs	r3, #220	; 0xdc\n",
  "  e0:	23de      	movs	r3, #222	; 0xde\n",
  "  e2:	23e0      	movs	r3, #224	; 0xe0\n",
  "  e4:	23e2      	movs	r3, #226	; 0xe2\n",
  "  e6:	23e4      	movs	r3, #228	; 0xe4\n",
  "  e8:	23e6      	movs	r3, #230	; 0xe6\n",
  "  ea:	23e8      	movs	r3, #232	; 0xe8\n",
  "  ec:	23ea      	movs	r3, #234	; 0xea\n",
  "  ee:	23ec      	movs	r3, #236	; 0xec\n",
  "  f0:	23ee      	movs	r3, #238	; 0xee\n",
  "  f2:	23f0      	movs	r3, #240	; 0xf0\n",
  "  f4:	23f2      	movs	r3, #242	; 0xf2\n",
  "  f6:	23f4      	movs	r3, #244	; 0xf4\n",
  "  f8:	23f6      	movs	r3, #246	; 0xf6\n",
  "  fa:	23f8      	movs	r3, #248	; 0xf8\n",
  "  fc:	23fa      	movs	r3, #250	; 0xfa\n",
  "  fe:	23fc      	movs	r3, #252	; 0xfc\n",
  " 100:	23fe      	movs	r3, #254	; 0xfe\n",
  " 102:	2300      	movs	r3, #0\n",
  " 104:	2302      	movs	r3, #2\n",
  " 106:	2304      	movs	r3, #4\n",
  " 108:	2306      	movs	r3, #6\n",
  " 10a:	2308      	movs	r3, #8\n",
  " 10c:	230a      	movs	r3, #10\n",
  " 10e:	230c      	movs	r3, #12\n",
  " 110:	230e      	movs	r3, #14\n",
  " 112:	2310      	movs	r3, #16\n",
  " 114:	2312      	movs	r3, #18\n",
  " 116:	2314      	movs	r3, #20\n",
  " 118:	2316      	movs	r3, #22\n",
  " 11a:	2318      	movs	r3, #24\n",
  " 11c:	231a      	movs	r3, #26\n",
  " 11e:	231c      	movs	r3, #28\n",
  " 120:	231e      	movs	r3, #30\n",
  " 122:	2320      	movs	r3, #32\n",
  " 124:	2322      	movs	r3, #34	; 0x22\n",
  " 126:	2324      	movs	r3, #36	; 0x24\n",
  " 128:	2326      	movs	r3, #38	; 0x26\n",
  " 12a:	2328      	movs	r3, #40	; 0x28\n",
  " 12c:	232a      	movs	r3, #42	; 0x2a\n",
  " 12e:	232c      	movs	r3, #44	; 0x2c\n",
  " 130:	232e      	movs	r3, #46	; 0x2e\n",
  " 132:	2330      	movs	r3, #48	; 0x30\n",
  " 134:	2332      	movs	r3, #50	; 0x32\n",
  " 136:	2334      	movs	r3, #52	; 0x34\n",
  " 138:	2336      	movs	r3, #54	; 0x36\n",
  " 13a:	2338      	movs	r3, #56	; 0x38\n",
  " 13c:	233a      	movs	r3, #58	; 0x3a\n",
  " 13e:	233c      	movs	r3, #60	; 0x3c\n",
  " 140:	233e      	movs	r3, #62	; 0x3e\n",
  " 142:	2340      	movs	r3, #64	; 0x40\n",
  " 144:	2342      	movs	r3, #66	; 0x42\n",
  " 146:	2344      	movs	r3, #68	; 0x44\n",
  " 148:	2346      	movs	r3, #70	; 0x46\n",
  " 14a:	2348      	movs	r3, #72	; 0x48\n",
  " 14c:	234a      	movs	r3, #74	; 0x4a\n",
  " 14e:	234c      	movs	r3, #76	; 0x4c\n",
  " 150:	234e      	movs	r3, #78	; 0x4e\n",
  " 152:	2350      	movs	r3, #80	; 0x50\n",
  " 154:	2352      	movs	r3, #82	; 0x52\n",
  " 156:	2354      	movs	r3, #84	; 0x54\n",
  " 158:	2356      	movs	r3, #86	; 0x56\n",
  " 15a:	2358      	movs	r3, #88	; 0x58\n",
  " 15c:	235a      	movs	r3, #90	; 0x5a\n",
  " 15e:	235c      	movs	r3, #92	; 0x5c\n",
  " 160:	235e      	movs	r3, #94	; 0x5e\n",
  " 162:	2360      	movs	r3, #96	; 0x60\n",
  " 164:	2362      	movs	r3, #98	; 0x62\n",
  " 166:	2364      	movs	r3, #100	; 0x64\n",
  " 168:	2366      	movs	r3, #102	; 0x66\n",
  " 16a:	2368      	movs	r3, #104	; 0x68\n",
  " 16c:	236a      	movs	r3, #106	; 0x6a\n",
  " 16e:	236c      	movs	r3, #108	; 0x6c\n",
  " 170:	236e      	movs	r3, #110	; 0x6e\n",
  " 172:	2370      	movs	r3, #112	; 0x70\n",
  " 174:	2372      	movs	r3, #114	; 0x72\n",
  " 176:	2374      	movs	r3, #116	; 0x74\n",
  " 178:	2376      	movs	r3, #118	; 0x76\n",
  " 17a:	2378      	movs	r3, #120	; 0x78\n",
  " 17c:	237a      	movs	r3, #122	; 0x7a\n",
  " 17e:	237c      	movs	r3, #124	; 0x7c\n",
  " 180:	237e      	movs	r3, #126	; 0x7e\n",
  " 182:	2380      	movs	r3, #128	; 0x80\n",
  " 184:	2382      	movs	r3, #130	; 0x82\n",
  " 186:	2384      	movs	r3, #132	; 0x84\n",
  " 188:	2386      	movs	r3, #134	; 0x86\n",
  " 18a:	2388      	movs	r3, #136	; 0x88\n",
  " 18c:	238a      	movs	r3, #138	; 0x8a\n",
  " 18e:	238c      	movs	r3, #140	; 0x8c\n",
  " 190:	238e      	movs	r3, #142	; 0x8e\n",
  " 192:	2390      	movs	r3, #144	; 0x90\n",
  " 194:	2392      	movs	r3, #146	; 0x92\n",
  " 196:	2394      	movs	r3, #148	; 0x94\n",
  " 198:	2396      	movs	r3, #150	; 0x96\n",
  " 19a:	2398      	movs	r3, #152	; 0x98\n",
  " 19c:	239a      	movs	r3, #154	; 0x9a\n",
  " 19e:	239c      	movs	r3, #156	; 0x9c\n",
  " 1a0:	239e      	movs	r3, #158	; 0x9e\n",
  " 1a2:	23a0      	movs	r3, #160	; 0xa0\n",
  " 1a4:	23a2      	movs	r3, #162	; 0xa2\n",
  " 1a6:	23a4      	movs	r3, #164	; 0xa4\n",
  " 1a8:	23a6      	movs	r3, #166	; 0xa6\n",
  " 1aa:	23a8      	movs	r3, #168	; 0xa8\n",
  " 1ac:	23aa      	movs	r3, #170	; 0xaa\n",
  " 1ae:	23ac      	movs	r3, #172	; 0xac\n",
  " 1b0:	23ae      	movs	r3, #174	; 0xae\n",
  " 1b2:	23b0      	movs	r3, #176	; 0xb0\n",
  " 1b4:	23b2      	movs	r3, #178	; 0xb2\n",
  " 1b6:	23b4      	movs	r3, #180	; 0xb4\n",
  " 1b8:	23b6      	movs	r3, #182	; 0xb6\n",
  " 1ba:	23b8      	movs	r3, #184	; 0xb8\n",
  " 1bc:	23ba      	movs	r3, #186	; 0xba\n",
  " 1be:	23bc      	movs	r3, #188	; 0xbc\n",
  " 1c0:	23be      	movs	r3, #190	; 0xbe\n",
  " 1c2:	23c0      	movs	r3, #192	; 0xc0\n",
  " 1c4:	23c2      	movs	r3, #194	; 0xc2\n",
  " 1c6:	23c4      	movs	r3, #196	; 0xc4\n",
  " 1c8:	23c6      	movs	r3, #198	; 0xc6\n",
  " 1ca:	23c8      	movs	r3, #200	; 0xc8\n",
  " 1cc:	23ca      	movs	r3, #202	; 0xca\n",
  " 1ce:	23cc      	movs	r3, #204	; 0xcc\n",
  " 1d0:	23ce      	movs	r3, #206	; 0xce\n",
  " 1d2:	23d0      	movs	r3, #208	; 0xd0\n",
  " 1d4:	23d2      	movs	r3, #210	; 0xd2\n",
  " 1d6:	23d4      	movs	r3, #212	; 0xd4\n",
  " 1d8:	23d6      	movs	r3, #214	; 0xd6\n",
  " 1da:	23d8      	movs	r3, #216	; 0xd8\n",
  " 1dc:	23da      	movs	r3, #218	; 0xda\n",
  " 1de:	23dc      	movs	r3, #220	; 0xdc\n",
  " 1e0:	23de      	movs	r3, #222	; 0xde\n",
  " 1e2:	23e0      	movs	r3, #224	; 0xe0\n",
  " 1e4:	23e2      	movs	r3, #226	; 0xe2\n",
  " 1e6:	23e4      	movs	r3, #228	; 0xe4\n",
  " 1e8:	23e6      	movs	r3, #230	; 0xe6\n",
  " 1ea:	23e8      	movs	r3, #232	; 0xe8\n",
  " 1ec:	23ea      	movs	r3, #234	; 0xea\n",
  " 1ee:	23ec      	movs	r3, #236	; 0xec\n",
  " 1f0:	23ee      	movs	r3, #238	; 0xee\n",
  " 1f2:	23f0      	movs	r3, #240	; 0xf0\n",
  " 1f4:	23f2      	movs	r3, #242	; 0xf2\n",
  " 1f6:	23f4      	movs	r3, #244	; 0xf4\n",
  " 1f8:	23f6      	movs	r3, #246	; 0xf6\n",
  " 1fa:	23f8      	movs	r3, #248	; 0xf8\n",
  " 1fc:	23fa      	movs	r3, #250	; 0xfa\n",
  " 1fe:	23fc      	movs	r3, #252	; 0xfc\n",
  " 200:	23fe      	movs	r3, #254	; 0xfe\n",
  " 202:	2300      	movs	r3, #0\n",
  " 204:	2302      	movs	r3, #2\n",
  " 206:	2304      	movs	r3, #4\n",
  " 208:	2306      	movs	r3, #6\n",
  " 20a:	2308      	movs	r3, #8\n",
  " 20c:	230a      	movs	r3, #10\n",
  " 20e:	230c      	movs	r3, #12\n",
  " 210:	230e      	movs	r3, #14\n",
  " 212:	2310      	movs	r3, #16\n",
  " 214:	2312      	movs	r3, #18\n",
  " 216:	2314      	movs	r3, #20\n",
  " 218:	2316      	movs	r3, #22\n",
  " 21a:	2318      	movs	r3, #24\n",
  " 21c:	231a      	movs	r3, #26\n",
  " 21e:	231c      	movs	r3, #28\n",
  " 220:	231e      	movs	r3, #30\n",
  " 222:	2320      	movs	r3, #32\n",
  " 224:	2322      	movs	r3, #34	; 0x22\n",
  " 226:	2324      	movs	r3, #36	; 0x24\n",
  " 228:	2326      	movs	r3, #38	; 0x26\n",
  " 22a:	2328      	movs	r3, #40	; 0x28\n",
  " 22c:	232a      	movs	r3, #42	; 0x2a\n",
  " 22e:	232c      	movs	r3, #44	; 0x2c\n",
  " 230:	232e      	movs	r3, #46	; 0x2e\n",
  " 232:	2330      	movs	r3, #48	; 0x30\n",
  " 234:	2332      	movs	r3, #50	; 0x32\n",
  " 236:	2334      	movs	r3, #52	; 0x34\n",
  " 238:	2336      	movs	r3, #54	; 0x36\n",
  " 23a:	2338      	movs	r3, #56	; 0x38\n",
  " 23c:	233a      	movs	r3, #58	; 0x3a\n",
  " 23e:	233c      	movs	r3, #60	; 0x3c\n",
  " 240:	233e      	movs	r3, #62	; 0x3e\n",
  " 242:	2340      	movs	r3, #64	; 0x40\n",
  " 244:	2342      	movs	r3, #66	; 0x42\n",
  " 246:	2344      	movs	r3, #68	; 0x44\n",
  " 248:	2346      	movs	r3, #70	; 0x46\n",
  " 24a:	2348      	movs	r3, #72	; 0x48\n",
  " 24c:	234a      	movs	r3, #74	; 0x4a\n",
  " 24e:	234c      	movs	r3, #76	; 0x4c\n",
  " 250:	234e      	movs	r3, #78	; 0x4e\n",
  " 252:	2350      	movs	r3, #80	; 0x50\n",
  " 254:	2352      	movs	r3, #82	; 0x52\n",
  " 256:	2354      	movs	r3, #84	; 0x54\n",
  " 258:	2356      	movs	r3, #86	; 0x56\n",
  " 25a:	2358      	movs	r3, #88	; 0x58\n",
  " 25c:	235a      	movs	r3, #90	; 0x5a\n",
  " 25e:	235c      	movs	r3, #92	; 0x5c\n",
  " 260:	235e      	movs	r3, #94	; 0x5e\n",
  " 262:	2360      	movs	r3, #96	; 0x60\n",
  " 264:	2362      	movs	r3, #98	; 0x62\n",
  " 266:	2364      	movs	r3, #100	; 0x64\n",
  " 268:	2366      	movs	r3, #102	; 0x66\n",
  " 26a:	2368      	movs	r3, #104	; 0x68\n",
  " 26c:	236a      	movs	r3, #106	; 0x6a\n",
  " 26e:	236c      	movs	r3, #108	; 0x6c\n",
  " 270:	236e      	movs	r3, #110	; 0x6e\n",
  " 272:	2370      	movs	r3, #112	; 0x70\n",
  " 274:	2372      	movs	r3, #114	; 0x72\n",
  " 276:	2374      	movs	r3, #116	; 0x74\n",
  " 278:	2376      	movs	r3, #118	; 0x76\n",
  " 27a:	2378      	movs	r3, #120	; 0x78\n",
  " 27c:	237a      	movs	r3, #122	; 0x7a\n",
  " 27e:	237c      	movs	r3, #124	; 0x7c\n",
  " 280:	237e      	movs	r3, #126	; 0x7e\n",
  " 282:	2380      	movs	r3, #128	; 0x80\n",
  " 284:	2382      	movs	r3, #130	; 0x82\n",
  " 286:	2384      	movs	r3, #132	; 0x84\n",
  " 288:	2386      	movs	r3, #134	; 0x86\n",
  " 28a:	2388      	movs	r3, #136	; 0x88\n",
  " 28c:	238a      	movs	r3, #138	; 0x8a\n",
  " 28e:	238c      	movs	r3, #140	; 0x8c\n",
  " 290:	238e      	movs	r3, #142	; 0x8e\n",
  " 292:	2390      	movs	r3, #144	; 0x90\n",
  " 294:	2392      	movs	r3, #146	; 0x92\n",
  " 296:	2394      	movs	r3, #148	; 0x94\n",
  " 298:	2396      	movs	r3, #150	; 0x96\n",
  " 29a:	2398      	movs	r3, #152	; 0x98\n",
  " 29c:	239a      	movs	r3, #154	; 0x9a\n",
  " 29e:	239c      	movs	r3, #156	; 0x9c\n",
  " 2a0:	239e      	movs	r3, #158	; 0x9e\n",
  " 2a2:	23a0      	movs	r3, #160	; 0xa0\n",
  " 2a4:	23a2      	movs	r3, #162	; 0xa2\n",
  " 2a6:	23a4      	movs	r3, #164	; 0xa4\n",
  " 2a8:	23a6      	movs	r3, #166	; 0xa6\n",
  " 2aa:	23a8      	movs	r3, #168	; 0xa8\n",
  " 2ac:	23aa      	movs	r3, #170	; 0xaa\n",
  " 2ae:	23ac      	movs	r3, #172	; 0xac\n",
  " 2b0:	23ae      	movs	r3, #174	; 0xae\n",
  " 2b2:	23b0      	movs	r3, #176	; 0xb0\n",
  " 2b4:	23b2      	movs	r3, #178	; 0xb2\n",
  " 2b6:	23b4      	movs	r3, #180	; 0xb4\n",
  " 2b8:	23b6      	movs	r3, #182	; 0xb6\n",
  " 2ba:	23b8      	movs	r3, #184	; 0xb8\n",
  " 2bc:	23ba      	movs	r3, #186	; 0xba\n",
  " 2be:	23bc      	movs	r3, #188	; 0xbc\n",
  " 2c0:	23be      	movs	r3, #190	; 0xbe\n",
  " 2c2:	23c0      	movs	r3, #192	; 0xc0\n",
  " 2c4:	23c2      	movs	r3, #194	; 0xc2\n",
  " 2c6:	23c4      	movs	r3, #196	; 0xc4\n",
  " 2c8:	23c6      	movs	r3, #198	; 0xc6\n",
  " 2ca:	23c8      	movs	r3, #200	; 0xc8\n",
  " 2cc:	23ca      	movs	r3, #202	; 0xca\n",
  " 2ce:	23cc      	movs	r3, #204	; 0xcc\n",
  " 2d0:	23ce      	movs	r3, #206	; 0xce\n",
  " 2d2:	23d0      	movs	r3, #208	; 0xd0\n",
  " 2d4:	23d2      	movs	r3, #210	; 0xd2\n",
  " 2d6:	23d4      	movs	r3, #212	; 0xd4\n",
  " 2d8:	23d6      	movs	r3, #214	; 0xd6\n",
  " 2da:	23d8      	movs	r3, #216	; 0xd8\n",
  " 2dc:	23da      	movs	r3, #218	; 0xda\n",
  " 2de:	23dc      	movs	r3, #220	; 0xdc\n",
  " 2e0:	23de      	movs	r3, #222	; 0xde\n",
  " 2e2:	23e0      	movs	r3, #224	; 0xe0\n",
  " 2e4:	23e2      	movs	r3, #226	; 0xe2\n",
  " 2e6:	23e4      	movs	r3, #228	; 0xe4\n",
  " 2e8:	23e6      	movs	r3, #230	; 0xe6\n",
  " 2ea:	23e8      	movs	r3, #232	; 0xe8\n",
  " 2ec:	23ea      	movs	r3, #234	; 0xea\n",
  " 2ee:	23ec      	movs	r3, #236	; 0xec\n",
  " 2f0:	23ee      	movs	r3, #238	; 0xee\n",
  " 2f2:	23f0      	movs	r3, #240	; 0xf0\n",
  " 2f4:	23f2      	movs	r3, #242	; 0xf2\n",
  " 2f6:	23f4      	movs	r3, #244	; 0xf4\n",
  " 2f8:	23f6      	movs	r3, #246	; 0xf6\n",
  " 2fa:	23f8      	movs	r3, #248	; 0xf8\n",
  " 2fc:	23fa      	movs	r3, #250	; 0xfa\n",
  " 2fe:	23fc      	movs	r3, #252	; 0xfc\n",
  " 300:	23fe      	movs	r3, #254	; 0xfe\n",
  " 302:	2300      	movs	r3, #0\n",
  " 304:	2302      	movs	r3, #2\n",
  " 306:	2304      	movs	r3, #4\n",
  " 308:	2306      	movs	r3, #6\n",
  " 30a:	2308      	movs	r3, #8\n",
  " 30c:	230a      	movs	r3, #10\n",
  " 30e:	230c      	movs	r3, #12\n",
  " 310:	230e      	movs	r3, #14\n",
  " 312:	2310      	movs	r3, #16\n",
  " 314:	2312      	movs	r3, #18\n",
  " 316:	2314      	movs	r3, #20\n",
  " 318:	2316      	movs	r3, #22\n",
  " 31a:	2318      	movs	r3, #24\n",
  " 31c:	231a      	movs	r3, #26\n",
  " 31e:	231c      	movs	r3, #28\n",
  " 320:	231e      	movs	r3, #30\n",
  " 322:	2320      	movs	r3, #32\n",
  " 324:	2322      	movs	r3, #34	; 0x22\n",
  " 326:	2324      	movs	r3, #36	; 0x24\n",
  " 328:	2326      	movs	r3, #38	; 0x26\n",
  " 32a:	2328      	movs	r3, #40	; 0x28\n",
  " 32c:	232a      	movs	r3, #42	; 0x2a\n",
  " 32e:	232c      	movs	r3, #44	; 0x2c\n",
  " 330:	232e      	movs	r3, #46	; 0x2e\n",
  " 332:	2330      	movs	r3, #48	; 0x30\n",
  " 334:	2332      	movs	r3, #50	; 0x32\n",
  " 336:	2334      	movs	r3, #52	; 0x34\n",
  " 338:	2336      	movs	r3, #54	; 0x36\n",
  " 33a:	2338      	movs	r3, #56	; 0x38\n",
  " 33c:	233a      	movs	r3, #58	; 0x3a\n",
  " 33e:	233c      	movs	r3, #60	; 0x3c\n",
  " 340:	233e      	movs	r3, #62	; 0x3e\n",
  " 342:	2340      	movs	r3, #64	; 0x40\n",
  " 344:	2342      	movs	r3, #66	; 0x42\n",
  " 346:	2344      	movs	r3, #68	; 0x44\n",
  " 348:	2346      	movs	r3, #70	; 0x46\n",
  " 34a:	2348      	movs	r3, #72	; 0x48\n",
  " 34c:	234a      	movs	r3, #74	; 0x4a\n",
  " 34e:	234c      	movs	r3, #76	; 0x4c\n",
  " 350:	234e      	movs	r3, #78	; 0x4e\n",
  " 352:	2350      	movs	r3, #80	; 0x50\n",
  " 354:	2352      	movs	r3, #82	; 0x52\n",
  " 356:	2354      	movs	r3, #84	; 0x54\n",
  " 358:	2356      	movs	r3, #86	; 0x56\n",
  " 35a:	2358      	movs	r3, #88	; 0x58\n",
  " 35c:	235a      	movs	r3, #90	; 0x5a\n",
  " 35e:	235c      	movs	r3, #92	; 0x5c\n",
  " 360:	235e      	movs	r3, #94	; 0x5e\n",
  " 362:	2360      	movs	r3, #96	; 0x60\n",
  " 364:	2362      	movs	r3, #98	; 0x62\n",
  " 366:	2364      	movs	r3, #100	; 0x64\n",
  " 368:	2366      	movs	r3, #102	; 0x66\n",
  " 36a:	2368      	movs	r3, #104	; 0x68\n",
  " 36c:	236a      	movs	r3, #106	; 0x6a\n",
  " 36e:	236c      	movs	r3, #108	; 0x6c\n",
  " 370:	236e      	movs	r3, #110	; 0x6e\n",
  " 372:	2370      	movs	r3, #112	; 0x70\n",
  " 374:	2372      	movs	r3, #114	; 0x72\n",
  " 376:	2374      	movs	r3, #116	; 0x74\n",
  " 378:	2376      	movs	r3, #118	; 0x76\n",
  " 37a:	2378      	movs	r3, #120	; 0x78\n",
  " 37c:	237a      	movs	r3, #122	; 0x7a\n",
  " 37e:	237c      	movs	r3, #124	; 0x7c\n",
  " 380:	237e      	movs	r3, #126	; 0x7e\n",
  " 382:	2380      	movs	r3, #128	; 0x80\n",
  " 384:	2382      	movs	r3, #130	; 0x82\n",
  " 386:	2384      	movs	r3, #132	; 0x84\n",
  " 388:	2386      	movs	r3, #134	; 0x86\n",
  " 38a:	2388      	movs	r3, #136	; 0x88\n",
  " 38c:	238a      	movs	r3, #138	; 0x8a\n",
  " 38e:	238c      	movs	r3, #140	; 0x8c\n",
  " 390:	238e      	movs	r3, #142	; 0x8e\n",
  " 392:	2390      	movs	r3, #144	; 0x90\n",
  " 394:	2392      	movs	r3, #146	; 0x92\n",
  " 396:	2394      	movs	r3, #148	; 0x94\n",
  " 398:	2396      	movs	r3, #150	; 0x96\n",
  " 39a:	2398      	movs	r3, #152	; 0x98\n",
  " 39c:	239a      	movs	r3, #154	; 0x9a\n",
  " 39e:	239c      	movs	r3, #156	; 0x9c\n",
  " 3a0:	239e      	movs	r3, #158	; 0x9e\n",
  " 3a2:	23a0      	movs	r3, #160	; 0xa0\n",
  " 3a4:	23a2      	movs	r3, #162	; 0xa2\n",
  " 3a6:	23a4      	movs	r3, #164	; 0xa4\n",
  " 3a8:	23a6      	movs	r3, #166	; 0xa6\n",
  " 3aa:	23a8      	movs	r3, #168	; 0xa8\n",
  " 3ac:	23aa      	movs	r3, #170	; 0xaa\n",
  " 3ae:	23ac      	movs	r3, #172	; 0xac\n",
  " 3b0:	23ae      	movs	r3, #174	; 0xae\n",
  " 3b2:	23b0      	movs	r3, #176	; 0xb0\n",
  " 3b4:	23b2      	movs	r3, #178	; 0xb2\n",
  " 3b6:	23b4      	movs	r3, #180	; 0xb4\n",
  " 3b8:	23b6      	movs	r3, #182	; 0xb6\n",
  " 3ba:	23b8      	movs	r3, #184	; 0xb8\n",
  " 3bc:	23ba      	movs	r3, #186	; 0xba\n",
  " 3be:	23bc      	movs	r3, #188	; 0xbc\n",
  " 3c0:	23be      	movs	r3, #190	; 0xbe\n",
  " 3c2:	23c0      	movs	r3, #192	; 0xc0\n",
  " 3c4:	23c2      	movs	r3, #194	; 0xc2\n",
  " 3c6:	23c4      	movs	r3, #196	; 0xc4\n",
  " 3c8:	23c6      	movs	r3, #198	; 0xc6\n",
  " 3ca:	23c8      	movs	r3, #200	; 0xc8\n",
  " 3cc:	23ca      	movs	r3, #202	; 0xca\n",
  " 3ce:	23cc      	movs	r3, #204	; 0xcc\n",
  " 3d0:	23ce      	movs	r3, #206	; 0xce\n",
  " 3d2:	23d0      	movs	r3, #208	; 0xd0\n",
  " 3d4:	23d2      	movs	r3, #210	; 0xd2\n",
  " 3d6:	23d4      	movs	r3, #212	; 0xd4\n",
  " 3d8:	23d6      	movs	r3, #214	; 0xd6\n",
  " 3da:	23d8      	movs	r3, #216	; 0xd8\n",
  " 3dc:	23da      	movs	r3, #218	; 0xda\n",
  " 3de:	23dc      	movs	r3, #220	; 0xdc\n",
  " 3e0:	23de      	movs	r3, #222	; 0xde\n",
  " 3e2:	23e0      	movs	r3, #224	; 0xe0\n",
  " 3e4:	23e2      	movs	r3, #226	; 0xe2\n",
  " 3e6:	23e4      	movs	r3, #228	; 0xe4\n",
  " 3e8:	23e6      	movs	r3, #230	; 0xe6\n",
  " 3ea:	23e8      	movs	r3, #232	; 0xe8\n",
  " 3ec:	23ea      	movs	r3, #234	; 0xea\n",
  " 3ee:	23ec      	movs	r3, #236	; 0xec\n",
  " 3f0:	23ee      	movs	r3, #238	; 0xee\n",
  " 3f2:	23f0      	movs	r3, #240	; 0xf0\n",
  " 3f4:	23f2      	movs	r3, #242	; 0xf2\n",
  " 3f6:	23f4      	movs	r3, #244	; 0xf4\n",
  " 3f8:	23f6      	movs	r3, #246	; 0xf6\n",
  " 3fa:	23f8      	movs	r3, #248	; 0xf8\n",
  " 3fc:	23fa      	movs	r3, #250	; 0xfa\n",
  " 3fe:	23fc      	movs	r3, #252	; 0xfc\n",
  " 400:	23fe      	movs	r3, #254	; 0xfe\n",
  " 402:	2300      	movs	r3, #0\n",
  " 404:	2302      	movs	r3, #2\n",
  " 406:	2304      	movs	r3, #4\n",
  " 408:	2306      	movs	r3, #6\n",
  " 40a:	2308      	movs	r3, #8\n",
  " 40c:	230a      	movs	r3, #10\n",
  " 40e:	230c      	movs	r3, #12\n",
  " 410:	230e      	movs	r3, #14\n",
  " 412:	2310      	movs	r3, #16\n",
  " 414:	2312      	movs	r3, #18\n",
  " 416:	2314      	movs	r3, #20\n",
  " 418:	2316      	movs	r3, #22\n",
  " 41a:	2318      	movs	r3, #24\n",
  " 41c:	231a      	movs	r3, #26\n",
  " 41e:	231c      	movs	r3, #28\n",
  " 420:	231e      	movs	r3, #30\n",
  " 422:	2320      	movs	r3, #32\n",
  " 424:	2322      	movs	r3, #34	; 0x22\n",
  " 426:	2324      	movs	r3, #36	; 0x24\n",
  " 428:	2326      	movs	r3, #38	; 0x26\n",
  " 42a:	2328      	movs	r3, #40	; 0x28\n",
  " 42c:	232a      	movs	r3, #42	; 0x2a\n",
  " 42e:	232c      	movs	r3, #44	; 0x2c\n",
  " 430:	232e      	movs	r3, #46	; 0x2e\n",
  " 432:	2330      	movs	r3, #48	; 0x30\n",
  " 434:	2332      	movs	r3, #50	; 0x32\n",
  " 436:	2334      	movs	r3, #52	; 0x34\n",
  " 438:	2336      	movs	r3, #54	; 0x36\n",
  " 43a:	2338      	movs	r3, #56	; 0x38\n",
  " 43c:	233a      	movs	r3, #58	; 0x3a\n",
  " 43e:	233c      	movs	r3, #60	; 0x3c\n",
  " 440:	233e      	movs	r3, #62	; 0x3e\n",
  " 442:	2340      	movs	r3, #64	; 0x40\n",
  " 444:	2342      	movs	r3, #66	; 0x42\n",
  " 446:	2344      	movs	r3, #68	; 0x44\n",
  " 448:	2346      	movs	r3, #70	; 0x46\n",
  " 44a:	2348      	movs	r3, #72	; 0x48\n",
  " 44c:	234a      	movs	r3, #74	; 0x4a\n",
  " 44e:	234c      	movs	r3, #76	; 0x4c\n",
  " 450:	234e      	movs	r3, #78	; 0x4e\n",
  " 452:	2350      	movs	r3, #80	; 0x50\n",
  " 454:	2352      	movs	r3, #82	; 0x52\n",
  " 456:	2354      	movs	r3, #84	; 0x54\n",
  " 458:	2356      	movs	r3, #86	; 0x56\n",
  " 45a:	2358      	movs	r3, #88	; 0x58\n",
  " 45c:	235a      	movs	r3, #90	; 0x5a\n",
  " 45e:	235c      	movs	r3, #92	; 0x5c\n",
  " 460:	235e      	movs	r3, #94	; 0x5e\n",
  " 462:	2360      	movs	r3, #96	; 0x60\n",
  " 464:	2362      	movs	r3, #98	; 0x62\n",
  " 466:	2364      	movs	r3, #100	; 0x64\n",
  " 468:	2366      	movs	r3, #102	; 0x66\n",
  " 46a:	2368      	movs	r3, #104	; 0x68\n",
  " 46c:	236a      	movs	r3, #106	; 0x6a\n",
  " 46e:	236c      	movs	r3, #108	; 0x6c\n",
  " 470:	236e      	movs	r3, #110	; 0x6e\n",
  " 472:	2370      	movs	r3, #112	; 0x70\n",
  " 474:	2372      	movs	r3, #114	; 0x72\n",
  " 476:	2374      	movs	r3, #116	; 0x74\n",
  " 478:	2376      	movs	r3, #118	; 0x76\n",
  " 47a:	2378      	movs	r3, #120	; 0x78\n",
  " 47c:	237a      	movs	r3, #122	; 0x7a\n",
  " 47e:	237c      	movs	r3, #124	; 0x7c\n",
  " 480:	237e      	movs	r3, #126	; 0x7e\n",
  " 482:	2380      	movs	r3, #128	; 0x80\n",
  " 484:	2382      	movs	r3, #130	; 0x82\n",
  " 486:	2384      	movs	r3, #132	; 0x84\n",
  " 488:	2386      	movs	r3, #134	; 0x86\n",
  " 48a:	2388      	movs	r3, #136	; 0x88\n",
  " 48c:	238a      	movs	r3, #138	; 0x8a\n",
  " 48e:	238c      	movs	r3, #140	; 0x8c\n",
  " 490:	238e      	movs	r3, #142	; 0x8e\n",
  " 492:	2390      	movs	r3, #144	; 0x90\n",
  " 494:	2392      	movs	r3, #146	; 0x92\n",
  " 496:	2394      	movs	r3, #148	; 0x94\n",
  " 498:	2396      	movs	r3, #150	; 0x96\n",
  " 49a:	2398      	movs	r3, #152	; 0x98\n",
  " 49c:	239a      	movs	r3, #154	; 0x9a\n",
  " 49e:	239c      	movs	r3, #156	; 0x9c\n",
  " 4a0:	239e      	movs	r3, #158	; 0x9e\n",
  " 4a2:	23a0      	movs	r3, #160	; 0xa0\n",
  " 4a4:	23a2      	movs	r3, #162	; 0xa2\n",
  " 4a6:	23a4      	movs	r3, #164	; 0xa4\n",
  " 4a8:	23a6      	movs	r3, #166	; 0xa6\n",
  " 4aa:	23a8      	movs	r3, #168	; 0xa8\n",
  " 4ac:	23aa      	movs	r3, #170	; 0xaa\n",
  " 4ae:	23ac      	movs	r3, #172	; 0xac\n",
  " 4b0:	23ae      	movs	r3, #174	; 0xae\n",
  " 4b2:	23b0      	movs	r3, #176	; 0xb0\n",
  " 4b4:	23b2      	movs	r3, #178	; 0xb2\n",
  " 4b6:	23b4      	movs	r3, #180	; 0xb4\n",
  " 4b8:	23b6      	movs	r3, #182	; 0xb6\n",
  " 4ba:	23b8      	movs	r3, #184	; 0xb8\n",
  " 4bc:	23ba      	movs	r3, #186	; 0xba\n",
  " 4be:	23bc      	movs	r3, #188	; 0xbc\n",
  " 4c0:	23be      	movs	r3, #190	; 0xbe\n",
  " 4c2:	23c0      	movs	r3, #192	; 0xc0\n",
  " 4c4:	23c2      	movs	r3, #194	; 0xc2\n",
  " 4c6:	23c4      	movs	r3, #196	; 0xc4\n",
  " 4c8:	23c6      	movs	r3, #198	; 0xc6\n",
  " 4ca:	23c8      	movs	r3, #200	; 0xc8\n",
  " 4cc:	23ca      	movs	r3, #202	; 0xca\n",
  " 4ce:	23cc      	movs	r3, #204	; 0xcc\n",
  " 4d0:	23ce      	movs	r3, #206	; 0xce\n",
  " 4d2:	23d0      	movs	r3, #208	; 0xd0\n",
  " 4d4:	23d2      	movs	r3, #210	; 0xd2\n",
  " 4d6:	23d4      	movs	r3, #212	; 0xd4\n",
  " 4d8:	23d6      	movs	r3, #214	; 0xd6\n",
  " 4da:	23d8      	movs	r3, #216	; 0xd8\n",
  " 4dc:	23da      	movs	r3, #218	; 0xda\n",
  " 4de:	23dc      	movs	r3, #220	; 0xdc\n",
  " 4e0:	23de      	movs	r3, #222	; 0xde\n",
  " 4e2:	23e0      	movs	r3, #224	; 0xe0\n",
  " 4e4:	23e2      	movs	r3, #226	; 0xe2\n",
  " 4e6:	23e4      	movs	r3, #228	; 0xe4\n",
  " 4e8:	23e6      	movs	r3, #230	; 0xe6\n",
  " 4ea:	23e8      	movs	r3, #232	; 0xe8\n",
  " 4ec:	23ea      	movs	r3, #234	; 0xea\n",
  " 4ee:	23ec      	movs	r3, #236	; 0xec\n",
  " 4f0:	23ee      	movs	r3, #238	; 0xee\n",
  " 4f2:	23f0      	movs	r3, #240	; 0xf0\n",
  " 4f4:	23f2      	movs	r3, #242	; 0xf2\n",
  " 4f6:	23f4      	movs	r3, #244	; 0xf4\n",
  " 4f8:	23f6      	movs	r3, #246	; 0xf6\n",
  " 4fa:	23f8      	movs	r3, #248	; 0xf8\n",
  " 4fc:	23fa      	movs	r3, #250	; 0xfa\n",
  " 4fe:	23fc      	movs	r3, #252	; 0xfc\n",
  " 500:	23fe      	movs	r3, #254	; 0xfe\n",
  " 502:	2300      	movs	r3, #0\n",
  " 504:	2302      	movs	r3, #2\n",
  " 506:	2304      	movs	r3, #4\n",
  " 508:	2306      	movs	r3, #6\n",
  " 50a:	2308      	movs	r3, #8\n",
  " 50c:	230a      	movs	r3, #10\n",
  " 50e:	230c      	movs	r3, #12\n",
  " 510:	230e      	movs	r3, #14\n",
  " 512:	2310      	movs	r3, #16\n",
  " 514:	2312      	movs	r3, #18\n",
  " 516:	2314      	movs	r3, #20\n",
  " 518:	2316      	movs	r3, #22\n",
  " 51a:	2318      	movs	r3, #24\n",
  " 51c:	231a      	movs	r3, #26\n",
  " 51e:	231c      	movs	r3, #28\n",
  " 520:	231e      	movs	r3, #30\n",
  " 522:	2320      	movs	r3, #32\n",
  " 524:	2322      	movs	r3, #34	; 0x22\n",
  " 526:	2324      	movs	r3, #36	; 0x24\n",
  " 528:	2326      	movs	r3, #38	; 0x26\n",
  " 52a:	2328      	movs	r3, #40	; 0x28\n",
  " 52c:	232a      	movs	r3, #42	; 0x2a\n",
  " 52e:	232c      	movs	r3, #44	; 0x2c\n",
  " 530:	232e      	movs	r3, #46	; 0x2e\n",
  " 532:	2330      	movs	r3, #48	; 0x30\n",
  " 534:	2332      	movs	r3, #50	; 0x32\n",
  " 536:	2334      	movs	r3, #52	; 0x34\n",
  " 538:	2336      	movs	r3, #54	; 0x36\n",
  " 53a:	2338      	movs	r3, #56	; 0x38\n",
  " 53c:	233a      	movs	r3, #58	; 0x3a\n",
  " 53e:	233c      	movs	r3, #60	; 0x3c\n",
  " 540:	233e      	movs	r3, #62	; 0x3e\n",
  " 542:	2340      	movs	r3, #64	; 0x40\n",
  " 544:	2342      	movs	r3, #66	; 0x42\n",
  " 546:	2344      	movs	r3, #68	; 0x44\n",
  " 548:	2346      	movs	r3, #70	; 0x46\n",
  " 54a:	2348      	movs	r3, #72	; 0x48\n",
  " 54c:	234a      	movs	r3, #74	; 0x4a\n",
  " 54e:	234c      	movs	r3, #76	; 0x4c\n",
  " 550:	234e      	movs	r3, #78	; 0x4e\n",
  " 552:	2350      	movs	r3, #80	; 0x50\n",
  " 554:	2352      	movs	r3, #82	; 0x52\n",
  " 556:	2354      	movs	r3, #84	; 0x54\n",
  " 558:	2356      	movs	r3, #86	; 0x56\n",
  " 55a:	2358      	movs	r3, #88	; 0x58\n",
  " 55c:	235a      	movs	r3, #90	; 0x5a\n",
  " 55e:	235c      	movs	r3, #92	; 0x5c\n",
  " 560:	235e      	movs	r3, #94	; 0x5e\n",
  " 562:	2360      	movs	r3, #96	; 0x60\n",
  " 564:	2362      	movs	r3, #98	; 0x62\n",
  " 566:	2364      	movs	r3, #100	; 0x64\n",
  " 568:	2366      	movs	r3, #102	; 0x66\n",
  " 56a:	2368      	movs	r3, #104	; 0x68\n",
  " 56c:	236a      	movs	r3, #106	; 0x6a\n",
  " 56e:	236c      	movs	r3, #108	; 0x6c\n",
  " 570:	236e      	movs	r3, #110	; 0x6e\n",
  " 572:	2370      	movs	r3, #112	; 0x70\n",
  " 574:	2372      	movs	r3, #114	; 0x72\n",
  " 576:	2374      	movs	r3, #116	; 0x74\n",
  " 578:	2376      	movs	r3, #118	; 0x76\n",
  " 57a:	2378      	movs	r3, #120	; 0x78\n",
  " 57c:	237a      	movs	r3, #122	; 0x7a\n",
  " 57e:	237c      	movs	r3, #124	; 0x7c\n",
  " 580:	237e      	movs	r3, #126	; 0x7e\n",
  " 582:	2380      	movs	r3, #128	; 0x80\n",
  " 584:	2382      	movs	r3, #130	; 0x82\n",
  " 586:	2384      	movs	r3, #132	; 0x84\n",
  " 588:	2386      	movs	r3, #134	; 0x86\n",
  " 58a:	2388      	movs	r3, #136	; 0x88\n",
  " 58c:	238a      	movs	r3, #138	; 0x8a\n",
  " 58e:	238c      	movs	r3, #140	; 0x8c\n",
  " 590:	238e      	movs	r3, #142	; 0x8e\n",
  " 592:	2390      	movs	r3, #144	; 0x90\n",
  " 594:	2392      	movs	r3, #146	; 0x92\n",
  " 596:	2394      	movs	r3, #148	; 0x94\n",
  " 598:	2396      	movs	r3, #150	; 0x96\n",
  " 59a:	2398      	movs	r3, #152	; 0x98\n",
  " 59c:	239a      	movs	r3, #154	; 0x9a\n",
  " 59e:	239c      	movs	r3, #156	; 0x9c\n",
  " 5a0:	239e      	movs	r3, #158	; 0x9e\n",
  " 5a2:	23a0      	movs	r3, #160	; 0xa0\n",
  " 5a4:	23a2      	movs	r3, #162	; 0xa2\n",
  " 5a6:	23a4      	movs	r3, #164	; 0xa4\n",
  " 5a8:	23a6      	movs	r3, #166	; 0xa6\n",
  " 5aa:	23a8      	movs	r3, #168	; 0xa8\n",
  " 5ac:	23aa      	movs	r3, #170	; 0xaa\n",
  " 5ae:	23ac      	movs	r3, #172	; 0xac\n",
  " 5b0:	23ae      	movs	r3, #174	; 0xae\n",
  " 5b2:	23b0      	movs	r3, #176	; 0xb0\n",
  " 5b4:	23b2      	movs	r3, #178	; 0xb2\n",
  " 5b6:	23b4      	movs	r3, #180	; 0xb4\n",
  " 5b8:	23b6      	movs	r3, #182	; 0xb6\n",
  " 5ba:	23b8      	movs	r3, #184	; 0xb8\n",
  " 5bc:	23ba      	movs	r3, #186	; 0xba\n",
  " 5be:	23bc      	movs	r3, #188	; 0xbc\n",
  " 5c0:	23be      	movs	r3, #190	; 0xbe\n",
  " 5c2:	23c0      	movs	r3, #192	; 0xc0\n",
  " 5c4:	23c2      	movs	r3, #194	; 0xc2\n",
  " 5c6:	23c4      	movs	r3, #196	; 0xc4\n",
  " 5c8:	23c6      	movs	r3, #198	; 0xc6\n",
  " 5ca:	23c8      	movs	r3, #200	; 0xc8\n",
  " 5cc:	23ca      	movs	r3, #202	; 0xca\n",
  " 5ce:	23cc      	movs	r3, #204	; 0xcc\n",
  " 5d0:	23ce      	movs	r3, #206	; 0xce\n",
  " 5d2:	23d0      	movs	r3, #208	; 0xd0\n",
  " 5d4:	23d2      	movs	r3, #210	; 0xd2\n",
  " 5d6:	23d4      	movs	r3, #212	; 0xd4\n",
  " 5d8:	23d6      	movs	r3, #214	; 0xd6\n",
  " 5da:	23d8      	movs	r3, #216	; 0xd8\n",
  " 5dc:	23da      	movs	r3, #218	; 0xda\n",
  " 5de:	23dc      	movs	r3, #220	; 0xdc\n",
  " 5e0:	23de      	movs	r3, #222	; 0xde\n",
  " 5e2:	23e0      	movs	r3, #224	; 0xe0\n",
  " 5e4:	23e2      	movs	r3, #226	; 0xe2\n",
  " 5e6:	23e4      	movs	r3, #228	; 0xe4\n",
  " 5e8:	23e6      	movs	r3, #230	; 0xe6\n",
  " 5ea:	23e8      	movs	r3, #232	; 0xe8\n",
  " 5ec:	23ea      	movs	r3, #234	; 0xea\n",
  " 5ee:	23ec      	movs	r3, #236	; 0xec\n",
  " 5f0:	23ee      	movs	r3, #238	; 0xee\n",
  " 5f2:	23f0      	movs	r3, #240	; 0xf0\n",
  " 5f4:	23f2      	movs	r3, #242	; 0xf2\n",
  " 5f6:	23f4      	movs	r3, #244	; 0xf4\n",
  " 5f8:	23f6      	movs	r3, #246	; 0xf6\n",
  " 5fa:	23f8      	movs	r3, #248	; 0xf8\n",
  " 5fc:	23fa      	movs	r3, #250	; 0xfa\n",
  " 5fe:	23fc      	movs	r3, #252	; 0xfc\n",
  " 600:	23fe      	movs	r3, #254	; 0xfe\n",
  " 602:	2300      	movs	r3, #0\n",
  " 604:	2302      	movs	r3, #2\n",
  " 606:	2304      	movs	r3, #4\n",
  " 608:	2306      	movs	r3, #6\n",
  " 60a:	2308      	movs	r3, #8\n",
  " 60c:	230a      	movs	r3, #10\n",
  " 60e:	230c      	movs	r3, #12\n",
  " 610:	230e      	movs	r3, #14\n",
  " 612:	2310      	movs	r3, #16\n",
  " 614:	2312      	movs	r3, #18\n",
  " 616:	2314      	movs	r3, #20\n",
  " 618:	2316      	movs	r3, #22\n",
  " 61a:	2318      	movs	r3, #24\n",
  " 61c:	231a      	movs	r3, #26\n",
  " 61e:	231c      	movs	r3, #28\n",
  " 620:	231e      	movs	r3, #30\n",
  " 622:	2320      	movs	r3, #32\n",
  " 624:	2322      	movs	r3, #34	; 0x22\n",
  " 626:	2324      	movs	r3, #36	; 0x24\n",
  " 628:	2326      	movs	r3, #38	; 0x26\n",
  " 62a:	2328      	movs	r3, #40	; 0x28\n",
  " 62c:	232a      	movs	r3, #42	; 0x2a\n",
  " 62e:	232c      	movs	r3, #44	; 0x2c\n",
  " 630:	232e      	movs	r3, #46	; 0x2e\n",
  " 632:	2330      	movs	r3, #48	; 0x30\n",
  " 634:	2332      	movs	r3, #50	; 0x32\n",
  " 636:	2334      	movs	r3, #52	; 0x34\n",
  " 638:	2336      	movs	r3, #54	; 0x36\n",
  " 63a:	2338      	movs	r3, #56	; 0x38\n",
  " 63c:	233a      	movs	r3, #58	; 0x3a\n",
  " 63e:	233c      	movs	r3, #60	; 0x3c\n",
  " 640:	233e      	movs	r3, #62	; 0x3e\n",
  " 642:	2340      	movs	r3, #64	; 0x40\n",
  " 644:	2342      	movs	r3, #66	; 0x42\n",
  " 646:	2344      	movs	r3, #68	; 0x44\n",
  " 648:	2346      	movs	r3, #70	; 0x46\n",
  " 64a:	2348      	movs	r3, #72	; 0x48\n",
  " 64c:	234a      	movs	r3, #74	; 0x4a\n",
  " 64e:	234c      	movs	r3, #76	; 0x4c\n",
  " 650:	234e      	movs	r3, #78	; 0x4e\n",
  " 652:	2350      	movs	r3, #80	; 0x50\n",
  " 654:	2352      	movs	r3, #82	; 0x52\n",
  " 656:	2354      	movs	r3, #84	; 0x54\n",
  " 658:	2356      	movs	r3, #86	; 0x56\n",
  " 65a:	2358      	movs	r3, #88	; 0x58\n",
  " 65c:	235a      	movs	r3, #90	; 0x5a\n",
  " 65e:	235c      	movs	r3, #92	; 0x5c\n",
  " 660:	235e      	movs	r3, #94	; 0x5e\n",
  " 662:	2360      	movs	r3, #96	; 0x60\n",
  " 664:	2362      	movs	r3, #98	; 0x62\n",
  " 666:	2364      	movs	r3, #100	; 0x64\n",
  " 668:	2366      	movs	r3, #102	; 0x66\n",
  " 66a:	2368      	movs	r3, #104	; 0x68\n",
  " 66c:	236a      	movs	r3, #106	; 0x6a\n",
  " 66e:	236c      	movs	r3, #108	; 0x6c\n",
  " 670:	236e      	movs	r3, #110	; 0x6e\n",
  " 672:	2370      	movs	r3, #112	; 0x70\n",
  " 674:	2372      	movs	r3, #114	; 0x72\n",
  " 676:	2374      	movs	r3, #116	; 0x74\n",
  " 678:	2376      	movs	r3, #118	; 0x76\n",
  " 67a:	2378      	movs	r3, #120	; 0x78\n",
  " 67c:	237a      	movs	r3, #122	; 0x7a\n",
  " 67e:	237c      	movs	r3, #124	; 0x7c\n",
  " 680:	237e      	movs	r3, #126	; 0x7e\n",
  " 682:	2380      	movs	r3, #128	; 0x80\n",
  " 684:	2382      	movs	r3, #130	; 0x82\n",
  " 686:	2384      	movs	r3, #132	; 0x84\n",
  " 688:	2386      	movs	r3, #134	; 0x86\n",
  " 68a:	2388      	movs	r3, #136	; 0x88\n",
  " 68c:	238a      	movs	r3, #138	; 0x8a\n",
  " 68e:	238c      	movs	r3, #140	; 0x8c\n",
  " 690:	238e      	movs	r3, #142	; 0x8e\n",
  " 692:	2390      	movs	r3, #144	; 0x90\n",
  " 694:	2392      	movs	r3, #146	; 0x92\n",
  " 696:	2394      	movs	r3, #148	; 0x94\n",
  " 698:	2396      	movs	r3, #150	; 0x96\n",
  " 69a:	2398      	movs	r3, #152	; 0x98\n",
  " 69c:	239a      	movs	r3, #154	; 0x9a\n",
  " 69e:	239c      	movs	r3, #156	; 0x9c\n",
  " 6a0:	239e      	movs	r3, #158	; 0x9e\n",
  " 6a2:	23a0      	movs	r3, #160	; 0xa0\n",
  " 6a4:	23a2      	movs	r3, #162	; 0xa2\n",
  " 6a6:	23a4      	movs	r3, #164	; 0xa4\n",
  " 6a8:	23a6      	movs	r3, #166	; 0xa6\n",
  " 6aa:	23a8      	movs	r3, #168	; 0xa8\n",
  " 6ac:	23aa      	movs	r3, #170	; 0xaa\n",
  " 6ae:	23ac      	movs	r3, #172	; 0xac\n",
  " 6b0:	23ae      	movs	r3, #174	; 0xae\n",
  " 6b2:	23b0      	movs	r3, #176	; 0xb0\n",
  " 6b4:	23b2      	movs	r3, #178	; 0xb2\n",
  " 6b6:	23b4      	movs	r3, #180	; 0xb4\n",
  " 6b8:	23b6      	movs	r3, #182	; 0xb6\n",
  " 6ba:	23b8      	movs	r3, #184	; 0xb8\n",
  " 6bc:	23ba      	movs	r3, #186	; 0xba\n",
  " 6be:	23bc      	movs	r3, #188	; 0xbc\n",
  " 6c0:	23be      	movs	r3, #190	; 0xbe\n",
  " 6c2:	23c0      	movs	r3, #192	; 0xc0\n",
  " 6c4:	23c2      	movs	r3, #194	; 0xc2\n",
  " 6c6:	23c4      	movs	r3, #196	; 0xc4\n",
  " 6c8:	23c6      	movs	r3, #198	; 0xc6\n",
  " 6ca:	23c8      	movs	r3, #200	; 0xc8\n",
  " 6cc:	23ca      	movs	r3, #202	; 0xca\n",
  " 6ce:	23cc      	movs	r3, #204	; 0xcc\n",
  " 6d0:	23ce      	movs	r3, #206	; 0xce\n",
  " 6d2:	23d0      	movs	r3, #208	; 0xd0\n",
  " 6d4:	23d2      	movs	r3, #210	; 0xd2\n",
  " 6d6:	23d4      	movs	r3, #212	; 0xd4\n",
  " 6d8:	23d6      	movs	r3, #214	; 0xd6\n",
  " 6da:	23d8      	movs	r3, #216	; 0xd8\n",
  " 6dc:	23da      	movs	r3, #218	; 0xda\n",
  " 6de:	23dc      	movs	r3, #220	; 0xdc\n",
  " 6e0:	23de      	movs	r3, #222	; 0xde\n",
  " 6e2:	23e0      	movs	r3, #224	; 0xe0\n",
  " 6e4:	23e2      	movs	r3, #226	; 0xe2\n",
  " 6e6:	23e4      	movs	r3, #228	; 0xe4\n",
  " 6e8:	23e6      	movs	r3, #230	; 0xe6\n",
  " 6ea:	23e8      	movs	r3, #232	; 0xe8\n",
  " 6ec:	23ea      	movs	r3, #234	; 0xea\n",
  " 6ee:	23ec      	movs	r3, #236	; 0xec\n",
  " 6f0:	23ee      	movs	r3, #238	; 0xee\n",
  " 6f2:	23f0      	movs	r3, #240	; 0xf0\n",
  " 6f4:	23f2      	movs	r3, #242	; 0xf2\n",
  " 6f6:	23f4      	movs	r3, #244	; 0xf4\n",
  " 6f8:	23f6      	movs	r3, #246	; 0xf6\n",
  " 6fa:	23f8      	movs	r3, #248	; 0xf8\n",
  " 6fc:	23fa      	movs	r3, #250	; 0xfa\n",
  " 6fe:	23fc      	movs	r3, #252	; 0xfc\n",
  " 700:	23fe      	movs	r3, #254	; 0xfe\n",
  " 702:	2300      	movs	r3, #0\n",
  " 704:	2302      	movs	r3, #2\n",
  " 706:	2304      	movs	r3, #4\n",
  " 708:	2306      	movs	r3, #6\n",
  " 70a:	2308      	movs	r3, #8\n",
  " 70c:	230a      	movs	r3, #10\n",
  " 70e:	230c      	movs	r3, #12\n",
  " 710:	230e      	movs	r3, #14\n",
  " 712:	2310      	movs	r3, #16\n",
  " 714:	2312      	movs	r3, #18\n",
  " 716:	2314      	movs	r3, #20\n",
  " 718:	2316      	movs	r3, #22\n",
  " 71a:	2318      	movs	r3, #24\n",
  " 71c:	231a      	movs	r3, #26\n",
  " 71e:	231c      	movs	r3, #28\n",
  " 720:	231e      	movs	r3, #30\n",
  " 722:	2320      	movs	r3, #32\n",
  " 724:	2322      	movs	r3, #34	; 0x22\n",
  " 726:	2324      	movs	r3, #36	; 0x24\n",
  " 728:	2326      	movs	r3, #38	; 0x26\n",
  " 72a:	2328      	movs	r3, #40	; 0x28\n",
  " 72c:	232a      	movs	r3, #42	; 0x2a\n",
  " 72e:	232c      	movs	r3, #44	; 0x2c\n",
  " 730:	232e      	movs	r3, #46	; 0x2e\n",
  " 732:	2330      	movs	r3, #48	; 0x30\n",
  " 734:	2332      	movs	r3, #50	; 0x32\n",
  " 736:	2334      	movs	r3, #52	; 0x34\n",
  " 738:	2336      	movs	r3, #54	; 0x36\n",
  " 73a:	2338      	movs	r3, #56	; 0x38\n",
  " 73c:	233a      	movs	r3, #58	; 0x3a\n",
  " 73e:	233c      	movs	r3, #60	; 0x3c\n",
  " 740:	233e      	movs	r3, #62	; 0x3e\n",
  " 742:	2340      	movs	r3, #64	; 0x40\n",
  " 744:	2342      	movs	r3, #66	; 0x42\n",
  " 746:	2344      	movs	r3, #68	; 0x44\n",
  " 748:	2346      	movs	r3, #70	; 0x46\n",
  " 74a:	2348      	movs	r3, #72	; 0x48\n",
  " 74c:	234a      	movs	r3, #74	; 0x4a\n",
  " 74e:	234c      	movs	r3, #76	; 0x4c\n",
  " 750:	234e      	movs	r3, #78	; 0x4e\n",
  " 752:	2350      	movs	r3, #80	; 0x50\n",
  " 754:	2352      	movs	r3, #82	; 0x52\n",
  " 756:	2354      	movs	r3, #84	; 0x54\n",
  " 758:	2356      	movs	r3, #86	; 0x56\n",
  " 75a:	2358      	movs	r3, #88	; 0x58\n",
  " 75c:	235a      	movs	r3, #90	; 0x5a\n",
  " 75e:	235c      	movs	r3, #92	; 0x5c\n",
  " 760:	235e      	movs	r3, #94	; 0x5e\n",
  " 762:	2360      	movs	r3, #96	; 0x60\n",
  " 764:	2362      	movs	r3, #98	; 0x62\n",
  " 766:	2364      	movs	r3, #100	; 0x64\n",
  " 768:	2366      	movs	r3, #102	; 0x66\n",
  " 76a:	2368      	movs	r3, #104	; 0x68\n",
  " 76c:	236a      	movs	r3, #106	; 0x6a\n",
  " 76e:	236c      	movs	r3, #108	; 0x6c\n",
  " 770:	236e      	movs	r3, #110	; 0x6e\n",
  " 772:	2370      	movs	r3, #112	; 0x70\n",
  " 774:	2372      	movs	r3, #114	; 0x72\n",
  " 776:	2374      	movs	r3, #116	; 0x74\n",
  " 778:	2376      	movs	r3, #118	; 0x76\n",
  " 77a:	2378      	movs	r3, #120	; 0x78\n",
  " 77c:	237a      	movs	r3, #122	; 0x7a\n",
  " 77e:	237c      	movs	r3, #124	; 0x7c\n",
  " 780:	237e      	movs	r3, #126	; 0x7e\n",
  " 782:	2380      	movs	r3, #128	; 0x80\n",
  " 784:	2382      	movs	r3, #130	; 0x82\n",
  " 786:	2384      	movs	r3, #132	; 0x84\n",
  " 788:	2386      	movs	r3, #134	; 0x86\n",
  " 78a:	2388      	movs	r3, #136	; 0x88\n",
  " 78c:	238a      	movs	r3, #138	; 0x8a\n",
  " 78e:	238c      	movs	r3, #140	; 0x8c\n",
  " 790:	238e      	movs	r3, #142	; 0x8e\n",
  " 792:	2390      	movs	r3, #144	; 0x90\n",
  " 794:	2392      	movs	r3, #146	; 0x92\n",
  " 796:	2394      	movs	r3, #148	; 0x94\n",
  " 798:	2396      	movs	r3, #150	; 0x96\n",
  " 79a:	2398      	movs	r3, #152	; 0x98\n",
  " 79c:	239a      	movs	r3, #154	; 0x9a\n",
  " 79e:	239c      	movs	r3, #156	; 0x9c\n",
  " 7a0:	239e      	movs	r3, #158	; 0x9e\n",
  " 7a2:	23a0      	movs	r3, #160	; 0xa0\n",
  " 7a4:	23a2      	movs	r3, #162	; 0xa2\n",
  " 7a6:	23a4      	movs	r3, #164	; 0xa4\n",
  " 7a8:	23a6      	movs	r3, #166	; 0xa6\n",
  " 7aa:	23a8      	movs	r3, #168	; 0xa8\n",
  " 7ac:	23aa      	movs	r3, #170	; 0xaa\n",
  " 7ae:	23ac      	movs	r3, #172	; 0xac\n",
  " 7b0:	23ae      	movs	r3, #174	; 0xae\n",
  " 7b2:	23b0      	movs	r3, #176	; 0xb0\n",
  " 7b4:	23b2      	movs	r3, #178	; 0xb2\n",
  " 7b6:	23b4      	movs	r3, #180	; 0xb4\n",
  " 7b8:	23b6      	movs	r3, #182	; 0xb6\n",
  " 7ba:	23b8      	movs	r3, #184	; 0xb8\n",
  " 7bc:	23ba      	movs	r3, #186	; 0xba\n",
  " 7be:	23bc      	movs	r3, #188	; 0xbc\n",
  " 7c0:	23be      	movs	r3, #190	; 0xbe\n",
  " 7c2:	23c0      	movs	r3, #192	; 0xc0\n",
  " 7c4:	23c2      	movs	r3, #194	; 0xc2\n",
  " 7c6:	23c4      	movs	r3, #196	; 0xc4\n",
  " 7c8:	23c6      	movs	r3, #198	; 0xc6\n",
  " 7ca:	23c8      	movs	r3, #200	; 0xc8\n",
  " 7cc:	23ca      	movs	r3, #202	; 0xca\n",
  " 7ce:	23cc      	movs	r3, #204	; 0xcc\n",
  " 7d0:	23ce      	movs	r3, #206	; 0xce\n",
  " 7d2:	23d0      	movs	r3, #208	; 0xd0\n",
  " 7d4:	23d2      	movs	r3, #210	; 0xd2\n",
  " 7d6:	23d4      	movs	r3, #212	; 0xd4\n",
  " 7d8:	23d6      	movs	r3, #214	; 0xd6\n",
  " 7da:	23d8      	movs	r3, #216	; 0xd8\n",
  " 7dc:	23da      	movs	r3, #218	; 0xda\n",
  " 7de:	23dc      	movs	r3, #220	; 0xdc\n",
  " 7e0:	23de      	movs	r3, #222	; 0xde\n",
  " 7e2:	23e0      	movs	r3, #224	; 0xe0\n",
  " 7e4:	23e2      	movs	r3, #226	; 0xe2\n",
  " 7e6:	23e4      	movs	r3, #228	; 0xe4\n",
  " 7e8:	23e6      	movs	r3, #230	; 0xe6\n",
  " 7ea:	23e8      	movs	r3, #232	; 0xe8\n",
  " 7ec:	23ea      	movs	r3, #234	; 0xea\n",
  " 7ee:	23ec      	movs	r3, #236	; 0xec\n",
  " 7f0:	23ee      	movs	r3, #238	; 0xee\n",
  " 7f2:	23f0      	movs	r3, #240	; 0xf0\n",
  " 7f4:	23f2      	movs	r3, #242	; 0xf2\n",
  " 7f6:	23f4      	movs	r3, #244	; 0xf4\n",
  " 7f8:	23f6      	movs	r3, #246	; 0xf6\n",
  " 7fa:	23f8      	movs	r3, #248	; 0xf8\n",
  " 7fc:	23fa      	movs	r3, #250	; 0xfa\n",
  " 7fe:	23fc      	movs	r3, #252	; 0xfc\n",
  " 800:	23fe      	movs	r3, #254	; 0xfe\n",
  " 802:	4611      	mov	r1, r2\n",
  nullptr
};
const char* Branch32Results[] = {
  "   0:	f000 bc01 	b.w	806 <Branch32+0x806>\n",
  "   4:	2300      	movs	r3, #0\n",
  "   6:	2302      	movs	r3, #2\n",
  "   8:	2304      	movs	r3, #4\n",
  "   a:	2306      	movs	r3, #6\n",
  "   c:	2308      	movs	r3, #8\n",
  "   e:	230a      	movs	r3, #10\n",
  "  10:	230c      	movs	r3, #12\n",
  "  12:	230e      	movs	r3, #14\n",
  "  14:	2310      	movs	r3, #16\n",
  "  16:	2312      	movs	r3, #18\n",
  "  18:	2314      	movs	r3, #20\n",
  "  1a:	2316      	movs	r3, #22\n",
  "  1c:	2318      	movs	r3, #24\n",
  "  1e:	231a      	movs	r3, #26\n",
  "  20:	231c      	movs	r3, #28\n",
  "  22:	231e      	movs	r3, #30\n",
  "  24:	2320      	movs	r3, #32\n",
  "  26:	2322      	movs	r3, #34	; 0x22\n",
  "  28:	2324      	movs	r3, #36	; 0x24\n",
  "  2a:	2326      	movs	r3, #38	; 0x26\n",
  "  2c:	2328      	movs	r3, #40	; 0x28\n",
  "  2e:	232a      	movs	r3, #42	; 0x2a\n",
  "  30:	232c      	movs	r3, #44	; 0x2c\n",
  "  32:	232e      	movs	r3, #46	; 0x2e\n",
  "  34:	2330      	movs	r3, #48	; 0x30\n",
  "  36:	2332      	movs	r3, #50	; 0x32\n",
  "  38:	2334      	movs	r3, #52	; 0x34\n",
  "  3a:	2336      	movs	r3, #54	; 0x36\n",
  "  3c:	2338      	movs	r3, #56	; 0x38\n",
  "  3e:	233a      	movs	r3, #58	; 0x3a\n",
  "  40:	233c      	movs	r3, #60	; 0x3c\n",
  "  42:	233e      	movs	r3, #62	; 0x3e\n",
  "  44:	2340      	movs	r3, #64	; 0x40\n",
  "  46:	2342      	movs	r3, #66	; 0x42\n",
  "  48:	2344      	movs	r3, #68	; 0x44\n",
  "  4a:	2346      	movs	r3, #70	; 0x46\n",
  "  4c:	2348      	movs	r3, #72	; 0x48\n",
  "  4e:	234a      	movs	r3, #74	; 0x4a\n",
  "  50:	234c      	movs	r3, #76	; 0x4c\n",
  "  52:	234e      	movs	r3, #78	; 0x4e\n",
  "  54:	2350      	movs	r3, #80	; 0x50\n",
  "  56:	2352      	movs	r3, #82	; 0x52\n",
  "  58:	2354      	movs	r3, #84	; 0x54\n",
  "  5a:	2356      	movs	r3, #86	; 0x56\n",
  "  5c:	2358      	movs	r3, #88	; 0x58\n",
  "  5e:	235a      	movs	r3, #90	; 0x5a\n",
  "  60:	235c      	movs	r3, #92	; 0x5c\n",
  "  62:	235e      	movs	r3, #94	; 0x5e\n",
  "  64:	2360      	movs	r3, #96	; 0x60\n",
  "  66:	2362      	movs	r3, #98	; 0x62\n",
  "  68:	2364      	movs	r3, #100	; 0x64\n",
  "  6a:	2366      	movs	r3, #102	; 0x66\n",
  "  6c:	2368      	movs	r3, #104	; 0x68\n",
  "  6e:	236a      	movs	r3, #106	; 0x6a\n",
  "  70:	236c      	movs	r3, #108	; 0x6c\n",
  "  72:	236e      	movs	r3, #110	; 0x6e\n",
  "  74:	2370      	movs	r3, #112	; 0x70\n",
  "  76:	2372      	movs	r3, #114	; 0x72\n",
  "  78:	2374      	movs	r3, #116	; 0x74\n",
  "  7a:	2376      	movs	r3, #118	; 0x76\n",
  "  7c:	2378      	movs	r3, #120	; 0x78\n",
  "  7e:	237a      	movs	r3, #122	; 0x7a\n",
  "  80:	237c      	movs	r3, #124	; 0x7c\n",
  "  82:	237e      	movs	r3, #126	; 0x7e\n",
  "  84:	2380      	movs	r3, #128	; 0x80\n",
  "  86:	2382      	movs	r3, #130	; 0x82\n",
  "  88:	2384      	movs	r3, #132	; 0x84\n",
  "  8a:	2386      	movs	r3, #134	; 0x86\n",
  "  8c:	2388      	movs	r3, #136	; 0x88\n",
  "  8e:	238a      	movs	r3, #138	; 0x8a\n",
  "  90:	238c      	movs	r3, #140	; 0x8c\n",
  "  92:	238e      	movs	r3, #142	; 0x8e\n",
  "  94:	2390      	movs	r3, #144	; 0x90\n",
  "  96:	2392      	movs	r3, #146	; 0x92\n",
  "  98:	2394      	movs	r3, #148	; 0x94\n",
  "  9a:	2396      	movs	r3, #150	; 0x96\n",
  "  9c:	2398      	movs	r3, #152	; 0x98\n",
  "  9e:	239a      	movs	r3, #154	; 0x9a\n",
  "  a0:	239c      	movs	r3, #156	; 0x9c\n",
  "  a2:	239e      	movs	r3, #158	; 0x9e\n",
  "  a4:	23a0      	movs	r3, #160	; 0xa0\n",
  "  a6:	23a2      	movs	r3, #162	; 0xa2\n",
  "  a8:	23a4      	movs	r3, #164	; 0xa4\n",
  "  aa:	23a6      	movs	r3, #166	; 0xa6\n",
  "  ac:	23a8      	movs	r3, #168	; 0xa8\n",
  "  ae:	23aa      	movs	r3, #170	; 0xaa\n",
  "  b0:	23ac      	movs	r3, #172	; 0xac\n",
  "  b2:	23ae      	movs	r3, #174	; 0xae\n",
  "  b4:	23b0      	movs	r3, #176	; 0xb0\n",
  "  b6:	23b2      	movs	r3, #178	; 0xb2\n",
  "  b8:	23b4      	movs	r3, #180	; 0xb4\n",
  "  ba:	23b6      	movs	r3, #182	; 0xb6\n",
  "  bc:	23b8      	movs	r3, #184	; 0xb8\n",
  "  be:	23ba      	movs	r3, #186	; 0xba\n",
  "  c0:	23bc      	movs	r3, #188	; 0xbc\n",
  "  c2:	23be      	movs	r3, #190	; 0xbe\n",
  "  c4:	23c0      	movs	r3, #192	; 0xc0\n",
  "  c6:	23c2      	movs	r3, #194	; 0xc2\n",
  "  c8:	23c4      	movs	r3, #196	; 0xc4\n",
  "  ca:	23c6      	movs	r3, #198	; 0xc6\n",
  "  cc:	23c8      	movs	r3, #200	; 0xc8\n",
  "  ce:	23ca      	movs	r3, #202	; 0xca\n",
  "  d0:	23cc      	movs	r3, #204	; 0xcc\n",
  "  d2:	23ce      	movs	r3, #206	; 0xce\n",
  "  d4:	23d0      	movs	r3, #208	; 0xd0\n",
  "  d6:	23d2      	movs	r3, #210	; 0xd2\n",
  "  d8:	23d4      	movs	r3, #212	; 0xd4\n",
  "  da:	23d6      	movs	r3, #214	; 0xd6\n",
  "  dc:	23d8      	movs	r3, #216	; 0xd8\n",
  "  de:	23da      	movs	r3, #218	; 0xda\n",
  "  e0:	23dc      	movs	r3, #220	; 0xdc\n",
  "  e2:	23de      	movs	r3, #222	; 0xde\n",
  "  e4:	23e0      	movs	r3, #224	; 0xe0\n",
  "  e6:	23e2      	movs	r3, #226	; 0xe2\n",
  "  e8:	23e4      	movs	r3, #228	; 0xe4\n",
  "  ea:	23e6      	movs	r3, #230	; 0xe6\n",
  "  ec:	23e8      	movs	r3, #232	; 0xe8\n",
  "  ee:	23ea      	movs	r3, #234	; 0xea\n",
  "  f0:	23ec      	movs	r3, #236	; 0xec\n",
  "  f2:	23ee      	movs	r3, #238	; 0xee\n",
  "  f4:	23f0      	movs	r3, #240	; 0xf0\n",
  "  f6:	23f2      	movs	r3, #242	; 0xf2\n",
  "  f8:	23f4      	movs	r3, #244	; 0xf4\n",
  "  fa:	23f6      	movs	r3, #246	; 0xf6\n",
  "  fc:	23f8      	movs	r3, #248	; 0xf8\n",
  "  fe:	23fa      	movs	r3, #250	; 0xfa\n",
  " 100:	23fc      	movs	r3, #252	; 0xfc\n",
  " 102:	23fe      	movs	r3, #254	; 0xfe\n",
  " 104:	2300      	movs	r3, #0\n",
  " 106:	2302      	movs	r3, #2\n",
  " 108:	2304      	movs	r3, #4\n",
  " 10a:	2306      	movs	r3, #6\n",
  " 10c:	2308      	movs	r3, #8\n",
  " 10e:	230a      	movs	r3, #10\n",
  " 110:	230c      	movs	r3, #12\n",
  " 112:	230e      	movs	r3, #14\n",
  " 114:	2310      	movs	r3, #16\n",
  " 116:	2312      	movs	r3, #18\n",
  " 118:	2314      	movs	r3, #20\n",
  " 11a:	2316      	movs	r3, #22\n",
  " 11c:	2318      	movs	r3, #24\n",
  " 11e:	231a      	movs	r3, #26\n",
  " 120:	231c      	movs	r3, #28\n",
  " 122:	231e      	movs	r3, #30\n",
  " 124:	2320      	movs	r3, #32\n",
  " 126:	2322      	movs	r3, #34	; 0x22\n",
  " 128:	2324      	movs	r3, #36	; 0x24\n",
  " 12a:	2326      	movs	r3, #38	; 0x26\n",
  " 12c:	2328      	movs	r3, #40	; 0x28\n",
  " 12e:	232a      	movs	r3, #42	; 0x2a\n",
  " 130:	232c      	movs	r3, #44	; 0x2c\n",
  " 132:	232e      	movs	r3, #46	; 0x2e\n",
  " 134:	2330      	movs	r3, #48	; 0x30\n",
  " 136:	2332      	movs	r3, #50	; 0x32\n",
  " 138:	2334      	movs	r3, #52	; 0x34\n",
  " 13a:	2336      	movs	r3, #54	; 0x36\n",
  " 13c:	2338      	movs	r3, #56	; 0x38\n",
  " 13e:	233a      	movs	r3, #58	; 0x3a\n",
  " 140:	233c      	movs	r3, #60	; 0x3c\n",
  " 142:	233e      	movs	r3, #62	; 0x3e\n",
  " 144:	2340      	movs	r3, #64	; 0x40\n",
  " 146:	2342      	movs	r3, #66	; 0x42\n",
  " 148:	2344      	movs	r3, #68	; 0x44\n",
  " 14a:	2346      	movs	r3, #70	; 0x46\n",
  " 14c:	2348      	movs	r3, #72	; 0x48\n",
  " 14e:	234a      	movs	r3, #74	; 0x4a\n",
  " 150:	234c      	movs	r3, #76	; 0x4c\n",
  " 152:	234e      	movs	r3, #78	; 0x4e\n",
  " 154:	2350      	movs	r3, #80	; 0x50\n",
  " 156:	2352      	movs	r3, #82	; 0x52\n",
  " 158:	2354      	movs	r3, #84	; 0x54\n",
  " 15a:	2356      	movs	r3, #86	; 0x56\n",
  " 15c:	2358      	movs	r3, #88	; 0x58\n",
  " 15e:	235a      	movs	r3, #90	; 0x5a\n",
  " 160:	235c      	movs	r3, #92	; 0x5c\n",
  " 162:	235e      	movs	r3, #94	; 0x5e\n",
  " 164:	2360      	movs	r3, #96	; 0x60\n",
  " 166:	2362      	movs	r3, #98	; 0x62\n",
  " 168:	2364      	movs	r3, #100	; 0x64\n",
  " 16a:	2366      	movs	r3, #102	; 0x66\n",
  " 16c:	2368      	movs	r3, #104	; 0x68\n",
  " 16e:	236a      	movs	r3, #106	; 0x6a\n",
  " 170:	236c      	movs	r3, #108	; 0x6c\n",
  " 172:	236e      	movs	r3, #110	; 0x6e\n",
  " 174:	2370      	movs	r3, #112	; 0x70\n",
  " 176:	2372      	movs	r3, #114	; 0x72\n",
  " 178:	2374      	movs	r3, #116	; 0x74\n",
  " 17a:	2376      	movs	r3, #118	; 0x76\n",
  " 17c:	2378      	movs	r3, #120	; 0x78\n",
  " 17e:	237a      	movs	r3, #122	; 0x7a\n",
  " 180:	237c      	movs	r3, #124	; 0x7c\n",
  " 182:	237e      	movs	r3, #126	; 0x7e\n",
  " 184:	2380      	movs	r3, #128	; 0x80\n",
  " 186:	2382      	movs	r3, #130	; 0x82\n",
  " 188:	2384      	movs	r3, #132	; 0x84\n",
  " 18a:	2386      	movs	r3, #134	; 0x86\n",
  " 18c:	2388      	movs	r3, #136	; 0x88\n",
  " 18e:	238a      	movs	r3, #138	; 0x8a\n",
  " 190:	238c      	movs	r3, #140	; 0x8c\n",
  " 192:	238e      	movs	r3, #142	; 0x8e\n",
  " 194:	2390      	movs	r3, #144	; 0x90\n",
  " 196:	2392      	movs	r3, #146	; 0x92\n",
  " 198:	2394      	movs	r3, #148	; 0x94\n",
  " 19a:	2396      	movs	r3, #150	; 0x96\n",
  " 19c:	2398      	movs	r3, #152	; 0x98\n",
  " 19e:	239a      	movs	r3, #154	; 0x9a\n",
  " 1a0:	239c      	movs	r3, #156	; 0x9c\n",
  " 1a2:	239e      	movs	r3, #158	; 0x9e\n",
  " 1a4:	23a0      	movs	r3, #160	; 0xa0\n",
  " 1a6:	23a2      	movs	r3, #162	; 0xa2\n",
  " 1a8:	23a4      	movs	r3, #164	; 0xa4\n",
  " 1aa:	23a6      	movs	r3, #166	; 0xa6\n",
  " 1ac:	23a8      	movs	r3, #168	; 0xa8\n",
  " 1ae:	23aa      	movs	r3, #170	; 0xaa\n",
  " 1b0:	23ac      	movs	r3, #172	; 0xac\n",
  " 1b2:	23ae      	movs	r3, #174	; 0xae\n",
  " 1b4:	23b0      	movs	r3, #176	; 0xb0\n",
  " 1b6:	23b2      	movs	r3, #178	; 0xb2\n",
  " 1b8:	23b4      	movs	r3, #180	; 0xb4\n",
  " 1ba:	23b6      	movs	r3, #182	; 0xb6\n",
  " 1bc:	23b8      	movs	r3, #184	; 0xb8\n",
  " 1be:	23ba      	movs	r3, #186	; 0xba\n",
  " 1c0:	23bc      	movs	r3, #188	; 0xbc\n",
  " 1c2:	23be      	movs	r3, #190	; 0xbe\n",
  " 1c4:	23c0      	movs	r3, #192	; 0xc0\n",
  " 1c6:	23c2      	movs	r3, #194	; 0xc2\n",
  " 1c8:	23c4      	movs	r3, #196	; 0xc4\n",
  " 1ca:	23c6      	movs	r3, #198	; 0xc6\n",
  " 1cc:	23c8      	movs	r3, #200	; 0xc8\n",
  " 1ce:	23ca      	movs	r3, #202	; 0xca\n",
  " 1d0:	23cc      	movs	r3, #204	; 0xcc\n",
  " 1d2:	23ce      	movs	r3, #206	; 0xce\n",
  " 1d4:	23d0      	movs	r3, #208	; 0xd0\n",
  " 1d6:	23d2      	movs	r3, #210	; 0xd2\n",
  " 1d8:	23d4      	movs	r3, #212	; 0xd4\n",
  " 1da:	23d6      	movs	r3, #214	; 0xd6\n",
  " 1dc:	23d8      	movs	r3, #216	; 0xd8\n",
  " 1de:	23da      	movs	r3, #218	; 0xda\n",
  " 1e0:	23dc      	movs	r3, #220	; 0xdc\n",
  " 1e2:	23de      	movs	r3, #222	; 0xde\n",
  " 1e4:	23e0      	movs	r3, #224	; 0xe0\n",
  " 1e6:	23e2      	movs	r3, #226	; 0xe2\n",
  " 1e8:	23e4      	movs	r3, #228	; 0xe4\n",
  " 1ea:	23e6      	movs	r3, #230	; 0xe6\n",
  " 1ec:	23e8      	movs	r3, #232	; 0xe8\n",
  " 1ee:	23ea      	movs	r3, #234	; 0xea\n",
  " 1f0:	23ec      	movs	r3, #236	; 0xec\n",
  " 1f2:	23ee      	movs	r3, #238	; 0xee\n",
  " 1f4:	23f0      	movs	r3, #240	; 0xf0\n",
  " 1f6:	23f2      	movs	r3, #242	; 0xf2\n",
  " 1f8:	23f4      	movs	r3, #244	; 0xf4\n",
  " 1fa:	23f6      	movs	r3, #246	; 0xf6\n",
  " 1fc:	23f8      	movs	r3, #248	; 0xf8\n",
  " 1fe:	23fa      	movs	r3, #250	; 0xfa\n",
  " 200:	23fc      	movs	r3, #252	; 0xfc\n",
  " 202:	23fe      	movs	r3, #254	; 0xfe\n",
  " 204:	2300      	movs	r3, #0\n",
  " 206:	2302      	movs	r3, #2\n",
  " 208:	2304      	movs	r3, #4\n",
  " 20a:	2306      	movs	r3, #6\n",
  " 20c:	2308      	movs	r3, #8\n",
  " 20e:	230a      	movs	r3, #10\n",
  " 210:	230c      	movs	r3, #12\n",
  " 212:	230e      	movs	r3, #14\n",
  " 214:	2310      	movs	r3, #16\n",
  " 216:	2312      	movs	r3, #18\n",
  " 218:	2314      	movs	r3, #20\n",
  " 21a:	2316      	movs	r3, #22\n",
  " 21c:	2318      	movs	r3, #24\n",
  " 21e:	231a      	movs	r3, #26\n",
  " 220:	231c      	movs	r3, #28\n",
  " 222:	231e      	movs	r3, #30\n",
  " 224:	2320      	movs	r3, #32\n",
  " 226:	2322      	movs	r3, #34	; 0x22\n",
  " 228:	2324      	movs	r3, #36	; 0x24\n",
  " 22a:	2326      	movs	r3, #38	; 0x26\n",
  " 22c:	2328      	movs	r3, #40	; 0x28\n",
  " 22e:	232a      	movs	r3, #42	; 0x2a\n",
  " 230:	232c      	movs	r3, #44	; 0x2c\n",
  " 232:	232e      	movs	r3, #46	; 0x2e\n",
  " 234:	2330      	movs	r3, #48	; 0x30\n",
  " 236:	2332      	movs	r3, #50	; 0x32\n",
  " 238:	2334      	movs	r3, #52	; 0x34\n",
  " 23a:	2336      	movs	r3, #54	; 0x36\n",
  " 23c:	2338      	movs	r3, #56	; 0x38\n",
  " 23e:	233a      	movs	r3, #58	; 0x3a\n",
  " 240:	233c      	movs	r3, #60	; 0x3c\n",
  " 242:	233e      	movs	r3, #62	; 0x3e\n",
  " 244:	2340      	movs	r3, #64	; 0x40\n",
  " 246:	2342      	movs	r3, #66	; 0x42\n",
  " 248:	2344      	movs	r3, #68	; 0x44\n",
  " 24a:	2346      	movs	r3, #70	; 0x46\n",
  " 24c:	2348      	movs	r3, #72	; 0x48\n",
  " 24e:	234a      	movs	r3, #74	; 0x4a\n",
  " 250:	234c      	movs	r3, #76	; 0x4c\n",
  " 252:	234e      	movs	r3, #78	; 0x4e\n",
  " 254:	2350      	movs	r3, #80	; 0x50\n",
  " 256:	2352      	movs	r3, #82	; 0x52\n",
  " 258:	2354      	movs	r3, #84	; 0x54\n",
  " 25a:	2356      	movs	r3, #86	; 0x56\n",
  " 25c:	2358      	movs	r3, #88	; 0x58\n",
  " 25e:	235a      	movs	r3, #90	; 0x5a\n",
  " 260:	235c      	movs	r3, #92	; 0x5c\n",
  " 262:	235e      	movs	r3, #94	; 0x5e\n",
  " 264:	2360      	movs	r3, #96	; 0x60\n",
  " 266:	2362      	movs	r3, #98	; 0x62\n",
  " 268:	2364      	movs	r3, #100	; 0x64\n",
  " 26a:	2366      	movs	r3, #102	; 0x66\n",
  " 26c:	2368      	movs	r3, #104	; 0x68\n",
  " 26e:	236a      	movs	r3, #106	; 0x6a\n",
  " 270:	236c      	movs	r3, #108	; 0x6c\n",
  " 272:	236e      	movs	r3, #110	; 0x6e\n",
  " 274:	2370      	movs	r3, #112	; 0x70\n",
  " 276:	2372      	movs	r3, #114	; 0x72\n",
  " 278:	2374      	movs	r3, #116	; 0x74\n",
  " 27a:	2376      	movs	r3, #118	; 0x76\n",
  " 27c:	2378      	movs	r3, #120	; 0x78\n",
  " 27e:	237a      	movs	r3, #122	; 0x7a\n",
  " 280:	237c      	movs	r3, #124	; 0x7c\n",
  " 282:	237e      	movs	r3, #126	; 0x7e\n",
  " 284:	2380      	movs	r3, #128	; 0x80\n",
  " 286:	2382      	movs	r3, #130	; 0x82\n",
  " 288:	2384      	movs	r3, #132	; 0x84\n",
  " 28a:	2386      	movs	r3, #134	; 0x86\n",
  " 28c:	2388      	movs	r3, #136	; 0x88\n",
  " 28e:	238a      	movs	r3, #138	; 0x8a\n",
  " 290:	238c      	movs	r3, #140	; 0x8c\n",
  " 292:	238e      	movs	r3, #142	; 0x8e\n",
  " 294:	2390      	movs	r3, #144	; 0x90\n",
  " 296:	2392      	movs	r3, #146	; 0x92\n",
  " 298:	2394      	movs	r3, #148	; 0x94\n",
  " 29a:	2396      	movs	r3, #150	; 0x96\n",
  " 29c:	2398      	movs	r3, #152	; 0x98\n",
  " 29e:	239a      	movs	r3, #154	; 0x9a\n",
  " 2a0:	239c      	movs	r3, #156	; 0x9c\n",
  " 2a2:	239e      	movs	r3, #158	; 0x9e\n",
  " 2a4:	23a0      	movs	r3, #160	; 0xa0\n",
  " 2a6:	23a2      	movs	r3, #162	; 0xa2\n",
  " 2a8:	23a4      	movs	r3, #164	; 0xa4\n",
  " 2aa:	23a6      	movs	r3, #166	; 0xa6\n",
  " 2ac:	23a8      	movs	r3, #168	; 0xa8\n",
  " 2ae:	23aa      	movs	r3, #170	; 0xaa\n",
  " 2b0:	23ac      	movs	r3, #172	; 0xac\n",
  " 2b2:	23ae      	movs	r3, #174	; 0xae\n",
  " 2b4:	23b0      	movs	r3, #176	; 0xb0\n",
  " 2b6:	23b2      	movs	r3, #178	; 0xb2\n",
  " 2b8:	23b4      	movs	r3, #180	; 0xb4\n",
  " 2ba:	23b6      	movs	r3, #182	; 0xb6\n",
  " 2bc:	23b8      	movs	r3, #184	; 0xb8\n",
  " 2be:	23ba      	movs	r3, #186	; 0xba\n",
  " 2c0:	23bc      	movs	r3, #188	; 0xbc\n",
  " 2c2:	23be      	movs	r3, #190	; 0xbe\n",
  " 2c4:	23c0      	movs	r3, #192	; 0xc0\n",
  " 2c6:	23c2      	movs	r3, #194	; 0xc2\n",
  " 2c8:	23c4      	movs	r3, #196	; 0xc4\n",
  " 2ca:	23c6      	movs	r3, #198	; 0xc6\n",
  " 2cc:	23c8      	movs	r3, #200	; 0xc8\n",
  " 2ce:	23ca      	movs	r3, #202	; 0xca\n",
  " 2d0:	23cc      	movs	r3, #204	; 0xcc\n",
  " 2d2:	23ce      	movs	r3, #206	; 0xce\n",
  " 2d4:	23d0      	movs	r3, #208	; 0xd0\n",
  " 2d6:	23d2      	movs	r3, #210	; 0xd2\n",
  " 2d8:	23d4      	movs	r3, #212	; 0xd4\n",
  " 2da:	23d6      	movs	r3, #214	; 0xd6\n",
  " 2dc:	23d8      	movs	r3, #216	; 0xd8\n",
  " 2de:	23da      	movs	r3, #218	; 0xda\n",
  " 2e0:	23dc      	movs	r3, #220	; 0xdc\n",
  " 2e2:	23de      	movs	r3, #222	; 0xde\n",
  " 2e4:	23e0      	movs	r3, #224	; 0xe0\n",
  " 2e6:	23e2      	movs	r3, #226	; 0xe2\n",
  " 2e8:	23e4      	movs	r3, #228	; 0xe4\n",
  " 2ea:	23e6      	movs	r3, #230	; 0xe6\n",
  " 2ec:	23e8      	movs	r3, #232	; 0xe8\n",
  " 2ee:	23ea      	movs	r3, #234	; 0xea\n",
  " 2f0:	23ec      	movs	r3, #236	; 0xec\n",
  " 2f2:	23ee      	movs	r3, #238	; 0xee\n",
  " 2f4:	23f0      	movs	r3, #240	; 0xf0\n",
  " 2f6:	23f2      	movs	r3, #242	; 0xf2\n",
  " 2f8:	23f4      	movs	r3, #244	; 0xf4\n",
  " 2fa:	23f6      	movs	r3, #246	; 0xf6\n",
  " 2fc:	23f8      	movs	r3, #248	; 0xf8\n",
  " 2fe:	23fa      	movs	r3, #250	; 0xfa\n",
  " 300:	23fc      	movs	r3, #252	; 0xfc\n",
  " 302:	23fe      	movs	r3, #254	; 0xfe\n",
  " 304:	2300      	movs	r3, #0\n",
  " 306:	2302      	movs	r3, #2\n",
  " 308:	2304      	movs	r3, #4\n",
  " 30a:	2306      	movs	r3, #6\n",
  " 30c:	2308      	movs	r3, #8\n",
  " 30e:	230a      	movs	r3, #10\n",
  " 310:	230c      	movs	r3, #12\n",
  " 312:	230e      	movs	r3, #14\n",
  " 314:	2310      	movs	r3, #16\n",
  " 316:	2312      	movs	r3, #18\n",
  " 318:	2314      	movs	r3, #20\n",
  " 31a:	2316      	movs	r3, #22\n",
  " 31c:	2318      	movs	r3, #24\n",
  " 31e:	231a      	movs	r3, #26\n",
  " 320:	231c      	movs	r3, #28\n",
  " 322:	231e      	movs	r3, #30\n",
  " 324:	2320      	movs	r3, #32\n",
  " 326:	2322      	movs	r3, #34	; 0x22\n",
  " 328:	2324      	movs	r3, #36	; 0x24\n",
  " 32a:	2326      	movs	r3, #38	; 0x26\n",
  " 32c:	2328      	movs	r3, #40	; 0x28\n",
  " 32e:	232a      	movs	r3, #42	; 0x2a\n",
  " 330:	232c      	movs	r3, #44	; 0x2c\n",
  " 332:	232e      	movs	r3, #46	; 0x2e\n",
  " 334:	2330      	movs	r3, #48	; 0x30\n",
  " 336:	2332      	movs	r3, #50	; 0x32\n",
  " 338:	2334      	movs	r3, #52	; 0x34\n",
  " 33a:	2336      	movs	r3, #54	; 0x36\n",
  " 33c:	2338      	movs	r3, #56	; 0x38\n",
  " 33e:	233a      	movs	r3, #58	; 0x3a\n",
  " 340:	233c      	movs	r3, #60	; 0x3c\n",
  " 342:	233e      	movs	r3, #62	; 0x3e\n",
  " 344:	2340      	movs	r3, #64	; 0x40\n",
  " 346:	2342      	movs	r3, #66	; 0x42\n",
  " 348:	2344      	movs	r3, #68	; 0x44\n",
  " 34a:	2346      	movs	r3, #70	; 0x46\n",
  " 34c:	2348      	movs	r3, #72	; 0x48\n",
  " 34e:	234a      	movs	r3, #74	; 0x4a\n",
  " 350:	234c      	movs	r3, #76	; 0x4c\n",
  " 352:	234e      	movs	r3, #78	; 0x4e\n",
  " 354:	2350      	movs	r3, #80	; 0x50\n",
  " 356:	2352      	movs	r3, #82	; 0x52\n",
  " 358:	2354      	movs	r3, #84	; 0x54\n",
  " 35a:	2356      	movs	r3, #86	; 0x56\n",
  " 35c:	2358      	movs	r3, #88	; 0x58\n",
  " 35e:	235a      	movs	r3, #90	; 0x5a\n",
  " 360:	235c      	movs	r3, #92	; 0x5c\n",
  " 362:	235e      	movs	r3, #94	; 0x5e\n",
  " 364:	2360      	movs	r3, #96	; 0x60\n",
  " 366:	2362      	movs	r3, #98	; 0x62\n",
  " 368:	2364      	movs	r3, #100	; 0x64\n",
  " 36a:	2366      	movs	r3, #102	; 0x66\n",
  " 36c:	2368      	movs	r3, #104	; 0x68\n",
  " 36e:	236a      	movs	r3, #106	; 0x6a\n",
  " 370:	236c      	movs	r3, #108	; 0x6c\n",
  " 372:	236e      	movs	r3, #110	; 0x6e\n",
  " 374:	2370      	movs	r3, #112	; 0x70\n",
  " 376:	2372      	movs	r3, #114	; 0x72\n",
  " 378:	2374      	movs	r3, #116	; 0x74\n",
  " 37a:	2376      	movs	r3, #118	; 0x76\n",
  " 37c:	2378      	movs	r3, #120	; 0x78\n",
  " 37e:	237a      	movs	r3, #122	; 0x7a\n",
  " 380:	237c      	movs	r3, #124	; 0x7c\n",
  " 382:	237e      	movs	r3, #126	; 0x7e\n",
  " 384:	2380      	movs	r3, #128	; 0x80\n",
  " 386:	2382      	movs	r3, #130	; 0x82\n",
  " 388:	2384      	movs	r3, #132	; 0x84\n",
  " 38a:	2386      	movs	r3, #134	; 0x86\n",
  " 38c:	2388      	movs	r3, #136	; 0x88\n",
  " 38e:	238a      	movs	r3, #138	; 0x8a\n",
  " 390:	238c      	movs	r3, #140	; 0x8c\n",
  " 392:	238e      	movs	r3, #142	; 0x8e\n",
  " 394:	2390      	movs	r3, #144	; 0x90\n",
  " 396:	2392      	movs	r3, #146	; 0x92\n",
  " 398:	2394      	movs	r3, #148	; 0x94\n",
  " 39a:	2396      	movs	r3, #150	; 0x96\n",
  " 39c:	2398      	movs	r3, #152	; 0x98\n",
  " 39e:	239a      	movs	r3, #154	; 0x9a\n",
  " 3a0:	239c      	movs	r3, #156	; 0x9c\n",
  " 3a2:	239e      	movs	r3, #158	; 0x9e\n",
  " 3a4:	23a0      	movs	r3, #160	; 0xa0\n",
  " 3a6:	23a2      	movs	r3, #162	; 0xa2\n",
  " 3a8:	23a4      	movs	r3, #164	; 0xa4\n",
  " 3aa:	23a6      	movs	r3, #166	; 0xa6\n",
  " 3ac:	23a8      	movs	r3, #168	; 0xa8\n",
  " 3ae:	23aa      	movs	r3, #170	; 0xaa\n",
  " 3b0:	23ac      	movs	r3, #172	; 0xac\n",
  " 3b2:	23ae      	movs	r3, #174	; 0xae\n",
  " 3b4:	23b0      	movs	r3, #176	; 0xb0\n",
  " 3b6:	23b2      	movs	r3, #178	; 0xb2\n",
  " 3b8:	23b4      	movs	r3, #180	; 0xb4\n",
  " 3ba:	23b6      	movs	r3, #182	; 0xb6\n",
  " 3bc:	23b8      	movs	r3, #184	; 0xb8\n",
  " 3be:	23ba      	movs	r3, #186	; 0xba\n",
  " 3c0:	23bc      	movs	r3, #188	; 0xbc\n",
  " 3c2:	23be      	movs	r3, #190	; 0xbe\n",
  " 3c4:	23c0      	movs	r3, #192	; 0xc0\n",
  " 3c6:	23c2      	movs	r3, #194	; 0xc2\n",
  " 3c8:	23c4      	movs	r3, #196	; 0xc4\n",
  " 3ca:	23c6      	movs	r3, #198	; 0xc6\n",
  " 3cc:	23c8      	movs	r3, #200	; 0xc8\n",
  " 3ce:	23ca      	movs	r3, #202	; 0xca\n",
  " 3d0:	23cc      	movs	r3, #204	; 0xcc\n",
  " 3d2:	23ce      	movs	r3, #206	; 0xce\n",
  " 3d4:	23d0      	movs	r3, #208	; 0xd0\n",
  " 3d6:	23d2      	movs	r3, #210	; 0xd2\n",
  " 3d8:	23d4      	movs	r3, #212	; 0xd4\n",
  " 3da:	23d6      	movs	r3, #214	; 0xd6\n",
  " 3dc:	23d8      	movs	r3, #216	; 0xd8\n",
  " 3de:	23da      	movs	r3, #218	; 0xda\n",
  " 3e0:	23dc      	movs	r3, #220	; 0xdc\n",
  " 3e2:	23de      	movs	r3, #222	; 0xde\n",
  " 3e4:	23e0      	movs	r3, #224	; 0xe0\n",
  " 3e6:	23e2      	movs	r3, #226	; 0xe2\n",
  " 3e8:	23e4      	movs	r3, #228	; 0xe4\n",
  " 3ea:	23e6      	movs	r3, #230	; 0xe6\n",
  " 3ec:	23e8      	movs	r3, #232	; 0xe8\n",
  " 3ee:	23ea      	movs	r3, #234	; 0xea\n",
  " 3f0:	23ec      	movs	r3, #236	; 0xec\n",
  " 3f2:	23ee      	movs	r3, #238	; 0xee\n",
  " 3f4:	23f0      	movs	r3, #240	; 0xf0\n",
  " 3f6:	23f2      	movs	r3, #242	; 0xf2\n",
  " 3f8:	23f4      	movs	r3, #244	; 0xf4\n",
  " 3fa:	23f6      	movs	r3, #246	; 0xf6\n",
  " 3fc:	23f8      	movs	r3, #248	; 0xf8\n",
  " 3fe:	23fa      	movs	r3, #250	; 0xfa\n",
  " 400:	23fc      	movs	r3, #252	; 0xfc\n",
  " 402:	23fe      	movs	r3, #254	; 0xfe\n",
  " 404:	2300      	movs	r3, #0\n",
  " 406:	2302      	movs	r3, #2\n",
  " 408:	2304      	movs	r3, #4\n",
  " 40a:	2306      	movs	r3, #6\n",
  " 40c:	2308      	movs	r3, #8\n",
  " 40e:	230a      	movs	r3, #10\n",
  " 410:	230c      	movs	r3, #12\n",
  " 412:	230e      	movs	r3, #14\n",
  " 414:	2310      	movs	r3, #16\n",
  " 416:	2312      	movs	r3, #18\n",
  " 418:	2314      	movs	r3, #20\n",
  " 41a:	2316      	movs	r3, #22\n",
  " 41c:	2318      	movs	r3, #24\n",
  " 41e:	231a      	movs	r3, #26\n",
  " 420:	231c      	movs	r3, #28\n",
  " 422:	231e      	movs	r3, #30\n",
  " 424:	2320      	movs	r3, #32\n",
  " 426:	2322      	movs	r3, #34	; 0x22\n",
  " 428:	2324      	movs	r3, #36	; 0x24\n",
  " 42a:	2326      	movs	r3, #38	; 0x26\n",
  " 42c:	2328      	movs	r3, #40	; 0x28\n",
  " 42e:	232a      	movs	r3, #42	; 0x2a\n",
  " 430:	232c      	movs	r3, #44	; 0x2c\n",
  " 432:	232e      	movs	r3, #46	; 0x2e\n",
  " 434:	2330      	movs	r3, #48	; 0x30\n",
  " 436:	2332      	movs	r3, #50	; 0x32\n",
  " 438:	2334      	movs	r3, #52	; 0x34\n",
  " 43a:	2336      	movs	r3, #54	; 0x36\n",
  " 43c:	2338      	movs	r3, #56	; 0x38\n",
  " 43e:	233a      	movs	r3, #58	; 0x3a\n",
  " 440:	233c      	movs	r3, #60	; 0x3c\n",
  " 442:	233e      	movs	r3, #62	; 0x3e\n",
  " 444:	2340      	movs	r3, #64	; 0x40\n",
  " 446:	2342      	movs	r3, #66	; 0x42\n",
  " 448:	2344      	movs	r3, #68	; 0x44\n",
  " 44a:	2346      	movs	r3, #70	; 0x46\n",
  " 44c:	2348      	movs	r3, #72	; 0x48\n",
  " 44e:	234a      	movs	r3, #74	; 0x4a\n",
  " 450:	234c      	movs	r3, #76	; 0x4c\n",
  " 452:	234e      	movs	r3, #78	; 0x4e\n",
  " 454:	2350      	movs	r3, #80	; 0x50\n",
  " 456:	2352      	movs	r3, #82	; 0x52\n",
  " 458:	2354      	movs	r3, #84	; 0x54\n",
  " 45a:	2356      	movs	r3, #86	; 0x56\n",
  " 45c:	2358      	movs	r3, #88	; 0x58\n",
  " 45e:	235a      	movs	r3, #90	; 0x5a\n",
  " 460:	235c      	movs	r3, #92	; 0x5c\n",
  " 462:	235e      	movs	r3, #94	; 0x5e\n",
  " 464:	2360      	movs	r3, #96	; 0x60\n",
  " 466:	2362      	movs	r3, #98	; 0x62\n",
  " 468:	2364      	movs	r3, #100	; 0x64\n",
  " 46a:	2366      	movs	r3, #102	; 0x66\n",
  " 46c:	2368      	movs	r3, #104	; 0x68\n",
  " 46e:	236a      	movs	r3, #106	; 0x6a\n",
  " 470:	236c      	movs	r3, #108	; 0x6c\n",
  " 472:	236e      	movs	r3, #110	; 0x6e\n",
  " 474:	2370      	movs	r3, #112	; 0x70\n",
  " 476:	2372      	movs	r3, #114	; 0x72\n",
  " 478:	2374      	movs	r3, #116	; 0x74\n",
  " 47a:	2376      	movs	r3, #118	; 0x76\n",
  " 47c:	2378      	movs	r3, #120	; 0x78\n",
  " 47e:	237a      	movs	r3, #122	; 0x7a\n",
  " 480:	237c      	movs	r3, #124	; 0x7c\n",
  " 482:	237e      	movs	r3, #126	; 0x7e\n",
  " 484:	2380      	movs	r3, #128	; 0x80\n",
  " 486:	2382      	movs	r3, #130	; 0x82\n",
  " 488:	2384      	movs	r3, #132	; 0x84\n",
  " 48a:	2386      	movs	r3, #134	; 0x86\n",
  " 48c:	2388      	movs	r3, #136	; 0x88\n",
  " 48e:	238a      	movs	r3, #138	; 0x8a\n",
  " 490:	238c      	movs	r3, #140	; 0x8c\n",
  " 492:	238e      	movs	r3, #142	; 0x8e\n",
  " 494:	2390      	movs	r3, #144	; 0x90\n",
  " 496:	2392      	movs	r3, #146	; 0x92\n",
  " 498:	2394      	movs	r3, #148	; 0x94\n",
  " 49a:	2396      	movs	r3, #150	; 0x96\n",
  " 49c:	2398      	movs	r3, #152	; 0x98\n",
  " 49e:	239a      	movs	r3, #154	; 0x9a\n",
  " 4a0:	239c      	movs	r3, #156	; 0x9c\n",
  " 4a2:	239e      	movs	r3, #158	; 0x9e\n",
  " 4a4:	23a0      	movs	r3, #160	; 0xa0\n",
  " 4a6:	23a2      	movs	r3, #162	; 0xa2\n",
  " 4a8:	23a4      	movs	r3, #164	; 0xa4\n",
  " 4aa:	23a6      	movs	r3, #166	; 0xa6\n",
  " 4ac:	23a8      	movs	r3, #168	; 0xa8\n",
  " 4ae:	23aa      	movs	r3, #170	; 0xaa\n",
  " 4b0:	23ac      	movs	r3, #172	; 0xac\n",
  " 4b2:	23ae      	movs	r3, #174	; 0xae\n",
  " 4b4:	23b0      	movs	r3, #176	; 0xb0\n",
  " 4b6:	23b2      	movs	r3, #178	; 0xb2\n",
  " 4b8:	23b4      	movs	r3, #180	; 0xb4\n",
  " 4ba:	23b6      	movs	r3, #182	; 0xb6\n",
  " 4bc:	23b8      	movs	r3, #184	; 0xb8\n",
  " 4be:	23ba      	movs	r3, #186	; 0xba\n",
  " 4c0:	23bc      	movs	r3, #188	; 0xbc\n",
  " 4c2:	23be      	movs	r3, #190	; 0xbe\n",
  " 4c4:	23c0      	movs	r3, #192	; 0xc0\n",
  " 4c6:	23c2      	movs	r3, #194	; 0xc2\n",
  " 4c8:	23c4      	movs	r3, #196	; 0xc4\n",
  " 4ca:	23c6      	movs	r3, #198	; 0xc6\n",
  " 4cc:	23c8      	movs	r3, #200	; 0xc8\n",
  " 4ce:	23ca      	movs	r3, #202	; 0xca\n",
  " 4d0:	23cc      	movs	r3, #204	; 0xcc\n",
  " 4d2:	23ce      	movs	r3, #206	; 0xce\n",
  " 4d4:	23d0      	movs	r3, #208	; 0xd0\n",
  " 4d6:	23d2      	movs	r3, #210	; 0xd2\n",
  " 4d8:	23d4      	movs	r3, #212	; 0xd4\n",
  " 4da:	23d6      	movs	r3, #214	; 0xd6\n",
  " 4dc:	23d8      	movs	r3, #216	; 0xd8\n",
  " 4de:	23da      	movs	r3, #218	; 0xda\n",
  " 4e0:	23dc      	movs	r3, #220	; 0xdc\n",
  " 4e2:	23de      	movs	r3, #222	; 0xde\n",
  " 4e4:	23e0      	movs	r3, #224	; 0xe0\n",
  " 4e6:	23e2      	movs	r3, #226	; 0xe2\n",
  " 4e8:	23e4      	movs	r3, #228	; 0xe4\n",
  " 4ea:	23e6      	movs	r3, #230	; 0xe6\n",
  " 4ec:	23e8      	movs	r3, #232	; 0xe8\n",
  " 4ee:	23ea      	movs	r3, #234	; 0xea\n",
  " 4f0:	23ec      	movs	r3, #236	; 0xec\n",
  " 4f2:	23ee      	movs	r3, #238	; 0xee\n",
  " 4f4:	23f0      	movs	r3, #240	; 0xf0\n",
  " 4f6:	23f2      	movs	r3, #242	; 0xf2\n",
  " 4f8:	23f4      	movs	r3, #244	; 0xf4\n",
  " 4fa:	23f6      	movs	r3, #246	; 0xf6\n",
  " 4fc:	23f8      	movs	r3, #248	; 0xf8\n",
  " 4fe:	23fa      	movs	r3, #250	; 0xfa\n",
  " 500:	23fc      	movs	r3, #252	; 0xfc\n",
  " 502:	23fe      	movs	r3, #254	; 0xfe\n",
  " 504:	2300      	movs	r3, #0\n",
  " 506:	2302      	movs	r3, #2\n",
  " 508:	2304      	movs	r3, #4\n",
  " 50a:	2306      	movs	r3, #6\n",
  " 50c:	2308      	movs	r3, #8\n",
  " 50e:	230a      	movs	r3, #10\n",
  " 510:	230c      	movs	r3, #12\n",
  " 512:	230e      	movs	r3, #14\n",
  " 514:	2310      	movs	r3, #16\n",
  " 516:	2312      	movs	r3, #18\n",
  " 518:	2314      	movs	r3, #20\n",
  " 51a:	2316      	movs	r3, #22\n",
  " 51c:	2318      	movs	r3, #24\n",
  " 51e:	231a      	movs	r3, #26\n",
  " 520:	231c      	movs	r3, #28\n",
  " 522:	231e      	movs	r3, #30\n",
  " 524:	2320      	movs	r3, #32\n",
  " 526:	2322      	movs	r3, #34	; 0x22\n",
  " 528:	2324      	movs	r3, #36	; 0x24\n",
  " 52a:	2326      	movs	r3, #38	; 0x26\n",
  " 52c:	2328      	movs	r3, #40	; 0x28\n",
  " 52e:	232a      	movs	r3, #42	; 0x2a\n",
  " 530:	232c      	movs	r3, #44	; 0x2c\n",
  " 532:	232e      	movs	r3, #46	; 0x2e\n",
  " 534:	2330      	movs	r3, #48	; 0x30\n",
  " 536:	2332      	movs	r3, #50	; 0x32\n",
  " 538:	2334      	movs	r3, #52	; 0x34\n",
  " 53a:	2336      	movs	r3, #54	; 0x36\n",
  " 53c:	2338      	movs	r3, #56	; 0x38\n",
  " 53e:	233a      	movs	r3, #58	; 0x3a\n",
  " 540:	233c      	movs	r3, #60	; 0x3c\n",
  " 542:	233e      	movs	r3, #62	; 0x3e\n",
  " 544:	2340      	movs	r3, #64	; 0x40\n",
  " 546:	2342      	movs	r3, #66	; 0x42\n",
  " 548:	2344      	movs	r3, #68	; 0x44\n",
  " 54a:	2346      	movs	r3, #70	; 0x46\n",
  " 54c:	2348      	movs	r3, #72	; 0x48\n",
  " 54e:	234a      	movs	r3, #74	; 0x4a\n",
  " 550:	234c      	movs	r3, #76	; 0x4c\n",
  " 552:	234e      	movs	r3, #78	; 0x4e\n",
  " 554:	2350      	movs	r3, #80	; 0x50\n",
  " 556:	2352      	movs	r3, #82	; 0x52\n",
  " 558:	2354      	movs	r3, #84	; 0x54\n",
  " 55a:	2356      	movs	r3, #86	; 0x56\n",
  " 55c:	2358      	movs	r3, #88	; 0x58\n",
  " 55e:	235a      	movs	r3, #90	; 0x5a\n",
  " 560:	235c      	movs	r3, #92	; 0x5c\n",
  " 562:	235e      	movs	r3, #94	; 0x5e\n",
  " 564:	2360      	movs	r3, #96	; 0x60\n",
  " 566:	2362      	movs	r3, #98	; 0x62\n",
  " 568:	2364      	movs	r3, #100	; 0x64\n",
  " 56a:	2366      	movs	r3, #102	; 0x66\n",
  " 56c:	2368      	movs	r3, #104	; 0x68\n",
  " 56e:	236a      	movs	r3, #106	; 0x6a\n",
  " 570:	236c      	movs	r3, #108	; 0x6c\n",
  " 572:	236e      	movs	r3, #110	; 0x6e\n",
  " 574:	2370      	movs	r3, #112	; 0x70\n",
  " 576:	2372      	movs	r3, #114	; 0x72\n",
  " 578:	2374      	movs	r3, #116	; 0x74\n",
  " 57a:	2376      	movs	r3, #118	; 0x76\n",
  " 57c:	2378      	movs	r3, #120	; 0x78\n",
  " 57e:	237a      	movs	r3, #122	; 0x7a\n",
  " 580:	237c      	movs	r3, #124	; 0x7c\n",
  " 582:	237e      	movs	r3, #126	; 0x7e\n",
  " 584:	2380      	movs	r3, #128	; 0x80\n",
  " 586:	2382      	movs	r3, #130	; 0x82\n",
  " 588:	2384      	movs	r3, #132	; 0x84\n",
  " 58a:	2386      	movs	r3, #134	; 0x86\n",
  " 58c:	2388      	movs	r3, #136	; 0x88\n",
  " 58e:	238a      	movs	r3, #138	; 0x8a\n",
  " 590:	238c      	movs	r3, #140	; 0x8c\n",
  " 592:	238e      	movs	r3, #142	; 0x8e\n",
  " 594:	2390      	movs	r3, #144	; 0x90\n",
  " 596:	2392      	movs	r3, #146	; 0x92\n",
  " 598:	2394      	movs	r3, #148	; 0x94\n",
  " 59a:	2396      	movs	r3, #150	; 0x96\n",
  " 59c:	2398      	movs	r3, #152	; 0x98\n",
  " 59e:	239a      	movs	r3, #154	; 0x9a\n",
  " 5a0:	239c      	movs	r3, #156	; 0x9c\n",
  " 5a2:	239e      	movs	r3, #158	; 0x9e\n",
  " 5a4:	23a0      	movs	r3, #160	; 0xa0\n",
  " 5a6:	23a2      	movs	r3, #162	; 0xa2\n",
  " 5a8:	23a4      	movs	r3, #164	; 0xa4\n",
  " 5aa:	23a6      	movs	r3, #166	; 0xa6\n",
  " 5ac:	23a8      	movs	r3, #168	; 0xa8\n",
  " 5ae:	23aa      	movs	r3, #170	; 0xaa\n",
  " 5b0:	23ac      	movs	r3, #172	; 0xac\n",
  " 5b2:	23ae      	movs	r3, #174	; 0xae\n",
  " 5b4:	23b0      	movs	r3, #176	; 0xb0\n",
  " 5b6:	23b2      	movs	r3, #178	; 0xb2\n",
  " 5b8:	23b4      	movs	r3, #180	; 0xb4\n",
  " 5ba:	23b6      	movs	r3, #182	; 0xb6\n",
  " 5bc:	23b8      	movs	r3, #184	; 0xb8\n",
  " 5be:	23ba      	movs	r3, #186	; 0xba\n",
  " 5c0:	23bc      	movs	r3, #188	; 0xbc\n",
  " 5c2:	23be      	movs	r3, #190	; 0xbe\n",
  " 5c4:	23c0      	movs	r3, #192	; 0xc0\n",
  " 5c6:	23c2      	movs	r3, #194	; 0xc2\n",
  " 5c8:	23c4      	movs	r3, #196	; 0xc4\n",
  " 5ca:	23c6      	movs	r3, #198	; 0xc6\n",
  " 5cc:	23c8      	movs	r3, #200	; 0xc8\n",
  " 5ce:	23ca      	movs	r3, #202	; 0xca\n",
  " 5d0:	23cc      	movs	r3, #204	; 0xcc\n",
  " 5d2:	23ce      	movs	r3, #206	; 0xce\n",
  " 5d4:	23d0      	movs	r3, #208	; 0xd0\n",
  " 5d6:	23d2      	movs	r3, #210	; 0xd2\n",
  " 5d8:	23d4      	movs	r3, #212	; 0xd4\n",
  " 5da:	23d6      	movs	r3, #214	; 0xd6\n",
  " 5dc:	23d8      	movs	r3, #216	; 0xd8\n",
  " 5de:	23da      	movs	r3, #218	; 0xda\n",
  " 5e0:	23dc      	movs	r3, #220	; 0xdc\n",
  " 5e2:	23de      	movs	r3, #222	; 0xde\n",
  " 5e4:	23e0      	movs	r3, #224	; 0xe0\n",
  " 5e6:	23e2      	movs	r3, #226	; 0xe2\n",
  " 5e8:	23e4      	movs	r3, #228	; 0xe4\n",
  " 5ea:	23e6      	movs	r3, #230	; 0xe6\n",
  " 5ec:	23e8      	movs	r3, #232	; 0xe8\n",
  " 5ee:	23ea      	movs	r3, #234	; 0xea\n",
  " 5f0:	23ec      	movs	r3, #236	; 0xec\n",
  " 5f2:	23ee      	movs	r3, #238	; 0xee\n",
  " 5f4:	23f0      	movs	r3, #240	; 0xf0\n",
  " 5f6:	23f2      	movs	r3, #242	; 0xf2\n",
  " 5f8:	23f4      	movs	r3, #244	; 0xf4\n",
  " 5fa:	23f6      	movs	r3, #246	; 0xf6\n",
  " 5fc:	23f8      	movs	r3, #248	; 0xf8\n",
  " 5fe:	23fa      	movs	r3, #250	; 0xfa\n",
  " 600:	23fc      	movs	r3, #252	; 0xfc\n",
  " 602:	23fe      	movs	r3, #254	; 0xfe\n",
  " 604:	2300      	movs	r3, #0\n",
  " 606:	2302      	movs	r3, #2\n",
  " 608:	2304      	movs	r3, #4\n",
  " 60a:	2306      	movs	r3, #6\n",
  " 60c:	2308      	movs	r3, #8\n",
  " 60e:	230a      	movs	r3, #10\n",
  " 610:	230c      	movs	r3, #12\n",
  " 612:	230e      	movs	r3, #14\n",
  " 614:	2310      	movs	r3, #16\n",
  " 616:	2312      	movs	r3, #18\n",
  " 618:	2314      	movs	r3, #20\n",
  " 61a:	2316      	movs	r3, #22\n",
  " 61c:	2318      	movs	r3, #24\n",
  " 61e:	231a      	movs	r3, #26\n",
  " 620:	231c      	movs	r3, #28\n",
  " 622:	231e      	movs	r3, #30\n",
  " 624:	2320      	movs	r3, #32\n",
  " 626:	2322      	movs	r3, #34	; 0x22\n",
  " 628:	2324      	movs	r3, #36	; 0x24\n",
  " 62a:	2326      	movs	r3, #38	; 0x26\n",
  " 62c:	2328      	movs	r3, #40	; 0x28\n",
  " 62e:	232a      	movs	r3, #42	; 0x2a\n",
  " 630:	232c      	movs	r3, #44	; 0x2c\n",
  " 632:	232e      	movs	r3, #46	; 0x2e\n",
  " 634:	2330      	movs	r3, #48	; 0x30\n",
  " 636:	2332      	movs	r3, #50	; 0x32\n",
  " 638:	2334      	movs	r3, #52	; 0x34\n",
  " 63a:	2336      	movs	r3, #54	; 0x36\n",
  " 63c:	2338      	movs	r3, #56	; 0x38\n",
  " 63e:	233a      	movs	r3, #58	; 0x3a\n",
  " 640:	233c      	movs	r3, #60	; 0x3c\n",
  " 642:	233e      	movs	r3, #62	; 0x3e\n",
  " 644:	2340      	movs	r3, #64	; 0x40\n",
  " 646:	2342      	movs	r3, #66	; 0x42\n",
  " 648:	2344      	movs	r3, #68	; 0x44\n",
  " 64a:	2346      	movs	r3, #70	; 0x46\n",
  " 64c:	2348      	movs	r3, #72	; 0x48\n",
  " 64e:	234a      	movs	r3, #74	; 0x4a\n",
  " 650:	234c      	movs	r3, #76	; 0x4c\n",
  " 652:	234e      	movs	r3, #78	; 0x4e\n",
  " 654:	2350      	movs	r3, #80	; 0x50\n",
  " 656:	2352      	movs	r3, #82	; 0x52\n",
  " 658:	2354      	movs	r3, #84	; 0x54\n",
  " 65a:	2356      	movs	r3, #86	; 0x56\n",
  " 65c:	2358      	movs	r3, #88	; 0x58\n",
  " 65e:	235a      	movs	r3, #90	; 0x5a\n",
  " 660:	235c      	movs	r3, #92	; 0x5c\n",
  " 662:	235e      	movs	r3, #94	; 0x5e\n",
  " 664:	2360      	movs	r3, #96	; 0x60\n",
  " 666:	2362      	movs	r3, #98	; 0x62\n",
  " 668:	2364      	movs	r3, #100	; 0x64\n",
  " 66a:	2366      	movs	r3, #102	; 0x66\n",
  " 66c:	2368      	movs	r3, #104	; 0x68\n",
  " 66e:	236a      	movs	r3, #106	; 0x6a\n",
  " 670:	236c      	movs	r3, #108	; 0x6c\n",
  " 672:	236e      	movs	r3, #110	; 0x6e\n",
  " 674:	2370      	movs	r3, #112	; 0x70\n",
  " 676:	2372      	movs	r3, #114	; 0x72\n",
  " 678:	2374      	movs	r3, #116	; 0x74\n",
  " 67a:	2376      	movs	r3, #118	; 0x76\n",
  " 67c:	2378      	movs	r3, #120	; 0x78\n",
  " 67e:	237a      	movs	r3, #122	; 0x7a\n",
  " 680:	237c      	movs	r3, #124	; 0x7c\n",
  " 682:	237e      	movs	r3, #126	; 0x7e\n",
  " 684:	2380      	movs	r3, #128	; 0x80\n",
  " 686:	2382      	movs	r3, #130	; 0x82\n",
  " 688:	2384      	movs	r3, #132	; 0x84\n",
  " 68a:	2386      	movs	r3, #134	; 0x86\n",
  " 68c:	2388      	movs	r3, #136	; 0x88\n",
  " 68e:	238a      	movs	r3, #138	; 0x8a\n",
  " 690:	238c      	movs	r3, #140	; 0x8c\n",
  " 692:	238e      	movs	r3, #142	; 0x8e\n",
  " 694:	2390      	movs	r3, #144	; 0x90\n",
  " 696:	2392      	movs	r3, #146	; 0x92\n",
  " 698:	2394      	movs	r3, #148	; 0x94\n",
  " 69a:	2396      	movs	r3, #150	; 0x96\n",
  " 69c:	2398      	movs	r3, #152	; 0x98\n",
  " 69e:	239a      	movs	r3, #154	; 0x9a\n",
  " 6a0:	239c      	movs	r3, #156	; 0x9c\n",
  " 6a2:	239e      	movs	r3, #158	; 0x9e\n",
  " 6a4:	23a0      	movs	r3, #160	; 0xa0\n",
  " 6a6:	23a2      	movs	r3, #162	; 0xa2\n",
  " 6a8:	23a4      	movs	r3, #164	; 0xa4\n",
  " 6aa:	23a6      	movs	r3, #166	; 0xa6\n",
  " 6ac:	23a8      	movs	r3, #168	; 0xa8\n",
  " 6ae:	23aa      	movs	r3, #170	; 0xaa\n",
  " 6b0:	23ac      	movs	r3, #172	; 0xac\n",
  " 6b2:	23ae      	movs	r3, #174	; 0xae\n",
  " 6b4:	23b0      	movs	r3, #176	; 0xb0\n",
  " 6b6:	23b2      	movs	r3, #178	; 0xb2\n",
  " 6b8:	23b4      	movs	r3, #180	; 0xb4\n",
  " 6ba:	23b6      	movs	r3, #182	; 0xb6\n",
  " 6bc:	23b8      	movs	r3, #184	; 0xb8\n",
  " 6be:	23ba      	movs	r3, #186	; 0xba\n",
  " 6c0:	23bc      	movs	r3, #188	; 0xbc\n",
  " 6c2:	23be      	movs	r3, #190	; 0xbe\n",
  " 6c4:	23c0      	movs	r3, #192	; 0xc0\n",
  " 6c6:	23c2      	movs	r3, #194	; 0xc2\n",
  " 6c8:	23c4      	movs	r3, #196	; 0xc4\n",
  " 6ca:	23c6      	movs	r3, #198	; 0xc6\n",
  " 6cc:	23c8      	movs	r3, #200	; 0xc8\n",
  " 6ce:	23ca      	movs	r3, #202	; 0xca\n",
  " 6d0:	23cc      	movs	r3, #204	; 0xcc\n",
  " 6d2:	23ce      	movs	r3, #206	; 0xce\n",
  " 6d4:	23d0      	movs	r3, #208	; 0xd0\n",
  " 6d6:	23d2      	movs	r3, #210	; 0xd2\n",
  " 6d8:	23d4      	movs	r3, #212	; 0xd4\n",
  " 6da:	23d6      	movs	r3, #214	; 0xd6\n",
  " 6dc:	23d8      	movs	r3, #216	; 0xd8\n",
  " 6de:	23da      	movs	r3, #218	; 0xda\n",
  " 6e0:	23dc      	movs	r3, #220	; 0xdc\n",
  " 6e2:	23de      	movs	r3, #222	; 0xde\n",
  " 6e4:	23e0      	movs	r3, #224	; 0xe0\n",
  " 6e6:	23e2      	movs	r3, #226	; 0xe2\n",
  " 6e8:	23e4      	movs	r3, #228	; 0xe4\n",
  " 6ea:	23e6      	movs	r3, #230	; 0xe6\n",
  " 6ec:	23e8      	movs	r3, #232	; 0xe8\n",
  " 6ee:	23ea      	movs	r3, #234	; 0xea\n",
  " 6f0:	23ec      	movs	r3, #236	; 0xec\n",
  " 6f2:	23ee      	movs	r3, #238	; 0xee\n",
  " 6f4:	23f0      	movs	r3, #240	; 0xf0\n",
  " 6f6:	23f2      	movs	r3, #242	; 0xf2\n",
  " 6f8:	23f4      	movs	r3, #244	; 0xf4\n",
  " 6fa:	23f6      	movs	r3, #246	; 0xf6\n",
  " 6fc:	23f8      	movs	r3, #248	; 0xf8\n",
  " 6fe:	23fa      	movs	r3, #250	; 0xfa\n",
  " 700:	23fc      	movs	r3, #252	; 0xfc\n",
  " 702:	23fe      	movs	r3, #254	; 0xfe\n",
  " 704:	2300      	movs	r3, #0\n",
  " 706:	2302      	movs	r3, #2\n",
  " 708:	2304      	movs	r3, #4\n",
  " 70a:	2306      	movs	r3, #6\n",
  " 70c:	2308      	movs	r3, #8\n",
  " 70e:	230a      	movs	r3, #10\n",
  " 710:	230c      	movs	r3, #12\n",
  " 712:	230e      	movs	r3, #14\n",
  " 714:	2310      	movs	r3, #16\n",
  " 716:	2312      	movs	r3, #18\n",
  " 718:	2314      	movs	r3, #20\n",
  " 71a:	2316      	movs	r3, #22\n",
  " 71c:	2318      	movs	r3, #24\n",
  " 71e:	231a      	movs	r3, #26\n",
  " 720:	231c      	movs	r3, #28\n",
  " 722:	231e      	movs	r3, #30\n",
  " 724:	2320      	movs	r3, #32\n",
  " 726:	2322      	movs	r3, #34	; 0x22\n",
  " 728:	2324      	movs	r3, #36	; 0x24\n",
  " 72a:	2326      	movs	r3, #38	; 0x26\n",
  " 72c:	2328      	movs	r3, #40	; 0x28\n",
  " 72e:	232a      	movs	r3, #42	; 0x2a\n",
  " 730:	232c      	movs	r3, #44	; 0x2c\n",
  " 732:	232e      	movs	r3, #46	; 0x2e\n",
  " 734:	2330      	movs	r3, #48	; 0x30\n",
  " 736:	2332      	movs	r3, #50	; 0x32\n",
  " 738:	2334      	movs	r3, #52	; 0x34\n",
  " 73a:	2336      	movs	r3, #54	; 0x36\n",
  " 73c:	2338      	movs	r3, #56	; 0x38\n",
  " 73e:	233a      	movs	r3, #58	; 0x3a\n",
  " 740:	233c      	movs	r3, #60	; 0x3c\n",
  " 742:	233e      	movs	r3, #62	; 0x3e\n",
  " 744:	2340      	movs	r3, #64	; 0x40\n",
  " 746:	2342      	movs	r3, #66	; 0x42\n",
  " 748:	2344      	movs	r3, #68	; 0x44\n",
  " 74a:	2346      	movs	r3, #70	; 0x46\n",
  " 74c:	2348      	movs	r3, #72	; 0x48\n",
  " 74e:	234a      	movs	r3, #74	; 0x4a\n",
  " 750:	234c      	movs	r3, #76	; 0x4c\n",
  " 752:	234e      	movs	r3, #78	; 0x4e\n",
  " 754:	2350      	movs	r3, #80	; 0x50\n",
  " 756:	2352      	movs	r3, #82	; 0x52\n",
  " 758:	2354      	movs	r3, #84	; 0x54\n",
  " 75a:	2356      	movs	r3, #86	; 0x56\n",
  " 75c:	2358      	movs	r3, #88	; 0x58\n",
  " 75e:	235a      	movs	r3, #90	; 0x5a\n",
  " 760:	235c      	movs	r3, #92	; 0x5c\n",
  " 762:	235e      	movs	r3, #94	; 0x5e\n",
  " 764:	2360      	movs	r3, #96	; 0x60\n",
  " 766:	2362      	movs	r3, #98	; 0x62\n",
  " 768:	2364      	movs	r3, #100	; 0x64\n",
  " 76a:	2366      	movs	r3, #102	; 0x66\n",
  " 76c:	2368      	movs	r3, #104	; 0x68\n",
  " 76e:	236a      	movs	r3, #106	; 0x6a\n",
  " 770:	236c      	movs	r3, #108	; 0x6c\n",
  " 772:	236e      	movs	r3, #110	; 0x6e\n",
  " 774:	2370      	movs	r3, #112	; 0x70\n",
  " 776:	2372      	movs	r3, #114	; 0x72\n",
  " 778:	2374      	movs	r3, #116	; 0x74\n",
  " 77a:	2376      	movs	r3, #118	; 0x76\n",
  " 77c:	2378      	movs	r3, #120	; 0x78\n",
  " 77e:	237a      	movs	r3, #122	; 0x7a\n",
  " 780:	237c      	movs	r3, #124	; 0x7c\n",
  " 782:	237e      	movs	r3, #126	; 0x7e\n",
  " 784:	2380      	movs	r3, #128	; 0x80\n",
  " 786:	2382      	movs	r3, #130	; 0x82\n",
  " 788:	2384      	movs	r3, #132	; 0x84\n",
  " 78a:	2386      	movs	r3, #134	; 0x86\n",
  " 78c:	2388      	movs	r3, #136	; 0x88\n",
  " 78e:	238a      	movs	r3, #138	; 0x8a\n",
  " 790:	238c      	movs	r3, #140	; 0x8c\n",
  " 792:	238e      	movs	r3, #142	; 0x8e\n",
  " 794:	2390      	movs	r3, #144	; 0x90\n",
  " 796:	2392      	movs	r3, #146	; 0x92\n",
  " 798:	2394      	movs	r3, #148	; 0x94\n",
  " 79a:	2396      	movs	r3, #150	; 0x96\n",
  " 79c:	2398      	movs	r3, #152	; 0x98\n",
  " 79e:	239a      	movs	r3, #154	; 0x9a\n",
  " 7a0:	239c      	movs	r3, #156	; 0x9c\n",
  " 7a2:	239e      	movs	r3, #158	; 0x9e\n",
  " 7a4:	23a0      	movs	r3, #160	; 0xa0\n",
  " 7a6:	23a2      	movs	r3, #162	; 0xa2\n",
  " 7a8:	23a4      	movs	r3, #164	; 0xa4\n",
  " 7aa:	23a6      	movs	r3, #166	; 0xa6\n",
  " 7ac:	23a8      	movs	r3, #168	; 0xa8\n",
  " 7ae:	23aa      	movs	r3, #170	; 0xaa\n",
  " 7b0:	23ac      	movs	r3, #172	; 0xac\n",
  " 7b2:	23ae      	movs	r3, #174	; 0xae\n",
  " 7b4:	23b0      	movs	r3, #176	; 0xb0\n",
  " 7b6:	23b2      	movs	r3, #178	; 0xb2\n",
  " 7b8:	23b4      	movs	r3, #180	; 0xb4\n",
  " 7ba:	23b6      	movs	r3, #182	; 0xb6\n",
  " 7bc:	23b8      	movs	r3, #184	; 0xb8\n",
  " 7be:	23ba      	movs	r3, #186	; 0xba\n",
  " 7c0:	23bc      	movs	r3, #188	; 0xbc\n",
  " 7c2:	23be      	movs	r3, #190	; 0xbe\n",
  " 7c4:	23c0      	movs	r3, #192	; 0xc0\n",
  " 7c6:	23c2      	movs	r3, #194	; 0xc2\n",
  " 7c8:	23c4      	movs	r3, #196	; 0xc4\n",
  " 7ca:	23c6      	movs	r3, #198	; 0xc6\n",
  " 7cc:	23c8      	movs	r3, #200	; 0xc8\n",
  " 7ce:	23ca      	movs	r3, #202	; 0xca\n",
  " 7d0:	23cc      	movs	r3, #204	; 0xcc\n",
  " 7d2:	23ce      	movs	r3, #206	; 0xce\n",
  " 7d4:	23d0      	movs	r3, #208	; 0xd0\n",
  " 7d6:	23d2      	movs	r3, #210	; 0xd2\n",
  " 7d8:	23d4      	movs	r3, #212	; 0xd4\n",
  " 7da:	23d6      	movs	r3, #214	; 0xd6\n",
  " 7dc:	23d8      	movs	r3, #216	; 0xd8\n",
  " 7de:	23da      	movs	r3, #218	; 0xda\n",
  " 7e0:	23dc      	movs	r3, #220	; 0xdc\n",
  " 7e2:	23de      	movs	r3, #222	; 0xde\n",
  " 7e4:	23e0      	movs	r3, #224	; 0xe0\n",
  " 7e6:	23e2      	movs	r3, #226	; 0xe2\n",
  " 7e8:	23e4      	movs	r3, #228	; 0xe4\n",
  " 7ea:	23e6      	movs	r3, #230	; 0xe6\n",
  " 7ec:	23e8      	movs	r3, #232	; 0xe8\n",
  " 7ee:	23ea      	movs	r3, #234	; 0xea\n",
  " 7f0:	23ec      	movs	r3, #236	; 0xec\n",
  " 7f2:	23ee      	movs	r3, #238	; 0xee\n",
  " 7f4:	23f0      	movs	r3, #240	; 0xf0\n",
  " 7f6:	23f2      	movs	r3, #242	; 0xf2\n",
  " 7f8:	23f4      	movs	r3, #244	; 0xf4\n",
  " 7fa:	23f6      	movs	r3, #246	; 0xf6\n",
  " 7fc:	23f8      	movs	r3, #248	; 0xf8\n",
  " 7fe:	23fa      	movs	r3, #250	; 0xfa\n",
  " 800:	23fc      	movs	r3, #252	; 0xfc\n",
  " 802:	23fe      	movs	r3, #254	; 0xfe\n",
  " 804:	2300      	movs	r3, #0\n",
  " 806:	4611      	mov	r1, r2\n",
  nullptr
};
const char* CompareAndBranchMaxResults[] = {
  "   0:	b3fc      	cbz	r4, 82 <CompareAndBranchMax+0x82>\n",
  "   2:	2300      	movs	r3, #0\n",
  "   4:	2302      	movs	r3, #2\n",
  "   6:	2304      	movs	r3, #4\n",
  "   8:	2306      	movs	r3, #6\n",
  "   a:	2308      	movs	r3, #8\n",
  "   c:	230a      	movs	r3, #10\n",
  "   e:	230c      	movs	r3, #12\n",
  "  10:	230e      	movs	r3, #14\n",
  "  12:	2310      	movs	r3, #16\n",
  "  14:	2312      	movs	r3, #18\n",
  "  16:	2314      	movs	r3, #20\n",
  "  18:	2316      	movs	r3, #22\n",
  "  1a:	2318      	movs	r3, #24\n",
  "  1c:	231a      	movs	r3, #26\n",
  "  1e:	231c      	movs	r3, #28\n",
  "  20:	231e      	movs	r3, #30\n",
  "  22:	2320      	movs	r3, #32\n",
  "  24:	2322      	movs	r3, #34	; 0x22\n",
  "  26:	2324      	movs	r3, #36	; 0x24\n",
  "  28:	2326      	movs	r3, #38	; 0x26\n",
  "  2a:	2328      	movs	r3, #40	; 0x28\n",
  "  2c:	232a      	movs	r3, #42	; 0x2a\n",
  "  2e:	232c      	movs	r3, #44	; 0x2c\n",
  "  30:	232e      	movs	r3, #46	; 0x2e\n",
  "  32:	2330      	movs	r3, #48	; 0x30\n",
  "  34:	2332      	movs	r3, #50	; 0x32\n",
  "  36:	2334      	movs	r3, #52	; 0x34\n",
  "  38:	2336      	movs	r3, #54	; 0x36\n",
  "  3a:	2338      	movs	r3, #56	; 0x38\n",
  "  3c:	233a      	movs	r3, #58	; 0x3a\n",
  "  3e:	233c      	movs	r3, #60	; 0x3c\n",
  "  40:	233e      	movs	r3, #62	; 0x3e\n",
  "  42:	2340      	movs	r3, #64	; 0x40\n",
  "  44:	2342      	movs	r3, #66	; 0x42\n",
  "  46:	2344      	movs	r3, #68	; 0x44\n",
  "  48:	2346      	movs	r3, #70	; 0x46\n",
  "  4a:	2348      	movs	r3, #72	; 0x48\n",
  "  4c:	234a      	movs	r3, #74	; 0x4a\n",
  "  4e:	234c      	movs	r3, #76	; 0x4c\n",
  "  50:	234e      	movs	r3, #78	; 0x4e\n",
  "  52:	2350      	movs	r3, #80	; 0x50\n",
  "  54:	2352      	movs	r3, #82	; 0x52\n",
  "  56:	2354      	movs	r3, #84	; 0x54\n",
  "  58:	2356      	movs	r3, #86	; 0x56\n",
  "  5a:	2358      	movs	r3, #88	; 0x58\n",
  "  5c:	235a      	movs	r3, #90	; 0x5a\n",
  "  5e:	235c      	movs	r3, #92	; 0x5c\n",
  "  60:	235e      	movs	r3, #94	; 0x5e\n",
  "  62:	2360      	movs	r3, #96	; 0x60\n",
  "  64:	2362      	movs	r3, #98	; 0x62\n",
  "  66:	2364      	movs	r3, #100	; 0x64\n",
  "  68:	2366      	movs	r3, #102	; 0x66\n",
  "  6a:	2368      	movs	r3, #104	; 0x68\n",
  "  6c:	236a      	movs	r3, #106	; 0x6a\n",
  "  6e:	236c      	movs	r3, #108	; 0x6c\n",
  "  70:	236e      	movs	r3, #110	; 0x6e\n",
  "  72:	2370      	movs	r3, #112	; 0x70\n",
  "  74:	2372      	movs	r3, #114	; 0x72\n",
  "  76:	2374      	movs	r3, #116	; 0x74\n",
  "  78:	2376      	movs	r3, #118	; 0x76\n",
  "  7a:	2378      	movs	r3, #120	; 0x78\n",
  "  7c:	237a      	movs	r3, #122	; 0x7a\n",
  "  7e:	237c      	movs	r3, #124	; 0x7c\n",
  "  80:	237e      	movs	r3, #126	; 0x7e\n",
  "  82:	4611      	mov	r1, r2\n",
  nullptr
};
const char* CompareAndBranchRelocation16Results[] = {
  "   0:	2c00      	cmp	r4, #0\n",
  "   2:	d040      	beq.n	86 <CompareAndBranchRelocation16+0x86>\n",
  "   4:	2300      	movs	r3, #0\n",
  "   6:	2302      	movs	r3, #2\n",
  "   8:	2304      	movs	r3, #4\n",
  "   a:	2306      	movs	r3, #6\n",
  "   c:	2308      	movs	r3, #8\n",
  "   e:	230a      	movs	r3, #10\n",
  "  10:	230c      	movs	r3, #12\n",
  "  12:	230e      	movs	r3, #14\n",
  "  14:	2310      	movs	r3, #16\n",
  "  16:	2312      	movs	r3, #18\n",
  "  18:	2314      	movs	r3, #20\n",
  "  1a:	2316      	movs	r3, #22\n",
  "  1c:	2318      	movs	r3, #24\n",
  "  1e:	231a      	movs	r3, #26\n",
  "  20:	231c      	movs	r3, #28\n",
  "  22:	231e      	movs	r3, #30\n",
  "  24:	2320      	movs	r3, #32\n",
  "  26:	2322      	movs	r3, #34	; 0x22\n",
  "  28:	2324      	movs	r3, #36	; 0x24\n",
  "  2a:	2326      	movs	r3, #38	; 0x26\n",
  "  2c:	2328      	movs	r3, #40	; 0x28\n",
  "  2e:	232a      	movs	r3, #42	; 0x2a\n",
  "  30:	232c      	movs	r3, #44	; 0x2c\n",
  "  32:	232e      	movs	r3, #46	; 0x2e\n",
  "  34:	2330      	movs	r3, #48	; 0x30\n",
  "  36:	2332      	movs	r3, #50	; 0x32\n",
  "  38:	2334      	movs	r3, #52	; 0x34\n",
  "  3a:	2336      	movs	r3, #54	; 0x36\n",
  "  3c:	2338      	movs	r3, #56	; 0x38\n",
  "  3e:	233a      	movs	r3, #58	; 0x3a\n",
  "  40:	233c      	movs	r3, #60	; 0x3c\n",
  "  42:	233e      	movs	r3, #62	; 0x3e\n",
  "  44:	2340      	movs	r3, #64	; 0x40\n",
  "  46:	2342      	movs	r3, #66	; 0x42\n",
  "  48:	2344      	movs	r3, #68	; 0x44\n",
  "  4a:	2346      	movs	r3, #70	; 0x46\n",
  "  4c:	2348      	movs	r3, #72	; 0x48\n",
  "  4e:	234a      	movs	r3, #74	; 0x4a\n",
  "  50:	234c      	movs	r3, #76	; 0x4c\n",
  "  52:	234e      	movs	r3, #78	; 0x4e\n",
  "  54:	2350      	movs	r3, #80	; 0x50\n",
  "  56:	2352      	movs	r3, #82	; 0x52\n",
  "  58:	2354      	movs	r3, #84	; 0x54\n",
  "  5a:	2356      	movs	r3, #86	; 0x56\n",
  "  5c:	2358      	movs	r3, #88	; 0x58\n",
  "  5e:	235a      	movs	r3, #90	; 0x5a\n",
  "  60:	235c      	movs	r3, #92	; 0x5c\n",
  "  62:	235e      	movs	r3, #94	; 0x5e\n",
  "  64:	2360      	movs	r3, #96	; 0x60\n",
  "  66:	2362      	movs	r3, #98	; 0x62\n",
  "  68:	2364      	movs	r3, #100	; 0x64\n",
  "  6a:	2366      	movs	r3, #102	; 0x66\n",
  "  6c:	2368      	movs	r3, #104	; 0x68\n",
  "  6e:	236a      	movs	r3, #106	; 0x6a\n",
  "  70:	236c      	movs	r3, #108	; 0x6c\n",
  "  72:	236e      	movs	r3, #110	; 0x6e\n",
  "  74:	2370      	movs	r3, #112	; 0x70\n",
  "  76:	2372      	movs	r3, #114	; 0x72\n",
  "  78:	2374      	movs	r3, #116	; 0x74\n",
  "  7a:	2376      	movs	r3, #118	; 0x76\n",
  "  7c:	2378      	movs	r3, #120	; 0x78\n",
  "  7e:	237a      	movs	r3, #122	; 0x7a\n",
  "  80:	237c      	movs	r3, #124	; 0x7c\n",
  "  82:	237e      	movs	r3, #126	; 0x7e\n",
  "  84:	2380      	movs	r3, #128	; 0x80\n",
  "  86:	4611      	mov	r1, r2\n",
  nullptr
};
const char* CompareAndBranchRelocation32Results[] = {
  "   0:	2c00      	cmp	r4, #0\n",
  "   2:	f000 8401 	beq.w	808 <CompareAndBranchRelocation32+0x808>\n",
  "   6:	2300      	movs	r3, #0\n",
  "   8:	2302      	movs	r3, #2\n",
  "   a:	2304      	movs	r3, #4\n",
  "   c:	2306      	movs	r3, #6\n",
  "   e:	2308      	movs	r3, #8\n",
  "  10:	230a      	movs	r3, #10\n",
  "  12:	230c      	movs	r3, #12\n",
  "  14:	230e      	movs	r3, #14\n",
  "  16:	2310      	movs	r3, #16\n",
  "  18:	2312      	movs	r3, #18\n",
  "  1a:	2314      	movs	r3, #20\n",
  "  1c:	2316      	movs	r3, #22\n",
  "  1e:	2318      	movs	r3, #24\n",
  "  20:	231a      	movs	r3, #26\n",
  "  22:	231c      	movs	r3, #28\n",
  "  24:	231e      	movs	r3, #30\n",
  "  26:	2320      	movs	r3, #32\n",
  "  28:	2322      	movs	r3, #34	; 0x22\n",
  "  2a:	2324      	movs	r3, #36	; 0x24\n",
  "  2c:	2326      	movs	r3, #38	; 0x26\n",
  "  2e:	2328      	movs	r3, #40	; 0x28\n",
  "  30:	232a      	movs	r3, #42	; 0x2a\n",
  "  32:	232c      	movs	r3, #44	; 0x2c\n",
  "  34:	232e      	movs	r3, #46	; 0x2e\n",
  "  36:	2330      	movs	r3, #48	; 0x30\n",
  "  38:	2332      	movs	r3, #50	; 0x32\n",
  "  3a:	2334      	movs	r3, #52	; 0x34\n",
  "  3c:	2336      	movs	r3, #54	; 0x36\n",
  "  3e:	2338      	movs	r3, #56	; 0x38\n",
  "  40:	233a      	movs	r3, #58	; 0x3a\n",
  "  42:	233c      	movs	r3, #60	; 0x3c\n",
  "  44:	233e      	movs	r3, #62	; 0x3e\n",
  "  46:	2340      	movs	r3, #64	; 0x40\n",
  "  48:	2342      	movs	r3, #66	; 0x42\n",
  "  4a:	2344      	movs	r3, #68	; 0x44\n",
  "  4c:	2346      	movs	r3, #70	; 0x46\n",
  "  4e:	2348      	movs	r3, #72	; 0x48\n",
  "  50:	234a      	movs	r3, #74	; 0x4a\n",
  "  52:	234c      	movs	r3, #76	; 0x4c\n",
  "  54:	234e      	movs	r3, #78	; 0x4e\n",
  "  56:	2350      	movs	r3, #80	; 0x50\n",
  "  58:	2352      	movs	r3, #82	; 0x52\n",
  "  5a:	2354      	movs	r3, #84	; 0x54\n",
  "  5c:	2356      	movs	r3, #86	; 0x56\n",
  "  5e:	2358      	movs	r3, #88	; 0x58\n",
  "  60:	235a      	movs	r3, #90	; 0x5a\n",
  "  62:	235c      	movs	r3, #92	; 0x5c\n",
  "  64:	235e      	movs	r3, #94	; 0x5e\n",
  "  66:	2360      	movs	r3, #96	; 0x60\n",
  "  68:	2362      	movs	r3, #98	; 0x62\n",
  "  6a:	2364      	movs	r3, #100	; 0x64\n",
  "  6c:	2366      	movs	r3, #102	; 0x66\n",
  "  6e:	2368      	movs	r3, #104	; 0x68\n",
  "  70:	236a      	movs	r3, #106	; 0x6a\n",
  "  72:	236c      	movs	r3, #108	; 0x6c\n",
  "  74:	236e      	movs	r3, #110	; 0x6e\n",
  "  76:	2370      	movs	r3, #112	; 0x70\n",
  "  78:	2372      	movs	r3, #114	; 0x72\n",
  "  7a:	2374      	movs	r3, #116	; 0x74\n",
  "  7c:	2376      	movs	r3, #118	; 0x76\n",
  "  7e:	2378      	movs	r3, #120	; 0x78\n",
  "  80:	237a      	movs	r3, #122	; 0x7a\n",
  "  82:	237c      	movs	r3, #124	; 0x7c\n",
  "  84:	237e      	movs	r3, #126	; 0x7e\n",
  "  86:	2380      	movs	r3, #128	; 0x80\n",
  "  88:	2382      	movs	r3, #130	; 0x82\n",
  "  8a:	2384      	movs	r3, #132	; 0x84\n",
  "  8c:	2386      	movs	r3, #134	; 0x86\n",
  "  8e:	2388      	movs	r3, #136	; 0x88\n",
  "  90:	238a      	movs	r3, #138	; 0x8a\n",
  "  92:	238c      	movs	r3, #140	; 0x8c\n",
  "  94:	238e      	movs	r3, #142	; 0x8e\n",
  "  96:	2390      	movs	r3, #144	; 0x90\n",
  "  98:	2392      	movs	r3, #146	; 0x92\n",
  "  9a:	2394      	movs	r3, #148	; 0x94\n",
  "  9c:	2396      	movs	r3, #150	; 0x96\n",
  "  9e:	2398      	movs	r3, #152	; 0x98\n",
  "  a0:	239a      	movs	r3, #154	; 0x9a\n",
  "  a2:	239c      	movs	r3, #156	; 0x9c\n",
  "  a4:	239e      	movs	r3, #158	; 0x9e\n",
  "  a6:	23a0      	movs	r3, #160	; 0xa0\n",
  "  a8:	23a2      	movs	r3, #162	; 0xa2\n",
  "  aa:	23a4      	movs	r3, #164	; 0xa4\n",
  "  ac:	23a6      	movs	r3, #166	; 0xa6\n",
  "  ae:	23a8      	movs	r3, #168	; 0xa8\n",
  "  b0:	23aa      	movs	r3, #170	; 0xaa\n",
  "  b2:	23ac      	movs	r3, #172	; 0xac\n",
  "  b4:	23ae      	movs	r3, #174	; 0xae\n",
  "  b6:	23b0      	movs	r3, #176	; 0xb0\n",
  "  b8:	23b2      	movs	r3, #178	; 0xb2\n",
  "  ba:	23b4      	movs	r3, #180	; 0xb4\n",
  "  bc:	23b6      	movs	r3, #182	; 0xb6\n",
  "  be:	23b8      	movs	r3, #184	; 0xb8\n",
  "  c0:	23ba      	movs	r3, #186	; 0xba\n",
  "  c2:	23bc      	movs	r3, #188	; 0xbc\n",
  "  c4:	23be      	movs	r3, #190	; 0xbe\n",
  "  c6:	23c0      	movs	r3, #192	; 0xc0\n",
  "  c8:	23c2      	movs	r3, #194	; 0xc2\n",
  "  ca:	23c4      	movs	r3, #196	; 0xc4\n",
  "  cc:	23c6      	movs	r3, #198	; 0xc6\n",
  "  ce:	23c8      	movs	r3, #200	; 0xc8\n",
  "  d0:	23ca      	movs	r3, #202	; 0xca\n",
  "  d2:	23cc      	movs	r3, #204	; 0xcc\n",
  "  d4:	23ce      	movs	r3, #206	; 0xce\n",
  "  d6:	23d0      	movs	r3, #208	; 0xd0\n",
  "  d8:	23d2      	movs	r3, #210	; 0xd2\n",
  "  da:	23d4      	movs	r3, #212	; 0xd4\n",
  "  dc:	23d6      	movs	r3, #214	; 0xd6\n",
  "  de:	23d8      	movs	r3, #216	; 0xd8\n",
  "  e0:	23da      	movs	r3, #218	; 0xda\n",
  "  e2:	23dc      	movs	r3, #220	; 0xdc\n",
  "  e4:	23de      	movs	r3, #222	; 0xde\n",
  "  e6:	23e0      	movs	r3, #224	; 0xe0\n",
  "  e8:	23e2      	movs	r3, #226	; 0xe2\n",
  "  ea:	23e4      	movs	r3, #228	; 0xe4\n",
  "  ec:	23e6      	movs	r3, #230	; 0xe6\n",
  "  ee:	23e8      	movs	r3, #232	; 0xe8\n",
  "  f0:	23ea      	movs	r3, #234	; 0xea\n",
  "  f2:	23ec      	movs	r3, #236	; 0xec\n",
  "  f4:	23ee      	movs	r3, #238	; 0xee\n",
  "  f6:	23f0      	movs	r3, #240	; 0xf0\n",
  "  f8:	23f2      	movs	r3, #242	; 0xf2\n",
  "  fa:	23f4      	movs	r3, #244	; 0xf4\n",
  "  fc:	23f6      	movs	r3, #246	; 0xf6\n",
  "  fe:	23f8      	movs	r3, #248	; 0xf8\n",
  " 100:	23fa      	movs	r3, #250	; 0xfa\n",
  " 102:	23fc      	movs	r3, #252	; 0xfc\n",
  " 104:	23fe      	movs	r3, #254	; 0xfe\n",
  " 106:	2300      	movs	r3, #0\n",
  " 108:	2302      	movs	r3, #2\n",
  " 10a:	2304      	movs	r3, #4\n",
  " 10c:	2306      	movs	r3, #6\n",
  " 10e:	2308      	movs	r3, #8\n",
  " 110:	230a      	movs	r3, #10\n",
  " 112:	230c      	movs	r3, #12\n",
  " 114:	230e      	movs	r3, #14\n",
  " 116:	2310      	movs	r3, #16\n",
  " 118:	2312      	movs	r3, #18\n",
  " 11a:	2314      	movs	r3, #20\n",
  " 11c:	2316      	movs	r3, #22\n",
  " 11e:	2318      	movs	r3, #24\n",
  " 120:	231a      	movs	r3, #26\n",
  " 122:	231c      	movs	r3, #28\n",
  " 124:	231e      	movs	r3, #30\n",
  " 126:	2320      	movs	r3, #32\n",
  " 128:	2322      	movs	r3, #34	; 0x22\n",
  " 12a:	2324      	movs	r3, #36	; 0x24\n",
  " 12c:	2326      	movs	r3, #38	; 0x26\n",
  " 12e:	2328      	movs	r3, #40	; 0x28\n",
  " 130:	232a      	movs	r3, #42	; 0x2a\n",
  " 132:	232c      	movs	r3, #44	; 0x2c\n",
  " 134:	232e      	movs	r3, #46	; 0x2e\n",
  " 136:	2330      	movs	r3, #48	; 0x30\n",
  " 138:	2332      	movs	r3, #50	; 0x32\n",
  " 13a:	2334      	movs	r3, #52	; 0x34\n",
  " 13c:	2336      	movs	r3, #54	; 0x36\n",
  " 13e:	2338      	movs	r3, #56	; 0x38\n",
  " 140:	233a      	movs	r3, #58	; 0x3a\n",
  " 142:	233c      	movs	r3, #60	; 0x3c\n",
  " 144:	233e      	movs	r3, #62	; 0x3e\n",
  " 146:	2340      	movs	r3, #64	; 0x40\n",
  " 148:	2342      	movs	r3, #66	; 0x42\n",
  " 14a:	2344      	movs	r3, #68	; 0x44\n",
  " 14c:	2346      	movs	r3, #70	; 0x46\n",
  " 14e:	2348      	movs	r3, #72	; 0x48\n",
  " 150:	234a      	movs	r3, #74	; 0x4a\n",
  " 152:	234c      	movs	r3, #76	; 0x4c\n",
  " 154:	234e      	movs	r3, #78	; 0x4e\n",
  " 156:	2350      	movs	r3, #80	; 0x50\n",
  " 158:	2352      	movs	r3, #82	; 0x52\n",
  " 15a:	2354      	movs	r3, #84	; 0x54\n",
  " 15c:	2356      	movs	r3, #86	; 0x56\n",
  " 15e:	2358      	movs	r3, #88	; 0x58\n",
  " 160:	235a      	movs	r3, #90	; 0x5a\n",
  " 162:	235c      	movs	r3, #92	; 0x5c\n",
  " 164:	235e      	movs	r3, #94	; 0x5e\n",
  " 166:	2360      	movs	r3, #96	; 0x60\n",
  " 168:	2362      	movs	r3, #98	; 0x62\n",
  " 16a:	2364      	movs	r3, #100	; 0x64\n",
  " 16c:	2366      	movs	r3, #102	; 0x66\n",
  " 16e:	2368      	movs	r3, #104	; 0x68\n",
  " 170:	236a      	movs	r3, #106	; 0x6a\n",
  " 172:	236c      	movs	r3, #108	; 0x6c\n",
  " 174:	236e      	movs	r3, #110	; 0x6e\n",
  " 176:	2370      	movs	r3, #112	; 0x70\n",
  " 178:	2372      	movs	r3, #114	; 0x72\n",
  " 17a:	2374      	movs	r3, #116	; 0x74\n",
  " 17c:	2376      	movs	r3, #118	; 0x76\n",
  " 17e:	2378      	movs	r3, #120	; 0x78\n",
  " 180:	237a      	movs	r3, #122	; 0x7a\n",
  " 182:	237c      	movs	r3, #124	; 0x7c\n",
  " 184:	237e      	movs	r3, #126	; 0x7e\n",
  " 186:	2380      	movs	r3, #128	; 0x80\n",
  " 188:	2382      	movs	r3, #130	; 0x82\n",
  " 18a:	2384      	movs	r3, #132	; 0x84\n",
  " 18c:	2386      	movs	r3, #134	; 0x86\n",
  " 18e:	2388      	movs	r3, #136	; 0x88\n",
  " 190:	238a      	movs	r3, #138	; 0x8a\n",
  " 192:	238c      	movs	r3, #140	; 0x8c\n",
  " 194:	238e      	movs	r3, #142	; 0x8e\n",
  " 196:	2390      	movs	r3, #144	; 0x90\n",
  " 198:	2392      	movs	r3, #146	; 0x92\n",
  " 19a:	2394      	movs	r3, #148	; 0x94\n",
  " 19c:	2396      	movs	r3, #150	; 0x96\n",
  " 19e:	2398      	movs	r3, #152	; 0x98\n",
  " 1a0:	239a      	movs	r3, #154	; 0x9a\n",
  " 1a2:	239c      	movs	r3, #156	; 0x9c\n",
  " 1a4:	239e      	movs	r3, #158	; 0x9e\n",
  " 1a6:	23a0      	movs	r3, #160	; 0xa0\n",
  " 1a8:	23a2      	movs	r3, #162	; 0xa2\n",
  " 1aa:	23a4      	movs	r3, #164	; 0xa4\n",
  " 1ac:	23a6      	movs	r3, #166	; 0xa6\n",
  " 1ae:	23a8      	movs	r3, #168	; 0xa8\n",
  " 1b0:	23aa      	movs	r3, #170	; 0xaa\n",
  " 1b2:	23ac      	movs	r3, #172	; 0xac\n",
  " 1b4:	23ae      	movs	r3, #174	; 0xae\n",
  " 1b6:	23b0      	movs	r3, #176	; 0xb0\n",
  " 1b8:	23b2      	movs	r3, #178	; 0xb2\n",
  " 1ba:	23b4      	movs	r3, #180	; 0xb4\n",
  " 1bc:	23b6      	movs	r3, #182	; 0xb6\n",
  " 1be:	23b8      	movs	r3, #184	; 0xb8\n",
  " 1c0:	23ba      	movs	r3, #186	; 0xba\n",
  " 1c2:	23bc      	movs	r3, #188	; 0xbc\n",
  " 1c4:	23be      	movs	r3, #190	; 0xbe\n",
  " 1c6:	23c0      	movs	r3, #192	; 0xc0\n",
  " 1c8:	23c2      	movs	r3, #194	; 0xc2\n",
  " 1ca:	23c4      	movs	r3, #196	; 0xc4\n",
  " 1cc:	23c6      	movs	r3, #198	; 0xc6\n",
  " 1ce:	23c8      	movs	r3, #200	; 0xc8\n",
  " 1d0:	23ca      	movs	r3, #202	; 0xca\n",
  " 1d2:	23cc      	movs	r3, #204	; 0xcc\n",
  " 1d4:	23ce      	movs	r3, #206	; 0xce\n",
  " 1d6:	23d0      	movs	r3, #208	; 0xd0\n",
  " 1d8:	23d2      	movs	r3, #210	; 0xd2\n",
  " 1da:	23d4      	movs	r3, #212	; 0xd4\n",
  " 1dc:	23d6      	movs	r3, #214	; 0xd6\n",
  " 1de:	23d8      	movs	r3, #216	; 0xd8\n",
  " 1e0:	23da      	movs	r3, #218	; 0xda\n",
  " 1e2:	23dc      	movs	r3, #220	; 0xdc\n",
  " 1e4:	23de      	movs	r3, #222	; 0xde\n",
  " 1e6:	23e0      	movs	r3, #224	; 0xe0\n",
  " 1e8:	23e2      	movs	r3, #226	; 0xe2\n",
  " 1ea:	23e4      	movs	r3, #228	; 0xe4\n",
  " 1ec:	23e6      	movs	r3, #230	; 0xe6\n",
  " 1ee:	23e8      	movs	r3, #232	; 0xe8\n",
  " 1f0:	23ea      	movs	r3, #234	; 0xea\n",
  " 1f2:	23ec      	movs	r3, #236	; 0xec\n",
  " 1f4:	23ee      	movs	r3, #238	; 0xee\n",
  " 1f6:	23f0      	movs	r3, #240	; 0xf0\n",
  " 1f8:	23f2      	movs	r3, #242	; 0xf2\n",
  " 1fa:	23f4      	movs	r3, #244	; 0xf4\n",
  " 1fc:	23f6      	movs	r3, #246	; 0xf6\n",
  " 1fe:	23f8      	movs	r3, #248	; 0xf8\n",
  " 200:	23fa      	movs	r3, #250	; 0xfa\n",
  " 202:	23fc      	movs	r3, #252	; 0xfc\n",
  " 204:	23fe      	movs	r3, #254	; 0xfe\n",
  " 206:	2300      	movs	r3, #0\n",
  " 208:	2302      	movs	r3, #2\n",
  " 20a:	2304      	movs	r3, #4\n",
  " 20c:	2306      	movs	r3, #6\n",
  " 20e:	2308      	movs	r3, #8\n",
  " 210:	230a      	movs	r3, #10\n",
  " 212:	230c      	movs	r3, #12\n",
  " 214:	230e      	movs	r3, #14\n",
  " 216:	2310      	movs	r3, #16\n",
  " 218:	2312      	movs	r3, #18\n",
  " 21a:	2314      	movs	r3, #20\n",
  " 21c:	2316      	movs	r3, #22\n",
  " 21e:	2318      	movs	r3, #24\n",
  " 220:	231a      	movs	r3, #26\n",
  " 222:	231c      	movs	r3, #28\n",
  " 224:	231e      	movs	r3, #30\n",
  " 226:	2320      	movs	r3, #32\n",
  " 228:	2322      	movs	r3, #34	; 0x22\n",
  " 22a:	2324      	movs	r3, #36	; 0x24\n",
  " 22c:	2326      	movs	r3, #38	; 0x26\n",
  " 22e:	2328      	movs	r3, #40	; 0x28\n",
  " 230:	232a      	movs	r3, #42	; 0x2a\n",
  " 232:	232c      	movs	r3, #44	; 0x2c\n",
  " 234:	232e      	movs	r3, #46	; 0x2e\n",
  " 236:	2330      	movs	r3, #48	; 0x30\n",
  " 238:	2332      	movs	r3, #50	; 0x32\n",
  " 23a:	2334      	movs	r3, #52	; 0x34\n",
  " 23c:	2336      	movs	r3, #54	; 0x36\n",
  " 23e:	2338      	movs	r3, #56	; 0x38\n",
  " 240:	233a      	movs	r3, #58	; 0x3a\n",
  " 242:	233c      	movs	r3, #60	; 0x3c\n",
  " 244:	233e      	movs	r3, #62	; 0x3e\n",
  " 246:	2340      	movs	r3, #64	; 0x40\n",
  " 248:	2342      	movs	r3, #66	; 0x42\n",
  " 24a:	2344      	movs	r3, #68	; 0x44\n",
  " 24c:	2346      	movs	r3, #70	; 0x46\n",
  " 24e:	2348      	movs	r3, #72	; 0x48\n",
  " 250:	234a      	movs	r3, #74	; 0x4a\n",
  " 252:	234c      	movs	r3, #76	; 0x4c\n",
  " 254:	234e      	movs	r3, #78	; 0x4e\n",
  " 256:	2350      	movs	r3, #80	; 0x50\n",
  " 258:	2352      	movs	r3, #82	; 0x52\n",
  " 25a:	2354      	movs	r3, #84	; 0x54\n",
  " 25c:	2356      	movs	r3, #86	; 0x56\n",
  " 25e:	2358      	movs	r3, #88	; 0x58\n",
  " 260:	235a      	movs	r3, #90	; 0x5a\n",
  " 262:	235c      	movs	r3, #92	; 0x5c\n",
  " 264:	235e      	movs	r3, #94	; 0x5e\n",
  " 266:	2360      	movs	r3, #96	; 0x60\n",
  " 268:	2362      	movs	r3, #98	; 0x62\n",
  " 26a:	2364      	movs	r3, #100	; 0x64\n",
  " 26c:	2366      	movs	r3, #102	; 0x66\n",
  " 26e:	2368      	movs	r3, #104	; 0x68\n",
  " 270:	236a      	movs	r3, #106	; 0x6a\n",
  " 272:	236c      	movs	r3, #108	; 0x6c\n",
  " 274:	236e      	movs	r3, #110	; 0x6e\n",
  " 276:	2370      	movs	r3, #112	; 0x70\n",
  " 278:	2372      	movs	r3, #114	; 0x72\n",
  " 27a:	2374      	movs	r3, #116	; 0x74\n",
  " 27c:	2376      	movs	r3, #118	; 0x76\n",
  " 27e:	2378      	movs	r3, #120	; 0x78\n",
  " 280:	237a      	movs	r3, #122	; 0x7a\n",
  " 282:	237c      	movs	r3, #124	; 0x7c\n",
  " 284:	237e      	movs	r3, #126	; 0x7e\n",
  " 286:	2380      	movs	r3, #128	; 0x80\n",
  " 288:	2382      	movs	r3, #130	; 0x82\n",
  " 28a:	2384      	movs	r3, #132	; 0x84\n",
  " 28c:	2386      	movs	r3, #134	; 0x86\n",
  " 28e:	2388      	movs	r3, #136	; 0x88\n",
  " 290:	238a      	movs	r3, #138	; 0x8a\n",
  " 292:	238c      	movs	r3, #140	; 0x8c\n",
  " 294:	238e      	movs	r3, #142	; 0x8e\n",
  " 296:	2390      	movs	r3, #144	; 0x90\n",
  " 298:	2392      	movs	r3, #146	; 0x92\n",
  " 29a:	2394      	movs	r3, #148	; 0x94\n",
  " 29c:	2396      	movs	r3, #150	; 0x96\n",
  " 29e:	2398      	movs	r3, #152	; 0x98\n",
  " 2a0:	239a      	movs	r3, #154	; 0x9a\n",
  " 2a2:	239c      	movs	r3, #156	; 0x9c\n",
  " 2a4:	239e      	movs	r3, #158	; 0x9e\n",
  " 2a6:	23a0      	movs	r3, #160	; 0xa0\n",
  " 2a8:	23a2      	movs	r3, #162	; 0xa2\n",
  " 2aa:	23a4      	movs	r3, #164	; 0xa4\n",
  " 2ac:	23a6      	movs	r3, #166	; 0xa6\n",
  " 2ae:	23a8      	movs	r3, #168	; 0xa8\n",
  " 2b0:	23aa      	movs	r3, #170	; 0xaa\n",
  " 2b2:	23ac      	movs	r3, #172	; 0xac\n",
  " 2b4:	23ae      	movs	r3, #174	; 0xae\n",
  " 2b6:	23b0      	movs	r3, #176	; 0xb0\n",
  " 2b8:	23b2      	movs	r3, #178	; 0xb2\n",
  " 2ba:	23b4      	movs	r3, #180	; 0xb4\n",
  " 2bc:	23b6      	movs	r3, #182	; 0xb6\n",
  " 2be:	23b8      	movs	r3, #184	; 0xb8\n",
  " 2c0:	23ba      	movs	r3, #186	; 0xba\n",
  " 2c2:	23bc      	movs	r3, #188	; 0xbc\n",
  " 2c4:	23be      	movs	r3, #190	; 0xbe\n",
  " 2c6:	23c0      	movs	r3, #192	; 0xc0\n",
  " 2c8:	23c2      	movs	r3, #194	; 0xc2\n",
  " 2ca:	23c4      	movs	r3, #196	; 0xc4\n",
  " 2cc:	23c6      	movs	r3, #198	; 0xc6\n",
  " 2ce:	23c8      	movs	r3, #200	; 0xc8\n",
  " 2d0:	23ca      	movs	r3, #202	; 0xca\n",
  " 2d2:	23cc      	movs	r3, #204	; 0xcc\n",
  " 2d4:	23ce      	movs	r3, #206	; 0xce\n",
  " 2d6:	23d0      	movs	r3, #208	; 0xd0\n",
  " 2d8:	23d2      	movs	r3, #210	; 0xd2\n",
  " 2da:	23d4      	movs	r3, #212	; 0xd4\n",
  " 2dc:	23d6      	movs	r3, #214	; 0xd6\n",
  " 2de:	23d8      	movs	r3, #216	; 0xd8\n",
  " 2e0:	23da      	movs	r3, #218	; 0xda\n",
  " 2e2:	23dc      	movs	r3, #220	; 0xdc\n",
  " 2e4:	23de      	movs	r3, #222	; 0xde\n",
  " 2e6:	23e0      	movs	r3, #224	; 0xe0\n",
  " 2e8:	23e2      	movs	r3, #226	; 0xe2\n",
  " 2ea:	23e4      	movs	r3, #228	; 0xe4\n",
  " 2ec:	23e6      	movs	r3, #230	; 0xe6\n",
  " 2ee:	23e8      	movs	r3, #232	; 0xe8\n",
  " 2f0:	23ea      	movs	r3, #234	; 0xea\n",
  " 2f2:	23ec      	movs	r3, #236	; 0xec\n",
  " 2f4:	23ee      	movs	r3, #238	; 0xee\n",
  " 2f6:	23f0      	movs	r3, #240	; 0xf0\n",
  " 2f8:	23f2      	movs	r3, #242	; 0xf2\n",
  " 2fa:	23f4      	movs	r3, #244	; 0xf4\n",
  " 2fc:	23f6      	movs	r3, #246	; 0xf6\n",
  " 2fe:	23f8      	movs	r3, #248	; 0xf8\n",
  " 300:	23fa      	movs	r3, #250	; 0xfa\n",
  " 302:	23fc      	movs	r3, #252	; 0xfc\n",
  " 304:	23fe      	movs	r3, #254	; 0xfe\n",
  " 306:	2300      	movs	r3, #0\n",
  " 308:	2302      	movs	r3, #2\n",
  " 30a:	2304      	movs	r3, #4\n",
  " 30c:	2306      	movs	r3, #6\n",
  " 30e:	2308      	movs	r3, #8\n",
  " 310:	230a      	movs	r3, #10\n",
  " 312:	230c      	movs	r3, #12\n",
  " 314:	230e      	movs	r3, #14\n",
  " 316:	2310      	movs	r3, #16\n",
  " 318:	2312      	movs	r3, #18\n",
  " 31a:	2314      	movs	r3, #20\n",
  " 31c:	2316      	movs	r3, #22\n",
  " 31e:	2318      	movs	r3, #24\n",
  " 320:	231a      	movs	r3, #26\n",
  " 322:	231c      	movs	r3, #28\n",
  " 324:	231e      	movs	r3, #30\n",
  " 326:	2320      	movs	r3, #32\n",
  " 328:	2322      	movs	r3, #34	; 0x22\n",
  " 32a:	2324      	movs	r3, #36	; 0x24\n",
  " 32c:	2326      	movs	r3, #38	; 0x26\n",
  " 32e:	2328      	movs	r3, #40	; 0x28\n",
  " 330:	232a      	movs	r3, #42	; 0x2a\n",
  " 332:	232c      	movs	r3, #44	; 0x2c\n",
  " 334:	232e      	movs	r3, #46	; 0x2e\n",
  " 336:	2330      	movs	r3, #48	; 0x30\n",
  " 338:	2332      	movs	r3, #50	; 0x32\n",
  " 33a:	2334      	movs	r3, #52	; 0x34\n",
  " 33c:	2336      	movs	r3, #54	; 0x36\n",
  " 33e:	2338      	movs	r3, #56	; 0x38\n",
  " 340:	233a      	movs	r3, #58	; 0x3a\n",
  " 342:	233c      	movs	r3, #60	; 0x3c\n",
  " 344:	233e      	movs	r3, #62	; 0x3e\n",
  " 346:	2340      	movs	r3, #64	; 0x40\n",
  " 348:	2342      	movs	r3, #66	; 0x42\n",
  " 34a:	2344      	movs	r3, #68	; 0x44\n",
  " 34c:	2346      	movs	r3, #70	; 0x46\n",
  " 34e:	2348      	movs	r3, #72	; 0x48\n",
  " 350:	234a      	movs	r3, #74	; 0x4a\n",
  " 352:	234c      	movs	r3, #76	; 0x4c\n",
  " 354:	234e      	movs	r3, #78	; 0x4e\n",
  " 356:	2350      	movs	r3, #80	; 0x50\n",
  " 358:	2352      	movs	r3, #82	; 0x52\n",
  " 35a:	2354      	movs	r3, #84	; 0x54\n",
  " 35c:	2356      	movs	r3, #86	; 0x56\n",
  " 35e:	2358      	movs	r3, #88	; 0x58\n",
  " 360:	235a      	movs	r3, #90	; 0x5a\n",
  " 362:	235c      	movs	r3, #92	; 0x5c\n",
  " 364:	235e      	movs	r3, #94	; 0x5e\n",
  " 366:	2360      	movs	r3, #96	; 0x60\n",
  " 368:	2362      	movs	r3, #98	; 0x62\n",
  " 36a:	2364      	movs	r3, #100	; 0x64\n",
  " 36c:	2366      	movs	r3, #102	; 0x66\n",
  " 36e:	2368      	movs	r3, #104	; 0x68\n",
  " 370:	236a      	movs	r3, #106	; 0x6a\n",
  " 372:	236c      	movs	r3, #108	; 0x6c\n",
  " 374:	236e      	movs	r3, #110	; 0x6e\n",
  " 376:	2370      	movs	r3, #112	; 0x70\n",
  " 378:	2372      	movs	r3, #114	; 0x72\n",
  " 37a:	2374      	movs	r3, #116	; 0x74\n",
  " 37c:	2376      	movs	r3, #118	; 0x76\n",
  " 37e:	2378      	movs	r3, #120	; 0x78\n",
  " 380:	237a      	movs	r3, #122	; 0x7a\n",
  " 382:	237c      	movs	r3, #124	; 0x7c\n",
  " 384:	237e      	movs	r3, #126	; 0x7e\n",
  " 386:	2380      	movs	r3, #128	; 0x80\n",
  " 388:	2382      	movs	r3, #130	; 0x82\n",
  " 38a:	2384      	movs	r3, #132	; 0x84\n",
  " 38c:	2386      	movs	r3, #134	; 0x86\n",
  " 38e:	2388      	movs	r3, #136	; 0x88\n",
  " 390:	238a      	movs	r3, #138	; 0x8a\n",
  " 392:	238c      	movs	r3, #140	; 0x8c\n",
  " 394:	238e      	movs	r3, #142	; 0x8e\n",
  " 396:	2390      	movs	r3, #144	; 0x90\n",
  " 398:	2392      	movs	r3, #146	; 0x92\n",
  " 39a:	2394      	movs	r3, #148	; 0x94\n",
  " 39c:	2396      	movs	r3, #150	; 0x96\n",
  " 39e:	2398      	movs	r3, #152	; 0x98\n",
  " 3a0:	239a      	movs	r3, #154	; 0x9a\n",
  " 3a2:	239c      	movs	r3, #156	; 0x9c\n",
  " 3a4:	239e      	movs	r3, #158	; 0x9e\n",
  " 3a6:	23a0      	movs	r3, #160	; 0xa0\n",
  " 3a8:	23a2      	movs	r3, #162	; 0xa2\n",
  " 3aa:	23a4      	movs	r3, #164	; 0xa4\n",
  " 3ac:	23a6      	movs	r3, #166	; 0xa6\n",
  " 3ae:	23a8      	movs	r3, #168	; 0xa8\n",
  " 3b0:	23aa      	movs	r3, #170	; 0xaa\n",
  " 3b2:	23ac      	movs	r3, #172	; 0xac\n",
  " 3b4:	23ae      	movs	r3, #174	; 0xae\n",
  " 3b6:	23b0      	movs	r3, #176	; 0xb0\n",
  " 3b8:	23b2      	movs	r3, #178	; 0xb2\n",
  " 3ba:	23b4      	movs	r3, #180	; 0xb4\n",
  " 3bc:	23b6      	movs	r3, #182	; 0xb6\n",
  " 3be:	23b8      	movs	r3, #184	; 0xb8\n",
  " 3c0:	23ba      	movs	r3, #186	; 0xba\n",
  " 3c2:	23bc      	movs	r3, #188	; 0xbc\n",
  " 3c4:	23be      	movs	r3, #190	; 0xbe\n",
  " 3c6:	23c0      	movs	r3, #192	; 0xc0\n",
  " 3c8:	23c2      	movs	r3, #194	; 0xc2\n",
  " 3ca:	23c4      	movs	r3, #196	; 0xc4\n",
  " 3cc:	23c6      	movs	r3, #198	; 0xc6\n",
  " 3ce:	23c8      	movs	r3, #200	; 0xc8\n",
  " 3d0:	23ca      	movs	r3, #202	; 0xca\n",
  " 3d2:	23cc      	movs	r3, #204	; 0xcc\n",
  " 3d4:	23ce      	movs	r3, #206	; 0xce\n",
  " 3d6:	23d0      	movs	r3, #208	; 0xd0\n",
  " 3d8:	23d2      	movs	r3, #210	; 0xd2\n",
  " 3da:	23d4      	movs	r3, #212	; 0xd4\n",
  " 3dc:	23d6      	movs	r3, #214	; 0xd6\n",
  " 3de:	23d8      	movs	r3, #216	; 0xd8\n",
  " 3e0:	23da      	movs	r3, #218	; 0xda\n",
  " 3e2:	23dc      	movs	r3, #220	; 0xdc\n",
  " 3e4:	23de      	movs	r3, #222	; 0xde\n",
  " 3e6:	23e0      	movs	r3, #224	; 0xe0\n",
  " 3e8:	23e2      	movs	r3, #226	; 0xe2\n",
  " 3ea:	23e4      	movs	r3, #228	; 0xe4\n",
  " 3ec:	23e6      	movs	r3, #230	; 0xe6\n",
  " 3ee:	23e8      	movs	r3, #232	; 0xe8\n",
  " 3f0:	23ea      	movs	r3, #234	; 0xea\n",
  " 3f2:	23ec      	movs	r3, #236	; 0xec\n",
  " 3f4:	23ee      	movs	r3, #238	; 0xee\n",
  " 3f6:	23f0      	movs	r3, #240	; 0xf0\n",
  " 3f8:	23f2      	movs	r3, #242	; 0xf2\n",
  " 3fa:	23f4      	movs	r3, #244	; 0xf4\n",
  " 3fc:	23f6      	movs	r3, #246	; 0xf6\n",
  " 3fe:	23f8      	movs	r3, #248	; 0xf8\n",
  " 400:	23fa      	movs	r3, #250	; 0xfa\n",
  " 402:	23fc      	movs	r3, #252	; 0xfc\n",
  " 404:	23fe      	movs	r3, #254	; 0xfe\n",
  " 406:	2300      	movs	r3, #0\n",
  " 408:	2302      	movs	r3, #2\n",
  " 40a:	2304      	movs	r3, #4\n",
  " 40c:	2306      	movs	r3, #6\n",
  " 40e:	2308      	movs	r3, #8\n",
  " 410:	230a      	movs	r3, #10\n",
  " 412:	230c      	movs	r3, #12\n",
  " 414:	230e      	movs	r3, #14\n",
  " 416:	2310      	movs	r3, #16\n",
  " 418:	2312      	movs	r3, #18\n",
  " 41a:	2314      	movs	r3, #20\n",
  " 41c:	2316      	movs	r3, #22\n",
  " 41e:	2318      	movs	r3, #24\n",
  " 420:	231a      	movs	r3, #26\n",
  " 422:	231c      	movs	r3, #28\n",
  " 424:	231e      	movs	r3, #30\n",
  " 426:	2320      	movs	r3, #32\n",
  " 428:	2322      	movs	r3, #34	; 0x22\n",
  " 42a:	2324      	movs	r3, #36	; 0x24\n",
  " 42c:	2326      	movs	r3, #38	; 0x26\n",
  " 42e:	2328      	movs	r3, #40	; 0x28\n",
  " 430:	232a      	movs	r3, #42	; 0x2a\n",
  " 432:	232c      	movs	r3, #44	; 0x2c\n",
  " 434:	232e      	movs	r3, #46	; 0x2e\n",
  " 436:	2330      	movs	r3, #48	; 0x30\n",
  " 438:	2332      	movs	r3, #50	; 0x32\n",
  " 43a:	2334      	movs	r3, #52	; 0x34\n",
  " 43c:	2336      	movs	r3, #54	; 0x36\n",
  " 43e:	2338      	movs	r3, #56	; 0x38\n",
  " 440:	233a      	movs	r3, #58	; 0x3a\n",
  " 442:	233c      	movs	r3, #60	; 0x3c\n",
  " 444:	233e      	movs	r3, #62	; 0x3e\n",
  " 446:	2340      	movs	r3, #64	; 0x40\n",
  " 448:	2342      	movs	r3, #66	; 0x42\n",
  " 44a:	2344      	movs	r3, #68	; 0x44\n",
  " 44c:	2346      	movs	r3, #70	; 0x46\n",
  " 44e:	2348      	movs	r3, #72	; 0x48\n",
  " 450:	234a      	movs	r3, #74	; 0x4a\n",
  " 452:	234c      	movs	r3, #76	; 0x4c\n",
  " 454:	234e      	movs	r3, #78	; 0x4e\n",
  " 456:	2350      	movs	r3, #80	; 0x50\n",
  " 458:	2352      	movs	r3, #82	; 0x52\n",
  " 45a:	2354      	movs	r3, #84	; 0x54\n",
  " 45c:	2356      	movs	r3, #86	; 0x56\n",
  " 45e:	2358      	movs	r3, #88	; 0x58\n",
  " 460:	235a      	movs	r3, #90	; 0x5a\n",
  " 462:	235c      	movs	r3, #92	; 0x5c\n",
  " 464:	235e      	movs	r3, #94	; 0x5e\n",
  " 466:	2360      	movs	r3, #96	; 0x60\n",
  " 468:	2362      	movs	r3, #98	; 0x62\n",
  " 46a:	2364      	movs	r3, #100	; 0x64\n",
  " 46c:	2366      	movs	r3, #102	; 0x66\n",
  " 46e:	2368      	movs	r3, #104	; 0x68\n",
  " 470:	236a      	movs	r3, #106	; 0x6a\n",
  " 472:	236c      	movs	r3, #108	; 0x6c\n",
  " 474:	236e      	movs	r3, #110	; 0x6e\n",
  " 476:	2370      	movs	r3, #112	; 0x70\n",
  " 478:	2372      	movs	r3, #114	; 0x72\n",
  " 47a:	2374      	movs	r3, #116	; 0x74\n",
  " 47c:	2376      	movs	r3, #118	; 0x76\n",
  " 47e:	2378      	movs	r3, #120	; 0x78\n",
  " 480:	237a      	movs	r3, #122	; 0x7a\n",
  " 482:	237c      	movs	r3, #124	; 0x7c\n",
  " 484:	237e      	movs	r3, #126	; 0x7e\n",
  " 486:	2380      	movs	r3, #128	; 0x80\n",
  " 488:	2382      	movs	r3, #130	; 0x82\n",
  " 48a:	2384      	movs	r3, #132	; 0x84\n",
  " 48c:	2386      	movs	r3, #134	; 0x86\n",
  " 48e:	2388      	movs	r3, #136	; 0x88\n",
  " 490:	238a      	movs	r3, #138	; 0x8a\n",
  " 492:	238c      	movs	r3, #140	; 0x8c\n",
  " 494:	238e      	movs	r3, #142	; 0x8e\n",
  " 496:	2390      	movs	r3, #144	; 0x90\n",
  " 498:	2392      	movs	r3, #146	; 0x92\n",
  " 49a:	2394      	movs	r3, #148	; 0x94\n",
  " 49c:	2396      	movs	r3, #150	; 0x96\n",
  " 49e:	2398      	movs	r3, #152	; 0x98\n",
  " 4a0:	239a      	movs	r3, #154	; 0x9a\n",
  " 4a2:	239c      	movs	r3, #156	; 0x9c\n",
  " 4a4:	239e      	movs	r3, #158	; 0x9e\n",
  " 4a6:	23a0      	movs	r3, #160	; 0xa0\n",
  " 4a8:	23a2      	movs	r3, #162	; 0xa2\n",
  " 4aa:	23a4      	movs	r3, #164	; 0xa4\n",
  " 4ac:	23a6      	movs	r3, #166	; 0xa6\n",
  " 4ae:	23a8      	movs	r3, #168	; 0xa8\n",
  " 4b0:	23aa      	movs	r3, #170	; 0xaa\n",
  " 4b2:	23ac      	movs	r3, #172	; 0xac\n",
  " 4b4:	23ae      	movs	r3, #174	; 0xae\n",
  " 4b6:	23b0      	movs	r3, #176	; 0xb0\n",
  " 4b8:	23b2      	movs	r3, #178	; 0xb2\n",
  " 4ba:	23b4      	movs	r3, #180	; 0xb4\n",
  " 4bc:	23b6      	movs	r3, #182	; 0xb6\n",
  " 4be:	23b8      	movs	r3, #184	; 0xb8\n",
  " 4c0:	23ba      	movs	r3, #186	; 0xba\n",
  " 4c2:	23bc      	movs	r3, #188	; 0xbc\n",
  " 4c4:	23be      	movs	r3, #190	; 0xbe\n",
  " 4c6:	23c0      	movs	r3, #192	; 0xc0\n",
  " 4c8:	23c2      	movs	r3, #194	; 0xc2\n",
  " 4ca:	23c4      	movs	r3, #196	; 0xc4\n",
  " 4cc:	23c6      	movs	r3, #198	; 0xc6\n",
  " 4ce:	23c8      	movs	r3, #200	; 0xc8\n",
  " 4d0:	23ca      	movs	r3, #202	; 0xca\n",
  " 4d2:	23cc      	movs	r3, #204	; 0xcc\n",
  " 4d4:	23ce      	movs	r3, #206	; 0xce\n",
  " 4d6:	23d0      	movs	r3, #208	; 0xd0\n",
  " 4d8:	23d2      	movs	r3, #210	; 0xd2\n",
  " 4da:	23d4      	movs	r3, #212	; 0xd4\n",
  " 4dc:	23d6      	movs	r3, #214	; 0xd6\n",
  " 4de:	23d8      	movs	r3, #216	; 0xd8\n",
  " 4e0:	23da      	movs	r3, #218	; 0xda\n",
  " 4e2:	23dc      	movs	r3, #220	; 0xdc\n",
  " 4e4:	23de      	movs	r3, #222	; 0xde\n",
  " 4e6:	23e0      	movs	r3, #224	; 0xe0\n",
  " 4e8:	23e2      	movs	r3, #226	; 0xe2\n",
  " 4ea:	23e4      	movs	r3, #228	; 0xe4\n",
  " 4ec:	23e6      	movs	r3, #230	; 0xe6\n",
  " 4ee:	23e8      	movs	r3, #232	; 0xe8\n",
  " 4f0:	23ea      	movs	r3, #234	; 0xea\n",
  " 4f2:	23ec      	movs	r3, #236	; 0xec\n",
  " 4f4:	23ee      	movs	r3, #238	; 0xee\n",
  " 4f6:	23f0      	movs	r3, #240	; 0xf0\n",
  " 4f8:	23f2      	movs	r3, #242	; 0xf2\n",
  " 4fa:	23f4      	movs	r3, #244	; 0xf4\n",
  " 4fc:	23f6      	movs	r3, #246	; 0xf6\n",
  " 4fe:	23f8      	movs	r3, #248	; 0xf8\n",
  " 500:	23fa      	movs	r3, #250	; 0xfa\n",
  " 502:	23fc      	movs	r3, #252	; 0xfc\n",
  " 504:	23fe      	movs	r3, #254	; 0xfe\n",
  " 506:	2300      	movs	r3, #0\n",
  " 508:	2302      	movs	r3, #2\n",
  " 50a:	2304      	movs	r3, #4\n",
  " 50c:	2306      	movs	r3, #6\n",
  " 50e:	2308      	movs	r3, #8\n",
  " 510:	230a      	movs	r3, #10\n",
  " 512:	230c      	movs	r3, #12\n",
  " 514:	230e      	movs	r3, #14\n",
  " 516:	2310      	movs	r3, #16\n",
  " 518:	2312      	movs	r3, #18\n",
  " 51a:	2314      	movs	r3, #20\n",
  " 51c:	2316      	movs	r3, #22\n",
  " 51e:	2318      	movs	r3, #24\n",
  " 520:	231a      	movs	r3, #26\n",
  " 522:	231c      	movs	r3, #28\n",
  " 524:	231e      	movs	r3, #30\n",
  " 526:	2320      	movs	r3, #32\n",
  " 528:	2322      	movs	r3, #34	; 0x22\n",
  " 52a:	2324      	movs	r3, #36	; 0x24\n",
  " 52c:	2326      	movs	r3, #38	; 0x26\n",
  " 52e:	2328      	movs	r3, #40	; 0x28\n",
  " 530:	232a      	movs	r3, #42	; 0x2a\n",
  " 532:	232c      	movs	r3, #44	; 0x2c\n",
  " 534:	232e      	movs	r3, #46	; 0x2e\n",
  " 536:	2330      	movs	r3, #48	; 0x30\n",
  " 538:	2332      	movs	r3, #50	; 0x32\n",
  " 53a:	2334      	movs	r3, #52	; 0x34\n",
  " 53c:	2336      	movs	r3, #54	; 0x36\n",
  " 53e:	2338      	movs	r3, #56	; 0x38\n",
  " 540:	233a      	movs	r3, #58	; 0x3a\n",
  " 542:	233c      	movs	r3, #60	; 0x3c\n",
  " 544:	233e      	movs	r3, #62	; 0x3e\n",
  " 546:	2340      	movs	r3, #64	; 0x40\n",
  " 548:	2342      	movs	r3, #66	; 0x42\n",
  " 54a:	2344      	movs	r3, #68	; 0x44\n",
  " 54c:	2346      	movs	r3, #70	; 0x46\n",
  " 54e:	2348      	movs	r3, #72	; 0x48\n",
  " 550:	234a      	movs	r3, #74	; 0x4a\n",
  " 552:	234c      	movs	r3, #76	; 0x4c\n",
  " 554:	234e      	movs	r3, #78	; 0x4e\n",
  " 556:	2350      	movs	r3, #80	; 0x50\n",
  " 558:	2352      	movs	r3, #82	; 0x52\n",
  " 55a:	2354      	movs	r3, #84	; 0x54\n",
  " 55c:	2356      	movs	r3, #86	; 0x56\n",
  " 55e:	2358      	movs	r3, #88	; 0x58\n",
  " 560:	235a      	movs	r3, #90	; 0x5a\n",
  " 562:	235c      	movs	r3, #92	; 0x5c\n",
  " 564:	235e      	movs	r3, #94	; 0x5e\n",
  " 566:	2360      	movs	r3, #96	; 0x60\n",
  " 568:	2362      	movs	r3, #98	; 0x62\n",
  " 56a:	2364      	movs	r3, #100	; 0x64\n",
  " 56c:	2366      	movs	r3, #102	; 0x66\n",
  " 56e:	2368      	movs	r3, #104	; 0x68\n",
  " 570:	236a      	movs	r3, #106	; 0x6a\n",
  " 572:	236c      	movs	r3, #108	; 0x6c\n",
  " 574:	236e      	movs	r3, #110	; 0x6e\n",
  " 576:	2370      	movs	r3, #112	; 0x70\n",
  " 578:	2372      	movs	r3, #114	; 0x72\n",
  " 57a:	2374      	movs	r3, #116	; 0x74\n",
  " 57c:	2376      	movs	r3, #118	; 0x76\n",
  " 57e:	2378      	movs	r3, #120	; 0x78\n",
  " 580:	237a      	movs	r3, #122	; 0x7a\n",
  " 582:	237c      	movs	r3, #124	; 0x7c\n",
  " 584:	237e      	movs	r3, #126	; 0x7e\n",
  " 586:	2380      	movs	r3, #128	; 0x80\n",
  " 588:	2382      	movs	r3, #130	; 0x82\n",
  " 58a:	2384      	movs	r3, #132	; 0x84\n",
  " 58c:	2386      	movs	r3, #134	; 0x86\n",
  " 58e:	2388      	movs	r3, #136	; 0x88\n",
  " 590:	238a      	movs	r3, #138	; 0x8a\n",
  " 592:	238c      	movs	r3, #140	; 0x8c\n",
  " 594:	238e      	movs	r3, #142	; 0x8e\n",
  " 596:	2390      	movs	r3, #144	; 0x90\n",
  " 598:	2392      	movs	r3, #146	; 0x92\n",
  " 59a:	2394      	movs	r3, #148	; 0x94\n",
  " 59c:	2396      	movs	r3, #150	; 0x96\n",
  " 59e:	2398      	movs	r3, #152	; 0x98\n",
  " 5a0:	239a      	movs	r3, #154	; 0x9a\n",
  " 5a2:	239c      	movs	r3, #156	; 0x9c\n",
  " 5a4:	239e      	movs	r3, #158	; 0x9e\n",
  " 5a6:	23a0      	movs	r3, #160	; 0xa0\n",
  " 5a8:	23a2      	movs	r3, #162	; 0xa2\n",
  " 5aa:	23a4      	movs	r3, #164	; 0xa4\n",
  " 5ac:	23a6      	movs	r3, #166	; 0xa6\n",
  " 5ae:	23a8      	movs	r3, #168	; 0xa8\n",
  " 5b0:	23aa      	movs	r3, #170	; 0xaa\n",
  " 5b2:	23ac      	movs	r3, #172	; 0xac\n",
  " 5b4:	23ae      	movs	r3, #174	; 0xae\n",
  " 5b6:	23b0      	movs	r3, #176	; 0xb0\n",
  " 5b8:	23b2      	movs	r3, #178	; 0xb2\n",
  " 5ba:	23b4      	movs	r3, #180	; 0xb4\n",
  " 5bc:	23b6      	movs	r3, #182	; 0xb6\n",
  " 5be:	23b8      	movs	r3, #184	; 0xb8\n",
  " 5c0:	23ba      	movs	r3, #186	; 0xba\n",
  " 5c2:	23bc      	movs	r3, #188	; 0xbc\n",
  " 5c4:	23be      	movs	r3, #190	; 0xbe\n",
  " 5c6:	23c0      	movs	r3, #192	; 0xc0\n",
  " 5c8:	23c2      	movs	r3, #194	; 0xc2\n",
  " 5ca:	23c4      	movs	r3, #196	; 0xc4\n",
  " 5cc:	23c6      	movs	r3, #198	; 0xc6\n",
  " 5ce:	23c8      	movs	r3, #200	; 0xc8\n",
  " 5d0:	23ca      	movs	r3, #202	; 0xca\n",
  " 5d2:	23cc      	movs	r3, #204	; 0xcc\n",
  " 5d4:	23ce      	movs	r3, #206	; 0xce\n",
  " 5d6:	23d0      	movs	r3, #208	; 0xd0\n",
  " 5d8:	23d2      	movs	r3, #210	; 0xd2\n",
  " 5da:	23d4      	movs	r3, #212	; 0xd4\n",
  " 5dc:	23d6      	movs	r3, #214	; 0xd6\n",
  " 5de:	23d8      	movs	r3, #216	; 0xd8\n",
  " 5e0:	23da      	movs	r3, #218	; 0xda\n",
  " 5e2:	23dc      	movs	r3, #220	; 0xdc\n",
  " 5e4:	23de      	movs	r3, #222	; 0xde\n",
  " 5e6:	23e0      	movs	r3, #224	; 0xe0\n",
  " 5e8:	23e2      	movs	r3, #226	; 0xe2\n",
  " 5ea:	23e4      	movs	r3, #228	; 0xe4\n",
  " 5ec:	23e6      	movs	r3, #230	; 0xe6\n",
  " 5ee:	23e8      	movs	r3, #232	; 0xe8\n",
  " 5f0:	23ea      	movs	r3, #234	; 0xea\n",
  " 5f2:	23ec      	movs	r3, #236	; 0xec\n",
  " 5f4:	23ee      	movs	r3, #238	; 0xee\n",
  " 5f6:	23f0      	movs	r3, #240	; 0xf0\n",
  " 5f8:	23f2      	movs	r3, #242	; 0xf2\n",
  " 5fa:	23f4      	movs	r3, #244	; 0xf4\n",
  " 5fc:	23f6      	movs	r3, #246	; 0xf6\n",
  " 5fe:	23f8      	movs	r3, #248	; 0xf8\n",
  " 600:	23fa      	movs	r3, #250	; 0xfa\n",
  " 602:	23fc      	movs	r3, #252	; 0xfc\n",
  " 604:	23fe      	movs	r3, #254	; 0xfe\n",
  " 606:	2300      	movs	r3, #0\n",
  " 608:	2302      	movs	r3, #2\n",
  " 60a:	2304      	movs	r3, #4\n",
  " 60c:	2306      	movs	r3, #6\n",
  " 60e:	2308      	movs	r3, #8\n",
  " 610:	230a      	movs	r3, #10\n",
  " 612:	230c      	movs	r3, #12\n",
  " 614:	230e      	movs	r3, #14\n",
  " 616:	2310      	movs	r3, #16\n",
  " 618:	2312      	movs	r3, #18\n",
  " 61a:	2314      	movs	r3, #20\n",
  " 61c:	2316      	movs	r3, #22\n",
  " 61e:	2318      	movs	r3, #24\n",
  " 620:	231a      	movs	r3, #26\n",
  " 622:	231c      	movs	r3, #28\n",
  " 624:	231e      	movs	r3, #30\n",
  " 626:	2320      	movs	r3, #32\n",
  " 628:	2322      	movs	r3, #34	; 0x22\n",
  " 62a:	2324      	movs	r3, #36	; 0x24\n",
  " 62c:	2326      	movs	r3, #38	; 0x26\n",
  " 62e:	2328      	movs	r3, #40	; 0x28\n",
  " 630:	232a      	movs	r3, #42	; 0x2a\n",
  " 632:	232c      	movs	r3, #44	; 0x2c\n",
  " 634:	232e      	movs	r3, #46	; 0x2e\n",
  " 636:	2330      	movs	r3, #48	; 0x30\n",
  " 638:	2332      	movs	r3, #50	; 0x32\n",
  " 63a:	2334      	movs	r3, #52	; 0x34\n",
  " 63c:	2336      	movs	r3, #54	; 0x36\n",
  " 63e:	2338      	movs	r3, #56	; 0x38\n",
  " 640:	233a      	movs	r3, #58	; 0x3a\n",
  " 642:	233c      	movs	r3, #60	; 0x3c\n",
  " 644:	233e      	movs	r3, #62	; 0x3e\n",
  " 646:	2340      	movs	r3, #64	; 0x40\n",
  " 648:	2342      	movs	r3, #66	; 0x42\n",
  " 64a:	2344      	movs	r3, #68	; 0x44\n",
  " 64c:	2346      	movs	r3, #70	; 0x46\n",
  " 64e:	2348      	movs	r3, #72	; 0x48\n",
  " 650:	234a      	movs	r3, #74	; 0x4a\n",
  " 652:	234c      	movs	r3, #76	; 0x4c\n",
  " 654:	234e      	movs	r3, #78	; 0x4e\n",
  " 656:	2350      	movs	r3, #80	; 0x50\n",
  " 658:	2352      	movs	r3, #82	; 0x52\n",
  " 65a:	2354      	movs	r3, #84	; 0x54\n",
  " 65c:	2356      	movs	r3, #86	; 0x56\n",
  " 65e:	2358      	movs	r3, #88	; 0x58\n",
  " 660:	235a      	movs	r3, #90	; 0x5a\n",
  " 662:	235c      	movs	r3, #92	; 0x5c\n",
  " 664:	235e      	movs	r3, #94	; 0x5e\n",
  " 666:	2360      	movs	r3, #96	; 0x60\n",
  " 668:	2362      	movs	r3, #98	; 0x62\n",
  " 66a:	2364      	movs	r3, #100	; 0x64\n",
  " 66c:	2366      	movs	r3, #102	; 0x66\n",
  " 66e:	2368      	movs	r3, #104	; 0x68\n",
  " 670:	236a      	movs	r3, #106	; 0x6a\n",
  " 672:	236c      	movs	r3, #108	; 0x6c\n",
  " 674:	236e      	movs	r3, #110	; 0x6e\n",
  " 676:	2370      	movs	r3, #112	; 0x70\n",
  " 678:	2372      	movs	r3, #114	; 0x72\n",
  " 67a:	2374      	movs	r3, #116	; 0x74\n",
  " 67c:	2376      	movs	r3, #118	; 0x76\n",
  " 67e:	2378      	movs	r3, #120	; 0x78\n",
  " 680:	237a      	movs	r3, #122	; 0x7a\n",
  " 682:	237c      	movs	r3, #124	; 0x7c\n",
  " 684:	237e      	movs	r3, #126	; 0x7e\n",
  " 686:	2380      	movs	r3, #128	; 0x80\n",
  " 688:	2382      	movs	r3, #130	; 0x82\n",
  " 68a:	2384      	movs	r3, #132	; 0x84\n",
  " 68c:	2386      	movs	r3, #134	; 0x86\n",
  " 68e:	2388      	movs	r3, #136	; 0x88\n",
  " 690:	238a      	movs	r3, #138	; 0x8a\n",
  " 692:	238c      	movs	r3, #140	; 0x8c\n",
  " 694:	238e      	movs	r3, #142	; 0x8e\n",
  " 696:	2390      	movs	r3, #144	; 0x90\n",
  " 698:	2392      	movs	r3, #146	; 0x92\n",
  " 69a:	2394      	movs	r3, #148	; 0x94\n",
  " 69c:	2396      	movs	r3, #150	; 0x96\n",
  " 69e:	2398      	movs	r3, #152	; 0x98\n",
  " 6a0:	239a      	movs	r3, #154	; 0x9a\n",
  " 6a2:	239c      	movs	r3, #156	; 0x9c\n",
  " 6a4:	239e      	movs	r3, #158	; 0x9e\n",
  " 6a6:	23a0      	movs	r3, #160	; 0xa0\n",
  " 6a8:	23a2      	movs	r3, #162	; 0xa2\n",
  " 6aa:	23a4      	movs	r3, #164	; 0xa4\n",
  " 6ac:	23a6      	movs	r3, #166	; 0xa6\n",
  " 6ae:	23a8      	movs	r3, #168	; 0xa8\n",
  " 6b0:	23aa      	movs	r3, #170	; 0xaa\n",
  " 6b2:	23ac      	movs	r3, #172	; 0xac\n",
  " 6b4:	23ae      	movs	r3, #174	; 0xae\n",
  " 6b6:	23b0      	movs	r3, #176	; 0xb0\n",
  " 6b8:	23b2      	movs	r3, #178	; 0xb2\n",
  " 6ba:	23b4      	movs	r3, #180	; 0xb4\n",
  " 6bc:	23b6      	movs	r3, #182	; 0xb6\n",
  " 6be:	23b8      	movs	r3, #184	; 0xb8\n",
  " 6c0:	23ba      	movs	r3, #186	; 0xba\n",
  " 6c2:	23bc      	movs	r3, #188	; 0xbc\n",
  " 6c4:	23be      	movs	r3, #190	; 0xbe\n",
  " 6c6:	23c0      	movs	r3, #192	; 0xc0\n",
  " 6c8:	23c2      	movs	r3, #194	; 0xc2\n",
  " 6ca:	23c4      	movs	r3, #196	; 0xc4\n",
  " 6cc:	23c6      	movs	r3, #198	; 0xc6\n",
  " 6ce:	23c8      	movs	r3, #200	; 0xc8\n",
  " 6d0:	23ca      	movs	r3, #202	; 0xca\n",
  " 6d2:	23cc      	movs	r3, #204	; 0xcc\n",
  " 6d4:	23ce      	movs	r3, #206	; 0xce\n",
  " 6d6:	23d0      	movs	r3, #208	; 0xd0\n",
  " 6d8:	23d2      	movs	r3, #210	; 0xd2\n",
  " 6da:	23d4      	movs	r3, #212	; 0xd4\n",
  " 6dc:	23d6      	movs	r3, #214	; 0xd6\n",
  " 6de:	23d8      	movs	r3, #216	; 0xd8\n",
  " 6e0:	23da      	movs	r3, #218	; 0xda\n",
  " 6e2:	23dc      	movs	r3, #220	; 0xdc\n",
  " 6e4:	23de      	movs	r3, #222	; 0xde\n",
  " 6e6:	23e0      	movs	r3, #224	; 0xe0\n",
  " 6e8:	23e2      	movs	r3, #226	; 0xe2\n",
  " 6ea:	23e4      	movs	r3, #228	; 0xe4\n",
  " 6ec:	23e6      	movs	r3, #230	; 0xe6\n",
  " 6ee:	23e8      	movs	r3, #232	; 0xe8\n",
  " 6f0:	23ea      	movs	r3, #234	; 0xea\n",
  " 6f2:	23ec      	movs	r3, #236	; 0xec\n",
  " 6f4:	23ee      	movs	r3, #238	; 0xee\n",
  " 6f6:	23f0      	movs	r3, #240	; 0xf0\n",
  " 6f8:	23f2      	movs	r3, #242	; 0xf2\n",
  " 6fa:	23f4      	movs	r3, #244	; 0xf4\n",
  " 6fc:	23f6      	movs	r3, #246	; 0xf6\n",
  " 6fe:	23f8      	movs	r3, #248	; 0xf8\n",
  " 700:	23fa      	movs	r3, #250	; 0xfa\n",
  " 702:	23fc      	movs	r3, #252	; 0xfc\n",
  " 704:	23fe      	movs	r3, #254	; 0xfe\n",
  " 706:	2300      	movs	r3, #0\n",
  " 708:	2302      	movs	r3, #2\n",
  " 70a:	2304      	movs	r3, #4\n",
  " 70c:	2306      	movs	r3, #6\n",
  " 70e:	2308      	movs	r3, #8\n",
  " 710:	230a      	movs	r3, #10\n",
  " 712:	230c      	movs	r3, #12\n",
  " 714:	230e      	movs	r3, #14\n",
  " 716:	2310      	movs	r3, #16\n",
  " 718:	2312      	movs	r3, #18\n",
  " 71a:	2314      	movs	r3, #20\n",
  " 71c:	2316      	movs	r3, #22\n",
  " 71e:	2318      	movs	r3, #24\n",
  " 720:	231a      	movs	r3, #26\n",
  " 722:	231c      	movs	r3, #28\n",
  " 724:	231e      	movs	r3, #30\n",
  " 726:	2320      	movs	r3, #32\n",
  " 728:	2322      	movs	r3, #34	; 0x22\n",
  " 72a:	2324      	movs	r3, #36	; 0x24\n",
  " 72c:	2326      	movs	r3, #38	; 0x26\n",
  " 72e:	2328      	movs	r3, #40	; 0x28\n",
  " 730:	232a      	movs	r3, #42	; 0x2a\n",
  " 732:	232c      	movs	r3, #44	; 0x2c\n",
  " 734:	232e      	movs	r3, #46	; 0x2e\n",
  " 736:	2330      	movs	r3, #48	; 0x30\n",
  " 738:	2332      	movs	r3, #50	; 0x32\n",
  " 73a:	2334      	movs	r3, #52	; 0x34\n",
  " 73c:	2336      	movs	r3, #54	; 0x36\n",
  " 73e:	2338      	movs	r3, #56	; 0x38\n",
  " 740:	233a      	movs	r3, #58	; 0x3a\n",
  " 742:	233c      	movs	r3, #60	; 0x3c\n",
  " 744:	233e      	movs	r3, #62	; 0x3e\n",
  " 746:	2340      	movs	r3, #64	; 0x40\n",
  " 748:	2342      	movs	r3, #66	; 0x42\n",
  " 74a:	2344      	movs	r3, #68	; 0x44\n",
  " 74c:	2346      	movs	r3, #70	; 0x46\n",
  " 74e:	2348      	movs	r3, #72	; 0x48\n",
  " 750:	234a      	movs	r3, #74	; 0x4a\n",
  " 752:	234c      	movs	r3, #76	; 0x4c\n",
  " 754:	234e      	movs	r3, #78	; 0x4e\n",
  " 756:	2350      	movs	r3, #80	; 0x50\n",
  " 758:	2352      	movs	r3, #82	; 0x52\n",
  " 75a:	2354      	movs	r3, #84	; 0x54\n",
  " 75c:	2356      	movs	r3, #86	; 0x56\n",
  " 75e:	2358      	movs	r3, #88	; 0x58\n",
  " 760:	235a      	movs	r3, #90	; 0x5a\n",
  " 762:	235c      	movs	r3, #92	; 0x5c\n",
  " 764:	235e      	movs	r3, #94	; 0x5e\n",
  " 766:	2360      	movs	r3, #96	; 0x60\n",
  " 768:	2362      	movs	r3, #98	; 0x62\n",
  " 76a:	2364      	movs	r3, #100	; 0x64\n",
  " 76c:	2366      	movs	r3, #102	; 0x66\n",
  " 76e:	2368      	movs	r3, #104	; 0x68\n",
  " 770:	236a      	movs	r3, #106	; 0x6a\n",
  " 772:	236c      	movs	r3, #108	; 0x6c\n",
  " 774:	236e      	movs	r3, #110	; 0x6e\n",
  " 776:	2370      	movs	r3, #112	; 0x70\n",
  " 778:	2372      	movs	r3, #114	; 0x72\n",
  " 77a:	2374      	movs	r3, #116	; 0x74\n",
  " 77c:	2376      	movs	r3, #118	; 0x76\n",
  " 77e:	2378      	movs	r3, #120	; 0x78\n",
  " 780:	237a      	movs	r3, #122	; 0x7a\n",
  " 782:	237c      	movs	r3, #124	; 0x7c\n",
  " 784:	237e      	movs	r3, #126	; 0x7e\n",
  " 786:	2380      	movs	r3, #128	; 0x80\n",
  " 788:	2382      	movs	r3, #130	; 0x82\n",
  " 78a:	2384      	movs	r3, #132	; 0x84\n",
  " 78c:	2386      	movs	r3, #134	; 0x86\n",
  " 78e:	2388      	movs	r3, #136	; 0x88\n",
  " 790:	238a      	movs	r3, #138	; 0x8a\n",
  " 792:	238c      	movs	r3, #140	; 0x8c\n",
  " 794:	238e      	movs	r3, #142	; 0x8e\n",
  " 796:	2390      	movs	r3, #144	; 0x90\n",
  " 798:	2392      	movs	r3, #146	; 0x92\n",
  " 79a:	2394      	movs	r3, #148	; 0x94\n",
  " 79c:	2396      	movs	r3, #150	; 0x96\n",
  " 79e:	2398      	movs	r3, #152	; 0x98\n",
  " 7a0:	239a      	movs	r3, #154	; 0x9a\n",
  " 7a2:	239c      	movs	r3, #156	; 0x9c\n",
  " 7a4:	239e      	movs	r3, #158	; 0x9e\n",
  " 7a6:	23a0      	movs	r3, #160	; 0xa0\n",
  " 7a8:	23a2      	movs	r3, #162	; 0xa2\n",
  " 7aa:	23a4      	movs	r3, #164	; 0xa4\n",
  " 7ac:	23a6      	movs	r3, #166	; 0xa6\n",
  " 7ae:	23a8      	movs	r3, #168	; 0xa8\n",
  " 7b0:	23aa      	movs	r3, #170	; 0xaa\n",
  " 7b2:	23ac      	movs	r3, #172	; 0xac\n",
  " 7b4:	23ae      	movs	r3, #174	; 0xae\n",
  " 7b6:	23b0      	movs	r3, #176	; 0xb0\n",
  " 7b8:	23b2      	movs	r3, #178	; 0xb2\n",
  " 7ba:	23b4      	movs	r3, #180	; 0xb4\n",
  " 7bc:	23b6      	movs	r3, #182	; 0xb6\n",
  " 7be:	23b8      	movs	r3, #184	; 0xb8\n",
  " 7c0:	23ba      	movs	r3, #186	; 0xba\n",
  " 7c2:	23bc      	movs	r3, #188	; 0xbc\n",
  " 7c4:	23be      	movs	r3, #190	; 0xbe\n",
  " 7c6:	23c0      	movs	r3, #192	; 0xc0\n",
  " 7c8:	23c2      	movs	r3, #194	; 0xc2\n",
  " 7ca:	23c4      	movs	r3, #196	; 0xc4\n",
  " 7cc:	23c6      	movs	r3, #198	; 0xc6\n",
  " 7ce:	23c8      	movs	r3, #200	; 0xc8\n",
  " 7d0:	23ca      	movs	r3, #202	; 0xca\n",
  " 7d2:	23cc      	movs	r3, #204	; 0xcc\n",
  " 7d4:	23ce      	movs	r3, #206	; 0xce\n",
  " 7d6:	23d0      	movs	r3, #208	; 0xd0\n",
  " 7d8:	23d2      	movs	r3, #210	; 0xd2\n",
  " 7da:	23d4      	movs	r3, #212	; 0xd4\n",
  " 7dc:	23d6      	movs	r3, #214	; 0xd6\n",
  " 7de:	23d8      	movs	r3, #216	; 0xd8\n",
  " 7e0:	23da      	movs	r3, #218	; 0xda\n",
  " 7e2:	23dc      	movs	r3, #220	; 0xdc\n",
  " 7e4:	23de      	movs	r3, #222	; 0xde\n",
  " 7e6:	23e0      	movs	r3, #224	; 0xe0\n",
  " 7e8:	23e2      	movs	r3, #226	; 0xe2\n",
  " 7ea:	23e4      	movs	r3, #228	; 0xe4\n",
  " 7ec:	23e6      	movs	r3, #230	; 0xe6\n",
  " 7ee:	23e8      	movs	r3, #232	; 0xe8\n",
  " 7f0:	23ea      	movs	r3, #234	; 0xea\n",
  " 7f2:	23ec      	movs	r3, #236	; 0xec\n",
  " 7f4:	23ee      	movs	r3, #238	; 0xee\n",
  " 7f6:	23f0      	movs	r3, #240	; 0xf0\n",
  " 7f8:	23f2      	movs	r3, #242	; 0xf2\n",
  " 7fa:	23f4      	movs	r3, #244	; 0xf4\n",
  " 7fc:	23f6      	movs	r3, #246	; 0xf6\n",
  " 7fe:	23f8      	movs	r3, #248	; 0xf8\n",
  " 800:	23fa      	movs	r3, #250	; 0xfa\n",
  " 802:	23fc      	movs	r3, #252	; 0xfc\n",
  " 804:	23fe      	movs	r3, #254	; 0xfe\n",
  " 806:	2300      	movs	r3, #0\n",
  " 808:	4611      	mov	r1, r2\n",
  nullptr
};
const char* MixedBranch32Results[] = {
  "   0:	f000 bc03 	b.w	80a <MixedBranch32+0x80a>\n",
  "   4:	2300      	movs	r3, #0\n",
  "   6:	2302      	movs	r3, #2\n",
  "   8:	2304      	movs	r3, #4\n",
  "   a:	2306      	movs	r3, #6\n",
  "   c:	2308      	movs	r3, #8\n",
  "   e:	230a      	movs	r3, #10\n",
  "  10:	230c      	movs	r3, #12\n",
  "  12:	230e      	movs	r3, #14\n",
  "  14:	2310      	movs	r3, #16\n",
  "  16:	2312      	movs	r3, #18\n",
  "  18:	2314      	movs	r3, #20\n",
  "  1a:	2316      	movs	r3, #22\n",
  "  1c:	2318      	movs	r3, #24\n",
  "  1e:	231a      	movs	r3, #26\n",
  "  20:	231c      	movs	r3, #28\n",
  "  22:	231e      	movs	r3, #30\n",
  "  24:	2320      	movs	r3, #32\n",
  "  26:	2322      	movs	r3, #34	; 0x22\n",
  "  28:	2324      	movs	r3, #36	; 0x24\n",
  "  2a:	2326      	movs	r3, #38	; 0x26\n",
  "  2c:	2328      	movs	r3, #40	; 0x28\n",
  "  2e:	232a      	movs	r3, #42	; 0x2a\n",
  "  30:	232c      	movs	r3, #44	; 0x2c\n",
  "  32:	232e      	movs	r3, #46	; 0x2e\n",
  "  34:	2330      	movs	r3, #48	; 0x30\n",
  "  36:	2332      	movs	r3, #50	; 0x32\n",
  "  38:	2334      	movs	r3, #52	; 0x34\n",
  "  3a:	2336      	movs	r3, #54	; 0x36\n",
  "  3c:	2338      	movs	r3, #56	; 0x38\n",
  "  3e:	233a      	movs	r3, #58	; 0x3a\n",
  "  40:	233c      	movs	r3, #60	; 0x3c\n",
  "  42:	233e      	movs	r3, #62	; 0x3e\n",
  "  44:	2340      	movs	r3, #64	; 0x40\n",
  "  46:	2342      	movs	r3, #66	; 0x42\n",
  "  48:	2344      	movs	r3, #68	; 0x44\n",
  "  4a:	2346      	movs	r3, #70	; 0x46\n",
  "  4c:	2348      	movs	r3, #72	; 0x48\n",
  "  4e:	234a      	movs	r3, #74	; 0x4a\n",
  "  50:	234c      	movs	r3, #76	; 0x4c\n",
  "  52:	234e      	movs	r3, #78	; 0x4e\n",
  "  54:	2350      	movs	r3, #80	; 0x50\n",
  "  56:	2352      	movs	r3, #82	; 0x52\n",
  "  58:	2354      	movs	r3, #84	; 0x54\n",
  "  5a:	2356      	movs	r3, #86	; 0x56\n",
  "  5c:	2358      	movs	r3, #88	; 0x58\n",
  "  5e:	235a      	movs	r3, #90	; 0x5a\n",
  "  60:	235c      	movs	r3, #92	; 0x5c\n",
  "  62:	235e      	movs	r3, #94	; 0x5e\n",
  "  64:	2360      	movs	r3, #96	; 0x60\n",
  "  66:	2362      	movs	r3, #98	; 0x62\n",
  "  68:	2364      	movs	r3, #100	; 0x64\n",
  "  6a:	2366      	movs	r3, #102	; 0x66\n",
  "  6c:	2368      	movs	r3, #104	; 0x68\n",
  "  6e:	236a      	movs	r3, #106	; 0x6a\n",
  "  70:	236c      	movs	r3, #108	; 0x6c\n",
  "  72:	236e      	movs	r3, #110	; 0x6e\n",
  "  74:	2370      	movs	r3, #112	; 0x70\n",
  "  76:	2372      	movs	r3, #114	; 0x72\n",
  "  78:	2374      	movs	r3, #116	; 0x74\n",
  "  7a:	2376      	movs	r3, #118	; 0x76\n",
  "  7c:	2378      	movs	r3, #120	; 0x78\n",
  "  7e:	237a      	movs	r3, #122	; 0x7a\n",
  "  80:	237c      	movs	r3, #124	; 0x7c\n",
  "  82:	237e      	movs	r3, #126	; 0x7e\n",
  "  84:	2380      	movs	r3, #128	; 0x80\n",
  "  86:	2382      	movs	r3, #130	; 0x82\n",
  "  88:	2384      	movs	r3, #132	; 0x84\n",
  "  8a:	2386      	movs	r3, #134	; 0x86\n",
  "  8c:	2388      	movs	r3, #136	; 0x88\n",
  "  8e:	238a      	movs	r3, #138	; 0x8a\n",
  "  90:	238c      	movs	r3, #140	; 0x8c\n",
  "  92:	238e      	movs	r3, #142	; 0x8e\n",
  "  94:	2390      	movs	r3, #144	; 0x90\n",
  "  96:	2392      	movs	r3, #146	; 0x92\n",
  "  98:	2394      	movs	r3, #148	; 0x94\n",
  "  9a:	2396      	movs	r3, #150	; 0x96\n",
  "  9c:	2398      	movs	r3, #152	; 0x98\n",
  "  9e:	239a      	movs	r3, #154	; 0x9a\n",
  "  a0:	239c      	movs	r3, #156	; 0x9c\n",
  "  a2:	239e      	movs	r3, #158	; 0x9e\n",
  "  a4:	23a0      	movs	r3, #160	; 0xa0\n",
  "  a6:	23a2      	movs	r3, #162	; 0xa2\n",
  "  a8:	23a4      	movs	r3, #164	; 0xa4\n",
  "  aa:	23a6      	movs	r3, #166	; 0xa6\n",
  "  ac:	23a8      	movs	r3, #168	; 0xa8\n",
  "  ae:	23aa      	movs	r3, #170	; 0xaa\n",
  "  b0:	23ac      	movs	r3, #172	; 0xac\n",
  "  b2:	23ae      	movs	r3, #174	; 0xae\n",
  "  b4:	23b0      	movs	r3, #176	; 0xb0\n",
  "  b6:	23b2      	movs	r3, #178	; 0xb2\n",
  "  b8:	23b4      	movs	r3, #180	; 0xb4\n",
  "  ba:	23b6      	movs	r3, #182	; 0xb6\n",
  "  bc:	23b8      	movs	r3, #184	; 0xb8\n",
  "  be:	23ba      	movs	r3, #186	; 0xba\n",
  "  c0:	23bc      	movs	r3, #188	; 0xbc\n",
  "  c2:	23be      	movs	r3, #190	; 0xbe\n",
  "  c4:	23c0      	movs	r3, #192	; 0xc0\n",
  "  c6:	23c2      	movs	r3, #194	; 0xc2\n",
  "  c8:	23c4      	movs	r3, #196	; 0xc4\n",
  "  ca:	23c6      	movs	r3, #198	; 0xc6\n",
  "  cc:	23c8      	movs	r3, #200	; 0xc8\n",
  "  ce:	23ca      	movs	r3, #202	; 0xca\n",
  "  d0:	23cc      	movs	r3, #204	; 0xcc\n",
  "  d2:	23ce      	movs	r3, #206	; 0xce\n",
  "  d4:	23d0      	movs	r3, #208	; 0xd0\n",
  "  d6:	23d2      	movs	r3, #210	; 0xd2\n",
  "  d8:	23d4      	movs	r3, #212	; 0xd4\n",
  "  da:	23d6      	movs	r3, #214	; 0xd6\n",
  "  dc:	23d8      	movs	r3, #216	; 0xd8\n",
  "  de:	23da      	movs	r3, #218	; 0xda\n",
  "  e0:	23dc      	movs	r3, #220	; 0xdc\n",
  "  e2:	23de      	movs	r3, #222	; 0xde\n",
  "  e4:	23e0      	movs	r3, #224	; 0xe0\n",
  "  e6:	23e2      	movs	r3, #226	; 0xe2\n",
  "  e8:	23e4      	movs	r3, #228	; 0xe4\n",
  "  ea:	23e6      	movs	r3, #230	; 0xe6\n",
  "  ec:	23e8      	movs	r3, #232	; 0xe8\n",
  "  ee:	23ea      	movs	r3, #234	; 0xea\n",
  "  f0:	23ec      	movs	r3, #236	; 0xec\n",
  "  f2:	23ee      	movs	r3, #238	; 0xee\n",
  "  f4:	23f0      	movs	r3, #240	; 0xf0\n",
  "  f6:	23f2      	movs	r3, #242	; 0xf2\n",
  "  f8:	23f4      	movs	r3, #244	; 0xf4\n",
  "  fa:	23f6      	movs	r3, #246	; 0xf6\n",
  "  fc:	23f8      	movs	r3, #248	; 0xf8\n",
  "  fe:	23fa      	movs	r3, #250	; 0xfa\n",
  " 100:	23fc      	movs	r3, #252	; 0xfc\n",
  " 102:	23fe      	movs	r3, #254	; 0xfe\n",
  " 104:	2300      	movs	r3, #0\n",
  " 106:	2302      	movs	r3, #2\n",
  " 108:	2304      	movs	r3, #4\n",
  " 10a:	2306      	movs	r3, #6\n",
  " 10c:	2308      	movs	r3, #8\n",
  " 10e:	230a      	movs	r3, #10\n",
  " 110:	230c      	movs	r3, #12\n",
  " 112:	230e      	movs	r3, #14\n",
  " 114:	2310      	movs	r3, #16\n",
  " 116:	2312      	movs	r3, #18\n",
  " 118:	2314      	movs	r3, #20\n",
  " 11a:	2316      	movs	r3, #22\n",
  " 11c:	2318      	movs	r3, #24\n",
  " 11e:	231a      	movs	r3, #26\n",
  " 120:	231c      	movs	r3, #28\n",
  " 122:	231e      	movs	r3, #30\n",
  " 124:	2320      	movs	r3, #32\n",
  " 126:	2322      	movs	r3, #34	; 0x22\n",
  " 128:	2324      	movs	r3, #36	; 0x24\n",
  " 12a:	2326      	movs	r3, #38	; 0x26\n",
  " 12c:	2328      	movs	r3, #40	; 0x28\n",
  " 12e:	232a      	movs	r3, #42	; 0x2a\n",
  " 130:	232c      	movs	r3, #44	; 0x2c\n",
  " 132:	232e      	movs	r3, #46	; 0x2e\n",
  " 134:	2330      	movs	r3, #48	; 0x30\n",
  " 136:	2332      	movs	r3, #50	; 0x32\n",
  " 138:	2334      	movs	r3, #52	; 0x34\n",
  " 13a:	2336      	movs	r3, #54	; 0x36\n",
  " 13c:	2338      	movs	r3, #56	; 0x38\n",
  " 13e:	233a      	movs	r3, #58	; 0x3a\n",
  " 140:	233c      	movs	r3, #60	; 0x3c\n",
  " 142:	233e      	movs	r3, #62	; 0x3e\n",
  " 144:	2340      	movs	r3, #64	; 0x40\n",
  " 146:	2342      	movs	r3, #66	; 0x42\n",
  " 148:	2344      	movs	r3, #68	; 0x44\n",
  " 14a:	2346      	movs	r3, #70	; 0x46\n",
  " 14c:	2348      	movs	r3, #72	; 0x48\n",
  " 14e:	234a      	movs	r3, #74	; 0x4a\n",
  " 150:	234c      	movs	r3, #76	; 0x4c\n",
  " 152:	234e      	movs	r3, #78	; 0x4e\n",
  " 154:	2350      	movs	r3, #80	; 0x50\n",
  " 156:	2352      	movs	r3, #82	; 0x52\n",
  " 158:	2354      	movs	r3, #84	; 0x54\n",
  " 15a:	2356      	movs	r3, #86	; 0x56\n",
  " 15c:	2358      	movs	r3, #88	; 0x58\n",
  " 15e:	235a      	movs	r3, #90	; 0x5a\n",
  " 160:	235c      	movs	r3, #92	; 0x5c\n",
  " 162:	235e      	movs	r3, #94	; 0x5e\n",
  " 164:	2360      	movs	r3, #96	; 0x60\n",
  " 166:	2362      	movs	r3, #98	; 0x62\n",
  " 168:	2364      	movs	r3, #100	; 0x64\n",
  " 16a:	2366      	movs	r3, #102	; 0x66\n",
  " 16c:	2368      	movs	r3, #104	; 0x68\n",
  " 16e:	236a      	movs	r3, #106	; 0x6a\n",
  " 170:	236c      	movs	r3, #108	; 0x6c\n",
  " 172:	236e      	movs	r3, #110	; 0x6e\n",
  " 174:	2370      	movs	r3, #112	; 0x70\n",
  " 176:	2372      	movs	r3, #114	; 0x72\n",
  " 178:	2374      	movs	r3, #116	; 0x74\n",
  " 17a:	2376      	movs	r3, #118	; 0x76\n",
  " 17c:	2378      	movs	r3, #120	; 0x78\n",
  " 17e:	237a      	movs	r3, #122	; 0x7a\n",
  " 180:	237c      	movs	r3, #124	; 0x7c\n",
  " 182:	237e      	movs	r3, #126	; 0x7e\n",
  " 184:	2380      	movs	r3, #128	; 0x80\n",
  " 186:	2382      	movs	r3, #130	; 0x82\n",
  " 188:	2384      	movs	r3, #132	; 0x84\n",
  " 18a:	2386      	movs	r3, #134	; 0x86\n",
  " 18c:	2388      	movs	r3, #136	; 0x88\n",
  " 18e:	238a      	movs	r3, #138	; 0x8a\n",
  " 190:	238c      	movs	r3, #140	; 0x8c\n",
  " 192:	238e      	movs	r3, #142	; 0x8e\n",
  " 194:	2390      	movs	r3, #144	; 0x90\n",
  " 196:	2392      	movs	r3, #146	; 0x92\n",
  " 198:	2394      	movs	r3, #148	; 0x94\n",
  " 19a:	2396      	movs	r3, #150	; 0x96\n",
  " 19c:	2398      	movs	r3, #152	; 0x98\n",
  " 19e:	239a      	movs	r3, #154	; 0x9a\n",
  " 1a0:	239c      	movs	r3, #156	; 0x9c\n",
  " 1a2:	239e      	movs	r3, #158	; 0x9e\n",
  " 1a4:	23a0      	movs	r3, #160	; 0xa0\n",
  " 1a6:	23a2      	movs	r3, #162	; 0xa2\n",
  " 1a8:	23a4      	movs	r3, #164	; 0xa4\n",
  " 1aa:	23a6      	movs	r3, #166	; 0xa6\n",
  " 1ac:	23a8      	movs	r3, #168	; 0xa8\n",
  " 1ae:	23aa      	movs	r3, #170	; 0xaa\n",
  " 1b0:	23ac      	movs	r3, #172	; 0xac\n",
  " 1b2:	23ae      	movs	r3, #174	; 0xae\n",
  " 1b4:	23b0      	movs	r3, #176	; 0xb0\n",
  " 1b6:	23b2      	movs	r3, #178	; 0xb2\n",
  " 1b8:	23b4      	movs	r3, #180	; 0xb4\n",
  " 1ba:	23b6      	movs	r3, #182	; 0xb6\n",
  " 1bc:	23b8      	movs	r3, #184	; 0xb8\n",
  " 1be:	23ba      	movs	r3, #186	; 0xba\n",
  " 1c0:	23bc      	movs	r3, #188	; 0xbc\n",
  " 1c2:	23be      	movs	r3, #190	; 0xbe\n",
  " 1c4:	23c0      	movs	r3, #192	; 0xc0\n",
  " 1c6:	23c2      	movs	r3, #194	; 0xc2\n",
  " 1c8:	23c4      	movs	r3, #196	; 0xc4\n",
  " 1ca:	23c6      	movs	r3, #198	; 0xc6\n",
  " 1cc:	23c8      	movs	r3, #200	; 0xc8\n",
  " 1ce:	23ca      	movs	r3, #202	; 0xca\n",
  " 1d0:	23cc      	movs	r3, #204	; 0xcc\n",
  " 1d2:	23ce      	movs	r3, #206	; 0xce\n",
  " 1d4:	23d0      	movs	r3, #208	; 0xd0\n",
  " 1d6:	23d2      	movs	r3, #210	; 0xd2\n",
  " 1d8:	23d4      	movs	r3, #212	; 0xd4\n",
  " 1da:	23d6      	movs	r3, #214	; 0xd6\n",
  " 1dc:	23d8      	movs	r3, #216	; 0xd8\n",
  " 1de:	23da      	movs	r3, #218	; 0xda\n",
  " 1e0:	23dc      	movs	r3, #220	; 0xdc\n",
  " 1e2:	23de      	movs	r3, #222	; 0xde\n",
  " 1e4:	23e0      	movs	r3, #224	; 0xe0\n",
  " 1e6:	23e2      	movs	r3, #226	; 0xe2\n",
  " 1e8:	23e4      	movs	r3, #228	; 0xe4\n",
  " 1ea:	23e6      	movs	r3, #230	; 0xe6\n",
  " 1ec:	23e8      	movs	r3, #232	; 0xe8\n",
  " 1ee:	23ea      	movs	r3, #234	; 0xea\n",
  " 1f0:	23ec      	movs	r3, #236	; 0xec\n",
  " 1f2:	23ee      	movs	r3, #238	; 0xee\n",
  " 1f4:	23f0      	movs	r3, #240	; 0xf0\n",
  " 1f6:	23f2      	movs	r3, #242	; 0xf2\n",
  " 1f8:	23f4      	movs	r3, #244	; 0xf4\n",
  " 1fa:	23f6      	movs	r3, #246	; 0xf6\n",
  " 1fc:	23f8      	movs	r3, #248	; 0xf8\n",
  " 1fe:	23fa      	movs	r3, #250	; 0xfa\n",
  " 200:	23fc      	movs	r3, #252	; 0xfc\n",
  " 202:	23fe      	movs	r3, #254	; 0xfe\n",
  " 204:	2300      	movs	r3, #0\n",
  " 206:	2302      	movs	r3, #2\n",
  " 208:	2304      	movs	r3, #4\n",
  " 20a:	2306      	movs	r3, #6\n",
  " 20c:	2308      	movs	r3, #8\n",
  " 20e:	230a      	movs	r3, #10\n",
  " 210:	230c      	movs	r3, #12\n",
  " 212:	230e      	movs	r3, #14\n",
  " 214:	2310      	movs	r3, #16\n",
  " 216:	2312      	movs	r3, #18\n",
  " 218:	2314      	movs	r3, #20\n",
  " 21a:	2316      	movs	r3, #22\n",
  " 21c:	2318      	movs	r3, #24\n",
  " 21e:	231a      	movs	r3, #26\n",
  " 220:	231c      	movs	r3, #28\n",
  " 222:	231e      	movs	r3, #30\n",
  " 224:	2320      	movs	r3, #32\n",
  " 226:	2322      	movs	r3, #34	; 0x22\n",
  " 228:	2324      	movs	r3, #36	; 0x24\n",
  " 22a:	2326      	movs	r3, #38	; 0x26\n",
  " 22c:	2328      	movs	r3, #40	; 0x28\n",
  " 22e:	232a      	movs	r3, #42	; 0x2a\n",
  " 230:	232c      	movs	r3, #44	; 0x2c\n",
  " 232:	232e      	movs	r3, #46	; 0x2e\n",
  " 234:	2330      	movs	r3, #48	; 0x30\n",
  " 236:	2332      	movs	r3, #50	; 0x32\n",
  " 238:	2334      	movs	r3, #52	; 0x34\n",
  " 23a:	2336      	movs	r3, #54	; 0x36\n",
  " 23c:	2338      	movs	r3, #56	; 0x38\n",
  " 23e:	233a      	movs	r3, #58	; 0x3a\n",
  " 240:	233c      	movs	r3, #60	; 0x3c\n",
  " 242:	233e      	movs	r3, #62	; 0x3e\n",
  " 244:	2340      	movs	r3, #64	; 0x40\n",
  " 246:	2342      	movs	r3, #66	; 0x42\n",
  " 248:	2344      	movs	r3, #68	; 0x44\n",
  " 24a:	2346      	movs	r3, #70	; 0x46\n",
  " 24c:	2348      	movs	r3, #72	; 0x48\n",
  " 24e:	234a      	movs	r3, #74	; 0x4a\n",
  " 250:	234c      	movs	r3, #76	; 0x4c\n",
  " 252:	234e      	movs	r3, #78	; 0x4e\n",
  " 254:	2350      	movs	r3, #80	; 0x50\n",
  " 256:	2352      	movs	r3, #82	; 0x52\n",
  " 258:	2354      	movs	r3, #84	; 0x54\n",
  " 25a:	2356      	movs	r3, #86	; 0x56\n",
  " 25c:	2358      	movs	r3, #88	; 0x58\n",
  " 25e:	235a      	movs	r3, #90	; 0x5a\n",
  " 260:	235c      	movs	r3, #92	; 0x5c\n",
  " 262:	235e      	movs	r3, #94	; 0x5e\n",
  " 264:	2360      	movs	r3, #96	; 0x60\n",
  " 266:	2362      	movs	r3, #98	; 0x62\n",
  " 268:	2364      	movs	r3, #100	; 0x64\n",
  " 26a:	2366      	movs	r3, #102	; 0x66\n",
  " 26c:	2368      	movs	r3, #104	; 0x68\n",
  " 26e:	236a      	movs	r3, #106	; 0x6a\n",
  " 270:	236c      	movs	r3, #108	; 0x6c\n",
  " 272:	236e      	movs	r3, #110	; 0x6e\n",
  " 274:	2370      	movs	r3, #112	; 0x70\n",
  " 276:	2372      	movs	r3, #114	; 0x72\n",
  " 278:	2374      	movs	r3, #116	; 0x74\n",
  " 27a:	2376      	movs	r3, #118	; 0x76\n",
  " 27c:	2378      	movs	r3, #120	; 0x78\n",
  " 27e:	237a      	movs	r3, #122	; 0x7a\n",
  " 280:	237c      	movs	r3, #124	; 0x7c\n",
  " 282:	237e      	movs	r3, #126	; 0x7e\n",
  " 284:	2380      	movs	r3, #128	; 0x80\n",
  " 286:	2382      	movs	r3, #130	; 0x82\n",
  " 288:	2384      	movs	r3, #132	; 0x84\n",
  " 28a:	2386      	movs	r3, #134	; 0x86\n",
  " 28c:	2388      	movs	r3, #136	; 0x88\n",
  " 28e:	238a      	movs	r3, #138	; 0x8a\n",
  " 290:	238c      	movs	r3, #140	; 0x8c\n",
  " 292:	238e      	movs	r3, #142	; 0x8e\n",
  " 294:	2390      	movs	r3, #144	; 0x90\n",
  " 296:	2392      	movs	r3, #146	; 0x92\n",
  " 298:	2394      	movs	r3, #148	; 0x94\n",
  " 29a:	2396      	movs	r3, #150	; 0x96\n",
  " 29c:	2398      	movs	r3, #152	; 0x98\n",
  " 29e:	239a      	movs	r3, #154	; 0x9a\n",
  " 2a0:	239c      	movs	r3, #156	; 0x9c\n",
  " 2a2:	239e      	movs	r3, #158	; 0x9e\n",
  " 2a4:	23a0      	movs	r3, #160	; 0xa0\n",
  " 2a6:	23a2      	movs	r3, #162	; 0xa2\n",
  " 2a8:	23a4      	movs	r3, #164	; 0xa4\n",
  " 2aa:	23a6      	movs	r3, #166	; 0xa6\n",
  " 2ac:	23a8      	movs	r3, #168	; 0xa8\n",
  " 2ae:	23aa      	movs	r3, #170	; 0xaa\n",
  " 2b0:	23ac      	movs	r3, #172	; 0xac\n",
  " 2b2:	23ae      	movs	r3, #174	; 0xae\n",
  " 2b4:	23b0      	movs	r3, #176	; 0xb0\n",
  " 2b6:	23b2      	movs	r3, #178	; 0xb2\n",
  " 2b8:	23b4      	movs	r3, #180	; 0xb4\n",
  " 2ba:	23b6      	movs	r3, #182	; 0xb6\n",
  " 2bc:	23b8      	movs	r3, #184	; 0xb8\n",
  " 2be:	23ba      	movs	r3, #186	; 0xba\n",
  " 2c0:	23bc      	movs	r3, #188	; 0xbc\n",
  " 2c2:	23be      	movs	r3, #190	; 0xbe\n",
  " 2c4:	23c0      	movs	r3, #192	; 0xc0\n",
  " 2c6:	23c2      	movs	r3, #194	; 0xc2\n",
  " 2c8:	23c4      	movs	r3, #196	; 0xc4\n",
  " 2ca:	23c6      	movs	r3, #198	; 0xc6\n",
  " 2cc:	23c8      	movs	r3, #200	; 0xc8\n",
  " 2ce:	23ca      	movs	r3, #202	; 0xca\n",
  " 2d0:	23cc      	movs	r3, #204	; 0xcc\n",
  " 2d2:	23ce      	movs	r3, #206	; 0xce\n",
  " 2d4:	23d0      	movs	r3, #208	; 0xd0\n",
  " 2d6:	23d2      	movs	r3, #210	; 0xd2\n",
  " 2d8:	23d4      	movs	r3, #212	; 0xd4\n",
  " 2da:	23d6      	movs	r3, #214	; 0xd6\n",
  " 2dc:	23d8      	movs	r3, #216	; 0xd8\n",
  " 2de:	23da      	movs	r3, #218	; 0xda\n",
  " 2e0:	23dc      	movs	r3, #220	; 0xdc\n",
  " 2e2:	23de      	movs	r3, #222	; 0xde\n",
  " 2e4:	23e0      	movs	r3, #224	; 0xe0\n",
  " 2e6:	23e2      	movs	r3, #226	; 0xe2\n",
  " 2e8:	23e4      	movs	r3, #228	; 0xe4\n",
  " 2ea:	23e6      	movs	r3, #230	; 0xe6\n",
  " 2ec:	23e8      	movs	r3, #232	; 0xe8\n",
  " 2ee:	23ea      	movs	r3, #234	; 0xea\n",
  " 2f0:	23ec      	movs	r3, #236	; 0xec\n",
  " 2f2:	23ee      	movs	r3, #238	; 0xee\n",
  " 2f4:	23f0      	movs	r3, #240	; 0xf0\n",
  " 2f6:	23f2      	movs	r3, #242	; 0xf2\n",
  " 2f8:	23f4      	movs	r3, #244	; 0xf4\n",
  " 2fa:	23f6      	movs	r3, #246	; 0xf6\n",
  " 2fc:	23f8      	movs	r3, #248	; 0xf8\n",
  " 2fe:	23fa      	movs	r3, #250	; 0xfa\n",
  " 300:	23fc      	movs	r3, #252	; 0xfc\n",
  " 302:	23fe      	movs	r3, #254	; 0xfe\n",
  " 304:	2300      	movs	r3, #0\n",
  " 306:	2302      	movs	r3, #2\n",
  " 308:	2304      	movs	r3, #4\n",
  " 30a:	2306      	movs	r3, #6\n",
  " 30c:	2308      	movs	r3, #8\n",
  " 30e:	230a      	movs	r3, #10\n",
  " 310:	230c      	movs	r3, #12\n",
  " 312:	230e      	movs	r3, #14\n",
  " 314:	2310      	movs	r3, #16\n",
  " 316:	2312      	movs	r3, #18\n",
  " 318:	2314      	movs	r3, #20\n",
  " 31a:	2316      	movs	r3, #22\n",
  " 31c:	2318      	movs	r3, #24\n",
  " 31e:	231a      	movs	r3, #26\n",
  " 320:	231c      	movs	r3, #28\n",
  " 322:	231e      	movs	r3, #30\n",
  " 324:	2320      	movs	r3, #32\n",
  " 326:	2322      	movs	r3, #34	; 0x22\n",
  " 328:	2324      	movs	r3, #36	; 0x24\n",
  " 32a:	2326      	movs	r3, #38	; 0x26\n",
  " 32c:	2328      	movs	r3, #40	; 0x28\n",
  " 32e:	232a      	movs	r3, #42	; 0x2a\n",
  " 330:	232c      	movs	r3, #44	; 0x2c\n",
  " 332:	232e      	movs	r3, #46	; 0x2e\n",
  " 334:	2330      	movs	r3, #48	; 0x30\n",
  " 336:	2332      	movs	r3, #50	; 0x32\n",
  " 338:	2334      	movs	r3, #52	; 0x34\n",
  " 33a:	2336      	movs	r3, #54	; 0x36\n",
  " 33c:	2338      	movs	r3, #56	; 0x38\n",
  " 33e:	233a      	movs	r3, #58	; 0x3a\n",
  " 340:	233c      	movs	r3, #60	; 0x3c\n",
  " 342:	233e      	movs	r3, #62	; 0x3e\n",
  " 344:	2340      	movs	r3, #64	; 0x40\n",
  " 346:	2342      	movs	r3, #66	; 0x42\n",
  " 348:	2344      	movs	r3, #68	; 0x44\n",
  " 34a:	2346      	movs	r3, #70	; 0x46\n",
  " 34c:	2348      	movs	r3, #72	; 0x48\n",
  " 34e:	234a      	movs	r3, #74	; 0x4a\n",
  " 350:	234c      	movs	r3, #76	; 0x4c\n",
  " 352:	234e      	movs	r3, #78	; 0x4e\n",
  " 354:	2350      	movs	r3, #80	; 0x50\n",
  " 356:	2352      	movs	r3, #82	; 0x52\n",
  " 358:	2354      	movs	r3, #84	; 0x54\n",
  " 35a:	2356      	movs	r3, #86	; 0x56\n",
  " 35c:	2358      	movs	r3, #88	; 0x58\n",
  " 35e:	235a      	movs	r3, #90	; 0x5a\n",
  " 360:	235c      	movs	r3, #92	; 0x5c\n",
  " 362:	235e      	movs	r3, #94	; 0x5e\n",
  " 364:	2360      	movs	r3, #96	; 0x60\n",
  " 366:	2362      	movs	r3, #98	; 0x62\n",
  " 368:	2364      	movs	r3, #100	; 0x64\n",
  " 36a:	2366      	movs	r3, #102	; 0x66\n",
  " 36c:	2368      	movs	r3, #104	; 0x68\n",
  " 36e:	236a      	movs	r3, #106	; 0x6a\n",
  " 370:	236c      	movs	r3, #108	; 0x6c\n",
  " 372:	236e      	movs	r3, #110	; 0x6e\n",
  " 374:	2370      	movs	r3, #112	; 0x70\n",
  " 376:	2372      	movs	r3, #114	; 0x72\n",
  " 378:	2374      	movs	r3, #116	; 0x74\n",
  " 37a:	2376      	movs	r3, #118	; 0x76\n",
  " 37c:	2378      	movs	r3, #120	; 0x78\n",
  " 37e:	237a      	movs	r3, #122	; 0x7a\n",
  " 380:	237c      	movs	r3, #124	; 0x7c\n",
  " 382:	237e      	movs	r3, #126	; 0x7e\n",
  " 384:	2380      	movs	r3, #128	; 0x80\n",
  " 386:	2382      	movs	r3, #130	; 0x82\n",
  " 388:	2384      	movs	r3, #132	; 0x84\n",
  " 38a:	2386      	movs	r3, #134	; 0x86\n",
  " 38c:	2388      	movs	r3, #136	; 0x88\n",
  " 38e:	238a      	movs	r3, #138	; 0x8a\n",
  " 390:	238c      	movs	r3, #140	; 0x8c\n",
  " 392:	238e      	movs	r3, #142	; 0x8e\n",
  " 394:	2390      	movs	r3, #144	; 0x90\n",
  " 396:	2392      	movs	r3, #146	; 0x92\n",
  " 398:	2394      	movs	r3, #148	; 0x94\n",
  " 39a:	2396      	movs	r3, #150	; 0x96\n",
  " 39c:	2398      	movs	r3, #152	; 0x98\n",
  " 39e:	239a      	movs	r3, #154	; 0x9a\n",
  " 3a0:	239c      	movs	r3, #156	; 0x9c\n",
  " 3a2:	239e      	movs	r3, #158	; 0x9e\n",
  " 3a4:	23a0      	movs	r3, #160	; 0xa0\n",
  " 3a6:	23a2      	movs	r3, #162	; 0xa2\n",
  " 3a8:	23a4      	movs	r3, #164	; 0xa4\n",
  " 3aa:	23a6      	movs	r3, #166	; 0xa6\n",
  " 3ac:	23a8      	movs	r3, #168	; 0xa8\n",
  " 3ae:	23aa      	movs	r3, #170	; 0xaa\n",
  " 3b0:	23ac      	movs	r3, #172	; 0xac\n",
  " 3b2:	23ae      	movs	r3, #174	; 0xae\n",
  " 3b4:	23b0      	movs	r3, #176	; 0xb0\n",
  " 3b6:	23b2      	movs	r3, #178	; 0xb2\n",
  " 3b8:	23b4      	movs	r3, #180	; 0xb4\n",
  " 3ba:	23b6      	movs	r3, #182	; 0xb6\n",
  " 3bc:	23b8      	movs	r3, #184	; 0xb8\n",
  " 3be:	23ba      	movs	r3, #186	; 0xba\n",
  " 3c0:	23bc      	movs	r3, #188	; 0xbc\n",
  " 3c2:	23be      	movs	r3, #190	; 0xbe\n",
  " 3c4:	23c0      	movs	r3, #192	; 0xc0\n",
  " 3c6:	23c2      	movs	r3, #194	; 0xc2\n",
  " 3c8:	23c4      	movs	r3, #196	; 0xc4\n",
  " 3ca:	23c6      	movs	r3, #198	; 0xc6\n",
  " 3cc:	23c8      	movs	r3, #200	; 0xc8\n",
  " 3ce:	23ca      	movs	r3, #202	; 0xca\n",
  " 3d0:	23cc      	movs	r3, #204	; 0xcc\n",
  " 3d2:	23ce      	movs	r3, #206	; 0xce\n",
  " 3d4:	23d0      	movs	r3, #208	; 0xd0\n",
  " 3d6:	23d2      	movs	r3, #210	; 0xd2\n",
  " 3d8:	23d4      	movs	r3, #212	; 0xd4\n",
  " 3da:	23d6      	movs	r3, #214	; 0xd6\n",
  " 3dc:	23d8      	movs	r3, #216	; 0xd8\n",
  " 3de:	23da      	movs	r3, #218	; 0xda\n",
  " 3e0:	23dc      	movs	r3, #220	; 0xdc\n",
  " 3e2:	23de      	movs	r3, #222	; 0xde\n",
  " 3e4:	23e0      	movs	r3, #224	; 0xe0\n",
  " 3e6:	23e2      	movs	r3, #226	; 0xe2\n",
  " 3e8:	23e4      	movs	r3, #228	; 0xe4\n",
  " 3ea:	23e6      	movs	r3, #230	; 0xe6\n",
  " 3ec:	23e8      	movs	r3, #232	; 0xe8\n",
  " 3ee:	23ea      	movs	r3, #234	; 0xea\n",
  " 3f0:	23ec      	movs	r3, #236	; 0xec\n",
  " 3f2:	23ee      	movs	r3, #238	; 0xee\n",
  " 3f4:	23f0      	movs	r3, #240	; 0xf0\n",
  " 3f6:	23f2      	movs	r3, #242	; 0xf2\n",
  " 3f8:	23f4      	movs	r3, #244	; 0xf4\n",
  " 3fa:	23f6      	movs	r3, #246	; 0xf6\n",
  " 3fc:	23f8      	movs	r3, #248	; 0xf8\n",
  " 3fe:	23fa      	movs	r3, #250	; 0xfa\n",
  " 400:	23fc      	movs	r3, #252	; 0xfc\n",
  " 402:	23fe      	movs	r3, #254	; 0xfe\n",
  " 404:	2300      	movs	r3, #0\n",
  " 406:	2302      	movs	r3, #2\n",
  " 408:	2304      	movs	r3, #4\n",
  " 40a:	2306      	movs	r3, #6\n",
  " 40c:	2308      	movs	r3, #8\n",
  " 40e:	230a      	movs	r3, #10\n",
  " 410:	230c      	movs	r3, #12\n",
  " 412:	230e      	movs	r3, #14\n",
  " 414:	2310      	movs	r3, #16\n",
  " 416:	2312      	movs	r3, #18\n",
  " 418:	2314      	movs	r3, #20\n",
  " 41a:	2316      	movs	r3, #22\n",
  " 41c:	2318      	movs	r3, #24\n",
  " 41e:	231a      	movs	r3, #26\n",
  " 420:	231c      	movs	r3, #28\n",
  " 422:	231e      	movs	r3, #30\n",
  " 424:	2320      	movs	r3, #32\n",
  " 426:	2322      	movs	r3, #34	; 0x22\n",
  " 428:	2324      	movs	r3, #36	; 0x24\n",
  " 42a:	2326      	movs	r3, #38	; 0x26\n",
  " 42c:	2328      	movs	r3, #40	; 0x28\n",
  " 42e:	232a      	movs	r3, #42	; 0x2a\n",
  " 430:	232c      	movs	r3, #44	; 0x2c\n",
  " 432:	232e      	movs	r3, #46	; 0x2e\n",
  " 434:	2330      	movs	r3, #48	; 0x30\n",
  " 436:	2332      	movs	r3, #50	; 0x32\n",
  " 438:	2334      	movs	r3, #52	; 0x34\n",
  " 43a:	2336      	movs	r3, #54	; 0x36\n",
  " 43c:	2338      	movs	r3, #56	; 0x38\n",
  " 43e:	233a      	movs	r3, #58	; 0x3a\n",
  " 440:	233c      	movs	r3, #60	; 0x3c\n",
  " 442:	233e      	movs	r3, #62	; 0x3e\n",
  " 444:	2340      	movs	r3, #64	; 0x40\n",
  " 446:	2342      	movs	r3, #66	; 0x42\n",
  " 448:	2344      	movs	r3, #68	; 0x44\n",
  " 44a:	2346      	movs	r3, #70	; 0x46\n",
  " 44c:	2348      	movs	r3, #72	; 0x48\n",
  " 44e:	234a      	movs	r3, #74	; 0x4a\n",
  " 450:	234c      	movs	r3, #76	; 0x4c\n",
  " 452:	234e      	movs	r3, #78	; 0x4e\n",
  " 454:	2350      	movs	r3, #80	; 0x50\n",
  " 456:	2352      	movs	r3, #82	; 0x52\n",
  " 458:	2354      	movs	r3, #84	; 0x54\n",
  " 45a:	2356      	movs	r3, #86	; 0x56\n",
  " 45c:	2358      	movs	r3, #88	; 0x58\n",
  " 45e:	235a      	movs	r3, #90	; 0x5a\n",
  " 460:	235c      	movs	r3, #92	; 0x5c\n",
  " 462:	235e      	movs	r3, #94	; 0x5e\n",
  " 464:	2360      	movs	r3, #96	; 0x60\n",
  " 466:	2362      	movs	r3, #98	; 0x62\n",
  " 468:	2364      	movs	r3, #100	; 0x64\n",
  " 46a:	2366      	movs	r3, #102	; 0x66\n",
  " 46c:	2368      	movs	r3, #104	; 0x68\n",
  " 46e:	236a      	movs	r3, #106	; 0x6a\n",
  " 470:	236c      	movs	r3, #108	; 0x6c\n",
  " 472:	236e      	movs	r3, #110	; 0x6e\n",
  " 474:	2370      	movs	r3, #112	; 0x70\n",
  " 476:	2372      	movs	r3, #114	; 0x72\n",
  " 478:	2374      	movs	r3, #116	; 0x74\n",
  " 47a:	2376      	movs	r3, #118	; 0x76\n",
  " 47c:	2378      	movs	r3, #120	; 0x78\n",
  " 47e:	237a      	movs	r3, #122	; 0x7a\n",
  " 480:	237c      	movs	r3, #124	; 0x7c\n",
  " 482:	237e      	movs	r3, #126	; 0x7e\n",
  " 484:	2380      	movs	r3, #128	; 0x80\n",
  " 486:	2382      	movs	r3, #130	; 0x82\n",
  " 488:	2384      	movs	r3, #132	; 0x84\n",
  " 48a:	2386      	movs	r3, #134	; 0x86\n",
  " 48c:	2388      	movs	r3, #136	; 0x88\n",
  " 48e:	238a      	movs	r3, #138	; 0x8a\n",
  " 490:	238c      	movs	r3, #140	; 0x8c\n",
  " 492:	238e      	movs	r3, #142	; 0x8e\n",
  " 494:	2390      	movs	r3, #144	; 0x90\n",
  " 496:	2392      	movs	r3, #146	; 0x92\n",
  " 498:	2394      	movs	r3, #148	; 0x94\n",
  " 49a:	2396      	movs	r3, #150	; 0x96\n",
  " 49c:	2398      	movs	r3, #152	; 0x98\n",
  " 49e:	239a      	movs	r3, #154	; 0x9a\n",
  " 4a0:	239c      	movs	r3, #156	; 0x9c\n",
  " 4a2:	239e      	movs	r3, #158	; 0x9e\n",
  " 4a4:	23a0      	movs	r3, #160	; 0xa0\n",
  " 4a6:	23a2      	movs	r3, #162	; 0xa2\n",
  " 4a8:	23a4      	movs	r3, #164	; 0xa4\n",
  " 4aa:	23a6      	movs	r3, #166	; 0xa6\n",
  " 4ac:	23a8      	movs	r3, #168	; 0xa8\n",
  " 4ae:	23aa      	movs	r3, #170	; 0xaa\n",
  " 4b0:	23ac      	movs	r3, #172	; 0xac\n",
  " 4b2:	23ae      	movs	r3, #174	; 0xae\n",
  " 4b4:	23b0      	movs	r3, #176	; 0xb0\n",
  " 4b6:	23b2      	movs	r3, #178	; 0xb2\n",
  " 4b8:	23b4      	movs	r3, #180	; 0xb4\n",
  " 4ba:	23b6      	movs	r3, #182	; 0xb6\n",
  " 4bc:	23b8      	movs	r3, #184	; 0xb8\n",
  " 4be:	23ba      	movs	r3, #186	; 0xba\n",
  " 4c0:	23bc      	movs	r3, #188	; 0xbc\n",
  " 4c2:	23be      	movs	r3, #190	; 0xbe\n",
  " 4c4:	23c0      	movs	r3, #192	; 0xc0\n",
  " 4c6:	23c2      	movs	r3, #194	; 0xc2\n",
  " 4c8:	23c4      	movs	r3, #196	; 0xc4\n",
  " 4ca:	23c6      	movs	r3, #198	; 0xc6\n",
  " 4cc:	23c8      	movs	r3, #200	; 0xc8\n",
  " 4ce:	23ca      	movs	r3, #202	; 0xca\n",
  " 4d0:	23cc      	movs	r3, #204	; 0xcc\n",
  " 4d2:	23ce      	movs	r3, #206	; 0xce\n",
  " 4d4:	23d0      	movs	r3, #208	; 0xd0\n",
  " 4d6:	23d2      	movs	r3, #210	; 0xd2\n",
  " 4d8:	23d4      	movs	r3, #212	; 0xd4\n",
  " 4da:	23d6      	movs	r3, #214	; 0xd6\n",
  " 4dc:	23d8      	movs	r3, #216	; 0xd8\n",
  " 4de:	23da      	movs	r3, #218	; 0xda\n",
  " 4e0:	23dc      	movs	r3, #220	; 0xdc\n",
  " 4e2:	23de      	movs	r3, #222	; 0xde\n",
  " 4e4:	23e0      	movs	r3, #224	; 0xe0\n",
  " 4e6:	23e2      	movs	r3, #226	; 0xe2\n",
  " 4e8:	23e4      	movs	r3, #228	; 0xe4\n",
  " 4ea:	23e6      	movs	r3, #230	; 0xe6\n",
  " 4ec:	23e8      	movs	r3, #232	; 0xe8\n",
  " 4ee:	23ea      	movs	r3, #234	; 0xea\n",
  " 4f0:	23ec      	movs	r3, #236	; 0xec\n",
  " 4f2:	23ee      	movs	r3, #238	; 0xee\n",
  " 4f4:	23f0      	movs	r3, #240	; 0xf0\n",
  " 4f6:	23f2      	movs	r3, #242	; 0xf2\n",
  " 4f8:	23f4      	movs	r3, #244	; 0xf4\n",
  " 4fa:	23f6      	movs	r3, #246	; 0xf6\n",
  " 4fc:	23f8      	movs	r3, #248	; 0xf8\n",
  " 4fe:	23fa      	movs	r3, #250	; 0xfa\n",
  " 500:	23fc      	movs	r3, #252	; 0xfc\n",
  " 502:	23fe      	movs	r3, #254	; 0xfe\n",
  " 504:	2300      	movs	r3, #0\n",
  " 506:	2302      	movs	r3, #2\n",
  " 508:	2304      	movs	r3, #4\n",
  " 50a:	2306      	movs	r3, #6\n",
  " 50c:	2308      	movs	r3, #8\n",
  " 50e:	230a      	movs	r3, #10\n",
  " 510:	230c      	movs	r3, #12\n",
  " 512:	230e      	movs	r3, #14\n",
  " 514:	2310      	movs	r3, #16\n",
  " 516:	2312      	movs	r3, #18\n",
  " 518:	2314      	movs	r3, #20\n",
  " 51a:	2316      	movs	r3, #22\n",
  " 51c:	2318      	movs	r3, #24\n",
  " 51e:	231a      	movs	r3, #26\n",
  " 520:	231c      	movs	r3, #28\n",
  " 522:	231e      	movs	r3, #30\n",
  " 524:	2320      	movs	r3, #32\n",
  " 526:	2322      	movs	r3, #34	; 0x22\n",
  " 528:	2324      	movs	r3, #36	; 0x24\n",
  " 52a:	2326      	movs	r3, #38	; 0x26\n",
  " 52c:	2328      	movs	r3, #40	; 0x28\n",
  " 52e:	232a      	movs	r3, #42	; 0x2a\n",
  " 530:	232c      	movs	r3, #44	; 0x2c\n",
  " 532:	232e      	movs	r3, #46	; 0x2e\n",
  " 534:	2330      	movs	r3, #48	; 0x30\n",
  " 536:	2332      	movs	r3, #50	; 0x32\n",
  " 538:	2334      	movs	r3, #52	; 0x34\n",
  " 53a:	2336      	movs	r3, #54	; 0x36\n",
  " 53c:	2338      	movs	r3, #56	; 0x38\n",
  " 53e:	233a      	movs	r3, #58	; 0x3a\n",
  " 540:	233c      	movs	r3, #60	; 0x3c\n",
  " 542:	233e      	movs	r3, #62	; 0x3e\n",
  " 544:	2340      	movs	r3, #64	; 0x40\n",
  " 546:	2342      	movs	r3, #66	; 0x42\n",
  " 548:	2344      	movs	r3, #68	; 0x44\n",
  " 54a:	2346      	movs	r3, #70	; 0x46\n",
  " 54c:	2348      	movs	r3, #72	; 0x48\n",
  " 54e:	234a      	movs	r3, #74	; 0x4a\n",
  " 550:	234c      	movs	r3, #76	; 0x4c\n",
  " 552:	234e      	movs	r3, #78	; 0x4e\n",
  " 554:	2350      	movs	r3, #80	; 0x50\n",
  " 556:	2352      	movs	r3, #82	; 0x52\n",
  " 558:	2354      	movs	r3, #84	; 0x54\n",
  " 55a:	2356      	movs	r3, #86	; 0x56\n",
  " 55c:	2358      	movs	r3, #88	; 0x58\n",
  " 55e:	235a      	movs	r3, #90	; 0x5a\n",
  " 560:	235c      	movs	r3, #92	; 0x5c\n",
  " 562:	235e      	movs	r3, #94	; 0x5e\n",
  " 564:	2360      	movs	r3, #96	; 0x60\n",
  " 566:	2362      	movs	r3, #98	; 0x62\n",
  " 568:	2364      	movs	r3, #100	; 0x64\n",
  " 56a:	2366      	movs	r3, #102	; 0x66\n",
  " 56c:	2368      	movs	r3, #104	; 0x68\n",
  " 56e:	236a      	movs	r3, #106	; 0x6a\n",
  " 570:	236c      	movs	r3, #108	; 0x6c\n",
  " 572:	236e      	movs	r3, #110	; 0x6e\n",
  " 574:	2370      	movs	r3, #112	; 0x70\n",
  " 576:	2372      	movs	r3, #114	; 0x72\n",
  " 578:	2374      	movs	r3, #116	; 0x74\n",
  " 57a:	2376      	movs	r3, #118	; 0x76\n",
  " 57c:	2378      	movs	r3, #120	; 0x78\n",
  " 57e:	237a      	movs	r3, #122	; 0x7a\n",
  " 580:	237c      	movs	r3, #124	; 0x7c\n",
  " 582:	237e      	movs	r3, #126	; 0x7e\n",
  " 584:	2380      	movs	r3, #128	; 0x80\n",
  " 586:	2382      	movs	r3, #130	; 0x82\n",
  " 588:	2384      	movs	r3, #132	; 0x84\n",
  " 58a:	2386      	movs	r3, #134	; 0x86\n",
  " 58c:	2388      	movs	r3, #136	; 0x88\n",
  " 58e:	238a      	movs	r3, #138	; 0x8a\n",
  " 590:	238c      	movs	r3, #140	; 0x8c\n",
  " 592:	238e      	movs	r3, #142	; 0x8e\n",
  " 594:	2390      	movs	r3, #144	; 0x90\n",
  " 596:	2392      	movs	r3, #146	; 0x92\n",
  " 598:	2394      	movs	r3, #148	; 0x94\n",
  " 59a:	2396      	movs	r3, #150	; 0x96\n",
  " 59c:	2398      	movs	r3, #152	; 0x98\n",
  " 59e:	239a      	movs	r3, #154	; 0x9a\n",
  " 5a0:	239c      	movs	r3, #156	; 0x9c\n",
  " 5a2:	239e      	movs	r3, #158	; 0x9e\n",
  " 5a4:	23a0      	movs	r3, #160	; 0xa0\n",
  " 5a6:	23a2      	movs	r3, #162	; 0xa2\n",
  " 5a8:	23a4      	movs	r3, #164	; 0xa4\n",
  " 5aa:	23a6      	movs	r3, #166	; 0xa6\n",
  " 5ac:	23a8      	movs	r3, #168	; 0xa8\n",
  " 5ae:	23aa      	movs	r3, #170	; 0xaa\n",
  " 5b0:	23ac      	movs	r3, #172	; 0xac\n",
  " 5b2:	23ae      	movs	r3, #174	; 0xae\n",
  " 5b4:	23b0      	movs	r3, #176	; 0xb0\n",
  " 5b6:	23b2      	movs	r3, #178	; 0xb2\n",
  " 5b8:	23b4      	movs	r3, #180	; 0xb4\n",
  " 5ba:	23b6      	movs	r3, #182	; 0xb6\n",
  " 5bc:	23b8      	movs	r3, #184	; 0xb8\n",
  " 5be:	23ba      	movs	r3, #186	; 0xba\n",
  " 5c0:	23bc      	movs	r3, #188	; 0xbc\n",
  " 5c2:	23be      	movs	r3, #190	; 0xbe\n",
  " 5c4:	23c0      	movs	r3, #192	; 0xc0\n",
  " 5c6:	23c2      	movs	r3, #194	; 0xc2\n",
  " 5c8:	23c4      	movs	r3, #196	; 0xc4\n",
  " 5ca:	23c6      	movs	r3, #198	; 0xc6\n",
  " 5cc:	23c8      	movs	r3, #200	; 0xc8\n",
  " 5ce:	23ca      	movs	r3, #202	; 0xca\n",
  " 5d0:	23cc      	movs	r3, #204	; 0xcc\n",
  " 5d2:	23ce      	movs	r3, #206	; 0xce\n",
  " 5d4:	23d0      	movs	r3, #208	; 0xd0\n",
  " 5d6:	23d2      	movs	r3, #210	; 0xd2\n",
  " 5d8:	23d4      	movs	r3, #212	; 0xd4\n",
  " 5da:	23d6      	movs	r3, #214	; 0xd6\n",
  " 5dc:	23d8      	movs	r3, #216	; 0xd8\n",
  " 5de:	23da      	movs	r3, #218	; 0xda\n",
  " 5e0:	23dc      	movs	r3, #220	; 0xdc\n",
  " 5e2:	23de      	movs	r3, #222	; 0xde\n",
  " 5e4:	23e0      	movs	r3, #224	; 0xe0\n",
  " 5e6:	23e2      	movs	r3, #226	; 0xe2\n",
  " 5e8:	23e4      	movs	r3, #228	; 0xe4\n",
  " 5ea:	23e6      	movs	r3, #230	; 0xe6\n",
  " 5ec:	23e8      	movs	r3, #232	; 0xe8\n",
  " 5ee:	23ea      	movs	r3, #234	; 0xea\n",
  " 5f0:	23ec      	movs	r3, #236	; 0xec\n",
  " 5f2:	23ee      	movs	r3, #238	; 0xee\n",
  " 5f4:	23f0      	movs	r3, #240	; 0xf0\n",
  " 5f6:	23f2      	movs	r3, #242	; 0xf2\n",
  " 5f8:	23f4      	movs	r3, #244	; 0xf4\n",
  " 5fa:	23f6      	movs	r3, #246	; 0xf6\n",
  " 5fc:	23f8      	movs	r3, #248	; 0xf8\n",
  " 5fe:	23fa      	movs	r3, #250	; 0xfa\n",
  " 600:	23fc      	movs	r3, #252	; 0xfc\n",
  " 602:	23fe      	movs	r3, #254	; 0xfe\n",
  " 604:	2300      	movs	r3, #0\n",
  " 606:	2302      	movs	r3, #2\n",
  " 608:	2304      	movs	r3, #4\n",
  " 60a:	2306      	movs	r3, #6\n",
  " 60c:	2308      	movs	r3, #8\n",
  " 60e:	230a      	movs	r3, #10\n",
  " 610:	230c      	movs	r3, #12\n",
  " 612:	230e      	movs	r3, #14\n",
  " 614:	2310      	movs	r3, #16\n",
  " 616:	2312      	movs	r3, #18\n",
  " 618:	2314      	movs	r3, #20\n",
  " 61a:	2316      	movs	r3, #22\n",
  " 61c:	2318      	movs	r3, #24\n",
  " 61e:	231a      	movs	r3, #26\n",
  " 620:	231c      	movs	r3, #28\n",
  " 622:	231e      	movs	r3, #30\n",
  " 624:	2320      	movs	r3, #32\n",
  " 626:	2322      	movs	r3, #34	; 0x22\n",
  " 628:	2324      	movs	r3, #36	; 0x24\n",
  " 62a:	2326      	movs	r3, #38	; 0x26\n",
  " 62c:	2328      	movs	r3, #40	; 0x28\n",
  " 62e:	232a      	movs	r3, #42	; 0x2a\n",
  " 630:	232c      	movs	r3, #44	; 0x2c\n",
  " 632:	232e      	movs	r3, #46	; 0x2e\n",
  " 634:	2330      	movs	r3, #48	; 0x30\n",
  " 636:	2332      	movs	r3, #50	; 0x32\n",
  " 638:	2334      	movs	r3, #52	; 0x34\n",
  " 63a:	2336      	movs	r3, #54	; 0x36\n",
  " 63c:	2338      	movs	r3, #56	; 0x38\n",
  " 63e:	233a      	movs	r3, #58	; 0x3a\n",
  " 640:	233c      	movs	r3, #60	; 0x3c\n",
  " 642:	233e      	movs	r3, #62	; 0x3e\n",
  " 644:	2340      	movs	r3, #64	; 0x40\n",
  " 646:	2342      	movs	r3, #66	; 0x42\n",
  " 648:	2344      	movs	r3, #68	; 0x44\n",
  " 64a:	2346      	movs	r3, #70	; 0x46\n",
  " 64c:	2348      	movs	r3, #72	; 0x48\n",
  " 64e:	234a      	movs	r3, #74	; 0x4a\n",
  " 650:	234c      	movs	r3, #76	; 0x4c\n",
  " 652:	234e      	movs	r3, #78	; 0x4e\n",
  " 654:	2350      	movs	r3, #80	; 0x50\n",
  " 656:	2352      	movs	r3, #82	; 0x52\n",
  " 658:	2354      	movs	r3, #84	; 0x54\n",
  " 65a:	2356      	movs	r3, #86	; 0x56\n",
  " 65c:	2358      	movs	r3, #88	; 0x58\n",
  " 65e:	235a      	movs	r3, #90	; 0x5a\n",
  " 660:	235c      	movs	r3, #92	; 0x5c\n",
  " 662:	235e      	movs	r3, #94	; 0x5e\n",
  " 664:	2360      	movs	r3, #96	; 0x60\n",
  " 666:	2362      	movs	r3, #98	; 0x62\n",
  " 668:	2364      	movs	r3, #100	; 0x64\n",
  " 66a:	2366      	movs	r3, #102	; 0x66\n",
  " 66c:	2368      	movs	r3, #104	; 0x68\n",
  " 66e:	236a      	movs	r3, #106	; 0x6a\n",
  " 670:	236c      	movs	r3, #108	; 0x6c\n",
  " 672:	236e      	movs	r3, #110	; 0x6e\n",
  " 674:	2370      	movs	r3, #112	; 0x70\n",
  " 676:	2372      	movs	r3, #114	; 0x72\n",
  " 678:	2374      	movs	r3, #116	; 0x74\n",
  " 67a:	2376      	movs	r3, #118	; 0x76\n",
  " 67c:	2378      	movs	r3, #120	; 0x78\n",
  " 67e:	237a      	movs	r3, #122	; 0x7a\n",
  " 680:	237c      	movs	r3, #124	; 0x7c\n",
  " 682:	237e      	movs	r3, #126	; 0x7e\n",
  " 684:	2380      	movs	r3, #128	; 0x80\n",
  " 686:	2382      	movs	r3, #130	; 0x82\n",
  " 688:	2384      	movs	r3, #132	; 0x84\n",
  " 68a:	2386      	movs	r3, #134	; 0x86\n",
  " 68c:	2388      	movs	r3, #136	; 0x88\n",
  " 68e:	238a      	movs	r3, #138	; 0x8a\n",
  " 690:	238c      	movs	r3, #140	; 0x8c\n",
  " 692:	238e      	movs	r3, #142	; 0x8e\n",
  " 694:	2390      	movs	r3, #144	; 0x90\n",
  " 696:	2392      	movs	r3, #146	; 0x92\n",
  " 698:	2394      	movs	r3, #148	; 0x94\n",
  " 69a:	2396      	movs	r3, #150	; 0x96\n",
  " 69c:	2398      	movs	r3, #152	; 0x98\n",
  " 69e:	239a      	movs	r3, #154	; 0x9a\n",
  " 6a0:	239c      	movs	r3, #156	; 0x9c\n",
  " 6a2:	239e      	movs	r3, #158	; 0x9e\n",
  " 6a4:	23a0      	movs	r3, #160	; 0xa0\n",
  " 6a6:	23a2      	movs	r3, #162	; 0xa2\n",
  " 6a8:	23a4      	movs	r3, #164	; 0xa4\n",
  " 6aa:	23a6      	movs	r3, #166	; 0xa6\n",
  " 6ac:	23a8      	movs	r3, #168	; 0xa8\n",
  " 6ae:	23aa      	movs	r3, #170	; 0xaa\n",
  " 6b0:	23ac      	movs	r3, #172	; 0xac\n",
  " 6b2:	23ae      	movs	r3, #174	; 0xae\n",
  " 6b4:	23b0      	movs	r3, #176	; 0xb0\n",
  " 6b6:	23b2      	movs	r3, #178	; 0xb2\n",
  " 6b8:	23b4      	movs	r3, #180	; 0xb4\n",
  " 6ba:	23b6      	movs	r3, #182	; 0xb6\n",
  " 6bc:	23b8      	movs	r3, #184	; 0xb8\n",
  " 6be:	23ba      	movs	r3, #186	; 0xba\n",
  " 6c0:	23bc      	movs	r3, #188	; 0xbc\n",
  " 6c2:	23be      	movs	r3, #190	; 0xbe\n",
  " 6c4:	23c0      	movs	r3, #192	; 0xc0\n",
  " 6c6:	23c2      	movs	r3, #194	; 0xc2\n",
  " 6c8:	23c4      	movs	r3, #196	; 0xc4\n",
  " 6ca:	23c6      	movs	r3, #198	; 0xc6\n",
  " 6cc:	23c8      	movs	r3, #200	; 0xc8\n",
  " 6ce:	23ca      	movs	r3, #202	; 0xca\n",
  " 6d0:	23cc      	movs	r3, #204	; 0xcc\n",
  " 6d2:	23ce      	movs	r3, #206	; 0xce\n",
  " 6d4:	23d0      	movs	r3, #208	; 0xd0\n",
  " 6d6:	23d2      	movs	r3, #210	; 0xd2\n",
  " 6d8:	23d4      	movs	r3, #212	; 0xd4\n",
  " 6da:	23d6      	movs	r3, #214	; 0xd6\n",
  " 6dc:	23d8      	movs	r3, #216	; 0xd8\n",
  " 6de:	23da      	movs	r3, #218	; 0xda\n",
  " 6e0:	23dc      	movs	r3, #220	; 0xdc\n",
  " 6e2:	23de      	movs	r3, #222	; 0xde\n",
  " 6e4:	23e0      	movs	r3, #224	; 0xe0\n",
  " 6e6:	23e2      	movs	r3, #226	; 0xe2\n",
  " 6e8:	23e4      	movs	r3, #228	; 0xe4\n",
  " 6ea:	23e6      	movs	r3, #230	; 0xe6\n",
  " 6ec:	23e8      	movs	r3, #232	; 0xe8\n",
  " 6ee:	23ea      	movs	r3, #234	; 0xea\n",
  " 6f0:	23ec      	movs	r3, #236	; 0xec\n",
  " 6f2:	23ee      	movs	r3, #238	; 0xee\n",
  " 6f4:	23f0      	movs	r3, #240	; 0xf0\n",
  " 6f6:	23f2      	movs	r3, #242	; 0xf2\n",
  " 6f8:	23f4      	movs	r3, #244	; 0xf4\n",
  " 6fa:	23f6      	movs	r3, #246	; 0xf6\n",
  " 6fc:	23f8      	movs	r3, #248	; 0xf8\n",
  " 6fe:	23fa      	movs	r3, #250	; 0xfa\n",
  " 700:	23fc      	movs	r3, #252	; 0xfc\n",
  " 702:	23fe      	movs	r3, #254	; 0xfe\n",
  " 704:	2300      	movs	r3, #0\n",
  " 706:	2302      	movs	r3, #2\n",
  " 708:	2304      	movs	r3, #4\n",
  " 70a:	2306      	movs	r3, #6\n",
  " 70c:	2308      	movs	r3, #8\n",
  " 70e:	230a      	movs	r3, #10\n",
  " 710:	230c      	movs	r3, #12\n",
  " 712:	230e      	movs	r3, #14\n",
  " 714:	2310      	movs	r3, #16\n",
  " 716:	2312      	movs	r3, #18\n",
  " 718:	2314      	movs	r3, #20\n",
  " 71a:	2316      	movs	r3, #22\n",
  " 71c:	2318      	movs	r3, #24\n",
  " 71e:	231a      	movs	r3, #26\n",
  " 720:	231c      	movs	r3, #28\n",
  " 722:	231e      	movs	r3, #30\n",
  " 724:	2320      	movs	r3, #32\n",
  " 726:	2322      	movs	r3, #34	; 0x22\n",
  " 728:	2324      	movs	r3, #36	; 0x24\n",
  " 72a:	2326      	movs	r3, #38	; 0x26\n",
  " 72c:	2328      	movs	r3, #40	; 0x28\n",
  " 72e:	232a      	movs	r3, #42	; 0x2a\n",
  " 730:	232c      	movs	r3, #44	; 0x2c\n",
  " 732:	232e      	movs	r3, #46	; 0x2e\n",
  " 734:	2330      	movs	r3, #48	; 0x30\n",
  " 736:	2332      	movs	r3, #50	; 0x32\n",
  " 738:	2334      	movs	r3, #52	; 0x34\n",
  " 73a:	2336      	movs	r3, #54	; 0x36\n",
  " 73c:	2338      	movs	r3, #56	; 0x38\n",
  " 73e:	233a      	movs	r3, #58	; 0x3a\n",
  " 740:	233c      	movs	r3, #60	; 0x3c\n",
  " 742:	233e      	movs	r3, #62	; 0x3e\n",
  " 744:	2340      	movs	r3, #64	; 0x40\n",
  " 746:	2342      	movs	r3, #66	; 0x42\n",
  " 748:	2344      	movs	r3, #68	; 0x44\n",
  " 74a:	2346      	movs	r3, #70	; 0x46\n",
  " 74c:	2348      	movs	r3, #72	; 0x48\n",
  " 74e:	234a      	movs	r3, #74	; 0x4a\n",
  " 750:	234c      	movs	r3, #76	; 0x4c\n",
  " 752:	234e      	movs	r3, #78	; 0x4e\n",
  " 754:	2350      	movs	r3, #80	; 0x50\n",
  " 756:	2352      	movs	r3, #82	; 0x52\n",
  " 758:	2354      	movs	r3, #84	; 0x54\n",
  " 75a:	2356      	movs	r3, #86	; 0x56\n",
  " 75c:	2358      	movs	r3, #88	; 0x58\n",
  " 75e:	235a      	movs	r3, #90	; 0x5a\n",
  " 760:	235c      	movs	r3, #92	; 0x5c\n",
  " 762:	235e      	movs	r3, #94	; 0x5e\n",
  " 764:	2360      	movs	r3, #96	; 0x60\n",
  " 766:	2362      	movs	r3, #98	; 0x62\n",
  " 768:	2364      	movs	r3, #100	; 0x64\n",
  " 76a:	2366      	movs	r3, #102	; 0x66\n",
  " 76c:	2368      	movs	r3, #104	; 0x68\n",
  " 76e:	236a      	movs	r3, #106	; 0x6a\n",
  " 770:	236c      	movs	r3, #108	; 0x6c\n",
  " 772:	236e      	movs	r3, #110	; 0x6e\n",
  " 774:	2370      	movs	r3, #112	; 0x70\n",
  " 776:	2372      	movs	r3, #114	; 0x72\n",
  " 778:	2374      	movs	r3, #116	; 0x74\n",
  " 77a:	2376      	movs	r3, #118	; 0x76\n",
  " 77c:	2378      	movs	r3, #120	; 0x78\n",
  " 77e:	237a      	movs	r3, #122	; 0x7a\n",
  " 780:	237c      	movs	r3, #124	; 0x7c\n",
  " 782:	237e      	movs	r3, #126	; 0x7e\n",
  " 784:	2380      	movs	r3, #128	; 0x80\n",
  " 786:	2382      	movs	r3, #130	; 0x82\n",
  " 788:	2384      	movs	r3, #132	; 0x84\n",
  " 78a:	2386      	movs	r3, #134	; 0x86\n",
  " 78c:	2388      	movs	r3, #136	; 0x88\n",
  " 78e:	238a      	movs	r3, #138	; 0x8a\n",
  " 790:	238c      	movs	r3, #140	; 0x8c\n",
  " 792:	238e      	movs	r3, #142	; 0x8e\n",
  " 794:	2390      	movs	r3, #144	; 0x90\n",
  " 796:	2392      	movs	r3, #146	; 0x92\n",
  " 798:	2394      	movs	r3, #148	; 0x94\n",
  " 79a:	2396      	movs	r3, #150	; 0x96\n",
  " 79c:	2398      	movs	r3, #152	; 0x98\n",
  " 79e:	239a      	movs	r3, #154	; 0x9a\n",
  " 7a0:	239c      	movs	r3, #156	; 0x9c\n",
  " 7a2:	239e      	movs	r3, #158	; 0x9e\n",
  " 7a4:	23a0      	movs	r3, #160	; 0xa0\n",
  " 7a6:	23a2      	movs	r3, #162	; 0xa2\n",
  " 7a8:	23a4      	movs	r3, #164	; 0xa4\n",
  " 7aa:	23a6      	movs	r3, #166	; 0xa6\n",
  " 7ac:	23a8      	movs	r3, #168	; 0xa8\n",
  " 7ae:	23aa      	movs	r3, #170	; 0xaa\n",
  " 7b0:	23ac      	movs	r3, #172	; 0xac\n",
  " 7b2:	23ae      	movs	r3, #174	; 0xae\n",
  " 7b4:	23b0      	movs	r3, #176	; 0xb0\n",
  " 7b6:	23b2      	movs	r3, #178	; 0xb2\n",
  " 7b8:	23b4      	movs	r3, #180	; 0xb4\n",
  " 7ba:	23b6      	movs	r3, #182	; 0xb6\n",
  " 7bc:	23b8      	movs	r3, #184	; 0xb8\n",
  " 7be:	23ba      	movs	r3, #186	; 0xba\n",
  " 7c0:	23bc      	movs	r3, #188	; 0xbc\n",
  " 7c2:	23be      	movs	r3, #190	; 0xbe\n",
  " 7c4:	23c0      	movs	r3, #192	; 0xc0\n",
  " 7c6:	23c2      	movs	r3, #194	; 0xc2\n",
  " 7c8:	23c4      	movs	r3, #196	; 0xc4\n",
  " 7ca:	23c6      	movs	r3, #198	; 0xc6\n",
  " 7cc:	23c8      	movs	r3, #200	; 0xc8\n",
  " 7ce:	23ca      	movs	r3, #202	; 0xca\n",
  " 7d0:	23cc      	movs	r3, #204	; 0xcc\n",
  " 7d2:	23ce      	movs	r3, #206	; 0xce\n",
  " 7d4:	23d0      	movs	r3, #208	; 0xd0\n",
  " 7d6:	23d2      	movs	r3, #210	; 0xd2\n",
  " 7d8:	23d4      	movs	r3, #212	; 0xd4\n",
  " 7da:	23d6      	movs	r3, #214	; 0xd6\n",
  " 7dc:	23d8      	movs	r3, #216	; 0xd8\n",
  " 7de:	23da      	movs	r3, #218	; 0xda\n",
  " 7e0:	23dc      	movs	r3, #220	; 0xdc\n",
  " 7e2:	23de      	movs	r3, #222	; 0xde\n",
  " 7e4:	23e0      	movs	r3, #224	; 0xe0\n",
  " 7e6:	23e2      	movs	r3, #226	; 0xe2\n",
  " 7e8:	23e4      	movs	r3, #228	; 0xe4\n",
  " 7ea:	23e6      	movs	r3, #230	; 0xe6\n",
  " 7ec:	23e8      	movs	r3, #232	; 0xe8\n",
  " 7ee:	23ea      	movs	r3, #234	; 0xea\n",
  " 7f0:	23ec      	movs	r3, #236	; 0xec\n",
  " 7f2:	23ee      	movs	r3, #238	; 0xee\n",
  " 7f4:	23f0      	movs	r3, #240	; 0xf0\n",
  " 7f6:	23f2      	movs	r3, #242	; 0xf2\n",
  " 7f8:	23f4      	movs	r3, #244	; 0xf4\n",
  " 7fa:	23f6      	movs	r3, #246	; 0xf6\n",
  " 7fc:	23f8      	movs	r3, #248	; 0xf8\n",
  " 7fe:	23fa      	movs	r3, #250	; 0xfa\n",
  " 800:	23fc      	movs	r3, #252	; 0xfc\n",
  " 802:	23fe      	movs	r3, #254	; 0xfe\n",
  " 804:	2300      	movs	r3, #0\n",
  " 806:	f7ff bbfd 	b.w	4 <MixedBranch32+0x4>\n",
  " 80a:	4611      	mov	r1, r2\n",
  nullptr
};
const char* ShiftsResults[] = {
  "   0:	0148      	lsls	r0, r1, #5\n",
  "   2:	0948      	lsrs	r0, r1, #5\n",
  "   4:	1148      	asrs	r0, r1, #5\n",
  "   6:	4088      	lsls	r0, r1\n",
  "   8:	40c8      	lsrs	r0, r1\n",
  "   a:	4108      	asrs	r0, r1\n",
  "   c:	41c8      	rors	r0, r1\n",
  "   e:	0148      	lsls	r0, r1, #5\n",
  "  10:	0948      	lsrs	r0, r1, #5\n",
  "  12:	1148      	asrs	r0, r1, #5\n",
  "  14:	4088      	lsls	r0, r1\n",
  "  16:	40c8      	lsrs	r0, r1\n",
  "  18:	4108      	asrs	r0, r1\n",
  "  1a:	41c8      	rors	r0, r1\n",
  "  1c:	ea4f 1041 	mov.w	r0, r1, lsl #5\n",
  "  20:	ea4f 1051 	mov.w	r0, r1, lsr #5\n",
  "  24:	ea4f 1061 	mov.w	r0, r1, asr #5\n",
  "  28:	fa00 f001 	lsl.w	r0, r0, r1\n",
  "  2c:	fa20 f001 	lsr.w	r0, r0, r1\n",
  "  30:	fa40 f001 	asr.w	r0, r0, r1\n",
  "  34:	fa60 f001 	ror.w	r0, r0, r1\n",
  "  38:	ea4f 1071 	mov.w	r0, r1, ror #5\n",
  "  3c:	ea5f 1071 	movs.w	r0, r1, ror #5\n",
  "  40:	ea4f 1071 	mov.w	r0, r1, ror #5\n",
  "  44:	ea4f 1841 	mov.w	r8, r1, lsl #5\n",
  "  48:	ea4f 1058 	mov.w	r0, r8, lsr #5\n",
  "  4c:	ea4f 1861 	mov.w	r8, r1, asr #5\n",
  "  50:	ea4f 1078 	mov.w	r0, r8, ror #5\n",
  "  54:	fa01 f002 	lsl.w	r0, r1, r2\n",
  "  58:	fa21 f002 	lsr.w	r0, r1, r2\n",
  "  5c:	fa41 f002 	asr.w	r0, r1, r2\n",
  "  60:	fa61 f002 	ror.w	r0, r1, r2\n",
  "  64:	fa01 f802 	lsl.w	r8, r1, r2\n",
  "  68:	fa28 f002 	lsr.w	r0, r8, r2\n",
  "  6c:	fa41 f008 	asr.w	r0, r1, r8\n",
  "  70:	ea5f 1841 	movs.w	r8, r1, lsl #5\n",
  "  74:	ea5f 1058 	movs.w	r0, r8, lsr #5\n",
  "  78:	ea5f 1861 	movs.w	r8, r1, asr #5\n",
  "  7c:	ea5f 1078 	movs.w	r0, r8, ror #5\n",
  "  80:	fa11 f002 	lsls.w	r0, r1, r2\n",
  "  84:	fa31 f002 	lsrs.w	r0, r1, r2\n",
  "  88:	fa51 f002 	asrs.w	r0, r1, r2\n",
  "  8c:	fa71 f002 	rors.w	r0, r1, r2\n",
  "  90:	fa11 f802 	lsls.w	r8, r1, r2\n",
  "  94:	fa38 f002 	lsrs.w	r0, r8, r2\n",
  "  98:	fa51 f008 	asrs.w	r0, r1, r8\n",
  nullptr
};
const char* LoadStoreRegOffsetResults[] = {
  "   0:	5888      	ldr	r0, [r1, r2]\n",
  "   2:	5088      	str	r0, [r1, r2]\n",
  "   4:	f851 0012 	ldr.w	r0, [r1, r2, lsl #1]\n",
  "   8:	f841 0012 	str.w	r0, [r1, r2, lsl #1]\n",
  "   c:	f851 0032 	ldr.w	r0, [r1, r2, lsl #3]\n",
  "  10:	f841 0032 	str.w	r0, [r1, r2, lsl #3]\n",
  "  14:	f851 8002 	ldr.w	r8, [r1, r2]\n",
  "  18:	f841 8002 	str.w	r8, [r1, r2]\n",
  "  1c:	f858 1002 	ldr.w	r1, [r8, r2]\n",
  "  20:	f848 2002 	str.w	r2, [r8, r2]\n",
  "  24:	f851 0008 	ldr.w	r0, [r1, r8]\n",
  "  28:	f841 0008 	str.w	r0, [r1, r8]\n",
  nullptr
};
const char* LoadStoreLiteralResults[] = {
  "   0:   4801            ldr     r0, [pc, #4]    ; (8 <LoadStoreLiteral+0x8>)\n",
  "   2:   f8cf 0004       str.w   r0, [pc, #4]    ; 8 <LoadStoreLiteral+0x8>\n",
  "   6:   f85f 0008       ldr.w   r0, [pc, #-8]   ; 0 <LoadStoreLiteral>\n",
  "   a:   f84f 0008       str.w   r0, [pc, #-8]   ; 4 <LoadStoreLiteral+0x4>\n",
  "   e:   48ff            ldr     r0, [pc, #1020] ; (40c <LoadStoreLiteral+0x40c>)\n",
  "  10:   f8df 07ff       ldr.w   r0, [pc, #2047] ; 813 <LoadStoreLiteral+0x813>\n",
  "  14:   f8cf 03ff       str.w   r0, [pc, #1023] ; 417 <LoadStoreLiteral+0x417>\n",
  "  18:   f8cf 07ff       str.w   r0, [pc, #2047] ; 81b <LoadStoreLiteral+0x81b>\n",
  nullptr
};
const char* LoadStoreLimitsResults[] = {
  "   0:   6fe0            ldr     r0, [r4, #124]  ; 0x7c\n",
  "   2:   f8d4 0080       ldr.w   r0, [r4, #128]  ; 0x80\n",
  "   6:   7fe0            ldrb    r0, [r4, #31]\n",
  "   8:   f894 0020       ldrb.w  r0, [r4, #32]\n",
  "   c:   8fe0            ldrh    r0, [r4, #62]   ; 0x3e\n",
  "   e:   f8b4 0040       ldrh.w  r0, [r4, #64]   ; 0x40\n",
  "  12:   f994 001f       ldrsb.w r0, [r4, #31]\n",
  "  16:   f994 0020       ldrsb.w r0, [r4, #32]\n",
  "  1a:   f9b4 003e       ldrsh.w r0, [r4, #62]   ; 0x3e\n",
  "  1e:   f9b4 0040       ldrsh.w r0, [r4, #64]   ; 0x40\n",
  "  22:   67e0            str     r0, [r4, #124]  ; 0x7c\n",
  "  24:   f8c4 0080       str.w   r0, [r4, #128]  ; 0x80\n",
  "  28:   77e0            strb    r0, [r4, #31]\n",
  "  2a:   f884 0020       strb.w  r0, [r4, #32]\n",
  "  2e:   87e0            strh    r0, [r4, #62]   ; 0x3e\n",
  "  30:   f8a4 0040       strh.w  r0, [r4, #64]   ; 0x40\n",
  nullptr
};
const char* CompareAndBranchResults[] = {
  "  0: b130        cbz r0, 10 <CompareAndBranch+0x10>\n",
  "  2: f1bb 0f00   cmp.w fp, #0\n",
  "  6: d003        beq.n 10 <CompareAndBranch+0x10>\n",
  "  8: b910        cbnz r0, 10 <CompareAndBranch+0x10>\n",
  "  a: f1bb 0f00   cmp.w fp, #0\n",
  "  e: d1ff        bne.n 10 <CompareAndBranch+0x10>\n",
  nullptr
};

std::map<std::string, const char* const*> test_results;
void setup_results() {
    test_results["SimpleMov"] = SimpleMovResults;
    test_results["SimpleMov32"] = SimpleMov32Results;
    test_results["SimpleMovAdd"] = SimpleMovAddResults;
    test_results["DataProcessingRegister"] = DataProcessingRegisterResults;
    test_results["DataProcessingImmediate"] = DataProcessingImmediateResults;
    test_results["DataProcessingModifiedImmediate"] = DataProcessingModifiedImmediateResults;
    test_results["DataProcessingModifiedImmediates"] = DataProcessingModifiedImmediatesResults;
    test_results["DataProcessingShiftedRegister"] = DataProcessingShiftedRegisterResults;
    test_results["ShiftImmediate"] = ShiftImmediateResults;
    test_results["BasicLoad"] = BasicLoadResults;
    test_results["BasicStore"] = BasicStoreResults;
    test_results["ComplexLoad"] = ComplexLoadResults;
    test_results["ComplexStore"] = ComplexStoreResults;
    test_results["NegativeLoadStore"] = NegativeLoadStoreResults;
    test_results["SimpleLoadStoreDual"] = SimpleLoadStoreDualResults;
    test_results["ComplexLoadStoreDual"] = ComplexLoadStoreDualResults;
    test_results["NegativeLoadStoreDual"] = NegativeLoadStoreDualResults;
    test_results["SimpleBranch"] = SimpleBranchResults;
    test_results["LongBranch"] = LongBranchResults;
    test_results["LoadMultiple"] = LoadMultipleResults;
    test_results["StoreMultiple"] = StoreMultipleResults;
    test_results["MovWMovT"] = MovWMovTResults;
    test_results["SpecialAddSub"] = SpecialAddSubResults;
    test_results["LoadFromOffset"] = LoadFromOffsetResults;
    test_results["StoreToOffset"] = StoreToOffsetResults;
    test_results["IfThen"] = IfThenResults;
    test_results["CbzCbnz"] = CbzCbnzResults;
    test_results["Multiply"] = MultiplyResults;
    test_results["Divide"] = DivideResults;
    test_results["VMov"] = VMovResults;
    test_results["BasicFloatingPoint"] = BasicFloatingPointResults;
    test_results["FloatingPointConversions"] = FloatingPointConversionsResults;
    test_results["FloatingPointComparisons"] = FloatingPointComparisonsResults;
    test_results["Calls"] = CallsResults;
    test_results["Breakpoint"] = BreakpointResults;
    test_results["StrR1"] = StrR1Results;
    test_results["VPushPop"] = VPushPopResults;
    test_results["Max16BitBranch"] = Max16BitBranchResults;
    test_results["Branch32"] = Branch32Results;
    test_results["CompareAndBranchMax"] = CompareAndBranchMaxResults;
    test_results["CompareAndBranchRelocation16"] = CompareAndBranchRelocation16Results;
    test_results["CompareAndBranchRelocation32"] = CompareAndBranchRelocation32Results;
    test_results["MixedBranch32"] = MixedBranch32Results;
    test_results["Shifts"] = ShiftsResults;
    test_results["LoadStoreRegOffset"] = LoadStoreRegOffsetResults;
    test_results["LoadStoreLiteral"] = LoadStoreLiteralResults;
    test_results["LoadStoreLimits"] = LoadStoreLimitsResults;
    test_results["CompareAndBranch"] = CompareAndBranchResults;
}
