/*
 * Copyright (C) 2011 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef ART_COMPILER_DEX_COMPILER_IR_H_
#define ART_COMPILER_DEX_COMPILER_IR_H_

#include <vector>
#include <llvm/IR/Module.h>
#include "arena_allocator.h"
#include "backend.h"
#include "compiler_enums.h"
#include "dex/quick/mir_to_lir.h"
#include "dex_instruction.h"
#include "driver/compiler_driver.h"
#include "driver/dex_compilation_unit.h"
#include "llvm/intrinsic_helper.h"
#include "llvm/ir_builder.h"
#include "safe_map.h"

namespace art {

class LLVMInfo;
namespace llvm {
class LlvmCompilationUnit;
}  // namespace llvm

struct ArenaMemBlock;
struct Memstats;
class MIRGraph;
class Mir2Lir;

struct CompilationUnit {
  CompilationUnit()
    : compiler_driver(NULL),
      class_linker(NULL),
      dex_file(NULL),
      class_loader(NULL),
      class_def_idx(0),
      method_idx(0),
      code_item(NULL),
      access_flags(0),
      invoke_type(kDirect),
      shorty(NULL),
      disable_opt(0),
      enable_debug(0),
      verbose(false),
      compiler_backend(kNoBackend),
      instruction_set(kNone),
      num_dalvik_registers(0),
      insns(NULL),
      num_ins(0),
      num_outs(0),
      num_regs(0),
      num_compiler_temps(0),
      compiler_flip_match(false),
      mir_graph(NULL),
      cg(NULL) {}
  /*
   * Fields needed/generated by common frontend and generally used throughout
   * the compiler.
  */
  CompilerDriver* compiler_driver;
  ClassLinker* class_linker;           // Linker to resolve fields and methods.
  const DexFile* dex_file;             // DexFile containing the method being compiled.
  jobject class_loader;                // compiling method's class loader.
  uint32_t class_def_idx;              // compiling method's defining class definition index.
  uint32_t method_idx;                 // compiling method's index into method_ids of DexFile.
  const DexFile::CodeItem* code_item;  // compiling method's DexFile code_item.
  uint32_t access_flags;               // compiling method's access flags.
  InvokeType invoke_type;              // compiling method's invocation type.
  const char* shorty;                  // compiling method's shorty.
  uint32_t disable_opt;                // opt_control_vector flags.
  uint32_t enable_debug;               // debugControlVector flags.
  bool verbose;
  CompilerBackend compiler_backend;
  InstructionSet instruction_set;

  // TODO: much of this info available elsewhere.  Go to the original source?
  int num_dalvik_registers;        // method->registers_size.
  const uint16_t* insns;
  int num_ins;
  int num_outs;
  int num_regs;            // Unlike num_dalvik_registers, does not include ins.

  // TODO: may want to move this to MIRGraph.
  int num_compiler_temps;

  // If non-empty, apply optimizer/debug flags only to matching methods.
  std::string compiler_method_match;
  // Flips sense of compiler_method_match - apply flags if doesn't match.
  bool compiler_flip_match;

  // TODO: move memory management to mir_graph, or just switch to using standard containers.
  ArenaAllocator arena;

  UniquePtr<MIRGraph> mir_graph;   // MIR container.
  UniquePtr<Backend> cg;           // Target-specific codegen.
};

}  // namespace art

#endif  // ART_COMPILER_DEX_COMPILER_IR_H_
