static constexpr uint8_t expected_asm_kThumb2[] = {
    0x2D, 0xE9, 0xE0, 0x4D, 0x2D, 0xED, 0x10, 0x8A, 0x89, 0xB0, 0x00, 0x90,
    0xCD, 0xF8, 0x84, 0x10, 0x8D, 0xED, 0x22, 0x0A, 0xCD, 0xF8, 0x8C, 0x20,
    0xCD, 0xF8, 0x90, 0x30, 0x88, 0xB0, 0x08, 0xB0, 0x09, 0xB0, 0xBD, 0xEC,
    0x10, 0x8A, 0xBD, 0xE8, 0xE0, 0x8D,
};
static constexpr uint8_t expected_cfi_kThumb2[] = {
    0x44, 0x0E, 0x1C, 0x85, 0x07, 0x86, 0x06, 0x87, 0x05, 0x88, 0x04, 0x8A,
    0x03, 0x8B, 0x02, 0x8E, 0x01, 0x44, 0x0E, 0x5C, 0x05, 0x50, 0x17, 0x05,
    0x51, 0x16, 0x05, 0x52, 0x15, 0x05, 0x53, 0x14, 0x05, 0x54, 0x13, 0x05,
    0x55, 0x12, 0x05, 0x56, 0x11, 0x05, 0x57, 0x10, 0x05, 0x58, 0x0F, 0x05,
    0x59, 0x0E, 0x05, 0x5A, 0x0D, 0x05, 0x5B, 0x0C, 0x05, 0x5C, 0x0B, 0x05,
    0x5D, 0x0A, 0x05, 0x5E, 0x09, 0x05, 0x5F, 0x08, 0x42, 0x0E, 0x80, 0x01,
    0x54, 0x0E, 0xA0, 0x01, 0x42, 0x0E, 0x80, 0x01, 0x0A, 0x42, 0x0E, 0x5C,
    0x44, 0x0E, 0x1C, 0x06, 0x50, 0x06, 0x51, 0x06, 0x52, 0x06, 0x53, 0x06,
    0x54, 0x06, 0x55, 0x06, 0x56, 0x06, 0x57, 0x06, 0x58, 0x06, 0x59, 0x06,
    0x5A, 0x06, 0x5B, 0x06, 0x5C, 0x06, 0x5D, 0x06, 0x5E, 0x06, 0x5F, 0x44,
    0x0B, 0x0E, 0x80, 0x01,
};
// 0x00000000: push {r5, r6, r7, r8, r10, r11, lr}
// 0x00000004: .cfi_def_cfa_offset: 28
// 0x00000004: .cfi_offset: r5 at cfa-28
// 0x00000004: .cfi_offset: r6 at cfa-24
// 0x00000004: .cfi_offset: r7 at cfa-20
// 0x00000004: .cfi_offset: r8 at cfa-16
// 0x00000004: .cfi_offset: r10 at cfa-12
// 0x00000004: .cfi_offset: r11 at cfa-8
// 0x00000004: .cfi_offset: r14 at cfa-4
// 0x00000004: vpush.f32 {s16-s31}
// 0x00000008: .cfi_def_cfa_offset: 92
// 0x00000008: .cfi_offset_extended: r80 at cfa-92
// 0x00000008: .cfi_offset_extended: r81 at cfa-88
// 0x00000008: .cfi_offset_extended: r82 at cfa-84
// 0x00000008: .cfi_offset_extended: r83 at cfa-80
// 0x00000008: .cfi_offset_extended: r84 at cfa-76
// 0x00000008: .cfi_offset_extended: r85 at cfa-72
// 0x00000008: .cfi_offset_extended: r86 at cfa-68
// 0x00000008: .cfi_offset_extended: r87 at cfa-64
// 0x00000008: .cfi_offset_extended: r88 at cfa-60
// 0x00000008: .cfi_offset_extended: r89 at cfa-56
// 0x00000008: .cfi_offset_extended: r90 at cfa-52
// 0x00000008: .cfi_offset_extended: r91 at cfa-48
// 0x00000008: .cfi_offset_extended: r92 at cfa-44
// 0x00000008: .cfi_offset_extended: r93 at cfa-40
// 0x00000008: .cfi_offset_extended: r94 at cfa-36
// 0x00000008: .cfi_offset_extended: r95 at cfa-32
// 0x00000008: sub sp, sp, #36
// 0x0000000a: .cfi_def_cfa_offset: 128
// 0x0000000a: str r0, [sp, #0]
// 0x0000000c: str.w r1, [sp, #132]
// 0x00000010: vstr.f32 s0, [sp, #136]
// 0x00000014: str.w r2, [sp, #140]
// 0x00000018: str.w r3, [sp, #144]
// 0x0000001c: sub sp, sp, #32
// 0x0000001e: .cfi_def_cfa_offset: 160
// 0x0000001e: add sp, sp, #32
// 0x00000020: .cfi_def_cfa_offset: 128
// 0x00000020: .cfi_remember_state
// 0x00000020: add sp, sp, #36
// 0x00000022: .cfi_def_cfa_offset: 92
// 0x00000022: vpop.f32 {s16-s31}
// 0x00000026: .cfi_def_cfa_offset: 28
// 0x00000026: .cfi_restore_extended: r80
// 0x00000026: .cfi_restore_extended: r81
// 0x00000026: .cfi_restore_extended: r82
// 0x00000026: .cfi_restore_extended: r83
// 0x00000026: .cfi_restore_extended: r84
// 0x00000026: .cfi_restore_extended: r85
// 0x00000026: .cfi_restore_extended: r86
// 0x00000026: .cfi_restore_extended: r87
// 0x00000026: .cfi_restore_extended: r88
// 0x00000026: .cfi_restore_extended: r89
// 0x00000026: .cfi_restore_extended: r90
// 0x00000026: .cfi_restore_extended: r91
// 0x00000026: .cfi_restore_extended: r92
// 0x00000026: .cfi_restore_extended: r93
// 0x00000026: .cfi_restore_extended: r94
// 0x00000026: .cfi_restore_extended: r95
// 0x00000026: pop {r5, r6, r7, r8, r10, r11, pc}
// 0x0000002a: .cfi_restore_state
// 0x0000002a: .cfi_def_cfa_offset: 128

static constexpr uint8_t expected_asm_kArm64[] = {
    0xFF, 0x03, 0x03, 0xD1, 0xF3, 0x53, 0x06, 0xA9, 0xF5, 0x5B, 0x07, 0xA9,
    0xF7, 0x63, 0x08, 0xA9, 0xF9, 0x6B, 0x09, 0xA9, 0xFB, 0x73, 0x0A, 0xA9,
    0xFD, 0x7B, 0x0B, 0xA9, 0xE8, 0x27, 0x02, 0x6D, 0xEA, 0x2F, 0x03, 0x6D,
    0xEC, 0x37, 0x04, 0x6D, 0xEE, 0x3F, 0x05, 0x6D, 0xF5, 0x03, 0x12, 0xAA,
    0xE0, 0x03, 0x00, 0xB9, 0xE1, 0xC7, 0x00, 0xB9, 0xE0, 0xCB, 0x00, 0xBD,
    0xE2, 0xCF, 0x00, 0xB9, 0xE3, 0xD3, 0x00, 0xB9, 0xFF, 0x83, 0x00, 0xD1,
    0xFF, 0x83, 0x00, 0x91, 0xF2, 0x03, 0x15, 0xAA, 0xF3, 0x53, 0x46, 0xA9,
    0xF5, 0x5B, 0x47, 0xA9, 0xF7, 0x63, 0x48, 0xA9, 0xF9, 0x6B, 0x49, 0xA9,
    0xFB, 0x73, 0x4A, 0xA9, 0xFD, 0x7B, 0x4B, 0xA9, 0xE8, 0x27, 0x42, 0x6D,
    0xEA, 0x2F, 0x43, 0x6D, 0xEC, 0x37, 0x44, 0x6D, 0xEE, 0x3F, 0x45, 0x6D,
    0xFF, 0x03, 0x03, 0x91, 0xC0, 0x03, 0x5F, 0xD6,
};
static constexpr uint8_t expected_cfi_kArm64[] = {
    0x44, 0x0E, 0xC0, 0x01, 0x44, 0x93, 0x18, 0x94, 0x16, 0x44, 0x95, 0x14,
    0x96, 0x12, 0x44, 0x97, 0x10, 0x98, 0x0E, 0x44, 0x99, 0x0C, 0x9A, 0x0A,
    0x44, 0x9B, 0x08, 0x9C, 0x06, 0x44, 0x9D, 0x04, 0x9E, 0x02, 0x44, 0x05,
    0x48, 0x28, 0x05, 0x49, 0x26, 0x44, 0x05, 0x4A, 0x24, 0x05, 0x4B, 0x22,
    0x44, 0x05, 0x4C, 0x20, 0x05, 0x4D, 0x1E, 0x44, 0x05, 0x4E, 0x1C, 0x05,
    0x4F, 0x1A, 0x5C, 0x0E, 0xE0, 0x01, 0x44, 0x0E, 0xC0, 0x01, 0x44, 0x0A,
    0x44, 0xD3, 0xD4, 0x44, 0xD5, 0xD6, 0x44, 0xD7, 0xD8, 0x44, 0xD9, 0xDA,
    0x44, 0xDB, 0xDC, 0x44, 0xDD, 0xDE, 0x44, 0x06, 0x48, 0x06, 0x49, 0x44,
    0x06, 0x4A, 0x06, 0x4B, 0x44, 0x06, 0x4C, 0x06, 0x4D, 0x44, 0x06, 0x4E,
    0x06, 0x4F, 0x44, 0x0E, 0x00, 0x44, 0x0B, 0x0E, 0xC0, 0x01,
};
// 0x00000000: sub sp, sp, #0xc0 (192)
// 0x00000004: .cfi_def_cfa_offset: 192
// 0x00000004: stp x19, x20, [sp, #96]
// 0x00000008: .cfi_offset: r19 at cfa-96
// 0x00000008: .cfi_offset: r20 at cfa-88
// 0x00000008: stp x21, x22, [sp, #112]
// 0x0000000c: .cfi_offset: r21 at cfa-80
// 0x0000000c: .cfi_offset: r22 at cfa-72
// 0x0000000c: stp x23, x24, [sp, #128]
// 0x00000010: .cfi_offset: r23 at cfa-64
// 0x00000010: .cfi_offset: r24 at cfa-56
// 0x00000010: stp x25, x26, [sp, #144]
// 0x00000014: .cfi_offset: r25 at cfa-48
// 0x00000014: .cfi_offset: r26 at cfa-40
// 0x00000014: stp x27, x28, [sp, #160]
// 0x00000018: .cfi_offset: r27 at cfa-32
// 0x00000018: .cfi_offset: r28 at cfa-24
// 0x00000018: stp x29, lr, [sp, #176]
// 0x0000001c: .cfi_offset: r29 at cfa-16
// 0x0000001c: .cfi_offset: r30 at cfa-8
// 0x0000001c: stp d8, d9, [sp, #32]
// 0x00000020: .cfi_offset_extended: r72 at cfa-160
// 0x00000020: .cfi_offset_extended: r73 at cfa-152
// 0x00000020: stp d10, d11, [sp, #48]
// 0x00000024: .cfi_offset_extended: r74 at cfa-144
// 0x00000024: .cfi_offset_extended: r75 at cfa-136
// 0x00000024: stp d12, d13, [sp, #64]
// 0x00000028: .cfi_offset_extended: r76 at cfa-128
// 0x00000028: .cfi_offset_extended: r77 at cfa-120
// 0x00000028: stp d14, d15, [sp, #80]
// 0x0000002c: .cfi_offset_extended: r78 at cfa-112
// 0x0000002c: .cfi_offset_extended: r79 at cfa-104
// 0x0000002c: mov x21, tr
// 0x00000030: str w0, [sp]
// 0x00000034: str w1, [sp, #196]
// 0x00000038: str s0, [sp, #200]
// 0x0000003c: str w2, [sp, #204]
// 0x00000040: str w3, [sp, #208]
// 0x00000044: sub sp, sp, #0x20 (32)
// 0x00000048: .cfi_def_cfa_offset: 224
// 0x00000048: add sp, sp, #0x20 (32)
// 0x0000004c: .cfi_def_cfa_offset: 192
// 0x0000004c: mov tr, x21
// 0x00000050: .cfi_remember_state
// 0x00000050: ldp x19, x20, [sp, #96]
// 0x00000054: .cfi_restore: r19
// 0x00000054: .cfi_restore: r20
// 0x00000054: ldp x21, x22, [sp, #112]
// 0x00000058: .cfi_restore: r21
// 0x00000058: .cfi_restore: r22
// 0x00000058: ldp x23, x24, [sp, #128]
// 0x0000005c: .cfi_restore: r23
// 0x0000005c: .cfi_restore: r24
// 0x0000005c: ldp x25, x26, [sp, #144]
// 0x00000060: .cfi_restore: r25
// 0x00000060: .cfi_restore: r26
// 0x00000060: ldp x27, x28, [sp, #160]
// 0x00000064: .cfi_restore: r27
// 0x00000064: .cfi_restore: r28
// 0x00000064: ldp x29, lr, [sp, #176]
// 0x00000068: .cfi_restore: r29
// 0x00000068: .cfi_restore: r30
// 0x00000068: ldp d8, d9, [sp, #32]
// 0x0000006c: .cfi_restore_extended: r72
// 0x0000006c: .cfi_restore_extended: r73
// 0x0000006c: ldp d10, d11, [sp, #48]
// 0x00000070: .cfi_restore_extended: r74
// 0x00000070: .cfi_restore_extended: r75
// 0x00000070: ldp d12, d13, [sp, #64]
// 0x00000074: .cfi_restore_extended: r76
// 0x00000074: .cfi_restore_extended: r77
// 0x00000074: ldp d14, d15, [sp, #80]
// 0x00000078: .cfi_restore_extended: r78
// 0x00000078: .cfi_restore_extended: r79
// 0x00000078: add sp, sp, #0xc0 (192)
// 0x0000007c: .cfi_def_cfa_offset: 0
// 0x0000007c: ret
// 0x00000080: .cfi_restore_state
// 0x00000080: .cfi_def_cfa_offset: 192

static constexpr uint8_t expected_asm_kX86[] = {
    0x57, 0x56, 0x55, 0x83, 0xC4, 0xE4, 0x50, 0x89, 0x4C, 0x24, 0x34, 0xF3,
    0x0F, 0x11, 0x44, 0x24, 0x38, 0x89, 0x54, 0x24, 0x3C, 0x89, 0x5C, 0x24,
    0x40, 0x83, 0xC4, 0xE0, 0x83, 0xC4, 0x20, 0x83, 0xC4, 0x20, 0x5D, 0x5E,
    0x5F, 0xC3,
};
static constexpr uint8_t expected_cfi_kX86[] = {
    0x41, 0x0E, 0x08, 0x87, 0x02, 0x41, 0x0E, 0x0C, 0x86, 0x03, 0x41, 0x0E,
    0x10, 0x85, 0x04, 0x43, 0x0E, 0x2C, 0x41, 0x0E, 0x30, 0x55, 0x0E, 0x50,
    0x43, 0x0E, 0x30, 0x0A, 0x43, 0x0E, 0x10, 0x41, 0x0E, 0x0C, 0xC5, 0x41,
    0x0E, 0x08, 0xC6, 0x41, 0x0E, 0x04, 0xC7, 0x41, 0x0B, 0x0E, 0x30,
};
// 0x00000000: push edi
// 0x00000001: .cfi_def_cfa_offset: 8
// 0x00000001: .cfi_offset: r7 at cfa-8
// 0x00000001: push esi
// 0x00000002: .cfi_def_cfa_offset: 12
// 0x00000002: .cfi_offset: r6 at cfa-12
// 0x00000002: push ebp
// 0x00000003: .cfi_def_cfa_offset: 16
// 0x00000003: .cfi_offset: r5 at cfa-16
// 0x00000003: add esp, -28
// 0x00000006: .cfi_def_cfa_offset: 44
// 0x00000006: push eax
// 0x00000007: .cfi_def_cfa_offset: 48
// 0x00000007: mov [esp + 52], ecx
// 0x0000000b: movss [esp + 56], xmm0
// 0x00000011: mov [esp + 60], edx
// 0x00000015: mov [esp + 64], ebx
// 0x00000019: add esp, -32
// 0x0000001c: .cfi_def_cfa_offset: 80
// 0x0000001c: add esp, 32
// 0x0000001f: .cfi_def_cfa_offset: 48
// 0x0000001f: .cfi_remember_state
// 0x0000001f: add esp, 32
// 0x00000022: .cfi_def_cfa_offset: 16
// 0x00000022: pop ebp
// 0x00000023: .cfi_def_cfa_offset: 12
// 0x00000023: .cfi_restore: r5
// 0x00000023: pop esi
// 0x00000024: .cfi_def_cfa_offset: 8
// 0x00000024: .cfi_restore: r6
// 0x00000024: pop edi
// 0x00000025: .cfi_def_cfa_offset: 4
// 0x00000025: .cfi_restore: r7
// 0x00000025: ret
// 0x00000026: .cfi_restore_state
// 0x00000026: .cfi_def_cfa_offset: 48

static constexpr uint8_t expected_asm_kX86_64[] = {
    0x41, 0x57, 0x41, 0x56, 0x41, 0x55, 0x41, 0x54, 0x55, 0x53, 0x48, 0x83,
    0xEC, 0x48, 0xF2, 0x44, 0x0F, 0x11, 0x7C, 0x24, 0x40, 0xF2, 0x44, 0x0F,
    0x11, 0x74, 0x24, 0x38, 0xF2, 0x44, 0x0F, 0x11, 0x6C, 0x24, 0x30, 0xF2,
    0x44, 0x0F, 0x11, 0x64, 0x24, 0x28, 0x89, 0x3C, 0x24, 0x89, 0xB4, 0x24,
    0x84, 0x00, 0x00, 0x00, 0xF3, 0x0F, 0x11, 0x84, 0x24, 0x88, 0x00, 0x00,
    0x00, 0x89, 0x94, 0x24, 0x8C, 0x00, 0x00, 0x00, 0x89, 0x8C, 0x24, 0x90,
    0x00, 0x00, 0x00, 0x48, 0x83, 0xC4, 0xE0, 0x48, 0x83, 0xC4, 0x20, 0xF2,
    0x44, 0x0F, 0x10, 0x64, 0x24, 0x28, 0xF2, 0x44, 0x0F, 0x10, 0x6C, 0x24,
    0x30, 0xF2, 0x44, 0x0F, 0x10, 0x74, 0x24, 0x38, 0xF2, 0x44, 0x0F, 0x10,
    0x7C, 0x24, 0x40, 0x48, 0x83, 0xC4, 0x48, 0x5B, 0x5D, 0x41, 0x5C, 0x41,
    0x5D, 0x41, 0x5E, 0x41, 0x5F, 0xC3,
};
static constexpr uint8_t expected_cfi_kX86_64[] = {
    0x42, 0x0E, 0x10, 0x8F, 0x04, 0x42, 0x0E, 0x18, 0x8E, 0x06, 0x42, 0x0E,
    0x20, 0x8D, 0x08, 0x42, 0x0E, 0x28, 0x8C, 0x0A, 0x41, 0x0E, 0x30, 0x86,
    0x0C, 0x41, 0x0E, 0x38, 0x83, 0x0E, 0x44, 0x0E, 0x80, 0x01, 0x47, 0xA0,
    0x10, 0x47, 0x9F, 0x12, 0x47, 0x9E, 0x14, 0x47, 0x9D, 0x16, 0x65, 0x0E,
    0xA0, 0x01, 0x44, 0x0E, 0x80, 0x01, 0x0A, 0x47, 0xDD, 0x47, 0xDE, 0x47,
    0xDF, 0x47, 0xE0, 0x44, 0x0E, 0x38, 0x41, 0x0E, 0x30, 0xC3, 0x41, 0x0E,
    0x28, 0xC6, 0x42, 0x0E, 0x20, 0xCC, 0x42, 0x0E, 0x18, 0xCD, 0x42, 0x0E,
    0x10, 0xCE, 0x42, 0x0E, 0x08, 0xCF, 0x41, 0x0B, 0x0E, 0x80, 0x01,
};
// 0x00000000: push r15
// 0x00000002: .cfi_def_cfa_offset: 16
// 0x00000002: .cfi_offset: r15 at cfa-16
// 0x00000002: push r14
// 0x00000004: .cfi_def_cfa_offset: 24
// 0x00000004: .cfi_offset: r14 at cfa-24
// 0x00000004: push r13
// 0x00000006: .cfi_def_cfa_offset: 32
// 0x00000006: .cfi_offset: r13 at cfa-32
// 0x00000006: push r12
// 0x00000008: .cfi_def_cfa_offset: 40
// 0x00000008: .cfi_offset: r12 at cfa-40
// 0x00000008: push rbp
// 0x00000009: .cfi_def_cfa_offset: 48
// 0x00000009: .cfi_offset: r6 at cfa-48
// 0x00000009: push rbx
// 0x0000000a: .cfi_def_cfa_offset: 56
// 0x0000000a: .cfi_offset: r3 at cfa-56
// 0x0000000a: subq rsp, 72
// 0x0000000e: .cfi_def_cfa_offset: 128
// 0x0000000e: movsd [rsp + 64], xmm15
// 0x00000015: .cfi_offset: r32 at cfa-64
// 0x00000015: movsd [rsp + 56], xmm14
// 0x0000001c: .cfi_offset: r31 at cfa-72
// 0x0000001c: movsd [rsp + 48], xmm13
// 0x00000023: .cfi_offset: r30 at cfa-80
// 0x00000023: movsd [rsp + 40], xmm12
// 0x0000002a: .cfi_offset: r29 at cfa-88
// 0x0000002a: mov [rsp], edi
// 0x0000002d: mov [rsp + 132], esi
// 0x00000034: movss [rsp + 136], xmm0
// 0x0000003d: mov [rsp + 140], edx
// 0x00000044: mov [rsp + 144], ecx
// 0x0000004b: addq rsp, -32
// 0x0000004f: .cfi_def_cfa_offset: 160
// 0x0000004f: addq rsp, 32
// 0x00000053: .cfi_def_cfa_offset: 128
// 0x00000053: .cfi_remember_state
// 0x00000053: movsd xmm12, [rsp + 40]
// 0x0000005a: .cfi_restore: r29
// 0x0000005a: movsd xmm13, [rsp + 48]
// 0x00000061: .cfi_restore: r30
// 0x00000061: movsd xmm14, [rsp + 56]
// 0x00000068: .cfi_restore: r31
// 0x00000068: movsd xmm15, [rsp + 64]
// 0x0000006f: .cfi_restore: r32
// 0x0000006f: addq rsp, 72
// 0x00000073: .cfi_def_cfa_offset: 56
// 0x00000073: pop rbx
// 0x00000074: .cfi_def_cfa_offset: 48
// 0x00000074: .cfi_restore: r3
// 0x00000074: pop rbp
// 0x00000075: .cfi_def_cfa_offset: 40
// 0x00000075: .cfi_restore: r6
// 0x00000075: pop r12
// 0x00000077: .cfi_def_cfa_offset: 32
// 0x00000077: .cfi_restore: r12
// 0x00000077: pop r13
// 0x00000079: .cfi_def_cfa_offset: 24
// 0x00000079: .cfi_restore: r13
// 0x00000079: pop r14
// 0x0000007b: .cfi_def_cfa_offset: 16
// 0x0000007b: .cfi_restore: r14
// 0x0000007b: pop r15
// 0x0000007d: .cfi_def_cfa_offset: 8
// 0x0000007d: .cfi_restore: r15
// 0x0000007d: ret
// 0x0000007e: .cfi_restore_state
// 0x0000007e: .cfi_def_cfa_offset: 128

static constexpr uint8_t expected_asm_kMips[] = {
    0xC0, 0xFF, 0xBD, 0x27, 0x3C, 0x00, 0xBF, 0xAF, 0x38, 0x00, 0xB8, 0xAF,
    0x34, 0x00, 0xAF, 0xAF, 0x30, 0x00, 0xAE, 0xAF, 0x2C, 0x00, 0xAD, 0xAF,
    0x28, 0x00, 0xAC, 0xAF, 0x24, 0x00, 0xAB, 0xAF, 0x20, 0x00, 0xAA, 0xAF,
    0x1C, 0x00, 0xA9, 0xAF, 0x18, 0x00, 0xA8, 0xAF, 0x00, 0x00, 0xA4, 0xAF,
    0x44, 0x00, 0xA5, 0xAF, 0x48, 0x00, 0xA6, 0xAF, 0x4C, 0x00, 0xA7, 0xAF,
    0xE0, 0xFF, 0xBD, 0x27, 0x20, 0x00, 0xBD, 0x27, 0x18, 0x00, 0xA8, 0x8F,
    0x1C, 0x00, 0xA9, 0x8F, 0x20, 0x00, 0xAA, 0x8F, 0x24, 0x00, 0xAB, 0x8F,
    0x28, 0x00, 0xAC, 0x8F, 0x2C, 0x00, 0xAD, 0x8F, 0x30, 0x00, 0xAE, 0x8F,
    0x34, 0x00, 0xAF, 0x8F, 0x38, 0x00, 0xB8, 0x8F, 0x3C, 0x00, 0xBF, 0x8F,
    0x40, 0x00, 0xBD, 0x27, 0x09, 0x00, 0xE0, 0x03, 0x00, 0x00, 0x00, 0x00,
};
static constexpr uint8_t expected_cfi_kMips[] = {
    0x44, 0x0E, 0x40, 0x44, 0x9F, 0x01, 0x44, 0x98, 0x02, 0x44, 0x8F, 0x03,
    0x44, 0x8E, 0x04, 0x44, 0x8D, 0x05, 0x44, 0x8C, 0x06, 0x44, 0x8B, 0x07,
    0x44, 0x8A, 0x08, 0x44, 0x89, 0x09, 0x44, 0x88, 0x0A, 0x54, 0x0E, 0x60,
    0x44, 0x0E, 0x40, 0x0A, 0x44, 0xC8, 0x44, 0xC9, 0x44, 0xCA, 0x44, 0xCB,
    0x44, 0xCC, 0x44, 0xCD, 0x44, 0xCE, 0x44, 0xCF, 0x44, 0xD8, 0x44, 0xDF,
    0x44, 0x0E, 0x00, 0x48, 0x0B, 0x0E, 0x40,
};
// 0x00000000: addiu r29, r29, -64
// 0x00000004: .cfi_def_cfa_offset: 64
// 0x00000004: sw r31, +60(r29)
// 0x00000008: .cfi_offset: r31 at cfa-4
// 0x00000008: sw r24, +56(r29)
// 0x0000000c: .cfi_offset: r24 at cfa-8
// 0x0000000c: sw r15, +52(r29)
// 0x00000010: .cfi_offset: r15 at cfa-12
// 0x00000010: sw r14, +48(r29)
// 0x00000014: .cfi_offset: r14 at cfa-16
// 0x00000014: sw r13, +44(r29)
// 0x00000018: .cfi_offset: r13 at cfa-20
// 0x00000018: sw r12, +40(r29)
// 0x0000001c: .cfi_offset: r12 at cfa-24
// 0x0000001c: sw r11, +36(r29)
// 0x00000020: .cfi_offset: r11 at cfa-28
// 0x00000020: sw r10, +32(r29)
// 0x00000024: .cfi_offset: r10 at cfa-32
// 0x00000024: sw r9, +28(r29)
// 0x00000028: .cfi_offset: r9 at cfa-36
// 0x00000028: sw r8, +24(r29)
// 0x0000002c: .cfi_offset: r8 at cfa-40
// 0x0000002c: sw r4, +0(r29)
// 0x00000030: sw r5, +68(r29)
// 0x00000034: sw r6, +72(r29)
// 0x00000038: sw r7, +76(r29)
// 0x0000003c: addiu r29, r29, -32
// 0x00000040: .cfi_def_cfa_offset: 96
// 0x00000040: addiu r29, r29, 32
// 0x00000044: .cfi_def_cfa_offset: 64
// 0x00000044: .cfi_remember_state
// 0x00000044: lw r8, +24(r29)
// 0x00000048: .cfi_restore: r8
// 0x00000048: lw r9, +28(r29)
// 0x0000004c: .cfi_restore: r9
// 0x0000004c: lw r10, +32(r29)
// 0x00000050: .cfi_restore: r10
// 0x00000050: lw r11, +36(r29)
// 0x00000054: .cfi_restore: r11
// 0x00000054: lw r12, +40(r29)
// 0x00000058: .cfi_restore: r12
// 0x00000058: lw r13, +44(r29)
// 0x0000005c: .cfi_restore: r13
// 0x0000005c: lw r14, +48(r29)
// 0x00000060: .cfi_restore: r14
// 0x00000060: lw r15, +52(r29)
// 0x00000064: .cfi_restore: r15
// 0x00000064: lw r24, +56(r29)
// 0x00000068: .cfi_restore: r24
// 0x00000068: lw r31, +60(r29)
// 0x0000006c: .cfi_restore: r31
// 0x0000006c: addiu r29, r29, 64
// 0x00000070: .cfi_def_cfa_offset: 0
// 0x00000070: jalr r0, r31
// 0x00000074: nop
// 0x00000078: .cfi_restore_state
// 0x00000078: .cfi_def_cfa_offset: 64

static constexpr uint8_t expected_asm_kMips64[] = {
    0xA0, 0xFF, 0xBD, 0x67, 0x58, 0x00, 0xBF, 0xFF, 0x50, 0x00, 0xBE, 0xFF,
    0x48, 0x00, 0xBC, 0xFF, 0x40, 0x00, 0xB7, 0xFF, 0x38, 0x00, 0xB6, 0xFF,
    0x30, 0x00, 0xB5, 0xFF, 0x28, 0x00, 0xB4, 0xFF, 0x20, 0x00, 0xB3, 0xFF,
    0x18, 0x00, 0xB2, 0xFF, 0x00, 0x00, 0xA4, 0xAF, 0x64, 0x00, 0xA5, 0xAF,
    0x68, 0x00, 0xAE, 0xE7, 0x6C, 0x00, 0xA7, 0xAF, 0x70, 0x00, 0xA8, 0xAF,
    0xE0, 0xFF, 0xBD, 0x67, 0x20, 0x00, 0xBD, 0x67, 0x18, 0x00, 0xB2, 0xDF,
    0x20, 0x00, 0xB3, 0xDF, 0x28, 0x00, 0xB4, 0xDF, 0x30, 0x00, 0xB5, 0xDF,
    0x38, 0x00, 0xB6, 0xDF, 0x40, 0x00, 0xB7, 0xDF, 0x48, 0x00, 0xBC, 0xDF,
    0x50, 0x00, 0xBE, 0xDF, 0x58, 0x00, 0xBF, 0xDF, 0x60, 0x00, 0xBD, 0x67,
    0x09, 0x00, 0xE0, 0x03, 0x00, 0x00, 0x00, 0x00,
};
static constexpr uint8_t expected_cfi_kMips64[] = {
    0x44, 0x0E, 0x60, 0x44, 0x9F, 0x02, 0x44, 0x9E, 0x04, 0x44, 0x9C, 0x06,
    0x44, 0x97, 0x08, 0x44, 0x96, 0x0A, 0x44, 0x95, 0x0C, 0x44, 0x94, 0x0E,
    0x44, 0x93, 0x10, 0x44, 0x92, 0x12, 0x58, 0x0E, 0x80, 0x01, 0x44, 0x0E,
    0x60, 0x0A, 0x44, 0xD2, 0x44, 0xD3, 0x44, 0xD4, 0x44, 0xD5, 0x44, 0xD6,
    0x44, 0xD7, 0x44, 0xDC, 0x44, 0xDE, 0x44, 0xDF, 0x44, 0x0E, 0x00, 0x48,
    0x0B, 0x0E, 0x60,
};
// 0x00000000: daddiu r29, r29, -96
// 0x00000004: .cfi_def_cfa_offset: 96
// 0x00000004: sd r31, +88(r29)
// 0x00000008: .cfi_offset: r31 at cfa-8
// 0x00000008: sd r30, +80(r29)
// 0x0000000c: .cfi_offset: r30 at cfa-16
// 0x0000000c: sd r28, +72(r29)
// 0x00000010: .cfi_offset: r28 at cfa-24
// 0x00000010: sd r23, +64(r29)
// 0x00000014: .cfi_offset: r23 at cfa-32
// 0x00000014: sd r22, +56(r29)
// 0x00000018: .cfi_offset: r22 at cfa-40
// 0x00000018: sd r21, +48(r29)
// 0x0000001c: .cfi_offset: r21 at cfa-48
// 0x0000001c: sd r20, +40(r29)
// 0x00000020: .cfi_offset: r20 at cfa-56
// 0x00000020: sd r19, +32(r29)
// 0x00000024: .cfi_offset: r19 at cfa-64
// 0x00000024: sd r18, +24(r29)
// 0x00000028: .cfi_offset: r18 at cfa-72
// 0x00000028: sw r4, +0(r29)
// 0x0000002c: sw r5, +100(r29)
// 0x00000030: swc1 f14, +104(r29)
// 0x00000034: sw r7, +108(r29)
// 0x00000038: sw r8, +112(r29)
// 0x0000003c: daddiu r29, r29, -32
// 0x00000040: .cfi_def_cfa_offset: 128
// 0x00000040: daddiu r29, r29, 32
// 0x00000044: .cfi_def_cfa_offset: 96
// 0x00000044: .cfi_remember_state
// 0x00000044: ld r18, +24(r29)
// 0x00000048: .cfi_restore: r18
// 0x00000048: ld r19, +32(r29)
// 0x0000004c: .cfi_restore: r19
// 0x0000004c: ld r20, +40(r29)
// 0x00000050: .cfi_restore: r20
// 0x00000050: ld r21, +48(r29)
// 0x00000054: .cfi_restore: r21
// 0x00000054: ld r22, +56(r29)
// 0x00000058: .cfi_restore: r22
// 0x00000058: ld r23, +64(r29)
// 0x0000005c: .cfi_restore: r23
// 0x0000005c: ld r28, +72(r29)
// 0x00000060: .cfi_restore: r28
// 0x00000060: ld r30, +80(r29)
// 0x00000064: .cfi_restore: r30
// 0x00000064: ld r31, +88(r29)
// 0x00000068: .cfi_restore: r31
// 0x00000068: daddiu r29, r29, 96
// 0x0000006c: .cfi_def_cfa_offset: 0
// 0x0000006c: jr r31
// 0x00000070: nop
// 0x00000074: .cfi_restore_state
// 0x00000074: .cfi_def_cfa_offset: 96

