/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

static data_2_1_t<float, float, float> g_modff_intel_data[] = {
  { // Entry 0
    -0x1.p-149,
    -0.0,
    -0x1.p-149
  },
  { // Entry 1
    0.0,
    0.0,
    0.0
  },
  { // Entry 2
    0x1.p-149,
    0.0,
    0x1.p-149
  },
  { // Entry 3
    0x1.fffffep-2,
    0.0,
    0x1.fffffep-2
  },
  { // Entry 4
    0x1.p-1,
    0.0,
    0x1.p-1
  },
  { // Entry 5
    0x1.000002p-1,
    0.0,
    0x1.000002p-1
  },
  { // Entry 6
    0x1.fffffep-1,
    0.0,
    0x1.fffffep-1
  },
  { // Entry 7
    0.0,
    0x1.p0,
    0x1.p0
  },
  { // Entry 8
    0x1.p-23,
    0x1.p0,
    0x1.000002p0
  },
  { // Entry 9
    0x1.fffff8p-2,
    0x1.p0,
    0x1.7ffffep0
  },
  { // Entry 10
    0x1.p-1,
    0x1.p0,
    0x1.80p0
  },
  { // Entry 11
    0x1.000004p-1,
    0x1.p0,
    0x1.800002p0
  },
  { // Entry 12
    0x1.fffffcp-1,
    0x1.p0,
    0x1.fffffep0
  },
  { // Entry 13
    0.0,
    0x1.p1,
    0x1.p1
  },
  { // Entry 14
    0x1.p-22,
    0x1.p1,
    0x1.000002p1
  },
  { // Entry 15
    0x1.fffff0p-2,
    0x1.p1,
    0x1.3ffffep1
  },
  { // Entry 16
    0x1.p-1,
    0x1.p1,
    0x1.40p1
  },
  { // Entry 17
    0x1.000008p-1,
    0x1.p1,
    0x1.400002p1
  },
  { // Entry 18
    0x1.ffffp-1,
    0x1.8cp6,
    0x1.8ffffep6
  },
  { // Entry 19
    0.0,
    0x1.90p6,
    0x1.90p6
  },
  { // Entry 20
    0x1.p-17,
    0x1.90p6,
    0x1.900002p6
  },
  { // Entry 21
    0x1.fffep-2,
    0x1.90p6,
    0x1.91fffep6
  },
  { // Entry 22
    0x1.p-1,
    0x1.90p6,
    0x1.92p6
  },
  { // Entry 23
    0x1.0001p-1,
    0x1.90p6,
    0x1.920002p6
  },
  { // Entry 24
    0x1.fff8p-1,
    0x1.f380p9,
    0x1.f3fffep9
  },
  { // Entry 25
    0.0,
    0x1.f4p9,
    0x1.f4p9
  },
  { // Entry 26
    0x1.p-14,
    0x1.f4p9,
    0x1.f40002p9
  },
  { // Entry 27
    0x1.fff0p-2,
    0x1.f4p9,
    0x1.f43ffep9
  },
  { // Entry 28
    0x1.p-1,
    0x1.f4p9,
    0x1.f440p9
  },
  { // Entry 29
    0x1.0008p-1,
    0x1.f4p9,
    0x1.f44002p9
  },
  { // Entry 30
    0x1.c0p-1,
    0x1.fffff0p20,
    0x1.fffffep20
  },
  { // Entry 31
    0.0,
    0x1.p21,
    0x1.p21
  },
  { // Entry 32
    0x1.p-2,
    0x1.p21,
    0x1.000002p21
  },
  { // Entry 33
    0x1.80p-1,
    0x1.fffff8p21,
    0x1.fffffep21
  },
  { // Entry 34
    0.0,
    0x1.p22,
    0x1.p22
  },
  { // Entry 35
    0x1.p-1,
    0x1.p22,
    0x1.000002p22
  },
  { // Entry 36
    0x1.p-1,
    0x1.fffffcp22,
    0x1.fffffep22
  },
  { // Entry 37
    0.0,
    0x1.p23,
    0x1.p23
  },
  { // Entry 38
    0.0,
    0x1.000002p23,
    0x1.000002p23
  },
  { // Entry 39
    0.0,
    0x1.fffffep23,
    0x1.fffffep23
  },
  { // Entry 40
    0.0,
    0x1.p24,
    0x1.p24
  },
  { // Entry 41
    0.0,
    0x1.000002p24,
    0x1.000002p24
  },
  { // Entry 42
    0.0,
    0x1.fffffep24,
    0x1.fffffep24
  },
  { // Entry 43
    0.0,
    0x1.p25,
    0x1.p25
  },
  { // Entry 44
    0.0,
    0x1.000002p25,
    0x1.000002p25
  },
  { // Entry 45
    0.0,
    0x1.fffffep127,
    0x1.fffffep127
  },
  { // Entry 46
    -0x1.000002p-1,
    -0.0,
    -0x1.000002p-1
  },
  { // Entry 47
    -0x1.p-1,
    -0.0,
    -0x1.p-1
  },
  { // Entry 48
    -0x1.fffffep-2,
    -0.0,
    -0x1.fffffep-2
  },
  { // Entry 49
    -0x1.p-23,
    -0x1.p0,
    -0x1.000002p0
  },
  { // Entry 50
    -0.0,
    -0x1.p0,
    -0x1.p0
  },
  { // Entry 51
    -0x1.fffffep-1,
    -0.0,
    -0x1.fffffep-1
  },
  { // Entry 52
    -0x1.000004p-1,
    -0x1.p0,
    -0x1.800002p0
  },
  { // Entry 53
    -0x1.p-1,
    -0x1.p0,
    -0x1.80p0
  },
  { // Entry 54
    -0x1.fffff8p-2,
    -0x1.p0,
    -0x1.7ffffep0
  },
  { // Entry 55
    -0x1.p-22,
    -0x1.p1,
    -0x1.000002p1
  },
  { // Entry 56
    -0.0,
    -0x1.p1,
    -0x1.p1
  },
  { // Entry 57
    -0x1.fffffcp-1,
    -0x1.p0,
    -0x1.fffffep0
  },
  { // Entry 58
    -0x1.000008p-1,
    -0x1.p1,
    -0x1.400002p1
  },
  { // Entry 59
    -0x1.p-1,
    -0x1.p1,
    -0x1.40p1
  },
  { // Entry 60
    -0x1.fffff0p-2,
    -0x1.p1,
    -0x1.3ffffep1
  },
  { // Entry 61
    -0x1.p-17,
    -0x1.90p6,
    -0x1.900002p6
  },
  { // Entry 62
    -0.0,
    -0x1.90p6,
    -0x1.90p6
  },
  { // Entry 63
    -0x1.ffffp-1,
    -0x1.8cp6,
    -0x1.8ffffep6
  },
  { // Entry 64
    -0x1.0001p-1,
    -0x1.90p6,
    -0x1.920002p6
  },
  { // Entry 65
    -0x1.p-1,
    -0x1.90p6,
    -0x1.92p6
  },
  { // Entry 66
    -0x1.fffep-2,
    -0x1.90p6,
    -0x1.91fffep6
  },
  { // Entry 67
    -0x1.p-14,
    -0x1.f4p9,
    -0x1.f40002p9
  },
  { // Entry 68
    -0.0,
    -0x1.f4p9,
    -0x1.f4p9
  },
  { // Entry 69
    -0x1.fff8p-1,
    -0x1.f380p9,
    -0x1.f3fffep9
  },
  { // Entry 70
    -0x1.0008p-1,
    -0x1.f4p9,
    -0x1.f44002p9
  },
  { // Entry 71
    -0x1.p-1,
    -0x1.f4p9,
    -0x1.f440p9
  },
  { // Entry 72
    -0x1.fff0p-2,
    -0x1.f4p9,
    -0x1.f43ffep9
  },
  { // Entry 73
    -0x1.p-2,
    -0x1.p21,
    -0x1.000002p21
  },
  { // Entry 74
    -0.0,
    -0x1.p21,
    -0x1.p21
  },
  { // Entry 75
    -0x1.c0p-1,
    -0x1.fffff0p20,
    -0x1.fffffep20
  },
  { // Entry 76
    -0x1.p-1,
    -0x1.p22,
    -0x1.000002p22
  },
  { // Entry 77
    -0.0,
    -0x1.p22,
    -0x1.p22
  },
  { // Entry 78
    -0x1.80p-1,
    -0x1.fffff8p21,
    -0x1.fffffep21
  },
  { // Entry 79
    -0.0,
    -0x1.000002p23,
    -0x1.000002p23
  },
  { // Entry 80
    -0.0,
    -0x1.p23,
    -0x1.p23
  },
  { // Entry 81
    -0x1.p-1,
    -0x1.fffffcp22,
    -0x1.fffffep22
  },
  { // Entry 82
    -0.0,
    -0x1.000002p24,
    -0x1.000002p24
  },
  { // Entry 83
    -0.0,
    -0x1.p24,
    -0x1.p24
  },
  { // Entry 84
    -0.0,
    -0x1.fffffep23,
    -0x1.fffffep23
  },
  { // Entry 85
    -0.0,
    -0x1.000002p25,
    -0x1.000002p25
  },
  { // Entry 86
    -0.0,
    -0x1.p25,
    -0x1.p25
  },
  { // Entry 87
    -0.0,
    -0x1.fffffep24,
    -0x1.fffffep24
  },
  { // Entry 88
    -0.0,
    -0x1.fffffep127,
    -0x1.fffffep127
  },
  { // Entry 89
    0.0,
    0x1.fffffep29,
    0x1.fffffep29
  },
  { // Entry 90
    0.0,
    0x1.p30,
    0x1.p30
  },
  { // Entry 91
    0.0,
    0x1.000002p30,
    0x1.000002p30
  },
  { // Entry 92
    0.0,
    0x1.fffffap30,
    0x1.fffffap30
  },
  { // Entry 93
    0.0,
    0x1.fffffcp30,
    0x1.fffffcp30
  },
  { // Entry 94
    0.0,
    0x1.fffffep30,
    0x1.fffffep30
  },
  { // Entry 95
    0.0,
    0x1.p31,
    0x1.p31
  },
  { // Entry 96
    0.0,
    0x1.000002p31,
    0x1.000002p31
  },
  { // Entry 97
    0.0,
    0x1.000004p31,
    0x1.000004p31
  },
  { // Entry 98
    0.0,
    0x1.000006p31,
    0x1.000006p31
  },
  { // Entry 99
    0.0,
    0x1.fffffap30,
    0x1.fffffap30
  },
  { // Entry 100
    0.0,
    0x1.fffffcp30,
    0x1.fffffcp30
  },
  { // Entry 101
    0.0,
    0x1.fffffep30,
    0x1.fffffep30
  },
  { // Entry 102
    0.0,
    0x1.p31,
    0x1.p31
  },
  { // Entry 103
    0.0,
    0x1.000002p31,
    0x1.000002p31
  },
  { // Entry 104
    0.0,
    0x1.000004p31,
    0x1.000004p31
  },
  { // Entry 105
    0.0,
    0x1.000006p31,
    0x1.000006p31
  },
  { // Entry 106
    0.0,
    0x1.fffffap30,
    0x1.fffffap30
  },
  { // Entry 107
    0.0,
    0x1.fffffcp30,
    0x1.fffffcp30
  },
  { // Entry 108
    0.0,
    0x1.fffffep30,
    0x1.fffffep30
  },
  { // Entry 109
    0.0,
    0x1.p31,
    0x1.p31
  },
  { // Entry 110
    0.0,
    0x1.000002p31,
    0x1.000002p31
  },
  { // Entry 111
    0.0,
    0x1.000004p31,
    0x1.000004p31
  },
  { // Entry 112
    0.0,
    0x1.000006p31,
    0x1.000006p31
  },
  { // Entry 113
    0.0,
    0x1.fffffap30,
    0x1.fffffap30
  },
  { // Entry 114
    0.0,
    0x1.fffffcp30,
    0x1.fffffcp30
  },
  { // Entry 115
    0.0,
    0x1.fffffep30,
    0x1.fffffep30
  },
  { // Entry 116
    0.0,
    0x1.p31,
    0x1.p31
  },
  { // Entry 117
    0.0,
    0x1.000002p31,
    0x1.000002p31
  },
  { // Entry 118
    0.0,
    0x1.000004p31,
    0x1.000004p31
  },
  { // Entry 119
    0.0,
    0x1.000006p31,
    0x1.000006p31
  },
  { // Entry 120
    0.0,
    0x1.fffffap30,
    0x1.fffffap30
  },
  { // Entry 121
    0.0,
    0x1.fffffcp30,
    0x1.fffffcp30
  },
  { // Entry 122
    0.0,
    0x1.fffffep30,
    0x1.fffffep30
  },
  { // Entry 123
    0.0,
    0x1.p31,
    0x1.p31
  },
  { // Entry 124
    0.0,
    0x1.000002p31,
    0x1.000002p31
  },
  { // Entry 125
    0.0,
    0x1.000004p31,
    0x1.000004p31
  },
  { // Entry 126
    0.0,
    0x1.000006p31,
    0x1.000006p31
  },
  { // Entry 127
    0.0,
    0x1.fffffap30,
    0x1.fffffap30
  },
  { // Entry 128
    0.0,
    0x1.fffffcp30,
    0x1.fffffcp30
  },
  { // Entry 129
    0.0,
    0x1.fffffep30,
    0x1.fffffep30
  },
  { // Entry 130
    0.0,
    0x1.p31,
    0x1.p31
  },
  { // Entry 131
    0.0,
    0x1.000002p31,
    0x1.000002p31
  },
  { // Entry 132
    0.0,
    0x1.000004p31,
    0x1.000004p31
  },
  { // Entry 133
    0.0,
    0x1.000006p31,
    0x1.000006p31
  },
  { // Entry 134
    0.0,
    0x1.p31,
    0x1.p31
  },
  { // Entry 135
    0.0,
    0x1.p31,
    0x1.p31
  },
  { // Entry 136
    0.0,
    0x1.p31,
    0x1.p31
  },
  { // Entry 137
    0.0,
    0x1.p31,
    0x1.p31
  },
  { // Entry 138
    0.0,
    0x1.p31,
    0x1.p31
  },
  { // Entry 139
    0.0,
    0x1.p31,
    0x1.p31
  },
  { // Entry 140
    0.0,
    0x1.p31,
    0x1.p31
  },
  { // Entry 141
    0.0,
    0x1.p31,
    0x1.p31
  },
  { // Entry 142
    0.0,
    0x1.p31,
    0x1.p31
  },
  { // Entry 143
    0.0,
    0x1.p31,
    0x1.p31
  },
  { // Entry 144
    -0.0,
    -0x1.000002p30,
    -0x1.000002p30
  },
  { // Entry 145
    -0.0,
    -0x1.p30,
    -0x1.p30
  },
  { // Entry 146
    -0.0,
    -0x1.fffffep29,
    -0x1.fffffep29
  },
  { // Entry 147
    -0.0,
    -0x1.000006p31,
    -0x1.000006p31
  },
  { // Entry 148
    -0.0,
    -0x1.000004p31,
    -0x1.000004p31
  },
  { // Entry 149
    -0.0,
    -0x1.000002p31,
    -0x1.000002p31
  },
  { // Entry 150
    -0.0,
    -0x1.p31,
    -0x1.p31
  },
  { // Entry 151
    -0.0,
    -0x1.fffffep30,
    -0x1.fffffep30
  },
  { // Entry 152
    -0.0,
    -0x1.fffffcp30,
    -0x1.fffffcp30
  },
  { // Entry 153
    -0.0,
    -0x1.fffffap30,
    -0x1.fffffap30
  },
  { // Entry 154
    -0.0,
    -0x1.000006p31,
    -0x1.000006p31
  },
  { // Entry 155
    -0.0,
    -0x1.000004p31,
    -0x1.000004p31
  },
  { // Entry 156
    -0.0,
    -0x1.000002p31,
    -0x1.000002p31
  },
  { // Entry 157
    -0.0,
    -0x1.p31,
    -0x1.p31
  },
  { // Entry 158
    -0.0,
    -0x1.fffffep30,
    -0x1.fffffep30
  },
  { // Entry 159
    -0.0,
    -0x1.fffffcp30,
    -0x1.fffffcp30
  },
  { // Entry 160
    -0.0,
    -0x1.fffffap30,
    -0x1.fffffap30
  },
  { // Entry 161
    -0.0,
    -0x1.000006p31,
    -0x1.000006p31
  },
  { // Entry 162
    -0.0,
    -0x1.000004p31,
    -0x1.000004p31
  },
  { // Entry 163
    -0.0,
    -0x1.000002p31,
    -0x1.000002p31
  },
  { // Entry 164
    -0.0,
    -0x1.p31,
    -0x1.p31
  },
  { // Entry 165
    -0.0,
    -0x1.fffffep30,
    -0x1.fffffep30
  },
  { // Entry 166
    -0.0,
    -0x1.fffffcp30,
    -0x1.fffffcp30
  },
  { // Entry 167
    -0.0,
    -0x1.fffffap30,
    -0x1.fffffap30
  },
  { // Entry 168
    -0.0,
    -0x1.000006p31,
    -0x1.000006p31
  },
  { // Entry 169
    -0.0,
    -0x1.000004p31,
    -0x1.000004p31
  },
  { // Entry 170
    -0.0,
    -0x1.000002p31,
    -0x1.000002p31
  },
  { // Entry 171
    -0.0,
    -0x1.p31,
    -0x1.p31
  },
  { // Entry 172
    -0.0,
    -0x1.fffffep30,
    -0x1.fffffep30
  },
  { // Entry 173
    -0.0,
    -0x1.fffffcp30,
    -0x1.fffffcp30
  },
  { // Entry 174
    -0.0,
    -0x1.fffffap30,
    -0x1.fffffap30
  },
  { // Entry 175
    -0.0,
    -0x1.000006p31,
    -0x1.000006p31
  },
  { // Entry 176
    -0.0,
    -0x1.000004p31,
    -0x1.000004p31
  },
  { // Entry 177
    -0.0,
    -0x1.000002p31,
    -0x1.000002p31
  },
  { // Entry 178
    -0.0,
    -0x1.p31,
    -0x1.p31
  },
  { // Entry 179
    -0.0,
    -0x1.fffffep30,
    -0x1.fffffep30
  },
  { // Entry 180
    -0.0,
    -0x1.fffffcp30,
    -0x1.fffffcp30
  },
  { // Entry 181
    -0.0,
    -0x1.fffffap30,
    -0x1.fffffap30
  },
  { // Entry 182
    -0.0,
    -0x1.000006p31,
    -0x1.000006p31
  },
  { // Entry 183
    -0.0,
    -0x1.000004p31,
    -0x1.000004p31
  },
  { // Entry 184
    -0.0,
    -0x1.000002p31,
    -0x1.000002p31
  },
  { // Entry 185
    -0.0,
    -0x1.p31,
    -0x1.p31
  },
  { // Entry 186
    -0.0,
    -0x1.fffffep30,
    -0x1.fffffep30
  },
  { // Entry 187
    -0.0,
    -0x1.fffffcp30,
    -0x1.fffffcp30
  },
  { // Entry 188
    -0.0,
    -0x1.fffffap30,
    -0x1.fffffap30
  },
  { // Entry 189
    -0.0,
    -0x1.p31,
    -0x1.p31
  },
  { // Entry 190
    -0.0,
    -0x1.p31,
    -0x1.p31
  },
  { // Entry 191
    -0.0,
    -0x1.p31,
    -0x1.p31
  },
  { // Entry 192
    -0.0,
    -0x1.p31,
    -0x1.p31
  },
  { // Entry 193
    -0.0,
    -0x1.p31,
    -0x1.p31
  },
  { // Entry 194
    -0.0,
    -0x1.p31,
    -0x1.p31
  },
  { // Entry 195
    -0.0,
    -0x1.p31,
    -0x1.p31
  },
  { // Entry 196
    -0.0,
    -0x1.p31,
    -0x1.p31
  },
  { // Entry 197
    -0.0,
    -0x1.p31,
    -0x1.p31
  },
  { // Entry 198
    -0.0,
    -0x1.p31,
    -0x1.p31
  },
  { // Entry 199
    0.0,
    0x1.fffffap61,
    0x1.fffffap61
  },
  { // Entry 200
    0.0,
    0x1.fffffcp61,
    0x1.fffffcp61
  },
  { // Entry 201
    0.0,
    0x1.fffffep61,
    0x1.fffffep61
  },
  { // Entry 202
    0.0,
    0x1.p62,
    0x1.p62
  },
  { // Entry 203
    0.0,
    0x1.000002p62,
    0x1.000002p62
  },
  { // Entry 204
    0.0,
    0x1.000004p62,
    0x1.000004p62
  },
  { // Entry 205
    0.0,
    0x1.000006p62,
    0x1.000006p62
  },
  { // Entry 206
    0.0,
    0x1.fffffap62,
    0x1.fffffap62
  },
  { // Entry 207
    0.0,
    0x1.fffffcp62,
    0x1.fffffcp62
  },
  { // Entry 208
    0.0,
    0x1.fffffep62,
    0x1.fffffep62
  },
  { // Entry 209
    0.0,
    0x1.p63,
    0x1.p63
  },
  { // Entry 210
    0.0,
    0x1.000002p63,
    0x1.000002p63
  },
  { // Entry 211
    0.0,
    0x1.000004p63,
    0x1.000004p63
  },
  { // Entry 212
    0.0,
    0x1.000006p63,
    0x1.000006p63
  },
  { // Entry 213
    0.0,
    0x1.fffffap63,
    0x1.fffffap63
  },
  { // Entry 214
    0.0,
    0x1.fffffcp63,
    0x1.fffffcp63
  },
  { // Entry 215
    0.0,
    0x1.fffffep63,
    0x1.fffffep63
  },
  { // Entry 216
    0.0,
    0x1.p64,
    0x1.p64
  },
  { // Entry 217
    0.0,
    0x1.000002p64,
    0x1.000002p64
  },
  { // Entry 218
    0.0,
    0x1.000004p64,
    0x1.000004p64
  },
  { // Entry 219
    0.0,
    0x1.000006p64,
    0x1.000006p64
  },
  { // Entry 220
    -0.0,
    -0x1.000006p62,
    -0x1.000006p62
  },
  { // Entry 221
    -0.0,
    -0x1.000004p62,
    -0x1.000004p62
  },
  { // Entry 222
    -0.0,
    -0x1.000002p62,
    -0x1.000002p62
  },
  { // Entry 223
    -0.0,
    -0x1.p62,
    -0x1.p62
  },
  { // Entry 224
    -0.0,
    -0x1.fffffep61,
    -0x1.fffffep61
  },
  { // Entry 225
    -0.0,
    -0x1.fffffcp61,
    -0x1.fffffcp61
  },
  { // Entry 226
    -0.0,
    -0x1.fffffap61,
    -0x1.fffffap61
  },
  { // Entry 227
    -0.0,
    -0x1.000006p63,
    -0x1.000006p63
  },
  { // Entry 228
    -0.0,
    -0x1.000004p63,
    -0x1.000004p63
  },
  { // Entry 229
    -0.0,
    -0x1.000002p63,
    -0x1.000002p63
  },
  { // Entry 230
    -0.0,
    -0x1.p63,
    -0x1.p63
  },
  { // Entry 231
    -0.0,
    -0x1.fffffep62,
    -0x1.fffffep62
  },
  { // Entry 232
    -0.0,
    -0x1.fffffcp62,
    -0x1.fffffcp62
  },
  { // Entry 233
    -0.0,
    -0x1.fffffap62,
    -0x1.fffffap62
  },
  { // Entry 234
    -0.0,
    -0x1.000006p64,
    -0x1.000006p64
  },
  { // Entry 235
    -0.0,
    -0x1.000004p64,
    -0x1.000004p64
  },
  { // Entry 236
    -0.0,
    -0x1.000002p64,
    -0x1.000002p64
  },
  { // Entry 237
    -0.0,
    -0x1.p64,
    -0x1.p64
  },
  { // Entry 238
    -0.0,
    -0x1.fffffep63,
    -0x1.fffffep63
  },
  { // Entry 239
    -0.0,
    -0x1.fffffcp63,
    -0x1.fffffcp63
  },
  { // Entry 240
    -0.0,
    -0x1.fffffap63,
    -0x1.fffffap63
  },
  { // Entry 241
    0.0,
    0x1.p62,
    0x1.p62
  },
  { // Entry 242
    0.0,
    0x1.40p62,
    0x1.40p62
  },
  { // Entry 243
    0.0,
    0x1.80p62,
    0x1.80p62
  },
  { // Entry 244
    0.0,
    0x1.c0p62,
    0x1.c0p62
  },
  { // Entry 245
    0.0,
    0x1.p63,
    0x1.p63
  },
  { // Entry 246
    0.0,
    0x1.p63,
    0x1.p63
  },
  { // Entry 247
    0.0,
    0x1.40p63,
    0x1.40p63
  },
  { // Entry 248
    0.0,
    0x1.80p63,
    0x1.80p63
  },
  { // Entry 249
    0.0,
    0x1.c0p63,
    0x1.c0p63
  },
  { // Entry 250
    0.0,
    0x1.p64,
    0x1.p64
  },
  { // Entry 251
    -0.0,
    -0x1.p62,
    -0x1.p62
  },
  { // Entry 252
    -0.0,
    -0x1.40p62,
    -0x1.40p62
  },
  { // Entry 253
    -0.0,
    -0x1.80p62,
    -0x1.80p62
  },
  { // Entry 254
    -0.0,
    -0x1.c0p62,
    -0x1.c0p62
  },
  { // Entry 255
    -0.0,
    -0x1.p63,
    -0x1.p63
  },
  { // Entry 256
    -0.0,
    -0x1.p63,
    -0x1.p63
  },
  { // Entry 257
    -0.0,
    -0x1.40p63,
    -0x1.40p63
  },
  { // Entry 258
    -0.0,
    -0x1.80p63,
    -0x1.80p63
  },
  { // Entry 259
    -0.0,
    -0x1.c0p63,
    -0x1.c0p63
  },
  { // Entry 260
    -0.0,
    -0x1.p64,
    -0x1.p64
  },
  { // Entry 261
    0.0,
    0x1.fffffcp30,
    0x1.fffffcp30
  },
  { // Entry 262
    0.0,
    0x1.fffffep30,
    0x1.fffffep30
  },
  { // Entry 263
    0.0,
    0x1.p31,
    0x1.p31
  },
  { // Entry 264
    -0.0,
    -0x1.000002p31,
    -0x1.000002p31
  },
  { // Entry 265
    -0.0,
    -0x1.p31,
    -0x1.p31
  },
  { // Entry 266
    -0.0,
    -0x1.fffffep30,
    -0x1.fffffep30
  },
  { // Entry 267
    0x1.fffff8p-1,
    0x1.80p1,
    0x1.fffffep1
  },
  { // Entry 268
    0.0,
    0x1.p2,
    0x1.p2
  },
  { // Entry 269
    0x1.p-21,
    0x1.p2,
    0x1.000002p2
  },
  { // Entry 270
    0x1.fffff0p-1,
    0x1.c0p2,
    0x1.fffffep2
  },
  { // Entry 271
    0.0,
    0x1.p3,
    0x1.p3
  },
  { // Entry 272
    0x1.p-20,
    0x1.p3,
    0x1.000002p3
  },
  { // Entry 273
    0x1.ffffe0p-1,
    0x1.e0p3,
    0x1.fffffep3
  },
  { // Entry 274
    0.0,
    0x1.p4,
    0x1.p4
  },
  { // Entry 275
    0x1.p-19,
    0x1.p4,
    0x1.000002p4
  },
  { // Entry 276
    0x1.ffffc0p-1,
    0x1.f0p4,
    0x1.fffffep4
  },
  { // Entry 277
    0.0,
    0x1.p5,
    0x1.p5
  },
  { // Entry 278
    0x1.p-18,
    0x1.p5,
    0x1.000002p5
  },
  { // Entry 279
    0x1.ffff80p-1,
    0x1.f8p5,
    0x1.fffffep5
  },
  { // Entry 280
    0.0,
    0x1.p6,
    0x1.p6
  },
  { // Entry 281
    0x1.p-17,
    0x1.p6,
    0x1.000002p6
  },
  { // Entry 282
    0x1.ffffp-1,
    0x1.fcp6,
    0x1.fffffep6
  },
  { // Entry 283
    0.0,
    0x1.p7,
    0x1.p7
  },
  { // Entry 284
    0x1.p-16,
    0x1.p7,
    0x1.000002p7
  },
  { // Entry 285
    0x1.fffep-1,
    0x1.fep7,
    0x1.fffffep7
  },
  { // Entry 286
    0.0,
    0x1.p8,
    0x1.p8
  },
  { // Entry 287
    0x1.p-15,
    0x1.p8,
    0x1.000002p8
  },
  { // Entry 288
    0x1.fffcp-1,
    0x1.ffp8,
    0x1.fffffep8
  },
  { // Entry 289
    0.0,
    0x1.p9,
    0x1.p9
  },
  { // Entry 290
    0x1.p-14,
    0x1.p9,
    0x1.000002p9
  },
  { // Entry 291
    0x1.fff8p-1,
    0x1.ff80p9,
    0x1.fffffep9
  },
  { // Entry 292
    0.0,
    0x1.p10,
    0x1.p10
  },
  { // Entry 293
    0x1.p-13,
    0x1.p10,
    0x1.000002p10
  },
  { // Entry 294
    0x1.fff0p-1,
    0x1.ffc0p10,
    0x1.fffffep10
  },
  { // Entry 295
    0.0,
    0x1.p11,
    0x1.p11
  },
  { // Entry 296
    0x1.p-12,
    0x1.p11,
    0x1.000002p11
  },
  { // Entry 297
    0x1.ffe0p-1,
    0x1.ffe0p11,
    0x1.fffffep11
  },
  { // Entry 298
    0.0,
    0x1.p12,
    0x1.p12
  },
  { // Entry 299
    0x1.p-11,
    0x1.p12,
    0x1.000002p12
  },
  { // Entry 300
    0x1.ffffe0p-2,
    0x1.p2,
    0x1.1ffffep2
  },
  { // Entry 301
    0x1.p-1,
    0x1.p2,
    0x1.20p2
  },
  { // Entry 302
    0x1.000010p-1,
    0x1.p2,
    0x1.200002p2
  },
  { // Entry 303
    0x1.ffffc0p-2,
    0x1.p3,
    0x1.0ffffep3
  },
  { // Entry 304
    0x1.p-1,
    0x1.p3,
    0x1.10p3
  },
  { // Entry 305
    0x1.000020p-1,
    0x1.p3,
    0x1.100002p3
  },
  { // Entry 306
    0x1.ffff80p-2,
    0x1.p4,
    0x1.07fffep4
  },
  { // Entry 307
    0x1.p-1,
    0x1.p4,
    0x1.08p4
  },
  { // Entry 308
    0x1.000040p-1,
    0x1.p4,
    0x1.080002p4
  },
  { // Entry 309
    0x1.ffffp-2,
    0x1.p5,
    0x1.03fffep5
  },
  { // Entry 310
    0x1.p-1,
    0x1.p5,
    0x1.04p5
  },
  { // Entry 311
    0x1.000080p-1,
    0x1.p5,
    0x1.040002p5
  },
  { // Entry 312
    0x1.fffep-2,
    0x1.p6,
    0x1.01fffep6
  },
  { // Entry 313
    0x1.p-1,
    0x1.p6,
    0x1.02p6
  },
  { // Entry 314
    0x1.0001p-1,
    0x1.p6,
    0x1.020002p6
  },
  { // Entry 315
    0x1.fffcp-2,
    0x1.p7,
    0x1.00fffep7
  },
  { // Entry 316
    0x1.p-1,
    0x1.p7,
    0x1.01p7
  },
  { // Entry 317
    0x1.0002p-1,
    0x1.p7,
    0x1.010002p7
  },
  { // Entry 318
    0x1.fff8p-2,
    0x1.p8,
    0x1.007ffep8
  },
  { // Entry 319
    0x1.p-1,
    0x1.p8,
    0x1.0080p8
  },
  { // Entry 320
    0x1.0004p-1,
    0x1.p8,
    0x1.008002p8
  },
  { // Entry 321
    0x1.fff0p-2,
    0x1.p9,
    0x1.003ffep9
  },
  { // Entry 322
    0x1.p-1,
    0x1.p9,
    0x1.0040p9
  },
  { // Entry 323
    0x1.0008p-1,
    0x1.p9,
    0x1.004002p9
  },
  { // Entry 324
    0x1.ffe0p-2,
    0x1.p10,
    0x1.001ffep10
  },
  { // Entry 325
    0x1.p-1,
    0x1.p10,
    0x1.0020p10
  },
  { // Entry 326
    0x1.0010p-1,
    0x1.p10,
    0x1.002002p10
  },
  { // Entry 327
    0x1.ffe0p-2,
    0x1.0040p10,
    0x1.005ffep10
  },
  { // Entry 328
    0x1.p-1,
    0x1.0040p10,
    0x1.0060p10
  },
  { // Entry 329
    0x1.0010p-1,
    0x1.0040p10,
    0x1.006002p10
  },
  { // Entry 330
    0x1.ffc0p-2,
    0x1.p11,
    0x1.000ffep11
  },
  { // Entry 331
    0x1.p-1,
    0x1.p11,
    0x1.0010p11
  },
  { // Entry 332
    0x1.0020p-1,
    0x1.p11,
    0x1.001002p11
  },
  { // Entry 333
    0x1.ff80p-2,
    0x1.p12,
    0x1.0007fep12
  },
  { // Entry 334
    0x1.p-1,
    0x1.p12,
    0x1.0008p12
  },
  { // Entry 335
    0x1.0040p-1,
    0x1.p12,
    0x1.000802p12
  },
  { // Entry 336
    0.0,
    HUGE_VALF,
    HUGE_VALF
  },
  { // Entry 337
    -0.0,
    -HUGE_VALF,
    -HUGE_VALF
  },
  { // Entry 338
    0.0,
    0x1.fffffep127,
    0x1.fffffep127
  },
  { // Entry 339
    -0.0,
    -0x1.fffffep127,
    -0x1.fffffep127
  },
  { // Entry 340
    0.0,
    0x1.fffffcp127,
    0x1.fffffcp127
  },
  { // Entry 341
    -0.0,
    -0x1.fffffcp127,
    -0x1.fffffcp127
  },
  { // Entry 342
    0x1.21fb60p-3,
    0x1.80p1,
    0x1.921fb6p1
  },
  { // Entry 343
    -0x1.21fb60p-3,
    -0x1.80p1,
    -0x1.921fb6p1
  },
  { // Entry 344
    0x1.243f6cp-1,
    0x1.p0,
    0x1.921fb6p0
  },
  { // Entry 345
    -0x1.243f6cp-1,
    -0x1.p0,
    -0x1.921fb6p0
  },
  { // Entry 346
    0x1.p-23,
    0x1.p0,
    0x1.000002p0
  },
  { // Entry 347
    -0x1.p-23,
    -0x1.p0,
    -0x1.000002p0
  },
  { // Entry 348
    0.0,
    0x1.p0,
    0x1.p0
  },
  { // Entry 349
    -0.0,
    -0x1.p0,
    -0x1.p0
  },
  { // Entry 350
    0x1.fffffep-1,
    0.0,
    0x1.fffffep-1
  },
  { // Entry 351
    -0x1.fffffep-1,
    -0.0,
    -0x1.fffffep-1
  },
  { // Entry 352
    0x1.921fb6p-1,
    0.0,
    0x1.921fb6p-1
  },
  { // Entry 353
    -0x1.921fb6p-1,
    -0.0,
    -0x1.921fb6p-1
  },
  { // Entry 354
    0x1.000002p-126,
    0.0,
    0x1.000002p-126
  },
  { // Entry 355
    -0x1.000002p-126,
    -0.0,
    -0x1.000002p-126
  },
  { // Entry 356
    0x1.p-126,
    0.0,
    0x1.p-126
  },
  { // Entry 357
    -0x1.p-126,
    -0.0,
    -0x1.p-126
  },
  { // Entry 358
    0x1.fffffcp-127,
    0.0,
    0x1.fffffcp-127
  },
  { // Entry 359
    -0x1.fffffcp-127,
    -0.0,
    -0x1.fffffcp-127
  },
  { // Entry 360
    0x1.fffff8p-127,
    0.0,
    0x1.fffff8p-127
  },
  { // Entry 361
    -0x1.fffff8p-127,
    -0.0,
    -0x1.fffff8p-127
  },
  { // Entry 362
    0x1.p-148,
    0.0,
    0x1.p-148
  },
  { // Entry 363
    -0x1.p-148,
    -0.0,
    -0x1.p-148
  },
  { // Entry 364
    0x1.p-149,
    0.0,
    0x1.p-149
  },
  { // Entry 365
    -0x1.p-149,
    -0.0,
    -0x1.p-149
  },
  { // Entry 366
    0.0,
    0.0,
    0.0f
  },
  { // Entry 367
    -0.0,
    -0.0,
    -0.0f
  }
};
