/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

static data_1_2_t<float, float, float> g_scalbf_intel_data[] = {
  { // Entry 0
    -0.0f,
    -0x1.p-149,
    -0x1.40p3
  },
  { // Entry 1
    -0x1.555554p-128,
    -0x1.555554p-2,
    -0x1.f8p6
  },
  { // Entry 2
    -0x1.6db6dcp-128,
    -0x1.6db6dcp-1,
    -0x1.fcp6
  },
  { // Entry 3
    -0x1.8e38e4p-128,
    -0x1.8e38e4p-1,
    -0x1.fcp6
  },
  { // Entry 4
    0.0f,
    0x1.p-149,
    -0x1.p0
  },
  { // Entry 5
    0.0f,
    0x1.p-149,
    -0x1.40p3
  },
  { // Entry 6
    0x1.5464b0p-130,
    0x1.5464b0p-2,
    -0x1.p7
  },
  { // Entry 7
    0.0f,
    0x1.dddddep-2,
    -0x1.28p7
  },
  { // Entry 8
    0x1.ecb7e8p-129,
    0x1.ecb7e8p-1,
    -0x1.p7
  },
  { // Entry 9
    0.0f,
    0x1.ffff60p-127,
    -0x1.70p4
  },
  { // Entry 10
    0.0f,
    0x1.ffff84p-127,
    -0x1.70p4
  },
  { // Entry 11
    0x1.fffff8p-137,
    0x1.fffff8p-127,
    -0x1.40p3
  },
  { // Entry 12
    0.0f,
    0x1.fffffep127,
    -0x1.p31
  },
  { // Entry 13
    HUGE_VALF,
    0x1.fffffep127,
    0x1.p31
  },
  { // Entry 14
    HUGE_VALF,
    0x1.fffffep127,
    0x1.p31
  },
  { // Entry 15
    -0x1.p-10,
    -0x1.p0,
    -0x1.40p3
  },
  { // Entry 16
    -0x1.p-9,
    -0x1.p0,
    -0x1.20p3
  },
  { // Entry 17
    -0x1.p-8,
    -0x1.p0,
    -0x1.p3
  },
  { // Entry 18
    -0x1.p-7,
    -0x1.p0,
    -0x1.c0p2
  },
  { // Entry 19
    -0x1.p-6,
    -0x1.p0,
    -0x1.80p2
  },
  { // Entry 20
    -0x1.p-5,
    -0x1.p0,
    -0x1.40p2
  },
  { // Entry 21
    -0x1.p-4,
    -0x1.p0,
    -0x1.p2
  },
  { // Entry 22
    -0x1.p-3,
    -0x1.p0,
    -0x1.80p1
  },
  { // Entry 23
    -0x1.p-2,
    -0x1.p0,
    -0x1.p1
  },
  { // Entry 24
    -0x1.p-1,
    -0x1.p0,
    -0x1.p0
  },
  { // Entry 25
    -0x1.p0,
    -0x1.p0,
    0.0
  },
  { // Entry 26
    -0x1.p1,
    -0x1.p0,
    0x1.p0
  },
  { // Entry 27
    -0x1.p2,
    -0x1.p0,
    0x1.p1
  },
  { // Entry 28
    -0x1.p3,
    -0x1.p0,
    0x1.80p1
  },
  { // Entry 29
    -0x1.p4,
    -0x1.p0,
    0x1.p2
  },
  { // Entry 30
    -0x1.p5,
    -0x1.p0,
    0x1.40p2
  },
  { // Entry 31
    -0x1.p6,
    -0x1.p0,
    0x1.80p2
  },
  { // Entry 32
    -0x1.p7,
    -0x1.p0,
    0x1.c0p2
  },
  { // Entry 33
    -0x1.p8,
    -0x1.p0,
    0x1.p3
  },
  { // Entry 34
    -0x1.p9,
    -0x1.p0,
    0x1.20p3
  },
  { // Entry 35
    -0x1.p10,
    -0x1.p0,
    0x1.40p3
  },
  { // Entry 36
    -0x1.d1745cp-11,
    -0x1.d1745cp-1,
    -0x1.40p3
  },
  { // Entry 37
    -0x1.d1745cp-10,
    -0x1.d1745cp-1,
    -0x1.20p3
  },
  { // Entry 38
    -0x1.d1745cp-9,
    -0x1.d1745cp-1,
    -0x1.p3
  },
  { // Entry 39
    -0x1.d1745cp-8,
    -0x1.d1745cp-1,
    -0x1.c0p2
  },
  { // Entry 40
    -0x1.d1745cp-7,
    -0x1.d1745cp-1,
    -0x1.80p2
  },
  { // Entry 41
    -0x1.d1745cp-6,
    -0x1.d1745cp-1,
    -0x1.40p2
  },
  { // Entry 42
    -0x1.d1745cp-5,
    -0x1.d1745cp-1,
    -0x1.p2
  },
  { // Entry 43
    -0x1.d1745cp-4,
    -0x1.d1745cp-1,
    -0x1.80p1
  },
  { // Entry 44
    -0x1.d1745cp-3,
    -0x1.d1745cp-1,
    -0x1.p1
  },
  { // Entry 45
    -0x1.d1745cp-2,
    -0x1.d1745cp-1,
    -0x1.p0
  },
  { // Entry 46
    -0x1.d1745cp-1,
    -0x1.d1745cp-1,
    0.0
  },
  { // Entry 47
    -0x1.d1745cp0,
    -0x1.d1745cp-1,
    0x1.p0
  },
  { // Entry 48
    -0x1.d1745cp1,
    -0x1.d1745cp-1,
    0x1.p1
  },
  { // Entry 49
    -0x1.d1745cp2,
    -0x1.d1745cp-1,
    0x1.80p1
  },
  { // Entry 50
    -0x1.d1745cp3,
    -0x1.d1745cp-1,
    0x1.p2
  },
  { // Entry 51
    -0x1.d1745cp4,
    -0x1.d1745cp-1,
    0x1.40p2
  },
  { // Entry 52
    -0x1.d1745cp5,
    -0x1.d1745cp-1,
    0x1.80p2
  },
  { // Entry 53
    -0x1.d1745cp6,
    -0x1.d1745cp-1,
    0x1.c0p2
  },
  { // Entry 54
    -0x1.d1745cp7,
    -0x1.d1745cp-1,
    0x1.p3
  },
  { // Entry 55
    -0x1.d1745cp8,
    -0x1.d1745cp-1,
    0x1.20p3
  },
  { // Entry 56
    -0x1.d1745cp9,
    -0x1.d1745cp-1,
    0x1.40p3
  },
  { // Entry 57
    -0x1.a2e8b8p-11,
    -0x1.a2e8b8p-1,
    -0x1.40p3
  },
  { // Entry 58
    -0x1.a2e8b8p-10,
    -0x1.a2e8b8p-1,
    -0x1.20p3
  },
  { // Entry 59
    -0x1.a2e8b8p-9,
    -0x1.a2e8b8p-1,
    -0x1.p3
  },
  { // Entry 60
    -0x1.a2e8b8p-8,
    -0x1.a2e8b8p-1,
    -0x1.c0p2
  },
  { // Entry 61
    -0x1.a2e8b8p-7,
    -0x1.a2e8b8p-1,
    -0x1.80p2
  },
  { // Entry 62
    -0x1.a2e8b8p-6,
    -0x1.a2e8b8p-1,
    -0x1.40p2
  },
  { // Entry 63
    -0x1.a2e8b8p-5,
    -0x1.a2e8b8p-1,
    -0x1.p2
  },
  { // Entry 64
    -0x1.a2e8b8p-4,
    -0x1.a2e8b8p-1,
    -0x1.80p1
  },
  { // Entry 65
    -0x1.a2e8b8p-3,
    -0x1.a2e8b8p-1,
    -0x1.p1
  },
  { // Entry 66
    -0x1.a2e8b8p-2,
    -0x1.a2e8b8p-1,
    -0x1.p0
  },
  { // Entry 67
    -0x1.a2e8b8p-1,
    -0x1.a2e8b8p-1,
    0.0
  },
  { // Entry 68
    -0x1.a2e8b8p0,
    -0x1.a2e8b8p-1,
    0x1.p0
  },
  { // Entry 69
    -0x1.a2e8b8p1,
    -0x1.a2e8b8p-1,
    0x1.p1
  },
  { // Entry 70
    -0x1.a2e8b8p2,
    -0x1.a2e8b8p-1,
    0x1.80p1
  },
  { // Entry 71
    -0x1.a2e8b8p3,
    -0x1.a2e8b8p-1,
    0x1.p2
  },
  { // Entry 72
    -0x1.a2e8b8p4,
    -0x1.a2e8b8p-1,
    0x1.40p2
  },
  { // Entry 73
    -0x1.a2e8b8p5,
    -0x1.a2e8b8p-1,
    0x1.80p2
  },
  { // Entry 74
    -0x1.a2e8b8p6,
    -0x1.a2e8b8p-1,
    0x1.c0p2
  },
  { // Entry 75
    -0x1.a2e8b8p7,
    -0x1.a2e8b8p-1,
    0x1.p3
  },
  { // Entry 76
    -0x1.a2e8b8p8,
    -0x1.a2e8b8p-1,
    0x1.20p3
  },
  { // Entry 77
    -0x1.a2e8b8p9,
    -0x1.a2e8b8p-1,
    0x1.40p3
  },
  { // Entry 78
    -0x1.745d14p-11,
    -0x1.745d14p-1,
    -0x1.40p3
  },
  { // Entry 79
    -0x1.745d14p-10,
    -0x1.745d14p-1,
    -0x1.20p3
  },
  { // Entry 80
    -0x1.745d14p-9,
    -0x1.745d14p-1,
    -0x1.p3
  },
  { // Entry 81
    -0x1.745d14p-8,
    -0x1.745d14p-1,
    -0x1.c0p2
  },
  { // Entry 82
    -0x1.745d14p-7,
    -0x1.745d14p-1,
    -0x1.80p2
  },
  { // Entry 83
    -0x1.745d14p-6,
    -0x1.745d14p-1,
    -0x1.40p2
  },
  { // Entry 84
    -0x1.745d14p-5,
    -0x1.745d14p-1,
    -0x1.p2
  },
  { // Entry 85
    -0x1.745d14p-4,
    -0x1.745d14p-1,
    -0x1.80p1
  },
  { // Entry 86
    -0x1.745d14p-3,
    -0x1.745d14p-1,
    -0x1.p1
  },
  { // Entry 87
    -0x1.745d14p-2,
    -0x1.745d14p-1,
    -0x1.p0
  },
  { // Entry 88
    -0x1.745d14p-1,
    -0x1.745d14p-1,
    0.0
  },
  { // Entry 89
    -0x1.745d14p0,
    -0x1.745d14p-1,
    0x1.p0
  },
  { // Entry 90
    -0x1.745d14p1,
    -0x1.745d14p-1,
    0x1.p1
  },
  { // Entry 91
    -0x1.745d14p2,
    -0x1.745d14p-1,
    0x1.80p1
  },
  { // Entry 92
    -0x1.745d14p3,
    -0x1.745d14p-1,
    0x1.p2
  },
  { // Entry 93
    -0x1.745d14p4,
    -0x1.745d14p-1,
    0x1.40p2
  },
  { // Entry 94
    -0x1.745d14p5,
    -0x1.745d14p-1,
    0x1.80p2
  },
  { // Entry 95
    -0x1.745d14p6,
    -0x1.745d14p-1,
    0x1.c0p2
  },
  { // Entry 96
    -0x1.745d14p7,
    -0x1.745d14p-1,
    0x1.p3
  },
  { // Entry 97
    -0x1.745d14p8,
    -0x1.745d14p-1,
    0x1.20p3
  },
  { // Entry 98
    -0x1.745d14p9,
    -0x1.745d14p-1,
    0x1.40p3
  },
  { // Entry 99
    -0x1.45d170p-11,
    -0x1.45d170p-1,
    -0x1.40p3
  },
  { // Entry 100
    -0x1.45d170p-10,
    -0x1.45d170p-1,
    -0x1.20p3
  },
  { // Entry 101
    -0x1.45d170p-9,
    -0x1.45d170p-1,
    -0x1.p3
  },
  { // Entry 102
    -0x1.45d170p-8,
    -0x1.45d170p-1,
    -0x1.c0p2
  },
  { // Entry 103
    -0x1.45d170p-7,
    -0x1.45d170p-1,
    -0x1.80p2
  },
  { // Entry 104
    -0x1.45d170p-6,
    -0x1.45d170p-1,
    -0x1.40p2
  },
  { // Entry 105
    -0x1.45d170p-5,
    -0x1.45d170p-1,
    -0x1.p2
  },
  { // Entry 106
    -0x1.45d170p-4,
    -0x1.45d170p-1,
    -0x1.80p1
  },
  { // Entry 107
    -0x1.45d170p-3,
    -0x1.45d170p-1,
    -0x1.p1
  },
  { // Entry 108
    -0x1.45d170p-2,
    -0x1.45d170p-1,
    -0x1.p0
  },
  { // Entry 109
    -0x1.45d170p-1,
    -0x1.45d170p-1,
    0.0
  },
  { // Entry 110
    -0x1.45d170p0,
    -0x1.45d170p-1,
    0x1.p0
  },
  { // Entry 111
    -0x1.45d170p1,
    -0x1.45d170p-1,
    0x1.p1
  },
  { // Entry 112
    -0x1.45d170p2,
    -0x1.45d170p-1,
    0x1.80p1
  },
  { // Entry 113
    -0x1.45d170p3,
    -0x1.45d170p-1,
    0x1.p2
  },
  { // Entry 114
    -0x1.45d170p4,
    -0x1.45d170p-1,
    0x1.40p2
  },
  { // Entry 115
    -0x1.45d170p5,
    -0x1.45d170p-1,
    0x1.80p2
  },
  { // Entry 116
    -0x1.45d170p6,
    -0x1.45d170p-1,
    0x1.c0p2
  },
  { // Entry 117
    -0x1.45d170p7,
    -0x1.45d170p-1,
    0x1.p3
  },
  { // Entry 118
    -0x1.45d170p8,
    -0x1.45d170p-1,
    0x1.20p3
  },
  { // Entry 119
    -0x1.45d170p9,
    -0x1.45d170p-1,
    0x1.40p3
  },
  { // Entry 120
    -0x1.1745ccp-11,
    -0x1.1745ccp-1,
    -0x1.40p3
  },
  { // Entry 121
    -0x1.1745ccp-10,
    -0x1.1745ccp-1,
    -0x1.20p3
  },
  { // Entry 122
    -0x1.1745ccp-9,
    -0x1.1745ccp-1,
    -0x1.p3
  },
  { // Entry 123
    -0x1.1745ccp-8,
    -0x1.1745ccp-1,
    -0x1.c0p2
  },
  { // Entry 124
    -0x1.1745ccp-7,
    -0x1.1745ccp-1,
    -0x1.80p2
  },
  { // Entry 125
    -0x1.1745ccp-6,
    -0x1.1745ccp-1,
    -0x1.40p2
  },
  { // Entry 126
    -0x1.1745ccp-5,
    -0x1.1745ccp-1,
    -0x1.p2
  },
  { // Entry 127
    -0x1.1745ccp-4,
    -0x1.1745ccp-1,
    -0x1.80p1
  },
  { // Entry 128
    -0x1.1745ccp-3,
    -0x1.1745ccp-1,
    -0x1.p1
  },
  { // Entry 129
    -0x1.1745ccp-2,
    -0x1.1745ccp-1,
    -0x1.p0
  },
  { // Entry 130
    -0x1.1745ccp-1,
    -0x1.1745ccp-1,
    0.0
  },
  { // Entry 131
    -0x1.1745ccp0,
    -0x1.1745ccp-1,
    0x1.p0
  },
  { // Entry 132
    -0x1.1745ccp1,
    -0x1.1745ccp-1,
    0x1.p1
  },
  { // Entry 133
    -0x1.1745ccp2,
    -0x1.1745ccp-1,
    0x1.80p1
  },
  { // Entry 134
    -0x1.1745ccp3,
    -0x1.1745ccp-1,
    0x1.p2
  },
  { // Entry 135
    -0x1.1745ccp4,
    -0x1.1745ccp-1,
    0x1.40p2
  },
  { // Entry 136
    -0x1.1745ccp5,
    -0x1.1745ccp-1,
    0x1.80p2
  },
  { // Entry 137
    -0x1.1745ccp6,
    -0x1.1745ccp-1,
    0x1.c0p2
  },
  { // Entry 138
    -0x1.1745ccp7,
    -0x1.1745ccp-1,
    0x1.p3
  },
  { // Entry 139
    -0x1.1745ccp8,
    -0x1.1745ccp-1,
    0x1.20p3
  },
  { // Entry 140
    -0x1.1745ccp9,
    -0x1.1745ccp-1,
    0x1.40p3
  },
  { // Entry 141
    -0x1.d17452p-12,
    -0x1.d17452p-2,
    -0x1.40p3
  },
  { // Entry 142
    -0x1.d17452p-11,
    -0x1.d17452p-2,
    -0x1.20p3
  },
  { // Entry 143
    -0x1.d17452p-10,
    -0x1.d17452p-2,
    -0x1.p3
  },
  { // Entry 144
    -0x1.d17452p-9,
    -0x1.d17452p-2,
    -0x1.c0p2
  },
  { // Entry 145
    -0x1.d17452p-8,
    -0x1.d17452p-2,
    -0x1.80p2
  },
  { // Entry 146
    -0x1.d17452p-7,
    -0x1.d17452p-2,
    -0x1.40p2
  },
  { // Entry 147
    -0x1.d17452p-6,
    -0x1.d17452p-2,
    -0x1.p2
  },
  { // Entry 148
    -0x1.d17452p-5,
    -0x1.d17452p-2,
    -0x1.80p1
  },
  { // Entry 149
    -0x1.d17452p-4,
    -0x1.d17452p-2,
    -0x1.p1
  },
  { // Entry 150
    -0x1.d17452p-3,
    -0x1.d17452p-2,
    -0x1.p0
  },
  { // Entry 151
    -0x1.d17452p-2,
    -0x1.d17452p-2,
    0.0
  },
  { // Entry 152
    -0x1.d17452p-1,
    -0x1.d17452p-2,
    0x1.p0
  },
  { // Entry 153
    -0x1.d17452p0,
    -0x1.d17452p-2,
    0x1.p1
  },
  { // Entry 154
    -0x1.d17452p1,
    -0x1.d17452p-2,
    0x1.80p1
  },
  { // Entry 155
    -0x1.d17452p2,
    -0x1.d17452p-2,
    0x1.p2
  },
  { // Entry 156
    -0x1.d17452p3,
    -0x1.d17452p-2,
    0x1.40p2
  },
  { // Entry 157
    -0x1.d17452p4,
    -0x1.d17452p-2,
    0x1.80p2
  },
  { // Entry 158
    -0x1.d17452p5,
    -0x1.d17452p-2,
    0x1.c0p2
  },
  { // Entry 159
    -0x1.d17452p6,
    -0x1.d17452p-2,
    0x1.p3
  },
  { // Entry 160
    -0x1.d17452p7,
    -0x1.d17452p-2,
    0x1.20p3
  },
  { // Entry 161
    -0x1.d17452p8,
    -0x1.d17452p-2,
    0x1.40p3
  },
  { // Entry 162
    -0x1.745d0cp-12,
    -0x1.745d0cp-2,
    -0x1.40p3
  },
  { // Entry 163
    -0x1.745d0cp-11,
    -0x1.745d0cp-2,
    -0x1.20p3
  },
  { // Entry 164
    -0x1.745d0cp-10,
    -0x1.745d0cp-2,
    -0x1.p3
  },
  { // Entry 165
    -0x1.745d0cp-9,
    -0x1.745d0cp-2,
    -0x1.c0p2
  },
  { // Entry 166
    -0x1.745d0cp-8,
    -0x1.745d0cp-2,
    -0x1.80p2
  },
  { // Entry 167
    -0x1.745d0cp-7,
    -0x1.745d0cp-2,
    -0x1.40p2
  },
  { // Entry 168
    -0x1.745d0cp-6,
    -0x1.745d0cp-2,
    -0x1.p2
  },
  { // Entry 169
    -0x1.745d0cp-5,
    -0x1.745d0cp-2,
    -0x1.80p1
  },
  { // Entry 170
    -0x1.745d0cp-4,
    -0x1.745d0cp-2,
    -0x1.p1
  },
  { // Entry 171
    -0x1.745d0cp-3,
    -0x1.745d0cp-2,
    -0x1.p0
  },
  { // Entry 172
    -0x1.745d0cp-2,
    -0x1.745d0cp-2,
    0.0
  },
  { // Entry 173
    -0x1.745d0cp-1,
    -0x1.745d0cp-2,
    0x1.p0
  },
  { // Entry 174
    -0x1.745d0cp0,
    -0x1.745d0cp-2,
    0x1.p1
  },
  { // Entry 175
    -0x1.745d0cp1,
    -0x1.745d0cp-2,
    0x1.80p1
  },
  { // Entry 176
    -0x1.745d0cp2,
    -0x1.745d0cp-2,
    0x1.p2
  },
  { // Entry 177
    -0x1.745d0cp3,
    -0x1.745d0cp-2,
    0x1.40p2
  },
  { // Entry 178
    -0x1.745d0cp4,
    -0x1.745d0cp-2,
    0x1.80p2
  },
  { // Entry 179
    -0x1.745d0cp5,
    -0x1.745d0cp-2,
    0x1.c0p2
  },
  { // Entry 180
    -0x1.745d0cp6,
    -0x1.745d0cp-2,
    0x1.p3
  },
  { // Entry 181
    -0x1.745d0cp7,
    -0x1.745d0cp-2,
    0x1.20p3
  },
  { // Entry 182
    -0x1.745d0cp8,
    -0x1.745d0cp-2,
    0x1.40p3
  },
  { // Entry 183
    -0x1.1745c6p-12,
    -0x1.1745c6p-2,
    -0x1.40p3
  },
  { // Entry 184
    -0x1.1745c6p-11,
    -0x1.1745c6p-2,
    -0x1.20p3
  },
  { // Entry 185
    -0x1.1745c6p-10,
    -0x1.1745c6p-2,
    -0x1.p3
  },
  { // Entry 186
    -0x1.1745c6p-9,
    -0x1.1745c6p-2,
    -0x1.c0p2
  },
  { // Entry 187
    -0x1.1745c6p-8,
    -0x1.1745c6p-2,
    -0x1.80p2
  },
  { // Entry 188
    -0x1.1745c6p-7,
    -0x1.1745c6p-2,
    -0x1.40p2
  },
  { // Entry 189
    -0x1.1745c6p-6,
    -0x1.1745c6p-2,
    -0x1.p2
  },
  { // Entry 190
    -0x1.1745c6p-5,
    -0x1.1745c6p-2,
    -0x1.80p1
  },
  { // Entry 191
    -0x1.1745c6p-4,
    -0x1.1745c6p-2,
    -0x1.p1
  },
  { // Entry 192
    -0x1.1745c6p-3,
    -0x1.1745c6p-2,
    -0x1.p0
  },
  { // Entry 193
    -0x1.1745c6p-2,
    -0x1.1745c6p-2,
    0.0
  },
  { // Entry 194
    -0x1.1745c6p-1,
    -0x1.1745c6p-2,
    0x1.p0
  },
  { // Entry 195
    -0x1.1745c6p0,
    -0x1.1745c6p-2,
    0x1.p1
  },
  { // Entry 196
    -0x1.1745c6p1,
    -0x1.1745c6p-2,
    0x1.80p1
  },
  { // Entry 197
    -0x1.1745c6p2,
    -0x1.1745c6p-2,
    0x1.p2
  },
  { // Entry 198
    -0x1.1745c6p3,
    -0x1.1745c6p-2,
    0x1.40p2
  },
  { // Entry 199
    -0x1.1745c6p4,
    -0x1.1745c6p-2,
    0x1.80p2
  },
  { // Entry 200
    -0x1.1745c6p5,
    -0x1.1745c6p-2,
    0x1.c0p2
  },
  { // Entry 201
    -0x1.1745c6p6,
    -0x1.1745c6p-2,
    0x1.p3
  },
  { // Entry 202
    -0x1.1745c6p7,
    -0x1.1745c6p-2,
    0x1.20p3
  },
  { // Entry 203
    -0x1.1745c6p8,
    -0x1.1745c6p-2,
    0x1.40p3
  },
  { // Entry 204
    -0x1.745dp-13,
    -0x1.745dp-3,
    -0x1.40p3
  },
  { // Entry 205
    -0x1.745dp-12,
    -0x1.745dp-3,
    -0x1.20p3
  },
  { // Entry 206
    -0x1.745dp-11,
    -0x1.745dp-3,
    -0x1.p3
  },
  { // Entry 207
    -0x1.745dp-10,
    -0x1.745dp-3,
    -0x1.c0p2
  },
  { // Entry 208
    -0x1.745dp-9,
    -0x1.745dp-3,
    -0x1.80p2
  },
  { // Entry 209
    -0x1.745dp-8,
    -0x1.745dp-3,
    -0x1.40p2
  },
  { // Entry 210
    -0x1.745dp-7,
    -0x1.745dp-3,
    -0x1.p2
  },
  { // Entry 211
    -0x1.745dp-6,
    -0x1.745dp-3,
    -0x1.80p1
  },
  { // Entry 212
    -0x1.745dp-5,
    -0x1.745dp-3,
    -0x1.p1
  },
  { // Entry 213
    -0x1.745dp-4,
    -0x1.745dp-3,
    -0x1.p0
  },
  { // Entry 214
    -0x1.745dp-3,
    -0x1.745dp-3,
    0.0
  },
  { // Entry 215
    -0x1.745dp-2,
    -0x1.745dp-3,
    0x1.p0
  },
  { // Entry 216
    -0x1.745dp-1,
    -0x1.745dp-3,
    0x1.p1
  },
  { // Entry 217
    -0x1.745dp0,
    -0x1.745dp-3,
    0x1.80p1
  },
  { // Entry 218
    -0x1.745dp1,
    -0x1.745dp-3,
    0x1.p2
  },
  { // Entry 219
    -0x1.745dp2,
    -0x1.745dp-3,
    0x1.40p2
  },
  { // Entry 220
    -0x1.745dp3,
    -0x1.745dp-3,
    0x1.80p2
  },
  { // Entry 221
    -0x1.745dp4,
    -0x1.745dp-3,
    0x1.c0p2
  },
  { // Entry 222
    -0x1.745dp5,
    -0x1.745dp-3,
    0x1.p3
  },
  { // Entry 223
    -0x1.745dp6,
    -0x1.745dp-3,
    0x1.20p3
  },
  { // Entry 224
    -0x1.745dp7,
    -0x1.745dp-3,
    0x1.40p3
  },
  { // Entry 225
    -0x1.745ce8p-14,
    -0x1.745ce8p-4,
    -0x1.40p3
  },
  { // Entry 226
    -0x1.745ce8p-13,
    -0x1.745ce8p-4,
    -0x1.20p3
  },
  { // Entry 227
    -0x1.745ce8p-12,
    -0x1.745ce8p-4,
    -0x1.p3
  },
  { // Entry 228
    -0x1.745ce8p-11,
    -0x1.745ce8p-4,
    -0x1.c0p2
  },
  { // Entry 229
    -0x1.745ce8p-10,
    -0x1.745ce8p-4,
    -0x1.80p2
  },
  { // Entry 230
    -0x1.745ce8p-9,
    -0x1.745ce8p-4,
    -0x1.40p2
  },
  { // Entry 231
    -0x1.745ce8p-8,
    -0x1.745ce8p-4,
    -0x1.p2
  },
  { // Entry 232
    -0x1.745ce8p-7,
    -0x1.745ce8p-4,
    -0x1.80p1
  },
  { // Entry 233
    -0x1.745ce8p-6,
    -0x1.745ce8p-4,
    -0x1.p1
  },
  { // Entry 234
    -0x1.745ce8p-5,
    -0x1.745ce8p-4,
    -0x1.p0
  },
  { // Entry 235
    -0x1.745ce8p-4,
    -0x1.745ce8p-4,
    0.0
  },
  { // Entry 236
    -0x1.745ce8p-3,
    -0x1.745ce8p-4,
    0x1.p0
  },
  { // Entry 237
    -0x1.745ce8p-2,
    -0x1.745ce8p-4,
    0x1.p1
  },
  { // Entry 238
    -0x1.745ce8p-1,
    -0x1.745ce8p-4,
    0x1.80p1
  },
  { // Entry 239
    -0x1.745ce8p0,
    -0x1.745ce8p-4,
    0x1.p2
  },
  { // Entry 240
    -0x1.745ce8p1,
    -0x1.745ce8p-4,
    0x1.40p2
  },
  { // Entry 241
    -0x1.745ce8p2,
    -0x1.745ce8p-4,
    0x1.80p2
  },
  { // Entry 242
    -0x1.745ce8p3,
    -0x1.745ce8p-4,
    0x1.c0p2
  },
  { // Entry 243
    -0x1.745ce8p4,
    -0x1.745ce8p-4,
    0x1.p3
  },
  { // Entry 244
    -0x1.745ce8p5,
    -0x1.745ce8p-4,
    0x1.20p3
  },
  { // Entry 245
    -0x1.745ce8p6,
    -0x1.745ce8p-4,
    0x1.40p3
  },
  { // Entry 246
    0x1.80p-33,
    0x1.80p-23,
    -0x1.40p3
  },
  { // Entry 247
    0x1.80p-32,
    0x1.80p-23,
    -0x1.20p3
  },
  { // Entry 248
    0x1.80p-31,
    0x1.80p-23,
    -0x1.p3
  },
  { // Entry 249
    0x1.80p-30,
    0x1.80p-23,
    -0x1.c0p2
  },
  { // Entry 250
    0x1.80p-29,
    0x1.80p-23,
    -0x1.80p2
  },
  { // Entry 251
    0x1.80p-28,
    0x1.80p-23,
    -0x1.40p2
  },
  { // Entry 252
    0x1.80p-27,
    0x1.80p-23,
    -0x1.p2
  },
  { // Entry 253
    0x1.80p-26,
    0x1.80p-23,
    -0x1.80p1
  },
  { // Entry 254
    0x1.80p-25,
    0x1.80p-23,
    -0x1.p1
  },
  { // Entry 255
    0x1.80p-24,
    0x1.80p-23,
    -0x1.p0
  },
  { // Entry 256
    0x1.80p-23,
    0x1.80p-23,
    0.0
  },
  { // Entry 257
    0x1.80p-22,
    0x1.80p-23,
    0x1.p0
  },
  { // Entry 258
    0x1.80p-21,
    0x1.80p-23,
    0x1.p1
  },
  { // Entry 259
    0x1.80p-20,
    0x1.80p-23,
    0x1.80p1
  },
  { // Entry 260
    0x1.80p-19,
    0x1.80p-23,
    0x1.p2
  },
  { // Entry 261
    0x1.80p-18,
    0x1.80p-23,
    0x1.40p2
  },
  { // Entry 262
    0x1.80p-17,
    0x1.80p-23,
    0x1.80p2
  },
  { // Entry 263
    0x1.80p-16,
    0x1.80p-23,
    0x1.c0p2
  },
  { // Entry 264
    0x1.80p-15,
    0x1.80p-23,
    0x1.p3
  },
  { // Entry 265
    0x1.80p-14,
    0x1.80p-23,
    0x1.20p3
  },
  { // Entry 266
    0x1.80p-13,
    0x1.80p-23,
    0x1.40p3
  },
  { // Entry 267
    0x1.745d48p-14,
    0x1.745d48p-4,
    -0x1.40p3
  },
  { // Entry 268
    0x1.745d48p-13,
    0x1.745d48p-4,
    -0x1.20p3
  },
  { // Entry 269
    0x1.745d48p-12,
    0x1.745d48p-4,
    -0x1.p3
  },
  { // Entry 270
    0x1.745d48p-11,
    0x1.745d48p-4,
    -0x1.c0p2
  },
  { // Entry 271
    0x1.745d48p-10,
    0x1.745d48p-4,
    -0x1.80p2
  },
  { // Entry 272
    0x1.745d48p-9,
    0x1.745d48p-4,
    -0x1.40p2
  },
  { // Entry 273
    0x1.745d48p-8,
    0x1.745d48p-4,
    -0x1.p2
  },
  { // Entry 274
    0x1.745d48p-7,
    0x1.745d48p-4,
    -0x1.80p1
  },
  { // Entry 275
    0x1.745d48p-6,
    0x1.745d48p-4,
    -0x1.p1
  },
  { // Entry 276
    0x1.745d48p-5,
    0x1.745d48p-4,
    -0x1.p0
  },
  { // Entry 277
    0x1.745d48p-4,
    0x1.745d48p-4,
    0.0
  },
  { // Entry 278
    0x1.745d48p-3,
    0x1.745d48p-4,
    0x1.p0
  },
  { // Entry 279
    0x1.745d48p-2,
    0x1.745d48p-4,
    0x1.p1
  },
  { // Entry 280
    0x1.745d48p-1,
    0x1.745d48p-4,
    0x1.80p1
  },
  { // Entry 281
    0x1.745d48p0,
    0x1.745d48p-4,
    0x1.p2
  },
  { // Entry 282
    0x1.745d48p1,
    0x1.745d48p-4,
    0x1.40p2
  },
  { // Entry 283
    0x1.745d48p2,
    0x1.745d48p-4,
    0x1.80p2
  },
  { // Entry 284
    0x1.745d48p3,
    0x1.745d48p-4,
    0x1.c0p2
  },
  { // Entry 285
    0x1.745d48p4,
    0x1.745d48p-4,
    0x1.p3
  },
  { // Entry 286
    0x1.745d48p5,
    0x1.745d48p-4,
    0x1.20p3
  },
  { // Entry 287
    0x1.745d48p6,
    0x1.745d48p-4,
    0x1.40p3
  },
  { // Entry 288
    0x1.745d30p-13,
    0x1.745d30p-3,
    -0x1.40p3
  },
  { // Entry 289
    0x1.745d30p-12,
    0x1.745d30p-3,
    -0x1.20p3
  },
  { // Entry 290
    0x1.745d30p-11,
    0x1.745d30p-3,
    -0x1.p3
  },
  { // Entry 291
    0x1.745d30p-10,
    0x1.745d30p-3,
    -0x1.c0p2
  },
  { // Entry 292
    0x1.745d30p-9,
    0x1.745d30p-3,
    -0x1.80p2
  },
  { // Entry 293
    0x1.745d30p-8,
    0x1.745d30p-3,
    -0x1.40p2
  },
  { // Entry 294
    0x1.745d30p-7,
    0x1.745d30p-3,
    -0x1.p2
  },
  { // Entry 295
    0x1.745d30p-6,
    0x1.745d30p-3,
    -0x1.80p1
  },
  { // Entry 296
    0x1.745d30p-5,
    0x1.745d30p-3,
    -0x1.p1
  },
  { // Entry 297
    0x1.745d30p-4,
    0x1.745d30p-3,
    -0x1.p0
  },
  { // Entry 298
    0x1.745d30p-3,
    0x1.745d30p-3,
    0.0
  },
  { // Entry 299
    0x1.745d30p-2,
    0x1.745d30p-3,
    0x1.p0
  },
  { // Entry 300
    0x1.745d30p-1,
    0x1.745d30p-3,
    0x1.p1
  },
  { // Entry 301
    0x1.745d30p0,
    0x1.745d30p-3,
    0x1.80p1
  },
  { // Entry 302
    0x1.745d30p1,
    0x1.745d30p-3,
    0x1.p2
  },
  { // Entry 303
    0x1.745d30p2,
    0x1.745d30p-3,
    0x1.40p2
  },
  { // Entry 304
    0x1.745d30p3,
    0x1.745d30p-3,
    0x1.80p2
  },
  { // Entry 305
    0x1.745d30p4,
    0x1.745d30p-3,
    0x1.c0p2
  },
  { // Entry 306
    0x1.745d30p5,
    0x1.745d30p-3,
    0x1.p3
  },
  { // Entry 307
    0x1.745d30p6,
    0x1.745d30p-3,
    0x1.20p3
  },
  { // Entry 308
    0x1.745d30p7,
    0x1.745d30p-3,
    0x1.40p3
  },
  { // Entry 309
    0x1.1745dep-12,
    0x1.1745dep-2,
    -0x1.40p3
  },
  { // Entry 310
    0x1.1745dep-11,
    0x1.1745dep-2,
    -0x1.20p3
  },
  { // Entry 311
    0x1.1745dep-10,
    0x1.1745dep-2,
    -0x1.p3
  },
  { // Entry 312
    0x1.1745dep-9,
    0x1.1745dep-2,
    -0x1.c0p2
  },
  { // Entry 313
    0x1.1745dep-8,
    0x1.1745dep-2,
    -0x1.80p2
  },
  { // Entry 314
    0x1.1745dep-7,
    0x1.1745dep-2,
    -0x1.40p2
  },
  { // Entry 315
    0x1.1745dep-6,
    0x1.1745dep-2,
    -0x1.p2
  },
  { // Entry 316
    0x1.1745dep-5,
    0x1.1745dep-2,
    -0x1.80p1
  },
  { // Entry 317
    0x1.1745dep-4,
    0x1.1745dep-2,
    -0x1.p1
  },
  { // Entry 318
    0x1.1745dep-3,
    0x1.1745dep-2,
    -0x1.p0
  },
  { // Entry 319
    0x1.1745dep-2,
    0x1.1745dep-2,
    0.0
  },
  { // Entry 320
    0x1.1745dep-1,
    0x1.1745dep-2,
    0x1.p0
  },
  { // Entry 321
    0x1.1745dep0,
    0x1.1745dep-2,
    0x1.p1
  },
  { // Entry 322
    0x1.1745dep1,
    0x1.1745dep-2,
    0x1.80p1
  },
  { // Entry 323
    0x1.1745dep2,
    0x1.1745dep-2,
    0x1.p2
  },
  { // Entry 324
    0x1.1745dep3,
    0x1.1745dep-2,
    0x1.40p2
  },
  { // Entry 325
    0x1.1745dep4,
    0x1.1745dep-2,
    0x1.80p2
  },
  { // Entry 326
    0x1.1745dep5,
    0x1.1745dep-2,
    0x1.c0p2
  },
  { // Entry 327
    0x1.1745dep6,
    0x1.1745dep-2,
    0x1.p3
  },
  { // Entry 328
    0x1.1745dep7,
    0x1.1745dep-2,
    0x1.20p3
  },
  { // Entry 329
    0x1.1745dep8,
    0x1.1745dep-2,
    0x1.40p3
  },
  { // Entry 330
    0x1.745d24p-12,
    0x1.745d24p-2,
    -0x1.40p3
  },
  { // Entry 331
    0x1.745d24p-11,
    0x1.745d24p-2,
    -0x1.20p3
  },
  { // Entry 332
    0x1.745d24p-10,
    0x1.745d24p-2,
    -0x1.p3
  },
  { // Entry 333
    0x1.745d24p-9,
    0x1.745d24p-2,
    -0x1.c0p2
  },
  { // Entry 334
    0x1.745d24p-8,
    0x1.745d24p-2,
    -0x1.80p2
  },
  { // Entry 335
    0x1.745d24p-7,
    0x1.745d24p-2,
    -0x1.40p2
  },
  { // Entry 336
    0x1.745d24p-6,
    0x1.745d24p-2,
    -0x1.p2
  },
  { // Entry 337
    0x1.745d24p-5,
    0x1.745d24p-2,
    -0x1.80p1
  },
  { // Entry 338
    0x1.745d24p-4,
    0x1.745d24p-2,
    -0x1.p1
  },
  { // Entry 339
    0x1.745d24p-3,
    0x1.745d24p-2,
    -0x1.p0
  },
  { // Entry 340
    0x1.745d24p-2,
    0x1.745d24p-2,
    0.0
  },
  { // Entry 341
    0x1.745d24p-1,
    0x1.745d24p-2,
    0x1.p0
  },
  { // Entry 342
    0x1.745d24p0,
    0x1.745d24p-2,
    0x1.p1
  },
  { // Entry 343
    0x1.745d24p1,
    0x1.745d24p-2,
    0x1.80p1
  },
  { // Entry 344
    0x1.745d24p2,
    0x1.745d24p-2,
    0x1.p2
  },
  { // Entry 345
    0x1.745d24p3,
    0x1.745d24p-2,
    0x1.40p2
  },
  { // Entry 346
    0x1.745d24p4,
    0x1.745d24p-2,
    0x1.80p2
  },
  { // Entry 347
    0x1.745d24p5,
    0x1.745d24p-2,
    0x1.c0p2
  },
  { // Entry 348
    0x1.745d24p6,
    0x1.745d24p-2,
    0x1.p3
  },
  { // Entry 349
    0x1.745d24p7,
    0x1.745d24p-2,
    0x1.20p3
  },
  { // Entry 350
    0x1.745d24p8,
    0x1.745d24p-2,
    0x1.40p3
  },
  { // Entry 351
    0x1.d1746ap-12,
    0x1.d1746ap-2,
    -0x1.40p3
  },
  { // Entry 352
    0x1.d1746ap-11,
    0x1.d1746ap-2,
    -0x1.20p3
  },
  { // Entry 353
    0x1.d1746ap-10,
    0x1.d1746ap-2,
    -0x1.p3
  },
  { // Entry 354
    0x1.d1746ap-9,
    0x1.d1746ap-2,
    -0x1.c0p2
  },
  { // Entry 355
    0x1.d1746ap-8,
    0x1.d1746ap-2,
    -0x1.80p2
  },
  { // Entry 356
    0x1.d1746ap-7,
    0x1.d1746ap-2,
    -0x1.40p2
  },
  { // Entry 357
    0x1.d1746ap-6,
    0x1.d1746ap-2,
    -0x1.p2
  },
  { // Entry 358
    0x1.d1746ap-5,
    0x1.d1746ap-2,
    -0x1.80p1
  },
  { // Entry 359
    0x1.d1746ap-4,
    0x1.d1746ap-2,
    -0x1.p1
  },
  { // Entry 360
    0x1.d1746ap-3,
    0x1.d1746ap-2,
    -0x1.p0
  },
  { // Entry 361
    0x1.d1746ap-2,
    0x1.d1746ap-2,
    0.0
  },
  { // Entry 362
    0x1.d1746ap-1,
    0x1.d1746ap-2,
    0x1.p0
  },
  { // Entry 363
    0x1.d1746ap0,
    0x1.d1746ap-2,
    0x1.p1
  },
  { // Entry 364
    0x1.d1746ap1,
    0x1.d1746ap-2,
    0x1.80p1
  },
  { // Entry 365
    0x1.d1746ap2,
    0x1.d1746ap-2,
    0x1.p2
  },
  { // Entry 366
    0x1.d1746ap3,
    0x1.d1746ap-2,
    0x1.40p2
  },
  { // Entry 367
    0x1.d1746ap4,
    0x1.d1746ap-2,
    0x1.80p2
  },
  { // Entry 368
    0x1.d1746ap5,
    0x1.d1746ap-2,
    0x1.c0p2
  },
  { // Entry 369
    0x1.d1746ap6,
    0x1.d1746ap-2,
    0x1.p3
  },
  { // Entry 370
    0x1.d1746ap7,
    0x1.d1746ap-2,
    0x1.20p3
  },
  { // Entry 371
    0x1.d1746ap8,
    0x1.d1746ap-2,
    0x1.40p3
  },
  { // Entry 372
    0x1.1745d8p-11,
    0x1.1745d8p-1,
    -0x1.40p3
  },
  { // Entry 373
    0x1.1745d8p-10,
    0x1.1745d8p-1,
    -0x1.20p3
  },
  { // Entry 374
    0x1.1745d8p-9,
    0x1.1745d8p-1,
    -0x1.p3
  },
  { // Entry 375
    0x1.1745d8p-8,
    0x1.1745d8p-1,
    -0x1.c0p2
  },
  { // Entry 376
    0x1.1745d8p-7,
    0x1.1745d8p-1,
    -0x1.80p2
  },
  { // Entry 377
    0x1.1745d8p-6,
    0x1.1745d8p-1,
    -0x1.40p2
  },
  { // Entry 378
    0x1.1745d8p-5,
    0x1.1745d8p-1,
    -0x1.p2
  },
  { // Entry 379
    0x1.1745d8p-4,
    0x1.1745d8p-1,
    -0x1.80p1
  },
  { // Entry 380
    0x1.1745d8p-3,
    0x1.1745d8p-1,
    -0x1.p1
  },
  { // Entry 381
    0x1.1745d8p-2,
    0x1.1745d8p-1,
    -0x1.p0
  },
  { // Entry 382
    0x1.1745d8p-1,
    0x1.1745d8p-1,
    0.0
  },
  { // Entry 383
    0x1.1745d8p0,
    0x1.1745d8p-1,
    0x1.p0
  },
  { // Entry 384
    0x1.1745d8p1,
    0x1.1745d8p-1,
    0x1.p1
  },
  { // Entry 385
    0x1.1745d8p2,
    0x1.1745d8p-1,
    0x1.80p1
  },
  { // Entry 386
    0x1.1745d8p3,
    0x1.1745d8p-1,
    0x1.p2
  },
  { // Entry 387
    0x1.1745d8p4,
    0x1.1745d8p-1,
    0x1.40p2
  },
  { // Entry 388
    0x1.1745d8p5,
    0x1.1745d8p-1,
    0x1.80p2
  },
  { // Entry 389
    0x1.1745d8p6,
    0x1.1745d8p-1,
    0x1.c0p2
  },
  { // Entry 390
    0x1.1745d8p7,
    0x1.1745d8p-1,
    0x1.p3
  },
  { // Entry 391
    0x1.1745d8p8,
    0x1.1745d8p-1,
    0x1.20p3
  },
  { // Entry 392
    0x1.1745d8p9,
    0x1.1745d8p-1,
    0x1.40p3
  },
  { // Entry 393
    0x1.45d17cp-11,
    0x1.45d17cp-1,
    -0x1.40p3
  },
  { // Entry 394
    0x1.45d17cp-10,
    0x1.45d17cp-1,
    -0x1.20p3
  },
  { // Entry 395
    0x1.45d17cp-9,
    0x1.45d17cp-1,
    -0x1.p3
  },
  { // Entry 396
    0x1.45d17cp-8,
    0x1.45d17cp-1,
    -0x1.c0p2
  },
  { // Entry 397
    0x1.45d17cp-7,
    0x1.45d17cp-1,
    -0x1.80p2
  },
  { // Entry 398
    0x1.45d17cp-6,
    0x1.45d17cp-1,
    -0x1.40p2
  },
  { // Entry 399
    0x1.45d17cp-5,
    0x1.45d17cp-1,
    -0x1.p2
  },
  { // Entry 400
    0x1.45d17cp-4,
    0x1.45d17cp-1,
    -0x1.80p1
  },
  { // Entry 401
    0x1.45d17cp-3,
    0x1.45d17cp-1,
    -0x1.p1
  },
  { // Entry 402
    0x1.45d17cp-2,
    0x1.45d17cp-1,
    -0x1.p0
  },
  { // Entry 403
    0x1.45d17cp-1,
    0x1.45d17cp-1,
    0.0
  },
  { // Entry 404
    0x1.45d17cp0,
    0x1.45d17cp-1,
    0x1.p0
  },
  { // Entry 405
    0x1.45d17cp1,
    0x1.45d17cp-1,
    0x1.p1
  },
  { // Entry 406
    0x1.45d17cp2,
    0x1.45d17cp-1,
    0x1.80p1
  },
  { // Entry 407
    0x1.45d17cp3,
    0x1.45d17cp-1,
    0x1.p2
  },
  { // Entry 408
    0x1.45d17cp4,
    0x1.45d17cp-1,
    0x1.40p2
  },
  { // Entry 409
    0x1.45d17cp5,
    0x1.45d17cp-1,
    0x1.80p2
  },
  { // Entry 410
    0x1.45d17cp6,
    0x1.45d17cp-1,
    0x1.c0p2
  },
  { // Entry 411
    0x1.45d17cp7,
    0x1.45d17cp-1,
    0x1.p3
  },
  { // Entry 412
    0x1.45d17cp8,
    0x1.45d17cp-1,
    0x1.20p3
  },
  { // Entry 413
    0x1.45d17cp9,
    0x1.45d17cp-1,
    0x1.40p3
  },
  { // Entry 414
    0x1.745d20p-11,
    0x1.745d20p-1,
    -0x1.40p3
  },
  { // Entry 415
    0x1.745d20p-10,
    0x1.745d20p-1,
    -0x1.20p3
  },
  { // Entry 416
    0x1.745d20p-9,
    0x1.745d20p-1,
    -0x1.p3
  },
  { // Entry 417
    0x1.745d20p-8,
    0x1.745d20p-1,
    -0x1.c0p2
  },
  { // Entry 418
    0x1.745d20p-7,
    0x1.745d20p-1,
    -0x1.80p2
  },
  { // Entry 419
    0x1.745d20p-6,
    0x1.745d20p-1,
    -0x1.40p2
  },
  { // Entry 420
    0x1.745d20p-5,
    0x1.745d20p-1,
    -0x1.p2
  },
  { // Entry 421
    0x1.745d20p-4,
    0x1.745d20p-1,
    -0x1.80p1
  },
  { // Entry 422
    0x1.745d20p-3,
    0x1.745d20p-1,
    -0x1.p1
  },
  { // Entry 423
    0x1.745d20p-2,
    0x1.745d20p-1,
    -0x1.p0
  },
  { // Entry 424
    0x1.745d20p-1,
    0x1.745d20p-1,
    0.0
  },
  { // Entry 425
    0x1.745d20p0,
    0x1.745d20p-1,
    0x1.p0
  },
  { // Entry 426
    0x1.745d20p1,
    0x1.745d20p-1,
    0x1.p1
  },
  { // Entry 427
    0x1.745d20p2,
    0x1.745d20p-1,
    0x1.80p1
  },
  { // Entry 428
    0x1.745d20p3,
    0x1.745d20p-1,
    0x1.p2
  },
  { // Entry 429
    0x1.745d20p4,
    0x1.745d20p-1,
    0x1.40p2
  },
  { // Entry 430
    0x1.745d20p5,
    0x1.745d20p-1,
    0x1.80p2
  },
  { // Entry 431
    0x1.745d20p6,
    0x1.745d20p-1,
    0x1.c0p2
  },
  { // Entry 432
    0x1.745d20p7,
    0x1.745d20p-1,
    0x1.p3
  },
  { // Entry 433
    0x1.745d20p8,
    0x1.745d20p-1,
    0x1.20p3
  },
  { // Entry 434
    0x1.745d20p9,
    0x1.745d20p-1,
    0x1.40p3
  },
  { // Entry 435
    0x1.a2e8c4p-11,
    0x1.a2e8c4p-1,
    -0x1.40p3
  },
  { // Entry 436
    0x1.a2e8c4p-10,
    0x1.a2e8c4p-1,
    -0x1.20p3
  },
  { // Entry 437
    0x1.a2e8c4p-9,
    0x1.a2e8c4p-1,
    -0x1.p3
  },
  { // Entry 438
    0x1.a2e8c4p-8,
    0x1.a2e8c4p-1,
    -0x1.c0p2
  },
  { // Entry 439
    0x1.a2e8c4p-7,
    0x1.a2e8c4p-1,
    -0x1.80p2
  },
  { // Entry 440
    0x1.a2e8c4p-6,
    0x1.a2e8c4p-1,
    -0x1.40p2
  },
  { // Entry 441
    0x1.a2e8c4p-5,
    0x1.a2e8c4p-1,
    -0x1.p2
  },
  { // Entry 442
    0x1.a2e8c4p-4,
    0x1.a2e8c4p-1,
    -0x1.80p1
  },
  { // Entry 443
    0x1.a2e8c4p-3,
    0x1.a2e8c4p-1,
    -0x1.p1
  },
  { // Entry 444
    0x1.a2e8c4p-2,
    0x1.a2e8c4p-1,
    -0x1.p0
  },
  { // Entry 445
    0x1.a2e8c4p-1,
    0x1.a2e8c4p-1,
    0.0
  },
  { // Entry 446
    0x1.a2e8c4p0,
    0x1.a2e8c4p-1,
    0x1.p0
  },
  { // Entry 447
    0x1.a2e8c4p1,
    0x1.a2e8c4p-1,
    0x1.p1
  },
  { // Entry 448
    0x1.a2e8c4p2,
    0x1.a2e8c4p-1,
    0x1.80p1
  },
  { // Entry 449
    0x1.a2e8c4p3,
    0x1.a2e8c4p-1,
    0x1.p2
  },
  { // Entry 450
    0x1.a2e8c4p4,
    0x1.a2e8c4p-1,
    0x1.40p2
  },
  { // Entry 451
    0x1.a2e8c4p5,
    0x1.a2e8c4p-1,
    0x1.80p2
  },
  { // Entry 452
    0x1.a2e8c4p6,
    0x1.a2e8c4p-1,
    0x1.c0p2
  },
  { // Entry 453
    0x1.a2e8c4p7,
    0x1.a2e8c4p-1,
    0x1.p3
  },
  { // Entry 454
    0x1.a2e8c4p8,
    0x1.a2e8c4p-1,
    0x1.20p3
  },
  { // Entry 455
    0x1.a2e8c4p9,
    0x1.a2e8c4p-1,
    0x1.40p3
  },
  { // Entry 456
    0x1.d17468p-11,
    0x1.d17468p-1,
    -0x1.40p3
  },
  { // Entry 457
    0x1.d17468p-10,
    0x1.d17468p-1,
    -0x1.20p3
  },
  { // Entry 458
    0x1.d17468p-9,
    0x1.d17468p-1,
    -0x1.p3
  },
  { // Entry 459
    0x1.d17468p-8,
    0x1.d17468p-1,
    -0x1.c0p2
  },
  { // Entry 460
    0x1.d17468p-7,
    0x1.d17468p-1,
    -0x1.80p2
  },
  { // Entry 461
    0x1.d17468p-6,
    0x1.d17468p-1,
    -0x1.40p2
  },
  { // Entry 462
    0x1.d17468p-5,
    0x1.d17468p-1,
    -0x1.p2
  },
  { // Entry 463
    0x1.d17468p-4,
    0x1.d17468p-1,
    -0x1.80p1
  },
  { // Entry 464
    0x1.d17468p-3,
    0x1.d17468p-1,
    -0x1.p1
  },
  { // Entry 465
    0x1.d17468p-2,
    0x1.d17468p-1,
    -0x1.p0
  },
  { // Entry 466
    0x1.d17468p-1,
    0x1.d17468p-1,
    0.0
  },
  { // Entry 467
    0x1.d17468p0,
    0x1.d17468p-1,
    0x1.p0
  },
  { // Entry 468
    0x1.d17468p1,
    0x1.d17468p-1,
    0x1.p1
  },
  { // Entry 469
    0x1.d17468p2,
    0x1.d17468p-1,
    0x1.80p1
  },
  { // Entry 470
    0x1.d17468p3,
    0x1.d17468p-1,
    0x1.p2
  },
  { // Entry 471
    0x1.d17468p4,
    0x1.d17468p-1,
    0x1.40p2
  },
  { // Entry 472
    0x1.d17468p5,
    0x1.d17468p-1,
    0x1.80p2
  },
  { // Entry 473
    0x1.d17468p6,
    0x1.d17468p-1,
    0x1.c0p2
  },
  { // Entry 474
    0x1.d17468p7,
    0x1.d17468p-1,
    0x1.p3
  },
  { // Entry 475
    0x1.d17468p8,
    0x1.d17468p-1,
    0x1.20p3
  },
  { // Entry 476
    0x1.d17468p9,
    0x1.d17468p-1,
    0x1.40p3
  },
  { // Entry 477
    0x1.p-10,
    0x1.p0,
    -0x1.40p3
  },
  { // Entry 478
    0x1.p-9,
    0x1.p0,
    -0x1.20p3
  },
  { // Entry 479
    0x1.p-8,
    0x1.p0,
    -0x1.p3
  },
  { // Entry 480
    0x1.p-7,
    0x1.p0,
    -0x1.c0p2
  },
  { // Entry 481
    0x1.p-6,
    0x1.p0,
    -0x1.80p2
  },
  { // Entry 482
    0x1.p-5,
    0x1.p0,
    -0x1.40p2
  },
  { // Entry 483
    0x1.p-4,
    0x1.p0,
    -0x1.p2
  },
  { // Entry 484
    0x1.p-3,
    0x1.p0,
    -0x1.80p1
  },
  { // Entry 485
    0x1.p-2,
    0x1.p0,
    -0x1.p1
  },
  { // Entry 486
    0x1.p-1,
    0x1.p0,
    -0x1.p0
  },
  { // Entry 487
    0x1.p0,
    0x1.p0,
    0.0
  },
  { // Entry 488
    0x1.p1,
    0x1.p0,
    0x1.p0
  },
  { // Entry 489
    0x1.p2,
    0x1.p0,
    0x1.p1
  },
  { // Entry 490
    0x1.p3,
    0x1.p0,
    0x1.80p1
  },
  { // Entry 491
    0x1.p4,
    0x1.p0,
    0x1.p2
  },
  { // Entry 492
    0x1.p5,
    0x1.p0,
    0x1.40p2
  },
  { // Entry 493
    0x1.p6,
    0x1.p0,
    0x1.80p2
  },
  { // Entry 494
    0x1.p7,
    0x1.p0,
    0x1.c0p2
  },
  { // Entry 495
    0x1.p8,
    0x1.p0,
    0x1.p3
  },
  { // Entry 496
    0x1.p9,
    0x1.p0,
    0x1.20p3
  },
  { // Entry 497
    0x1.p10,
    0x1.p0,
    0x1.40p3
  },
  { // Entry 498
    0x1.fffffep0,
    0x1.fffffep127,
    -0x1.fcp6
  },
  { // Entry 499
    0x1.fffffep1,
    0x1.fffffep127,
    -0x1.f8p6
  },
  { // Entry 500
    0x1.fffffep117,
    0x1.fffffep127,
    -0x1.40p3
  },
  { // Entry 501
    0x1.fffffep118,
    0x1.fffffep127,
    -0x1.20p3
  },
  { // Entry 502
    0x1.fffffep119,
    0x1.fffffep127,
    -0x1.p3
  },
  { // Entry 503
    0x1.fffffep120,
    0x1.fffffep127,
    -0x1.c0p2
  },
  { // Entry 504
    0x1.fffffep121,
    0x1.fffffep127,
    -0x1.80p2
  },
  { // Entry 505
    0x1.fffffep122,
    0x1.fffffep127,
    -0x1.40p2
  },
  { // Entry 506
    0x1.fffffep123,
    0x1.fffffep127,
    -0x1.p2
  },
  { // Entry 507
    0x1.fffffep124,
    0x1.fffffep127,
    -0x1.80p1
  },
  { // Entry 508
    0x1.fffffep125,
    0x1.fffffep127,
    -0x1.p1
  },
  { // Entry 509
    0x1.fffffep126,
    0x1.fffffep127,
    -0x1.p0
  },
  { // Entry 510
    0x1.fffffep127,
    0x1.fffffep127,
    0.0
  },
  { // Entry 511
    0x1.p-22,
    0x1.p-149,
    0x1.fcp6
  },
  { // Entry 512
    0x1.p-23,
    0x1.p-149,
    0x1.f8p6
  },
  { // Entry 513
    0x1.p-149,
    0x1.p-149,
    0.0
  },
  { // Entry 514
    0x1.p-148,
    0x1.p-149,
    0x1.p0
  },
  { // Entry 515
    0x1.p-147,
    0x1.p-149,
    0x1.p1
  },
  { // Entry 516
    0x1.p-146,
    0x1.p-149,
    0x1.80p1
  },
  { // Entry 517
    0x1.p-145,
    0x1.p-149,
    0x1.p2
  },
  { // Entry 518
    0x1.p-144,
    0x1.p-149,
    0x1.40p2
  },
  { // Entry 519
    0x1.p-143,
    0x1.p-149,
    0x1.80p2
  },
  { // Entry 520
    0x1.p-142,
    0x1.p-149,
    0x1.c0p2
  },
  { // Entry 521
    0x1.p-141,
    0x1.p-149,
    0x1.p3
  },
  { // Entry 522
    0x1.p-140,
    0x1.p-149,
    0x1.20p3
  },
  { // Entry 523
    0x1.p-139,
    0x1.p-149,
    0x1.40p3
  },
  { // Entry 524
    0x1.p-129,
    0x1.p-2,
    -0x1.fcp6
  },
  { // Entry 525
    0x1.p-128,
    0x1.p-2,
    -0x1.f8p6
  },
  { // Entry 526
    0x1.p-128,
    0x1.p-1,
    -0x1.fcp6
  },
  { // Entry 527
    0x1.p-127,
    0x1.p-1,
    -0x1.f8p6
  },
  { // Entry 528
    0x1.80p-128,
    0x1.80p-1,
    -0x1.fcp6
  },
  { // Entry 529
    0x1.80p-127,
    0x1.80p-1,
    -0x1.f8p6
  },
  { // Entry 530
    0.0f,
    0x1.p-2,
    -0x1.2ap7
  },
  { // Entry 531
    0.0f,
    0x1.p-2,
    -0x1.28p7
  },
  { // Entry 532
    0.0f,
    0x1.p-1,
    -0x1.2ap7
  },
  { // Entry 533
    0x1.p-149,
    0x1.p-1,
    -0x1.28p7
  },
  { // Entry 534
    0.0f,
    0x1.80p-1,
    -0x1.2ap7
  },
  { // Entry 535
    0x1.80p-149,
    0x1.80p-1,
    -0x1.28p7
  },
  { // Entry 536
    0x1.p127,
    0x1.p0,
    0x1.fcp6
  },
  { // Entry 537
    0x1.p126,
    0x1.p0,
    0x1.f8p6
  },
  { // Entry 538
    0x1.p-149,
    0x1.p-149,
    0.0
  },
  { // Entry 539
    0x1.p-148,
    0x1.p-149,
    0x1.p0
  },
  { // Entry 540
    0x1.p-147,
    0x1.p-149,
    0x1.p1
  },
  { // Entry 541
    0x1.p-146,
    0x1.p-149,
    0x1.80p1
  },
  { // Entry 542
    0x1.p-145,
    0x1.p-149,
    0x1.p2
  },
  { // Entry 543
    0x1.p-144,
    0x1.p-149,
    0x1.40p2
  },
  { // Entry 544
    0x1.p-143,
    0x1.p-149,
    0x1.80p2
  },
  { // Entry 545
    0x1.p-142,
    0x1.p-149,
    0x1.c0p2
  },
  { // Entry 546
    0x1.p-141,
    0x1.p-149,
    0x1.p3
  },
  { // Entry 547
    0x1.p-140,
    0x1.p-149,
    0x1.20p3
  },
  { // Entry 548
    0x1.p-139,
    0x1.p-149,
    0x1.40p3
  },
  { // Entry 549
    0x1.p-138,
    0x1.p-149,
    0x1.60p3
  },
  { // Entry 550
    0x1.p-137,
    0x1.p-149,
    0x1.80p3
  },
  { // Entry 551
    0x1.p-136,
    0x1.p-149,
    0x1.a0p3
  },
  { // Entry 552
    0x1.p-135,
    0x1.p-149,
    0x1.c0p3
  },
  { // Entry 553
    0x1.p-134,
    0x1.p-149,
    0x1.e0p3
  },
  { // Entry 554
    0x1.p-133,
    0x1.p-149,
    0x1.p4
  },
  { // Entry 555
    0x1.p-132,
    0x1.p-149,
    0x1.10p4
  },
  { // Entry 556
    0x1.p-131,
    0x1.p-149,
    0x1.20p4
  },
  { // Entry 557
    0x1.p-130,
    0x1.p-149,
    0x1.30p4
  },
  { // Entry 558
    0x1.p-129,
    0x1.p-149,
    0x1.40p4
  },
  { // Entry 559
    0x1.p-128,
    0x1.p-149,
    0x1.50p4
  },
  { // Entry 560
    0x1.p-127,
    0x1.p-149,
    0x1.60p4
  },
  { // Entry 561
    0x1.p-126,
    0x1.p-149,
    0x1.70p4
  },
  { // Entry 562
    0x1.p-125,
    0x1.p-149,
    0x1.80p4
  },
  { // Entry 563
    0x1.p-124,
    0x1.p-149,
    0x1.90p4
  },
  { // Entry 564
    0x1.p-123,
    0x1.p-149,
    0x1.a0p4
  },
  { // Entry 565
    0x1.p-122,
    0x1.p-149,
    0x1.b0p4
  },
  { // Entry 566
    0x1.p-121,
    0x1.p-149,
    0x1.c0p4
  },
  { // Entry 567
    0x1.p-120,
    0x1.p-149,
    0x1.d0p4
  },
  { // Entry 568
    0x1.p-119,
    0x1.p-149,
    0x1.e0p4
  },
  { // Entry 569
    0x1.p-118,
    0x1.p-149,
    0x1.f0p4
  },
  { // Entry 570
    0x1.p-117,
    0x1.p-149,
    0x1.p5
  },
  { // Entry 571
    0x1.p-116,
    0x1.p-149,
    0x1.08p5
  },
  { // Entry 572
    0x1.p-115,
    0x1.p-149,
    0x1.10p5
  },
  { // Entry 573
    0x1.p-114,
    0x1.p-149,
    0x1.18p5
  },
  { // Entry 574
    0x1.p-113,
    0x1.p-149,
    0x1.20p5
  },
  { // Entry 575
    0x1.p-112,
    0x1.p-149,
    0x1.28p5
  },
  { // Entry 576
    0x1.p-111,
    0x1.p-149,
    0x1.30p5
  },
  { // Entry 577
    0x1.p-110,
    0x1.p-149,
    0x1.38p5
  },
  { // Entry 578
    0x1.p-109,
    0x1.p-149,
    0x1.40p5
  },
  { // Entry 579
    0x1.p-108,
    0x1.p-149,
    0x1.48p5
  },
  { // Entry 580
    0x1.p-107,
    0x1.p-149,
    0x1.50p5
  },
  { // Entry 581
    0x1.p-106,
    0x1.p-149,
    0x1.58p5
  },
  { // Entry 582
    0x1.p-105,
    0x1.p-149,
    0x1.60p5
  },
  { // Entry 583
    0x1.p-104,
    0x1.p-149,
    0x1.68p5
  },
  { // Entry 584
    0x1.p-103,
    0x1.p-149,
    0x1.70p5
  },
  { // Entry 585
    0x1.p-102,
    0x1.p-149,
    0x1.78p5
  },
  { // Entry 586
    0x1.p-101,
    0x1.p-149,
    0x1.80p5
  },
  { // Entry 587
    0x1.p-100,
    0x1.p-149,
    0x1.88p5
  },
  { // Entry 588
    0x1.p-99,
    0x1.p-149,
    0x1.90p5
  },
  { // Entry 589
    0x1.p-98,
    0x1.p-149,
    0x1.98p5
  },
  { // Entry 590
    0x1.p-97,
    0x1.p-149,
    0x1.a0p5
  },
  { // Entry 591
    0x1.p-96,
    0x1.p-149,
    0x1.a8p5
  },
  { // Entry 592
    0x1.p-95,
    0x1.p-149,
    0x1.b0p5
  },
  { // Entry 593
    0x1.p-94,
    0x1.p-149,
    0x1.b8p5
  },
  { // Entry 594
    0x1.p-93,
    0x1.p-149,
    0x1.c0p5
  },
  { // Entry 595
    0x1.p-92,
    0x1.p-149,
    0x1.c8p5
  },
  { // Entry 596
    0x1.p-91,
    0x1.p-149,
    0x1.d0p5
  },
  { // Entry 597
    0x1.p-90,
    0x1.p-149,
    0x1.d8p5
  },
  { // Entry 598
    0x1.p-89,
    0x1.p-149,
    0x1.e0p5
  },
  { // Entry 599
    0x1.p-88,
    0x1.p-149,
    0x1.e8p5
  },
  { // Entry 600
    0x1.p-87,
    0x1.p-149,
    0x1.f0p5
  },
  { // Entry 601
    0x1.p-86,
    0x1.p-149,
    0x1.f8p5
  },
  { // Entry 602
    0x1.p-85,
    0x1.p-149,
    0x1.p6
  },
  { // Entry 603
    0x1.p-84,
    0x1.p-149,
    0x1.04p6
  },
  { // Entry 604
    0x1.p-83,
    0x1.p-149,
    0x1.08p6
  },
  { // Entry 605
    0x1.p-82,
    0x1.p-149,
    0x1.0cp6
  },
  { // Entry 606
    0x1.p-81,
    0x1.p-149,
    0x1.10p6
  },
  { // Entry 607
    0x1.p-80,
    0x1.p-149,
    0x1.14p6
  },
  { // Entry 608
    0x1.p-79,
    0x1.p-149,
    0x1.18p6
  },
  { // Entry 609
    0x1.p-78,
    0x1.p-149,
    0x1.1cp6
  },
  { // Entry 610
    0x1.p-77,
    0x1.p-149,
    0x1.20p6
  },
  { // Entry 611
    0x1.p-76,
    0x1.p-149,
    0x1.24p6
  },
  { // Entry 612
    0x1.p-75,
    0x1.p-149,
    0x1.28p6
  },
  { // Entry 613
    0x1.p-74,
    0x1.p-149,
    0x1.2cp6
  },
  { // Entry 614
    0x1.p-73,
    0x1.p-149,
    0x1.30p6
  },
  { // Entry 615
    0x1.p-72,
    0x1.p-149,
    0x1.34p6
  },
  { // Entry 616
    0x1.p-71,
    0x1.p-149,
    0x1.38p6
  },
  { // Entry 617
    0x1.p-70,
    0x1.p-149,
    0x1.3cp6
  },
  { // Entry 618
    0x1.p-69,
    0x1.p-149,
    0x1.40p6
  },
  { // Entry 619
    0x1.p-68,
    0x1.p-149,
    0x1.44p6
  },
  { // Entry 620
    0x1.p-67,
    0x1.p-149,
    0x1.48p6
  },
  { // Entry 621
    0x1.p-66,
    0x1.p-149,
    0x1.4cp6
  },
  { // Entry 622
    0x1.p-65,
    0x1.p-149,
    0x1.50p6
  },
  { // Entry 623
    0x1.p-64,
    0x1.p-149,
    0x1.54p6
  },
  { // Entry 624
    0x1.p-63,
    0x1.p-149,
    0x1.58p6
  },
  { // Entry 625
    0x1.p-62,
    0x1.p-149,
    0x1.5cp6
  },
  { // Entry 626
    0x1.p-61,
    0x1.p-149,
    0x1.60p6
  },
  { // Entry 627
    0x1.p-60,
    0x1.p-149,
    0x1.64p6
  },
  { // Entry 628
    0x1.p-59,
    0x1.p-149,
    0x1.68p6
  },
  { // Entry 629
    0x1.p-58,
    0x1.p-149,
    0x1.6cp6
  },
  { // Entry 630
    0x1.p-57,
    0x1.p-149,
    0x1.70p6
  },
  { // Entry 631
    0x1.p-56,
    0x1.p-149,
    0x1.74p6
  },
  { // Entry 632
    0x1.p-55,
    0x1.p-149,
    0x1.78p6
  },
  { // Entry 633
    0x1.p-54,
    0x1.p-149,
    0x1.7cp6
  },
  { // Entry 634
    0x1.p-53,
    0x1.p-149,
    0x1.80p6
  },
  { // Entry 635
    0x1.p-52,
    0x1.p-149,
    0x1.84p6
  },
  { // Entry 636
    0x1.p-51,
    0x1.p-149,
    0x1.88p6
  },
  { // Entry 637
    0x1.p-50,
    0x1.p-149,
    0x1.8cp6
  },
  { // Entry 638
    0x1.p-49,
    0x1.p-149,
    0x1.90p6
  },
  { // Entry 639
    0x1.p-48,
    0x1.p-149,
    0x1.94p6
  },
  { // Entry 640
    0x1.p-47,
    0x1.p-149,
    0x1.98p6
  },
  { // Entry 641
    0x1.p-46,
    0x1.p-149,
    0x1.9cp6
  },
  { // Entry 642
    0x1.p-45,
    0x1.p-149,
    0x1.a0p6
  },
  { // Entry 643
    0x1.p-44,
    0x1.p-149,
    0x1.a4p6
  },
  { // Entry 644
    0x1.p-43,
    0x1.p-149,
    0x1.a8p6
  },
  { // Entry 645
    0x1.p-42,
    0x1.p-149,
    0x1.acp6
  },
  { // Entry 646
    0x1.p-41,
    0x1.p-149,
    0x1.b0p6
  },
  { // Entry 647
    0x1.p-40,
    0x1.p-149,
    0x1.b4p6
  },
  { // Entry 648
    0x1.p-39,
    0x1.p-149,
    0x1.b8p6
  },
  { // Entry 649
    0x1.p-38,
    0x1.p-149,
    0x1.bcp6
  },
  { // Entry 650
    0x1.p-37,
    0x1.p-149,
    0x1.c0p6
  },
  { // Entry 651
    0x1.p-36,
    0x1.p-149,
    0x1.c4p6
  },
  { // Entry 652
    0x1.p-35,
    0x1.p-149,
    0x1.c8p6
  },
  { // Entry 653
    0x1.p-34,
    0x1.p-149,
    0x1.ccp6
  },
  { // Entry 654
    0x1.p-33,
    0x1.p-149,
    0x1.d0p6
  },
  { // Entry 655
    0x1.p-32,
    0x1.p-149,
    0x1.d4p6
  },
  { // Entry 656
    0x1.p-31,
    0x1.p-149,
    0x1.d8p6
  },
  { // Entry 657
    0x1.p-30,
    0x1.p-149,
    0x1.dcp6
  },
  { // Entry 658
    0x1.p-29,
    0x1.p-149,
    0x1.e0p6
  },
  { // Entry 659
    0x1.p-28,
    0x1.p-149,
    0x1.e4p6
  },
  { // Entry 660
    0x1.p-27,
    0x1.p-149,
    0x1.e8p6
  },
  { // Entry 661
    0x1.p-26,
    0x1.p-149,
    0x1.ecp6
  },
  { // Entry 662
    0x1.p-25,
    0x1.p-149,
    0x1.f0p6
  },
  { // Entry 663
    0x1.p-24,
    0x1.p-149,
    0x1.f4p6
  },
  { // Entry 664
    0x1.p-23,
    0x1.p-149,
    0x1.f8p6
  },
  { // Entry 665
    0x1.p-22,
    0x1.p-149,
    0x1.fcp6
  },
  { // Entry 666
    0x1.p-21,
    0x1.p-149,
    0x1.p7
  },
  { // Entry 667
    0x1.p-20,
    0x1.p-149,
    0x1.02p7
  },
  { // Entry 668
    0x1.p-19,
    0x1.p-149,
    0x1.04p7
  },
  { // Entry 669
    0x1.fffffcp-127,
    0x1.fffffcp-127,
    0.0
  },
  { // Entry 670
    0x1.fffffcp-126,
    0x1.fffffcp-127,
    0x1.p0
  },
  { // Entry 671
    0x1.fffffcp-125,
    0x1.fffffcp-127,
    0x1.p1
  },
  { // Entry 672
    0x1.fffffcp-124,
    0x1.fffffcp-127,
    0x1.80p1
  },
  { // Entry 673
    0x1.fffffcp-123,
    0x1.fffffcp-127,
    0x1.p2
  },
  { // Entry 674
    0x1.fffffcp-122,
    0x1.fffffcp-127,
    0x1.40p2
  },
  { // Entry 675
    0x1.fffffcp-121,
    0x1.fffffcp-127,
    0x1.80p2
  },
  { // Entry 676
    0x1.fffffcp-120,
    0x1.fffffcp-127,
    0x1.c0p2
  },
  { // Entry 677
    0x1.fffffcp-119,
    0x1.fffffcp-127,
    0x1.p3
  },
  { // Entry 678
    0x1.fffffcp-118,
    0x1.fffffcp-127,
    0x1.20p3
  },
  { // Entry 679
    0x1.fffffcp-117,
    0x1.fffffcp-127,
    0x1.40p3
  },
  { // Entry 680
    0x1.fffffcp-116,
    0x1.fffffcp-127,
    0x1.60p3
  },
  { // Entry 681
    0x1.fffffcp-115,
    0x1.fffffcp-127,
    0x1.80p3
  },
  { // Entry 682
    0x1.fffffcp-114,
    0x1.fffffcp-127,
    0x1.a0p3
  },
  { // Entry 683
    0x1.fffffcp-113,
    0x1.fffffcp-127,
    0x1.c0p3
  },
  { // Entry 684
    0x1.fffffcp-112,
    0x1.fffffcp-127,
    0x1.e0p3
  },
  { // Entry 685
    0x1.fffffcp-111,
    0x1.fffffcp-127,
    0x1.p4
  },
  { // Entry 686
    0x1.fffffcp-110,
    0x1.fffffcp-127,
    0x1.10p4
  },
  { // Entry 687
    0x1.fffffcp-109,
    0x1.fffffcp-127,
    0x1.20p4
  },
  { // Entry 688
    0x1.fffffcp-108,
    0x1.fffffcp-127,
    0x1.30p4
  },
  { // Entry 689
    0x1.fffffcp-107,
    0x1.fffffcp-127,
    0x1.40p4
  },
  { // Entry 690
    0x1.fffffcp-106,
    0x1.fffffcp-127,
    0x1.50p4
  },
  { // Entry 691
    0x1.fffffcp-105,
    0x1.fffffcp-127,
    0x1.60p4
  },
  { // Entry 692
    0x1.fffffcp-104,
    0x1.fffffcp-127,
    0x1.70p4
  },
  { // Entry 693
    0x1.fffffcp-103,
    0x1.fffffcp-127,
    0x1.80p4
  },
  { // Entry 694
    0x1.fffffcp-102,
    0x1.fffffcp-127,
    0x1.90p4
  },
  { // Entry 695
    0x1.fffffcp-101,
    0x1.fffffcp-127,
    0x1.a0p4
  },
  { // Entry 696
    0x1.fffffcp-100,
    0x1.fffffcp-127,
    0x1.b0p4
  },
  { // Entry 697
    0x1.fffffcp-99,
    0x1.fffffcp-127,
    0x1.c0p4
  },
  { // Entry 698
    0x1.fffffcp-98,
    0x1.fffffcp-127,
    0x1.d0p4
  },
  { // Entry 699
    0x1.fffffcp-97,
    0x1.fffffcp-127,
    0x1.e0p4
  },
  { // Entry 700
    0x1.fffffcp-96,
    0x1.fffffcp-127,
    0x1.f0p4
  },
  { // Entry 701
    0x1.fffffcp-95,
    0x1.fffffcp-127,
    0x1.p5
  },
  { // Entry 702
    0x1.fffffcp-94,
    0x1.fffffcp-127,
    0x1.08p5
  },
  { // Entry 703
    0x1.fffffcp-93,
    0x1.fffffcp-127,
    0x1.10p5
  },
  { // Entry 704
    0x1.fffffcp-92,
    0x1.fffffcp-127,
    0x1.18p5
  },
  { // Entry 705
    0x1.fffffcp-91,
    0x1.fffffcp-127,
    0x1.20p5
  },
  { // Entry 706
    0x1.fffffcp-90,
    0x1.fffffcp-127,
    0x1.28p5
  },
  { // Entry 707
    0x1.fffffcp-89,
    0x1.fffffcp-127,
    0x1.30p5
  },
  { // Entry 708
    0x1.fffffcp-88,
    0x1.fffffcp-127,
    0x1.38p5
  },
  { // Entry 709
    0x1.fffffcp-87,
    0x1.fffffcp-127,
    0x1.40p5
  },
  { // Entry 710
    0x1.fffffcp-86,
    0x1.fffffcp-127,
    0x1.48p5
  },
  { // Entry 711
    0x1.fffffcp-85,
    0x1.fffffcp-127,
    0x1.50p5
  },
  { // Entry 712
    0x1.fffffcp-84,
    0x1.fffffcp-127,
    0x1.58p5
  },
  { // Entry 713
    0x1.fffffcp-83,
    0x1.fffffcp-127,
    0x1.60p5
  },
  { // Entry 714
    0x1.fffffcp-82,
    0x1.fffffcp-127,
    0x1.68p5
  },
  { // Entry 715
    0x1.fffffcp-81,
    0x1.fffffcp-127,
    0x1.70p5
  },
  { // Entry 716
    0x1.fffffcp-80,
    0x1.fffffcp-127,
    0x1.78p5
  },
  { // Entry 717
    0x1.fffffcp-79,
    0x1.fffffcp-127,
    0x1.80p5
  },
  { // Entry 718
    0x1.fffffcp-78,
    0x1.fffffcp-127,
    0x1.88p5
  },
  { // Entry 719
    0x1.fffffcp-77,
    0x1.fffffcp-127,
    0x1.90p5
  },
  { // Entry 720
    0x1.fffffcp-76,
    0x1.fffffcp-127,
    0x1.98p5
  },
  { // Entry 721
    0x1.fffffcp-75,
    0x1.fffffcp-127,
    0x1.a0p5
  },
  { // Entry 722
    0x1.fffffcp-74,
    0x1.fffffcp-127,
    0x1.a8p5
  },
  { // Entry 723
    0x1.fffffcp-73,
    0x1.fffffcp-127,
    0x1.b0p5
  },
  { // Entry 724
    0x1.fffffcp-72,
    0x1.fffffcp-127,
    0x1.b8p5
  },
  { // Entry 725
    0x1.fffffcp-71,
    0x1.fffffcp-127,
    0x1.c0p5
  },
  { // Entry 726
    0x1.fffffcp-70,
    0x1.fffffcp-127,
    0x1.c8p5
  },
  { // Entry 727
    0x1.fffffcp-69,
    0x1.fffffcp-127,
    0x1.d0p5
  },
  { // Entry 728
    0x1.fffffcp-68,
    0x1.fffffcp-127,
    0x1.d8p5
  },
  { // Entry 729
    0x1.fffffcp-67,
    0x1.fffffcp-127,
    0x1.e0p5
  },
  { // Entry 730
    0x1.fffffcp-66,
    0x1.fffffcp-127,
    0x1.e8p5
  },
  { // Entry 731
    0x1.fffffcp-65,
    0x1.fffffcp-127,
    0x1.f0p5
  },
  { // Entry 732
    0x1.fffffcp-64,
    0x1.fffffcp-127,
    0x1.f8p5
  },
  { // Entry 733
    0x1.fffffcp-63,
    0x1.fffffcp-127,
    0x1.p6
  },
  { // Entry 734
    0x1.fffffcp-62,
    0x1.fffffcp-127,
    0x1.04p6
  },
  { // Entry 735
    0x1.fffffcp-61,
    0x1.fffffcp-127,
    0x1.08p6
  },
  { // Entry 736
    0x1.fffffcp-60,
    0x1.fffffcp-127,
    0x1.0cp6
  },
  { // Entry 737
    0x1.fffffcp-59,
    0x1.fffffcp-127,
    0x1.10p6
  },
  { // Entry 738
    0x1.fffffcp-58,
    0x1.fffffcp-127,
    0x1.14p6
  },
  { // Entry 739
    0x1.fffffcp-57,
    0x1.fffffcp-127,
    0x1.18p6
  },
  { // Entry 740
    0x1.fffffcp-56,
    0x1.fffffcp-127,
    0x1.1cp6
  },
  { // Entry 741
    0x1.fffffcp-55,
    0x1.fffffcp-127,
    0x1.20p6
  },
  { // Entry 742
    0x1.fffffcp-54,
    0x1.fffffcp-127,
    0x1.24p6
  },
  { // Entry 743
    0x1.fffffcp-53,
    0x1.fffffcp-127,
    0x1.28p6
  },
  { // Entry 744
    0x1.fffffcp-52,
    0x1.fffffcp-127,
    0x1.2cp6
  },
  { // Entry 745
    0x1.fffffcp-51,
    0x1.fffffcp-127,
    0x1.30p6
  },
  { // Entry 746
    0x1.fffffcp-50,
    0x1.fffffcp-127,
    0x1.34p6
  },
  { // Entry 747
    0x1.fffffcp-49,
    0x1.fffffcp-127,
    0x1.38p6
  },
  { // Entry 748
    0x1.fffffcp-48,
    0x1.fffffcp-127,
    0x1.3cp6
  },
  { // Entry 749
    0x1.fffffcp-47,
    0x1.fffffcp-127,
    0x1.40p6
  },
  { // Entry 750
    0x1.fffffcp-46,
    0x1.fffffcp-127,
    0x1.44p6
  },
  { // Entry 751
    0x1.fffffcp-45,
    0x1.fffffcp-127,
    0x1.48p6
  },
  { // Entry 752
    0x1.fffffcp-44,
    0x1.fffffcp-127,
    0x1.4cp6
  },
  { // Entry 753
    0x1.fffffcp-43,
    0x1.fffffcp-127,
    0x1.50p6
  },
  { // Entry 754
    0x1.fffffcp-42,
    0x1.fffffcp-127,
    0x1.54p6
  },
  { // Entry 755
    0x1.fffffcp-41,
    0x1.fffffcp-127,
    0x1.58p6
  },
  { // Entry 756
    0x1.fffffcp-40,
    0x1.fffffcp-127,
    0x1.5cp6
  },
  { // Entry 757
    0x1.fffffcp-39,
    0x1.fffffcp-127,
    0x1.60p6
  },
  { // Entry 758
    0x1.fffffcp-38,
    0x1.fffffcp-127,
    0x1.64p6
  },
  { // Entry 759
    0x1.fffffcp-37,
    0x1.fffffcp-127,
    0x1.68p6
  },
  { // Entry 760
    0x1.fffffcp-36,
    0x1.fffffcp-127,
    0x1.6cp6
  },
  { // Entry 761
    0x1.fffffcp-35,
    0x1.fffffcp-127,
    0x1.70p6
  },
  { // Entry 762
    0x1.fffffcp-34,
    0x1.fffffcp-127,
    0x1.74p6
  },
  { // Entry 763
    0x1.fffffcp-33,
    0x1.fffffcp-127,
    0x1.78p6
  },
  { // Entry 764
    0x1.fffffcp-32,
    0x1.fffffcp-127,
    0x1.7cp6
  },
  { // Entry 765
    0x1.fffffcp-31,
    0x1.fffffcp-127,
    0x1.80p6
  },
  { // Entry 766
    0x1.fffffcp-30,
    0x1.fffffcp-127,
    0x1.84p6
  },
  { // Entry 767
    0x1.fffffcp-29,
    0x1.fffffcp-127,
    0x1.88p6
  },
  { // Entry 768
    0x1.fffffcp-28,
    0x1.fffffcp-127,
    0x1.8cp6
  },
  { // Entry 769
    0x1.fffffcp-27,
    0x1.fffffcp-127,
    0x1.90p6
  },
  { // Entry 770
    0x1.fffffcp-26,
    0x1.fffffcp-127,
    0x1.94p6
  },
  { // Entry 771
    0x1.fffffcp-25,
    0x1.fffffcp-127,
    0x1.98p6
  },
  { // Entry 772
    0x1.fffffcp-24,
    0x1.fffffcp-127,
    0x1.9cp6
  },
  { // Entry 773
    0x1.fffffcp-23,
    0x1.fffffcp-127,
    0x1.a0p6
  },
  { // Entry 774
    0x1.fffffcp-22,
    0x1.fffffcp-127,
    0x1.a4p6
  },
  { // Entry 775
    0x1.fffffcp-21,
    0x1.fffffcp-127,
    0x1.a8p6
  },
  { // Entry 776
    0x1.fffffcp-20,
    0x1.fffffcp-127,
    0x1.acp6
  },
  { // Entry 777
    0x1.fffffcp-19,
    0x1.fffffcp-127,
    0x1.b0p6
  },
  { // Entry 778
    0x1.fffffcp-18,
    0x1.fffffcp-127,
    0x1.b4p6
  },
  { // Entry 779
    0x1.fffffcp-17,
    0x1.fffffcp-127,
    0x1.b8p6
  },
  { // Entry 780
    0x1.fffffcp-16,
    0x1.fffffcp-127,
    0x1.bcp6
  },
  { // Entry 781
    0x1.fffffcp-15,
    0x1.fffffcp-127,
    0x1.c0p6
  },
  { // Entry 782
    0x1.fffffcp-14,
    0x1.fffffcp-127,
    0x1.c4p6
  },
  { // Entry 783
    0x1.fffffcp-13,
    0x1.fffffcp-127,
    0x1.c8p6
  },
  { // Entry 784
    0x1.fffffcp-12,
    0x1.fffffcp-127,
    0x1.ccp6
  },
  { // Entry 785
    0x1.fffffcp-11,
    0x1.fffffcp-127,
    0x1.d0p6
  },
  { // Entry 786
    0x1.fffffcp-10,
    0x1.fffffcp-127,
    0x1.d4p6
  },
  { // Entry 787
    0x1.fffffcp-9,
    0x1.fffffcp-127,
    0x1.d8p6
  },
  { // Entry 788
    0x1.fffffcp-8,
    0x1.fffffcp-127,
    0x1.dcp6
  },
  { // Entry 789
    0x1.fffffcp-7,
    0x1.fffffcp-127,
    0x1.e0p6
  },
  { // Entry 790
    0x1.fffffcp-6,
    0x1.fffffcp-127,
    0x1.e4p6
  },
  { // Entry 791
    0x1.fffffcp-5,
    0x1.fffffcp-127,
    0x1.e8p6
  },
  { // Entry 792
    0x1.fffffcp-4,
    0x1.fffffcp-127,
    0x1.ecp6
  },
  { // Entry 793
    0x1.fffffcp-3,
    0x1.fffffcp-127,
    0x1.f0p6
  },
  { // Entry 794
    0x1.fffffcp-2,
    0x1.fffffcp-127,
    0x1.f4p6
  },
  { // Entry 795
    0x1.fffffcp-1,
    0x1.fffffcp-127,
    0x1.f8p6
  },
  { // Entry 796
    0x1.fffffcp0,
    0x1.fffffcp-127,
    0x1.fcp6
  },
  { // Entry 797
    0x1.fffffcp1,
    0x1.fffffcp-127,
    0x1.p7
  },
  { // Entry 798
    0x1.fffffcp2,
    0x1.fffffcp-127,
    0x1.02p7
  },
  { // Entry 799
    0x1.fffffcp3,
    0x1.fffffcp-127,
    0x1.04p7
  },
  { // Entry 800
    0x1.p0,
    0x1.p-149,
    0x1.2ap7
  },
  { // Entry 801
    0x1.p-1,
    0x1.p-149,
    0x1.28p7
  },
  { // Entry 802
    0x1.fffffcp22,
    0x1.fffffcp-127,
    0x1.2ap7
  },
  { // Entry 803
    0x1.fffffcp21,
    0x1.fffffcp-127,
    0x1.28p7
  },
  { // Entry 804
    0x1.p-126,
    0x1.p-149,
    0x1.70p4
  },
  { // Entry 805
    0x1.p-127,
    0x1.p-149,
    0x1.60p4
  },
  { // Entry 806
    0x1.fffffcp-104,
    0x1.fffffcp-127,
    0x1.70p4
  },
  { // Entry 807
    0x1.fffffcp-105,
    0x1.fffffcp-127,
    0x1.60p4
  },
  { // Entry 808
    0x1.p-149,
    0x1.p-149,
    0.0
  },
  { // Entry 809
    0x1.p-148,
    0x1.p-149,
    0x1.p0
  },
  { // Entry 810
    0x1.fffffcp-127,
    0x1.fffffcp-127,
    0.0
  },
  { // Entry 811
    0x1.fffffcp-126,
    0x1.fffffcp-127,
    0x1.p0
  },
  { // Entry 812
    HUGE_VALF,
    HUGE_VALF,
    HUGE_VALF
  },
  { // Entry 813
    HUGE_VALF,
    HUGE_VALF,
    0x1.fffffep127
  },
  { // Entry 814
    HUGE_VALF,
    HUGE_VALF,
    -0x1.fffffep127
  },
  { // Entry 815
    HUGE_VALF,
    0x1.fffffep127,
    HUGE_VALF
  },
  { // Entry 816
    HUGE_VALF,
    0x1.p-126,
    HUGE_VALF
  },
  { // Entry 817
    HUGE_VALF,
    0x1.fffffcp-127,
    HUGE_VALF
  },
  { // Entry 818
    HUGE_VALF,
    0x1.p-149,
    HUGE_VALF
  },
  { // Entry 819
    -HUGE_VALF,
    -0x1.p-149,
    HUGE_VALF
  },
  { // Entry 820
    -HUGE_VALF,
    -0x1.fffffcp-127,
    HUGE_VALF
  },
  { // Entry 821
    -HUGE_VALF,
    -0x1.p-126,
    HUGE_VALF
  },
  { // Entry 822
    -HUGE_VALF,
    -0x1.fffffep127,
    HUGE_VALF
  },
  { // Entry 823
    -HUGE_VALF,
    -HUGE_VALF,
    HUGE_VALF
  },
  { // Entry 824
    HUGE_VALF,
    0x1.fffffep127,
    0x1.fffffep127
  },
  { // Entry 825
    0.0f,
    0x1.fffffep127,
    -0x1.fffffep127
  },
  { // Entry 826
    0.0,
    0x1.fffffep127,
    -HUGE_VALF
  },
  { // Entry 827
    HUGE_VALF,
    0x1.p-126,
    0x1.fffffep127
  },
  { // Entry 828
    HUGE_VALF,
    0x1.fffffcp-127,
    0x1.fffffep127
  },
  { // Entry 829
    HUGE_VALF,
    0x1.p-149,
    0x1.fffffep127
  },
  { // Entry 830
    -HUGE_VALF,
    -0x1.p-149,
    0x1.fffffep127
  },
  { // Entry 831
    -HUGE_VALF,
    -0x1.fffffcp-127,
    0x1.fffffep127
  },
  { // Entry 832
    -HUGE_VALF,
    -0x1.p-126,
    0x1.fffffep127
  },
  { // Entry 833
    -HUGE_VALF,
    -0x1.fffffep127,
    0x1.fffffep127
  },
  { // Entry 834
    0.0f,
    0x1.p-126,
    -0x1.fffffep127
  },
  { // Entry 835
    0.0,
    0x1.p-126,
    -HUGE_VALF
  },
  { // Entry 836
    0.0f,
    0x1.fffffcp-127,
    -0x1.fffffep127
  },
  { // Entry 837
    0.0,
    0x1.fffffcp-127,
    -HUGE_VALF
  },
  { // Entry 838
    0.0f,
    0x1.p-149,
    -0x1.fffffep127
  },
  { // Entry 839
    0.0,
    0x1.p-149,
    -HUGE_VALF
  },
  { // Entry 840
    0.0,
    0.0f,
    -HUGE_VALF
  },
  { // Entry 841
    -0.0,
    -0.0f,
    -HUGE_VALF
  },
  { // Entry 842
    -0.0f,
    -0x1.p-149,
    -0x1.fffffep127
  },
  { // Entry 843
    -0.0,
    -0x1.p-149,
    -HUGE_VALF
  },
  { // Entry 844
    -0.0f,
    -0x1.fffffcp-127,
    -0x1.fffffep127
  },
  { // Entry 845
    -0.0,
    -0x1.fffffcp-127,
    -HUGE_VALF
  },
  { // Entry 846
    -0.0f,
    -0x1.p-126,
    -0x1.fffffep127
  },
  { // Entry 847
    -0.0,
    -0x1.p-126,
    -HUGE_VALF
  },
  { // Entry 848
    -0.0f,
    -0x1.fffffep127,
    -0x1.fffffep127
  },
  { // Entry 849
    -0.0,
    -0x1.fffffep127,
    -HUGE_VALF
  },
  { // Entry 850
    0.0,
    0.0f,
    0x1.fffffep127
  },
  { // Entry 851
    -0.0,
    -0.0f,
    0x1.fffffep127
  },
  { // Entry 852
    0.0,
    0.0f,
    0.0f
  },
  { // Entry 853
    -0.0,
    -0.0f,
    0.0f
  },
  { // Entry 854
    0.0,
    0.0f,
    -0.0f
  },
  { // Entry 855
    -0.0,
    -0.0f,
    -0.0f
  },
  { // Entry 856
    0.0,
    0.0f,
    0x1.p0
  },
  { // Entry 857
    -0.0,
    -0.0f,
    0x1.p0
  },
  { // Entry 858
    0.0,
    0.0f,
    -0x1.p0
  },
  { // Entry 859
    -0.0,
    -0.0f,
    -0x1.p0
  },
  { // Entry 860
    0.0,
    0.0f,
    0x1.fcp6
  },
  { // Entry 861
    -0.0,
    -0.0f,
    0x1.fcp6
  },
  { // Entry 862
    0.0,
    0.0f,
    -0x1.fcp6
  },
  { // Entry 863
    -0.0,
    -0.0f,
    -0x1.fcp6
  },
  { // Entry 864
    0.0,
    0.0f,
    -0x1.fffffep127
  },
  { // Entry 865
    -0.0,
    -0.0f,
    -0x1.fffffep127
  },
  { // Entry 866
    HUGE_VALF,
    HUGE_VALF,
    0x1.fffffep127
  },
  { // Entry 867
    -HUGE_VALF,
    -HUGE_VALF,
    0x1.fffffep127
  },
  { // Entry 868
    HUGE_VALF,
    HUGE_VALF,
    0.0f
  },
  { // Entry 869
    -HUGE_VALF,
    -HUGE_VALF,
    0.0f
  },
  { // Entry 870
    HUGE_VALF,
    HUGE_VALF,
    -0.0f
  },
  { // Entry 871
    -HUGE_VALF,
    -HUGE_VALF,
    -0.0f
  },
  { // Entry 872
    HUGE_VALF,
    HUGE_VALF,
    0x1.p0
  },
  { // Entry 873
    -HUGE_VALF,
    -HUGE_VALF,
    0x1.p0
  },
  { // Entry 874
    HUGE_VALF,
    HUGE_VALF,
    -0x1.p0
  },
  { // Entry 875
    -HUGE_VALF,
    -HUGE_VALF,
    -0x1.p0
  },
  { // Entry 876
    HUGE_VALF,
    HUGE_VALF,
    0x1.fcp6
  },
  { // Entry 877
    -HUGE_VALF,
    -HUGE_VALF,
    0x1.fcp6
  },
  { // Entry 878
    HUGE_VALF,
    HUGE_VALF,
    -0x1.fcp6
  },
  { // Entry 879
    -HUGE_VALF,
    -HUGE_VALF,
    -0x1.fcp6
  },
  { // Entry 880
    HUGE_VALF,
    HUGE_VALF,
    -0x1.fffffep127
  },
  { // Entry 881
    -HUGE_VALF,
    -HUGE_VALF,
    -0x1.fffffep127
  },
  { // Entry 882
    0x1.fffffep127,
    0x1.fffffep127,
    0.0f
  },
  { // Entry 883
    0x1.fffffep127,
    0x1.fffffep127,
    -0.0f
  },
  { // Entry 884
    0x1.p-126,
    0x1.p-126,
    0.0f
  },
  { // Entry 885
    0x1.p-126,
    0x1.p-126,
    -0.0f
  },
  { // Entry 886
    0x1.fffffcp-127,
    0x1.fffffcp-127,
    0.0f
  },
  { // Entry 887
    0x1.fffffcp-127,
    0x1.fffffcp-127,
    -0.0f
  },
  { // Entry 888
    0x1.p-149,
    0x1.p-149,
    0.0f
  },
  { // Entry 889
    0x1.p-149,
    0x1.p-149,
    -0.0f
  },
  { // Entry 890
    -0x1.p-149,
    -0x1.p-149,
    0.0f
  },
  { // Entry 891
    -0x1.p-149,
    -0x1.p-149,
    -0.0f
  },
  { // Entry 892
    -0x1.fffffcp-127,
    -0x1.fffffcp-127,
    0.0f
  },
  { // Entry 893
    -0x1.fffffcp-127,
    -0x1.fffffcp-127,
    -0.0f
  },
  { // Entry 894
    -0x1.p-126,
    -0x1.p-126,
    0.0f
  },
  { // Entry 895
    -0x1.p-126,
    -0x1.p-126,
    -0.0f
  },
  { // Entry 896
    -0x1.fffffep127,
    -0x1.fffffep127,
    0.0f
  },
  { // Entry 897
    -0x1.fffffep127,
    -0x1.fffffep127,
    -0.0f
  },
  { // Entry 898
    HUGE_VALF,
    0x1.fffffep127,
    0x1.p0
  },
  { // Entry 899
    HUGE_VALF,
    0x1.fffffep127,
    0x1.fcp6
  },
  { // Entry 900
    -HUGE_VALF,
    -0x1.fffffep127,
    0x1.p0
  },
  { // Entry 901
    -HUGE_VALF,
    -0x1.fffffep127,
    0x1.fcp6
  },
  { // Entry 902
    HUGE_VALF,
    0x1.p-126,
    0x1.3880p15
  },
  { // Entry 903
    HUGE_VALF,
    0x1.p-149,
    0x1.3880p15
  },
  { // Entry 904
    -HUGE_VALF,
    -0x1.p-126,
    0x1.3880p15
  },
  { // Entry 905
    -HUGE_VALF,
    -0x1.p-149,
    0x1.3880p15
  },
  { // Entry 906
    0x1.p-127,
    0x1.p-126,
    -0x1.p0
  },
  { // Entry 907
    0x1.fffffcp-128,
    0x1.fffffcp-127,
    -0x1.p0
  },
  { // Entry 908
    0.0f,
    0x1.p-149,
    -0x1.p0
  },
  { // Entry 909
    -0.0f,
    -0x1.p-149,
    -0x1.p0
  },
  { // Entry 910
    -0x1.fffffcp-128,
    -0x1.fffffcp-127,
    -0x1.p0
  },
  { // Entry 911
    -0x1.p-127,
    -0x1.p-126,
    -0x1.p0
  },
  { // Entry 912
    0.0f,
    0x1.fffffep127,
    -0x1.3880p15
  },
  { // Entry 913
    -0.0f,
    -0x1.fffffep127,
    -0x1.3880p15
  }
};
