/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.media;

import android.media.TranscodingRequestParcel;
import android.media.TranscodingVideoTrackFormat;

/**
 * TranscodingSession is generated by the MediaTranscodingService upon receiving a
 * TranscodingRequest. It contains all the necessary configuration generated by the
 * MediaTranscodingService for the TranscodingRequest.
 *
 * {@hide}
 */
//TODO(hkuang): Implement the parcelable.
parcelable TranscodingSessionParcel {
    /**
     * A unique positive Id generated by the MediaTranscodingService.
     */
    int sessionId;

    /**
     * The request associated with the TranscodingSession.
     */
    TranscodingRequestParcel request;

    /**
     * Output video track's format. This will only be avaiable for video transcoding and it will
     * be avaiable when the session is finished.
     */
    @nullable TranscodingVideoTrackFormat videoTrackFormat;

    /**
    * Current number of sessions ahead of this session. The service schedules the session based on
    * the priority passed from the client. Client could specify whether to receive updates when the
    * awaitNumberOfSessions changes through setting requestProgressUpdate in the TranscodingRequest.
    */
    int awaitNumberOfSessions;
}
