/*
* Copyright (C) 2011 The Android Open Source Project
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package android.animation;

import android.widget.Button;
import com.android.frameworks.coretests.R;

/**
 * Listener tests for AnimatorSet.
 */
public class AnimatorSetEventsTest extends EventsTest {

    @Override
    public void setUp() throws Exception {
        final BasicAnimatorActivity activity = getActivity();
        Button button = (Button) activity.findViewById(R.id.animatingButton);

        ObjectAnimator xAnim = ObjectAnimator.ofFloat(button, "translationX", 0, 100);
        ObjectAnimator yAnim = ObjectAnimator.ofFloat(button, "translationX", 0, 100);
        mAnimator = new AnimatorSet();
        ((AnimatorSet)mAnimator).playSequentially(xAnim, yAnim);

        super.setUp();
    }

}
