/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.onemedia.playback;

import android.os.Bundle;
import android.support.v7.media.MediaItemMetadata;

import java.util.HashMap;
import java.util.Map;

/**
 * TODO: Insert description here. (generated by epastern)
 */
public class RequestUtils {
    public static final String ACTION_SET_CONTENT = "set_content";
    public static final String ACTION_SET_NEXT_CONTENT = "set_next_content";

    public static final String EXTRA_KEY_SOURCE = "source";
    public static final String EXTRA_KEY_METADATA = "metadata";
    public static final String EXTRA_KEY_HEADERS = "headers";

    private RequestUtils() {
    }

    public static class ContentBuilder {
        private Bundle mBundle;

        public ContentBuilder() {
            mBundle = new Bundle();
        }

        public ContentBuilder setSource(String source) {
            mBundle.putString(EXTRA_KEY_SOURCE, source);
            return this;
        }

        /**
         * @see MediaItemMetadata
         * @param metadata The metadata for this item
         */
        public ContentBuilder setMetadata(Bundle metadata) {
            mBundle.putBundle(EXTRA_KEY_METADATA, metadata);
            return this;
        }

        public ContentBuilder setHeaders(HashMap<String, String> headers) {
            mBundle.putSerializable(EXTRA_KEY_HEADERS, headers);
            return this;
        }

        public Bundle build() {
            return mBundle;
        }
    }
}
