/*
 * Copyright (C) 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.view;

import android.text.TextPaint;

/**
 * Container for storing additional per-view data generated by {@link View#onProvideAssistStructure
 * View.onProvideAssistStructure}.
 */
public abstract class ViewAssistStructure {
    public abstract void setText(CharSequence text);
    public abstract void setText(CharSequence text, int selectionStart, int selectionEnd);
    public abstract void setTextPaint(TextPaint paint);
    public abstract void setHint(CharSequence hint);

    public abstract CharSequence getText();
    public abstract int getTextSelectionStart();
    public abstract int getTextSelectionEnd();
    public abstract CharSequence getHint();
}
