/*
 * Copyright (C) 2004-2010 NXP Software
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/************************************************************************/
/*                                                                      */
/*     Project::                                                        */
/*     $Author: beq07716 $*/
/*     $Revision: 1000 $*/
/*     $Date: 2010-06-28 13:08:20 +0200 (Mon, 28 Jun 2010) $*/
/*                                                                      */
/************************************************************************/

/************************************************************************************/
/*                                                                                  */
/* Mixer library tables                                                             */
/*                                                                                  */
/* Coefficients and table values for the mixer library, generated by the Matlab     */
/* Script: Mixer_GenerateCoeffs.m                                                   */
/*                                                                                  */
/************************************************************************************/

#ifndef __LVM_MIXER_FILTER_COEFFS_H__
#define __LVM_MIXER_FILTER_COEFFS_H__


/************************************************************************************/
/*                                                                                  */
/* Alpha Time Constant table                                                        */
/*                                                                                  */
/************************************************************************************/

#define Alpha_TableSize                        50      /* The number of table entires */
#define ALPHA_0                        2147480769      /* Floating point Alpha = 0.999999 */
#define ALPHA_1                        2147479577      /* Floating point Alpha = 0.999998 */
#define ALPHA_2                        2147477892      /* Floating point Alpha = 0.999997 */
#define ALPHA_3                        2147475510      /* Floating point Alpha = 0.999996 */
#define ALPHA_4                        2147472141      /* Floating point Alpha = 0.999995 */
#define ALPHA_5                        2147467377      /* Floating point Alpha = 0.999992 */
#define ALPHA_6                        2147460642      /* Floating point Alpha = 0.999989 */
#define ALPHA_7                        2147451118      /* Floating point Alpha = 0.999985 */
#define ALPHA_8                        2147437651      /* Floating point Alpha = 0.999979 */
#define ALPHA_9                        2147418608      /* Floating point Alpha = 0.999970 */
#define ALPHA_10                       2147391683      /* Floating point Alpha = 0.999957 */
#define ALPHA_11                       2147353611      /* Floating point Alpha = 0.999939 */
#define ALPHA_12                       2147299779      /* Floating point Alpha = 0.999914 */
#define ALPHA_13                       2147223662      /* Floating point Alpha = 0.999879 */
#define ALPHA_14                       2147116037      /* Floating point Alpha = 0.999829 */
#define ALPHA_15                       2146963865      /* Floating point Alpha = 0.999758 */
#define ALPHA_16                       2146748712      /* Floating point Alpha = 0.999658 */
#define ALPHA_17                       2146444522      /* Floating point Alpha = 0.999516 */
#define ALPHA_18                       2146014472      /* Floating point Alpha = 0.999316 */
#define ALPHA_19                       2145406527      /* Floating point Alpha = 0.999033 */
#define ALPHA_20                       2144547188      /* Floating point Alpha = 0.998633 */
#define ALPHA_21                       2143332669      /* Floating point Alpha = 0.998067 */
#define ALPHA_22                       2141616514      /* Floating point Alpha = 0.997268 */
#define ALPHA_23                       2139192215      /* Floating point Alpha = 0.996139 */
#define ALPHA_24                       2135768939      /* Floating point Alpha = 0.994545 */
#define ALPHA_25                       2130937774      /* Floating point Alpha = 0.992295 */
#define ALPHA_26                       2124125153      /* Floating point Alpha = 0.989123 */
#define ALPHA_27                       2114529263      /* Floating point Alpha = 0.984654 */
#define ALPHA_28                       2101034612      /* Floating point Alpha = 0.978370 */
#define ALPHA_29                       2082100030      /* Floating point Alpha = 0.969553 */
#define ALPHA_30                       2055617398      /* Floating point Alpha = 0.957221 */
#define ALPHA_31                       2018744824      /* Floating point Alpha = 0.940051 */
#define ALPHA_32                       1967733015      /* Floating point Alpha = 0.916297 */
#define ALPHA_33                       1897794587      /* Floating point Alpha = 0.883729 */
#define ALPHA_34                       1803123234      /* Floating point Alpha = 0.839645 */
#define ALPHA_35                       1677262220      /* Floating point Alpha = 0.781036 */
#define ALPHA_36                       1514142675      /* Floating point Alpha = 0.705078 */
#define ALPHA_37                       1310197875      /* Floating point Alpha = 0.610108 */
#define ALPHA_38                       1067813480      /* Floating point Alpha = 0.497239 */
#define ALPHA_39                        799601371      /* Floating point Alpha = 0.372343 */
#define ALPHA_40                        531183049      /* Floating point Alpha = 0.247351 */
#define ALPHA_41                        297904007      /* Floating point Alpha = 0.138722 */
#define ALPHA_42                        131499768      /* Floating point Alpha = 0.061234 */
#define ALPHA_43                         41375282      /* Floating point Alpha = 0.019267 */
#define ALPHA_44                          8065899      /* Floating point Alpha = 0.003756 */
#define ALPHA_45                           799076      /* Floating point Alpha = 0.000372 */
#define ALPHA_46                            30398      /* Floating point Alpha = 0.000014 */
#define ALPHA_47                              299      /* Floating point Alpha = 0.000000 */
#define ALPHA_48                                0      /* Floating point Alpha = 0.000000 */
#define ALPHA_49                                0      /* Floating point Alpha = 0.000000 */
#define ALPHA_50                                0      /* Floating point Alpha = 0.000000 */


#endif
