#define LOG_TAG "android.hardware.nfc@1.0-impl"
#include <utils/Log.h>

#include <hardware/hardware.h>
#include <hardware/nfc.h>
#include "Nfc.h"

namespace android {
namespace hardware {
namespace nfc {
namespace V1_0 {
namespace implementation {

sp<INfcClientCallback> Nfc::mCallback = NULL;

Nfc::Nfc(nfc_nci_device_t* device) : mDevice(device) {
}

// Methods from ::android::hardware::nfc::V1_0::INfc follow.
::android::hardware::Return<NfcStatus> Nfc::open(const sp<INfcClientCallback>& clientCallback)  {
    mCallback = clientCallback;
    int ret = mDevice->open(mDevice, eventCallback, dataCallback);
    return ret == 0 ? NfcStatus::OK : NfcStatus::FAILED;
}

::android::hardware::Return<uint32_t> Nfc::write(const hidl_vec<uint8_t>& data)  {
    return mDevice->write(mDevice, data.size(), &data[0]);
}

::android::hardware::Return<NfcStatus> Nfc::coreInitialized(const hidl_vec<uint8_t>& data)  {
    hidl_vec<uint8_t> copy = data;
    int ret = mDevice->core_initialized(mDevice, &copy[0]);
    return ret == 0 ? NfcStatus::OK : NfcStatus::FAILED;
}

::android::hardware::Return<NfcStatus> Nfc::prediscover()  {
    return mDevice->pre_discover(mDevice) ? NfcStatus::FAILED : NfcStatus::OK;
}

::android::hardware::Return<NfcStatus> Nfc::close()  {
    return mDevice->close(mDevice) ? NfcStatus::FAILED : NfcStatus::OK;
}

::android::hardware::Return<NfcStatus> Nfc::controlGranted()  {
    return mDevice->control_granted(mDevice) ? NfcStatus::FAILED : NfcStatus::OK;
}

::android::hardware::Return<NfcStatus> Nfc::powerCycle()  {
    return mDevice->power_cycle(mDevice) ? NfcStatus::FAILED : NfcStatus::OK;
}


INfc* HIDL_FETCH_INfc(const char *hal) {
    nfc_nci_device_t* nfc_device;
    int ret = 0;
    const hw_module_t* hw_module = NULL;

    ret = hw_get_module (hal, &hw_module);
    if (ret == 0)
    {
        ret = nfc_nci_open (hw_module, &nfc_device);
        if (ret != 0) {
            ALOGE ("nfc_nci_open %s failed: %d", hal, ret);
        }
    }
    else
        ALOGE ("hw_get_module %s failed: %d", hal, ret);

    if (ret == 0) {
        return new Nfc(nfc_device);
    } else {
        ALOGE("Passthrough failed to load legacy HAL.");
        return nullptr;
    }
}

} // namespace implementation
}  // namespace V1_0
}  // namespace nfc
}  // namespace hardware
}  // namespace android
