/*
 * Copyright (C) 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#define LOG_TAG "hardware_info"
/*#define LOG_NDEBUG 0*/
#define LOG_NDDEBUG 0

#include <stdlib.h>
#include <dlfcn.h>
#include <log/log.h>
#include <cutils/str_parms.h>
#include "audio_hw.h"
#include "platform.h"
#include "platform_api.h"


struct hardware_info {
    char name[HW_INFO_ARRAY_MAX_SIZE];
    char type[HW_INFO_ARRAY_MAX_SIZE];
    /* variables for handling target variants */
    uint32_t num_snd_devices;
    char dev_extn[HW_INFO_ARRAY_MAX_SIZE];
    snd_device_t  *snd_devices;
};

#define ARRAY_SIZE(a) (sizeof(a) / sizeof((a)[0]))


static void update_hardware_info_8x16(struct hardware_info *hw_info, const char *snd_card_name)
{
    if (!strcmp(snd_card_name, "msm8x16-snd-card") ||
        !strcmp(snd_card_name, "msm8x16-snd-card-mtp")) {
        strlcpy(hw_info->name, "msm8x16", sizeof(hw_info->name));
    } else if (!strcmp(snd_card_name, "msm8909-snd-card") ||
               !strcmp(snd_card_name, "msm8909-pm8916-snd-card")) {
        strlcpy(hw_info->name, "msm8909", sizeof(hw_info->name));
    } else if (!strcmp(snd_card_name, "msm-bg-snd-card")) {
        strlcpy(hw_info->name, "msm8909", sizeof(hw_info->name));
    }  else if (!strcmp(snd_card_name, "msm8952-snd-card") ||
                !strcmp(snd_card_name, "msm8952-snd-card-mtp")) {
        strlcpy(hw_info->name, "msm8952", sizeof(hw_info->name));
    }  else if (!strcmp(snd_card_name, "msm8952-l9300-snd-card")) {
        strlcpy(hw_info->name, "msm8952", sizeof(hw_info->name));
    } else {
        ALOGW("%s: Not an  8x16/8909/8952 device", __func__);
    }
}

void *hw_info_init(const char *snd_card_name)
{
    struct hardware_info *hw_info;

    hw_info = malloc(sizeof(struct hardware_info));
    if (!hw_info) {
        ALOGE("failed to allocate mem for hardware info");
        return NULL;
    }

    if (strstr(snd_card_name, "msm8x16") || strstr(snd_card_name, "msm8909")
        || strstr(snd_card_name, "msm8952") ||
        strstr(snd_card_name, "msm-bg-snd-card")) {
        ALOGV("8x16 - variant soundcard");

        strlcpy(hw_info->type, "", sizeof(hw_info->type));
        strlcpy(hw_info->name, "", sizeof(hw_info->name));
        hw_info->snd_devices = NULL;
        hw_info->num_snd_devices = 0;
        strlcpy(hw_info->dev_extn, "", sizeof(hw_info->dev_extn));

        update_hardware_info_8x16(hw_info, snd_card_name);
    } else {
        ALOGE("%s: Unsupported target %s:",__func__, snd_card_name);
        free(hw_info);
        hw_info = NULL;
    }

    return hw_info;
}

void hw_info_deinit(void *hw_info)
{
    struct hardware_info *my_data = (struct hardware_info*) hw_info;

    if(my_data)
        free(my_data);
}

void hw_info_append_hw_type(void *hw_info, snd_device_t snd_device,
                            char *device_name)
{
    struct hardware_info *my_data = (struct hardware_info*) hw_info;
    uint32_t i = 0;

    if (my_data == NULL)
        return;

    snd_device_t *snd_devices =
            (snd_device_t *) my_data->snd_devices;

    if(snd_devices != NULL) {
        for (i = 0; i <  my_data->num_snd_devices; i++) {
            if (snd_device == (snd_device_t)snd_devices[i]) {
                ALOGV("extract dev_extn device %d, extn = %s",
                        (snd_device_t)snd_devices[i],  my_data->dev_extn);
                CHECK(strlcat(device_name,  my_data->dev_extn,
                        DEVICE_NAME_MAX_SIZE) < DEVICE_NAME_MAX_SIZE);
                break;
            }
        }
    }
    ALOGD("%s : device_name = %s", __func__,device_name);
}
