/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.voicemail;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.android.dialer.common.Assert;

/** Receives {@link Intent#ACTION_BOOT_COMPLETED} and {@link Intent#ACTION_SHUTDOWN} */
public class VoicemailPowerCycleReceiver extends BroadcastReceiver {

  @Override
  public void onReceive(Context context, Intent intent) {
    VoicemailClient voicemailClient = VoicemailComponent.get(context).getVoicemailClient();
    if (Intent.ACTION_BOOT_COMPLETED.equals(intent.getAction())) {
      voicemailClient.onBoot(context);
    } else if (Intent.ACTION_SHUTDOWN.equals(intent.getAction())) {
      voicemailClient.onShutdown(context);
    } else {
      throw Assert.createAssertionFailException("unexpected action: " + intent.getAction());
    }
  }
}
