/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 */
package com.android.voicemail.impl.transcribe.grpc;

import android.support.annotation.Nullable;
import com.android.dialer.common.Assert;
import io.grpc.Status;

/**
 * Base class for encapulating a voicemail transcription server response. This handles the Grpc
 * status response, subclasses will handle request specific responses.
 */
public abstract class TranscriptionResponse {
  @Nullable public final Status status;

  TranscriptionResponse() {
    this.status = null;
  }

  TranscriptionResponse(Status status) {
    Assert.checkArgument(status != null);
    this.status = status;
  }

  public boolean hasRecoverableError() {
    if (status != null) {
      return status.getCode() == Status.Code.UNAVAILABLE;
    }

    return false;
  }

  public boolean hasFatalError() {
    if (status != null) {
      return status.getCode() != Status.Code.OK && status.getCode() != Status.Code.UNAVAILABLE;
    }

    return false;
  }

  @Override
  public String toString() {
    return "status: " + status;
  }
}
