'use strict';

function flamegraphInit() {
  $("div#flamegraph_id svg").each(function (_, element) {
    createZoomHistoryStack(element);
    adjust_text_size(element);
  });
  $("div#flamegraph_id .flamegraph_block").resizable({
    handles: "e",
    resize: function(event, ui) {
      adjust_text_size(ui.element.find("svg")[0]);
    }
  });
}

// Create a stack add the root svg element in it.
function createZoomHistoryStack(svgElement) {
  svgElement.zoomStack = [svgElement.getElementById(svgElement.attributes['rootid'].value)];
}

function dumpStack(svgElement) {
  // Disable (enable for debugging)
  return;
  stack = svgElement.zoomStack;
  for (i=0; i < stack.length; i++) {
    let title = stack[i].getElementsByTagName('title')[0];
    console.log('[' +i+ ']-' + title.textContent);
  }
}

function adjust_node_text_size(x, svgWidth) {
  let title = x.getElementsByTagName('title')[0];
  let text = x.getElementsByTagName('text')[0];
  let rect = x.getElementsByTagName('rect')[0];

  let width = parseFloat(rect.attributes['width'].value) * svgWidth * 0.01;

  // Don't even bother trying to find a best fit. The area is too small.
  if (width < 28) {
    text.textContent = '';
    return;
  }
  // Remove dso and #samples which are here only for mouseover purposes.
  let methodName = title.textContent.split(' | ')[0];

  let numCharacters;
  for (numCharacters = methodName.length; numCharacters > 4; numCharacters--) {
     // Avoid reflow by using hard-coded estimate instead of text.getSubStringLength(0, numCharacters)
     // if (text.getSubStringLength(0, numCharacters) <= width) {
     if (numCharacters * 7.5 <= width) {
       break;
     }
  }

  if (numCharacters == methodName.length) {
    text.textContent = methodName;
    return;
  }

  text.textContent = methodName.substring(0, numCharacters-2) + '..';
 }

function adjust_text_size(svgElement) {
  let svgWidth = $(svgElement).parent().width();
  let x = svgElement.getElementsByTagName('g');
  for (let i = 0; i < x.length; i++) {
    adjust_node_text_size(x[i], svgWidth);
  }
}

function zoom(e) {
  let svgElement = e.ownerSVGElement;
  let zoomStack = svgElement.zoomStack;
  zoomStack.push(e);
  displayFromElement(e);
  select(e);
  dumpStack(svgElement);

  // Show zoom out button.
  svgElement.getElementById('zoom_rect').style.display = 'block';
  svgElement.getElementById('zoom_text').style.display = 'block';
}

function displayFromElement(e) {
  let clicked_rect = e.getElementsByTagName('rect')[0];
  let clicked_origin_x = clicked_rect.attributes['ox'].value;
  let clicked_origin_y = clicked_rect.attributes['oy'].value;
  let clicked_origin_width = clicked_rect.attributes['owidth'].value;


  let svgBox = e.ownerSVGElement.getBoundingClientRect();
  let svgBoxHeight = svgBox.height;
  let svgBoxWidth = 100;
  let scaleFactor = svgBoxWidth / clicked_origin_width;

  let callsites = e.ownerSVGElement.getElementsByTagName('g');
  for (let i = 0; i < callsites.length; i++) {
    let text = callsites[i].getElementsByTagName('text')[0];
    let rect = callsites[i].getElementsByTagName('rect')[0];

    let rect_o_x = parseFloat(rect.attributes['ox'].value);
    let rect_o_y = parseFloat(rect.attributes['oy'].value);

    // Avoid multiple forced reflow by hiding nodes.
    if (rect_o_y > clicked_origin_y) {
      rect.style.display = 'none';
      text.style.display = 'none';
      continue;
    }
    rect.style.display = 'block';
    text.style.display = 'block';

    let newrec_x = rect.attributes['x'].value = (rect_o_x - clicked_origin_x) * scaleFactor + "%";
    let newrec_y = rect.attributes['y'].value = rect_o_y + (svgBoxHeight - clicked_origin_y
                                                            - 17 - 2);

    text.attributes['y'].value = newrec_y + 12;
    text.attributes['x'].value = newrec_x;

    rect.attributes['width'].value = (rect.attributes['owidth'].value * scaleFactor) + "%";
  }

  adjust_text_size(e.ownerSVGElement);
}

function unzoom(e) {
  let svgOwner = e.ownerSVGElement;
  let stack = svgOwner.zoomStack;

  // Unhighlight whatever was selected.
  if (selected) {
    selected.classList.remove('s');
  }

  // Stack management: Never remove the last element which is the flamegraph root.
  if (stack.length > 1) {
    let previouslySelected = stack.pop();
    select(previouslySelected);
  }
  let nextElement = stack[stack.length-1];

  // Hide zoom out button.
  if (stack.length == 1) {
    svgOwner.getElementById('zoom_rect').style.display = 'none';
    svgOwner.getElementById('zoom_text').style.display = 'none';
  }

  displayFromElement(nextElement);
  dumpStack(svgOwner);
}

function search(e) {
  let term = prompt('Search for:', '');
  let svgOwner = e.ownerSVGElement;
  let callsites = e.ownerSVGElement.getElementsByTagName('g');

  if (!term) {
    for (let i = 0; i < callsites.length; i++) {
      let rect = callsites[i].getElementsByTagName('rect')[0];
      rect.attributes['fill'].value = rect.attributes['ofill'].value;
    }
    return;
  }

  for (let i = 0; i < callsites.length; i++) {
    let title = callsites[i].getElementsByTagName('title')[0];
    let rect = callsites[i].getElementsByTagName('rect')[0];
    if (title.textContent.indexOf(term) != -1) {
      rect.attributes['fill'].value = 'rgb(230,100,230)';
    } else {
      rect.attributes['fill'].value = rect.attributes['ofill'].value;
    }
  }
}

let selected;
document.onkeydown = function handle_keyboard_input(e) {
  if (!selected) {
     return;
  }

  let title = selected.getElementsByTagName('title')[0];
  let nav = selected.attributes['nav'].value.split(',');
  let navigation_index;
  switch (e.keyCode) {
     // case 38: // ARROW UP
     case 87: navigation_index = 0; break; // W

     // case 32 : // ARROW LEFT
     case 65: navigation_index = 1; break; // A

     // case 43: // ARROW DOWN
     case 68: navigation_index = 3; break; // S

     // case 39: // ARROW RIGHT
     case 83: navigation_index = 2; break; // D

     case 32: zoom(selected); return false; // SPACE

     case 8: // BACKSPACE
          unzoom(selected); return false;
     default: return true;
  }

  if (nav[navigation_index] == '0') {
    return false;
  }

  let target_element = selected.ownerSVGElement.getElementById(nav[navigation_index]);
  select(target_element);
  return false;
};

function select(e) {
  if (selected) {
    selected.classList.remove('s');
  }
  selected = e;
  selected.classList.add('s');

  // Update info bar
  let titleElement = selected.getElementsByTagName('title')[0];
  let text = titleElement.textContent;

  // Parse title
  let method_and_info = text.split(' | ');
  let methodName = method_and_info[0];
  let info = method_and_info[1];

  // Parse info
  // '/system/lib64/libhwbinder.so (4 events: 0.28%)'
  let regexp = /(.*) \(.* ([0-9**\.[0-9]*%)\)/g;
  let match = regexp.exec(info);
  if (match.length > 2) {
    let percentage = match[2];
    // Write percentage
    let percentageTextElement = selected.ownerSVGElement.getElementById('percent_text');
    percentageTextElement.textContent = percentage;
    // console.log("'" + percentage + "'")
  }

  // Set fields
  let barTextElement = selected.ownerSVGElement.getElementById('info_text');
  barTextElement.textContent = methodName;
}